/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.config;

import com.sun.enterprise.admin.BaseAdminMBean;
import com.sun.enterprise.admin.MBeanHelper;
import com.sun.enterprise.admin.config.ConfigMBeanHelper;
import com.sun.enterprise.admin.config.MBeanConfigException;
import com.sun.enterprise.admin.config.MBeanConfigInstanceNotFoundException;
import com.sun.enterprise.admin.meta.MBeanMetaException;
import com.sun.enterprise.admin.meta.MBeanMetaHelper;
import com.sun.enterprise.admin.meta.MBeanRegistry;
import com.sun.enterprise.admin.meta.MBeanRegistryEntry;
import com.sun.enterprise.admin.meta.naming.MBeanNamingInfo;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigBeansFactory;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.ServerXPathHelper;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.Descriptor;
import javax.management.DynamicMBean;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;

public class ManagedConfigBean {
    public final String PROPERTY_NAME_PREFIX = "property.";
    public final String SYSTEM_PROPERTY_NAME_PREFIX = "system-property.";
    public static final Logger _sLogger = LogDomains.getLogger("javax.enterprise.system.tools.admin");
    private static final String MSG_BASE_GET_ATTRIBUTE = "mbean.config.base_get_attribute";
    private static final String MSG_BASE_SET_ATTRIBUTE = "mbean.config.base_set_attribute";
    private static final String MSG_BASE_GOT_ATTRIBUTE = "mbean.config.base_got_attribute";
    private static final String MSG_BASE_GET_PROPERTY = "mbean.config.base_get_property";
    private static final String MSG_BASE_GET_PROPERTIES = "mbean.config.base_get_properties";
    private static final String MSG_BASE_SET_PROPERTY = "mbean.config.base_set_property";
    private static final String MSG_BASE_GET_DEF_ATTR_VALUE = "mbean.config.get_def_attr_value";
    private static final String MSG_GET_CONFBEANBYXPATH = "mbean.config.get_confbeanbyxpath";
    private static final String MSG_BASE_GET_CUSTOM_PROPERTIESLIST = "mbean.config.base_get_custom_property";
    private ConfigBean m_baseConfigBean;
    private DynamicMBean m_mbean;
    private MBeanRegistry m_registry;
    private ConfigContext m_configContext;
    private static StringManager localStrings = StringManager.getManager(BaseAdminMBean.class);

    public ManagedConfigBean(DynamicMBean mbean, ConfigBean cb, MBeanRegistry registry) {
        this.m_baseConfigBean = cb;
        this.m_mbean = mbean;
        this.m_configContext = cb.getConfigContext();
        this.m_registry = registry;
    }

    public ConfigContext getConfigContext() {
        return this.m_configContext;
    }

    public MBeanNamingInfo getConfigMBeanNamingInfo() {
        return null;
    }

    public ConfigBean getBaseConfigBean() {
        return this.m_baseConfigBean;
    }

    public ConfigBean getConfigBean(String externalName) {
        return this.m_baseConfigBean;
    }

    public Object getAttribute(ModelMBeanAttributeInfo attrInfo, String externalName) throws MBeanException, AttributeNotFoundException {
        _sLogger.log(Level.FINEST, MSG_BASE_GET_ATTRIBUTE, externalName);
        MBeanAttributeInfo ai = this.getAttrInfo(externalName);
        boolean isProperty = externalName.startsWith("property.");
        boolean isSystemProperty = externalName.startsWith("system-property.");
        boolean isArray = false;
        if (externalName.equals("modelerType")) {
            return null;
        }
        if (ai == null && !isProperty && !isSystemProperty) {
            String msg = localStrings.getString("admin.server.core.mbean.config.attribute_not_defined", externalName);
            throw new AttributeNotFoundException(msg);
        }
        if (ai != null && !ai.isReadable()) {
            String msg = localStrings.getString("admin.server.core.mbean.config.attribute_not_readable", externalName);
            throw new AttributeNotFoundException(msg);
        }
        if (isProperty) {
            return this.getPropertyValue(externalName.substring("property.".length()));
        }
        if (isSystemProperty) {
            return this.getSystemPropertyValue(externalName.substring("system-property.".length()));
        }
        AttrDescriptor descr = this.getDescriptor(externalName);
        ConfigBean bean = this.getConfigBean(externalName);
        Object value = null;
        if (descr.isElement()) {
            String msg = localStrings.getString("admin.server.core.mbean.config.getattribute_not_implemented_for_xml", externalName);
            throw new MBeanException(new MBeanConfigException(msg));
        }
        if (ai.getType().startsWith("[")) {
            Class<?> cl = bean.getClass();
            try {
                Method method = cl.getMethod("getValues", Class.forName("java.lang.String"));
                value = method.invoke((Object)bean, ConfigBean.camelize(descr.getAttributeName()));
            }
            catch (Exception e) {
                String msg = localStrings.getString("admin.server.core.mbean.config.getattribute_invocation_error", externalName);
                throw MBeanHelper.extractAndWrapTargetException(e, msg);
            }
        } else {
            value = bean.getAttributeValue(descr.getAttributeName());
        }
        _sLogger.log(Level.FINEST, MSG_BASE_GOT_ATTRIBUTE, new Object[]{externalName, value});
        return value;
    }

    public ConfigBean getChildElementByName(String methodName, String name) throws MBeanException, AttributeNotFoundException {
        ConfigBean baseBean = this.getBaseConfigBean();
        Class<?> cl = baseBean.getClass();
        try {
            Method method = cl.getDeclaredMethod(methodName, Class.forName("java.lang.String"));
            return (ConfigBean)method.invoke((Object)baseBean, name);
        }
        catch (Exception e) {
            String msg = localStrings.getString("admin.server.core.mbean.config.getattribute.undefined_childelement_in_base_element", name);
            throw new MBeanException(new MBeanConfigException(msg));
        }
    }

    public AttributeList getProperties() throws MBeanException, AttributeNotFoundException {
        _sLogger.log(Level.FINEST, MSG_BASE_GET_PROPERTIES);
        ConfigBean baseBean = this.getBaseConfigBean();
        Class<?> cl = baseBean.getClass();
        ElementProperty[] props = null;
        try {
            Method method = cl.getDeclaredMethod("getElementProperty", null);
            props = (ElementProperty[])method.invoke((Object)baseBean, null);
        }
        catch (Exception e) {
            String msg = localStrings.getString("admin.server.core.mbean.config.getattribute.undefined_properties_in_base_element");
            throw new MBeanException(new MBeanConfigException(msg));
        }
        if (props == null) {
            return new AttributeList();
        }
        AttributeList list = new AttributeList();
        for (int i = 0; i < props.length; ++i) {
            list.add(new Attribute(props[i].getName(), props[i].getValue()));
        }
        return list;
    }

    public AttributeList getSystemProperties() throws MBeanException, AttributeNotFoundException {
        _sLogger.log(Level.FINEST, MSG_BASE_GET_PROPERTIES);
        ConfigBean baseBean = this.getBaseConfigBean();
        Class<?> cl = baseBean.getClass();
        SystemProperty[] props = null;
        try {
            Method method = cl.getDeclaredMethod("getSystemProperty", null);
            props = (SystemProperty[])method.invoke((Object)baseBean, null);
        }
        catch (Exception e) {
            String msg = localStrings.getString("admin.server.core.mbean.config.getattribute.undefined_properties_in_base_element");
            throw new MBeanException(new MBeanConfigException(msg));
        }
        if (props == null) {
            return new AttributeList();
        }
        AttributeList list = new AttributeList();
        for (int i = 0; i < props.length; ++i) {
            list.add(new Attribute(props[i].getName(), props[i].getValue()));
        }
        return list;
    }

    public Object getDefaulCustomProperties(String propertyName) throws MBeanException, AttributeNotFoundException {
        _sLogger.log(Level.FINEST, MSG_BASE_GET_CUSTOM_PROPERTIESLIST, propertyName);
        return null;
    }

    public Object getPropertyValue(String propertyName) throws MBeanException, AttributeNotFoundException {
        ElementProperty prop;
        _sLogger.log(Level.FINEST, MSG_BASE_GET_PROPERTY, propertyName);
        ConfigBean baseBean = this.getBaseConfigBean();
        Class<?> cl = baseBean.getClass();
        try {
            Method method = cl.getDeclaredMethod("getElementPropertyByName", Class.forName("java.lang.String"));
            prop = (ElementProperty)method.invoke((Object)baseBean, propertyName);
        }
        catch (Exception e) {
            String msg = localStrings.getString("admin.server.core.mbean.config.getattribute.undefined_properties_in_base_element");
            throw new MBeanException(new MBeanConfigException(msg));
        }
        if (prop == null) {
            String msg = localStrings.getString("admin.server.core.mbean.config.getattribute_properties_not_found_in_base_element", propertyName);
            throw new MBeanException(new MBeanConfigException(msg));
        }
        return prop.getValue();
    }

    public Object getSystemPropertyValue(String propertyName) throws MBeanException, AttributeNotFoundException {
        SystemProperty prop;
        _sLogger.log(Level.FINEST, MSG_BASE_GET_PROPERTY, propertyName);
        ConfigBean baseBean = this.getBaseConfigBean();
        Class<?> cl = baseBean.getClass();
        try {
            Method method = cl.getDeclaredMethod("getSystemPropertyByName", Class.forName("java.lang.String"));
            prop = (SystemProperty)method.invoke((Object)baseBean, propertyName);
        }
        catch (Exception e) {
            String msg = localStrings.getString("admin.server.core.mbean.config.getattribute.undefined_properties_in_base_element");
            throw new MBeanException(new MBeanConfigException(msg));
        }
        if (prop == null) {
            String msg = localStrings.getString("admin.server.core.mbean.config.getattribute_properties_not_found_in_base_element", propertyName);
            throw new MBeanException(new MBeanConfigException(msg));
        }
        return prop.getValue();
    }

    public void setProperty(Attribute attr) throws MBeanException, AttributeNotFoundException {
        this.setElementProperty(attr, false);
    }

    public void setSystemProperty(Attribute attr) throws MBeanException, AttributeNotFoundException {
        this.setSystemProperty(attr, false);
    }

    private void setElementProperty(Attribute attr, boolean bAllowsEmptyValue) throws MBeanException, AttributeNotFoundException {
        ElementProperty prop;
        Method method;
        String propertyName = attr.getName();
        String value = (String)attr.getValue();
        _sLogger.log(Level.FINEST, MSG_BASE_SET_PROPERTY, new Object[]{propertyName, value});
        ConfigBean baseBean = this.getBaseConfigBean();
        Class<?> cl = baseBean.getClass();
        try {
            method = cl.getDeclaredMethod("getElementPropertyByName", Class.forName("java.lang.String"));
            prop = (ElementProperty)method.invoke((Object)baseBean, propertyName);
        }
        catch (Exception e) {
            String msg = localStrings.getString("admin.server.core.mbean.config.setattribute_undefined_properties_in_base_element", propertyName);
            throw new MBeanException(new MBeanConfigException(msg));
        }
        if (prop == null && value != null && (bAllowsEmptyValue || !value.equals(""))) {
            prop = new ElementProperty();
            prop.setName(propertyName);
            prop.setValue(value);
            try {
                method = cl.getDeclaredMethod("addElementProperty", prop.getClass());
                method.invoke((Object)baseBean, prop);
            }
            catch (Exception e) {
                String msg = localStrings.getString("admin.server.core.mbean.config.setproperty_invoke_error", propertyName);
                throw new MBeanException(new MBeanConfigException(msg));
            }
        } else if (value == null || !bAllowsEmptyValue && value.equals("")) {
            try {
                method = cl.getDeclaredMethod("removeElementProperty", prop.getClass());
                method.invoke((Object)baseBean, prop);
            }
            catch (Exception e) {
                String msg = localStrings.getString("admin.server.core.mbean.config.setproperty_could_not_remove_propery", propertyName);
                throw new MBeanException(new MBeanConfigException(msg));
            }
        } else {
            prop.setValue(value);
        }
    }

    private void setSystemProperty(Attribute attr, boolean bAllowsEmptyValue) throws MBeanException, AttributeNotFoundException {
        SystemProperty prop;
        Method method;
        String propertyName = attr.getName();
        String value = (String)attr.getValue();
        _sLogger.log(Level.FINEST, MSG_BASE_SET_PROPERTY, new Object[]{propertyName, value});
        ConfigBean baseBean = this.getBaseConfigBean();
        Class<?> cl = baseBean.getClass();
        try {
            method = cl.getDeclaredMethod("getSystemPropertyByName", Class.forName("java.lang.String"));
            prop = (SystemProperty)method.invoke((Object)baseBean, propertyName);
        }
        catch (Exception e) {
            String msg = localStrings.getString("admin.server.core.mbean.config.setattribute_undefined_properties_in_base_element", propertyName);
            throw new MBeanException(new MBeanConfigException(msg));
        }
        if (prop == null && value != null && (bAllowsEmptyValue || !value.equals(""))) {
            prop = new SystemProperty();
            prop.setName(propertyName);
            prop.setValue(value);
            try {
                method = cl.getDeclaredMethod("addSystemProperty", prop.getClass());
                method.invoke((Object)baseBean, prop);
            }
            catch (Exception e) {
                String msg = localStrings.getString("admin.server.core.mbean.config.setproperty_invoke_error", propertyName);
                throw new MBeanException(new MBeanConfigException(msg));
            }
        } else if (value == null || !bAllowsEmptyValue && value.equals("")) {
            try {
                method = cl.getDeclaredMethod("removeSystemProperty", prop.getClass());
                method.invoke((Object)baseBean, prop);
            }
            catch (Exception e) {
                String msg = localStrings.getString("admin.server.core.mbean.config.setproperty_could_not_remove_propery", propertyName);
                throw new MBeanException(new MBeanConfigException(msg));
            }
        } else {
            prop.setValue(value);
        }
    }

    public String getDefaultAttributeValue(String externalName) throws Exception {
        _sLogger.log(Level.FINEST, MSG_BASE_GET_DEF_ATTR_VALUE, externalName);
        MBeanAttributeInfo ai = this.getAttrInfo(externalName);
        if (ai == null) {
            String msg = localStrings.getString("admin.server.core.mbean.config.getdefaultattribute_undefined_attribute", externalName);
            throw new AttributeNotFoundException(msg);
        }
        AttrDescriptor descr = this.getDescriptor(externalName);
        String value = descr.getDefaultValue();
        return value;
    }

    private static boolean isEmptyValueAllowed(MBeanAttributeInfo ai) {
        if (ai != null && ai instanceof ModelMBeanAttributeInfo) {
            try {
                Descriptor descr = ((ModelMBeanAttributeInfo)ai).getDescriptor();
                String strAllowed = (String)descr.getFieldValue("emptyValueAllowed");
                if (Boolean.valueOf(strAllowed).booleanValue()) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public void setAttribute(ModelMBeanAttributeInfo attrInfo, Attribute attr) throws MBeanException, AttributeNotFoundException {
        String externalName = attr.getName();
        Object value = attr.getValue();
        _sLogger.log(Level.FINEST, MSG_BASE_SET_ATTRIBUTE, new Object[]{externalName, value});
        MBeanAttributeInfo ai = this.getAttrInfo(externalName);
        boolean isProperty = externalName.startsWith("property.");
        boolean isSystemProperty = externalName.startsWith("system-property.");
        if (ai == null && !isProperty && !isSystemProperty) {
            String msg = localStrings.getString("admin.server.core.mbean.config.setattribute_undefined_attribute", externalName);
            throw new AttributeNotFoundException(msg);
        }
        if (ai != null && !ai.isWritable()) {
            String msg = localStrings.getString("admin.server.core.mbean.config.setattribute_attribute_not_writable", externalName);
            throw new MBeanException(new MBeanConfigException(msg), msg);
        }
        if (isProperty) {
            boolean bAllowsEmptyValue = ManagedConfigBean.isEmptyValueAllowed(ai);
            this.setElementProperty(new Attribute(externalName.substring("property.".length()), value), bAllowsEmptyValue);
            return;
        }
        if (isSystemProperty) {
            boolean bAllowsEmptyValue = ManagedConfigBean.isEmptyValueAllowed(ai);
            this.setSystemProperty(new Attribute(externalName.substring("system-property.".length()), value), bAllowsEmptyValue);
            return;
        }
        AttrDescriptor descr = this.getDescriptor(externalName);
        ConfigBean bean = this.getConfigBean(externalName);
        if (descr.isElement()) {
            String msg = localStrings.getString("admin.server.core.mbean.config.not_supported_attribute_type", externalName);
            throw new MBeanException(new MBeanConfigException(msg));
        }
        if (ai.getType().startsWith("[")) {
            Class<?> cl = bean.getClass();
            try {
                Method method = cl.getMethod("setValue", Class.forName("java.lang.String"), new Object[0].getClass());
                method.invoke((Object)bean, ConfigBean.camelize(descr.getAttributeName()), value);
            }
            catch (Exception e) {
                String msg = localStrings.getString("admin.server.core.mbean.config.setattribute_invocation_error", externalName);
                throw MBeanHelper.extractAndWrapTargetException(e, msg);
            }
        } else if (value == null || value.equals("") && !ManagedConfigBean.isEmptyValueAllowed(ai)) {
            bean.setAttributeValue(descr.getAttributeName(), null);
        } else {
            bean.setAttributeValue(descr.getAttributeName(), value.toString());
        }
    }

    public AttributeList getAttributes(String[] attributeNames) {
        AttributeList attrs = new AttributeList();
        for (int i = 0; i < attributeNames.length; ++i) {
            String[] names;
            if (attributeNames[i].length() == 0) {
                names = this.getAllAttributeNames();
                if (names == null) continue;
                attrs.addAll(this.getAttributes(names));
                continue;
            }
            if (attributeNames[i].equals("property.")) {
                names = this.getAllPropertyNames(true);
                if (names == null) continue;
                attrs.addAll(this.getAttributes(names));
                continue;
            }
            if (attributeNames[i].equals("system-property.")) {
                names = this.getAllSystemPropertyNames(true);
                if (names == null) continue;
                attrs.addAll(this.getAttributes(names));
                continue;
            }
            try {
                String name = MBeanMetaHelper.mapToMBeanAttributeName(attributeNames[i]);
                Object value = this.getAttribute(null, name);
                attrs.add(new Attribute(name, value));
                continue;
            }
            catch (MBeanException ce) {
                continue;
            }
            catch (AttributeNotFoundException ce) {
                continue;
            }
            catch (NullPointerException npe) {
                // empty catch block
            }
        }
        return attrs;
    }

    public AttributeList setAttributes(AttributeList attrList) {
        AttributeList attrs = new AttributeList();
        Iterator it = attrList.iterator();
        while (it.hasNext()) {
            try {
                Attribute attribute = (Attribute)it.next();
                attribute = new Attribute(MBeanMetaHelper.mapToMBeanAttributeName(attribute.getName()), attribute.getValue());
                this.setAttribute(null, attribute);
                attrs.add(attribute);
            }
            catch (MBeanException mbe) {
            }
            catch (AttributeNotFoundException anfe) {
            }
            catch (NullPointerException npe) {}
        }
        return attrs;
    }

    public Object invoke(String methodName, Object[] methodParams, String[] methodSignature) throws MBeanException, ReflectionException {
        return null;
    }

    private AttrDescriptor getDescriptor(String externalName) {
        try {
            return new AttrDescriptor(externalName);
        }
        catch (MBeanConfigException mbce) {
            return null;
        }
    }

    private MBeanAttributeInfo getAttrInfo(String attrName) {
        MBeanInfo mbi = this.m_mbean.getMBeanInfo();
        if (mbi == null) {
            return null;
        }
        MBeanAttributeInfo[] ai = mbi.getAttributes();
        if (ai != null) {
            for (int i = 0; i < ai.length; ++i) {
                String name = ai[i].getName();
                if (!attrName.equals(ai[i].getName())) continue;
                return ai[i];
            }
        }
        return null;
    }

    private String[] getAllAttributeNames() {
        MBeanInfo mbi = this.m_mbean.getMBeanInfo();
        if (mbi == null) {
            return null;
        }
        MBeanAttributeInfo[] ai = mbi.getAttributes();
        if (ai == null || ai.length == 0) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        if (ai != null) {
            for (int i = 0; i < ai.length; ++i) {
                String name = ai[i].getName();
                if (name.equals("modelerType")) continue;
                list.add(name);
            }
        }
        return list.toArray(new String[list.size()]);
    }

    private String[] getAllPropertyNames(boolean bAddPropertyPrefix) {
        ConfigBean baseBean = this.getBaseConfigBean();
        Class<?> cl = baseBean.getClass();
        try {
            Method method = cl.getDeclaredMethod("getElementProperty", null);
            ElementProperty[] props = (ElementProperty[])method.invoke((Object)baseBean, null);
            String[] names = new String[props.length];
            for (int i = 0; i < props.length; ++i) {
                names[i] = bAddPropertyPrefix ? "property." + props[i].getName() : props[i].getName();
            }
            return names;
        }
        catch (NoSuchMethodException nsme) {
            return null;
        }
        catch (IllegalAccessException iae) {
            return null;
        }
        catch (InvocationTargetException ite) {
            return null;
        }
    }

    private String[] getAllSystemPropertyNames(boolean bAddPropertyPrefix) {
        ConfigBean baseBean = this.getBaseConfigBean();
        Class<?> cl = baseBean.getClass();
        try {
            Method method = cl.getDeclaredMethod("getSystemProperty", null);
            SystemProperty[] props = (SystemProperty[])method.invoke((Object)baseBean, null);
            String[] names = new String[props.length];
            for (int i = 0; i < props.length; ++i) {
                names[i] = bAddPropertyPrefix ? "system-property." + props[i].getName() : props[i].getName();
            }
            return names;
        }
        catch (NoSuchMethodException nsme) {
            return null;
        }
        catch (IllegalAccessException iae) {
            return null;
        }
        catch (InvocationTargetException ite) {
            return null;
        }
    }

    public ConfigBean createChildByType(String childName, AttributeList childValues, boolean bOnlyOneChildPossible) throws Exception {
        if (this.m_baseConfigBean == null) {
            return null;
        }
        String xpath = MBeanHelper.getXPathPattern((ModelMBeanInfo)((Object)this.m_mbean.getMBeanInfo())) + "/" + childName;
        Class cl = ConfigMBeanHelper.getConfigBeanClass(xpath);
        ConfigBean bean = (ConfigBean)cl.newInstance();
        MBeanRegistryEntry regEntry = this.m_registry.findMBeanRegistryEntryByXPathPattern(xpath);
        if (childValues != null) {
            for (int i = 0; i < childValues.size(); ++i) {
                Attribute attr = (Attribute)childValues.get(i);
                if (attr.getValue() == null || attr.getValue().equals("")) {
                    boolean bEmptyValueAllowed = false;
                    try {
                        bEmptyValueAllowed = regEntry.isAttributeEmptyValueAllowed(attr.getName());
                    }
                    catch (MBeanMetaException mme) {
                        // empty catch block
                    }
                    if (!bEmptyValueAllowed) continue;
                }
                if (attr.getValue() == null) {
                    bean.setAttributeValue(MBeanMetaHelper.mapToConfigBeanAttributeName(attr.getName()), (String)attr.getValue());
                    continue;
                }
                bean.setAttributeValue(MBeanMetaHelper.mapToConfigBeanAttributeName(attr.getName()), "" + attr.getValue());
            }
        }
        Class<?> clBase = this.m_baseConfigBean.getClass();
        Method method = bOnlyOneChildPossible ? clBase.getDeclaredMethod("set" + ConfigMBeanHelper.convertTagName(childName), cl) : clBase.getDeclaredMethod("add" + ConfigMBeanHelper.convertTagName(childName), cl);
        method.invoke((Object)this.m_baseConfigBean, bean);
        return bean;
    }

    void removeChild(String opName, MBeanOperationInfo opInfo, Object[] params, String childTag) throws Exception {
        MBeanOperationInfo getInfo = new MBeanOperationInfo("get" + opName.substring("remove".length()), "", opInfo.getSignature(), "java.lang.Object", 0);
        Object ret = MBeanHelper.invokeOperationInBean(getInfo, this.getBaseConfigBean(), params);
        if (ret == null) {
            String parentName = "";
            parentName = this.getBaseConfigBean().getClass().getName();
            int last = parentName.lastIndexOf(46);
            if (last >= 0 && last < parentName.length() - 1) {
                parentName = parentName.substring(last + 1);
            }
            String elemName = "";
            if (params != null && params.length == 1 && params[0] instanceof String) {
                elemName = "\"" + (String)params[0] + "\"";
            }
            String msg = localStrings.getString("admin.server.core.mbean.config.element_not_found", new Object[]{parentName, childTag, elemName});
            throw new MBeanConfigException(msg);
        }
        if (ret == MBeanHelper.INVOKE_ERROR_SIGNAL_OBJECT) {
            String elemName = "";
            if (params.length == 1 && params[0] instanceof String) {
                elemName = (String)params[0];
            }
            String msg = localStrings.getString("admin.server.core.mbean.config.remove_get_invocation", opName, elemName);
            throw new MBeanConfigException(msg);
        }
        ArrayList arr = new ArrayList();
        this.collectChildrenObjectNames((ConfigBean)ret, arr);
        this.m_baseConfigBean.removeChild((ConfigBean)ret);
        MBeanServer server = null;
        try {
            server = MBeanServerFactory.findMBeanServer(null).get(0);
        }
        catch (Exception e) {
            // empty catch block
        }
        for (int i = 0; i < arr.size(); ++i) {
            ObjectName objectName = (ObjectName)arr.get(i);
            try {
                if (server.isRegistered(objectName)) {
                    server.unregisterMBean(objectName);
                    continue;
                }
                this.m_registry.notifyUnregisterMBean(objectName, this.getConfigContext());
                continue;
            }
            catch (Throwable t) {
                _sLogger.fine("!!!!!!!!!!!!!! Can not unregister MBean: " + objectName);
            }
        }
    }

    void collectChildrenObjectNames(ConfigBean bean, ArrayList arr) {
        try {
            ConfigBean[] beans = bean.getAllChildBeans();
            for (int i = 0; i < beans.length; ++i) {
                this.collectChildrenObjectNames(beans[i], arr);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            ObjectName name = (ObjectName)ConfigMBeanHelper.converConfigBeansToObjectNames(this.m_registry, (ModelMBeanInfo)((Object)this.m_mbean.getMBeanInfo()), bean);
            if (name != null) {
                arr.add(name);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void deleteSelf() throws Exception {
        if (this.m_baseConfigBean == null) {
            return;
        }
        String xpath = null;
        xpath = this.m_baseConfigBean.getAbsoluteXPath(null);
        xpath = ServerXPathHelper.getParentXPath(xpath);
        ConfigContext ctx = this.getConfigContext();
        ConfigBean parent = ConfigBeansFactory.getConfigBeanByXPath(ctx, xpath);
        parent.removeChild(this.m_baseConfigBean);
    }

    public Object invokeOperation(ModelMBeanOperationInfo opInfo, Object[] params, String[] signature) throws Exception {
        Descriptor descr = opInfo.getDescriptor();
        String opName = opInfo.getName();
        String child = (String)descr.getFieldValue("child");
        String multi = (String)descr.getFieldValue("multi");
        boolean bOnlyOne = true;
        if (multi != null && multi.length() > 0 && multi.charAt(0) == 't') {
            bOnlyOne = false;
        }
        if (child != null && opName.startsWith("create")) {
            ConfigBean bean = this.createChildByType(child, (AttributeList)params[0], bOnlyOne);
            ObjectName objectName = ConfigMBeanHelper.getChildObjectName(this.m_registry, (ModelMBeanInfo)((Object)this.m_mbean.getMBeanInfo()), bean);
            this.m_registry.notifyRegisterMBean(objectName, this.getConfigContext());
            return objectName;
        }
        if (child != null && opName.startsWith("remove")) {
            this.removeChild(opName, opInfo, params, child);
            return null;
        }
        Object ret = MBeanHelper.invokeOperationInBean(opInfo, this, params);
        if (ret != MBeanHelper.INVOKE_ERROR_SIGNAL_OBJECT) {
            return ret;
        }
        ret = MBeanHelper.invokeOperationInBean(opInfo, this.getBaseConfigBean(), params);
        if (ret != MBeanHelper.INVOKE_ERROR_SIGNAL_OBJECT) {
            if (ret == null && "javax.management.ObjectName".equals(opInfo.getReturnType())) {
                String parentName = "";
                parentName = this.getBaseConfigBean().getClass().getName();
                int last = parentName.lastIndexOf(46);
                if (last >= 0 && last < parentName.length() - 1) {
                    parentName = parentName.substring(last + 1);
                }
                String elemName = "";
                if (params != null && params.length == 1 && params[0] instanceof String) {
                    elemName = (String)params[0];
                }
                String msg = child != null ? localStrings.getString("admin.server.core.mbean.config.element_not_found", new Object[]{parentName, child, elemName}) : localStrings.getString("admin.server.core.mbean.config.oper_element_not_found", new Object[]{parentName, opName, elemName});
                throw new MBeanConfigInstanceNotFoundException(msg);
            }
            ret = ConfigMBeanHelper.converConfigBeansToObjectNames(this.m_registry, (ModelMBeanInfo)((Object)this.m_mbean.getMBeanInfo()), ret);
            if (ret != null) {
                if (ret instanceof ConfigBean) {
                    return ConfigMBeanHelper.getChildObjectName(this.m_registry, (ModelMBeanInfo)((Object)this.m_mbean.getMBeanInfo()), (ConfigBean)ret);
                }
                if (ret instanceof ConfigBean[]) {
                    return ConfigMBeanHelper.getChildObjectNames(this.m_registry, (ModelMBeanInfo)((Object)this.m_mbean.getMBeanInfo()), (ConfigBean[])ret);
                }
            }
            return ret;
        }
        return MBeanHelper.INVOKE_ERROR_SIGNAL_OBJECT;
    }

    private class AttrDescriptor {
        public String m_attributeName;
        public boolean m_bAllowsEmptyValue = false;

        public AttrDescriptor(String description) throws MBeanConfigException {
            try {
                this.m_attributeName = MBeanMetaHelper.mapToConfigBeanAttributeName(description);
            }
            catch (Throwable e) {
                String msg = localStrings.getString("admin.server.core.mbean.config.attrdescriptor_constructor_exception", description, e.getMessage());
                throw new MBeanConfigException(msg);
            }
        }

        public String getAttributeName() {
            return this.m_attributeName;
        }

        public boolean isEmptyValueAllowed() {
            return this.m_bAllowsEmptyValue;
        }

        public String getDefaultValue() throws Exception {
            if (ManagedConfigBean.this.m_baseConfigBean == null || this.isProperty() || this.isSystemProperty() || this.isElement()) {
                return null;
            }
            Class<?> clBase = ManagedConfigBean.this.m_baseConfigBean.getClass();
            Method method = clBase.getDeclaredMethod("getDefaultAttributeValue", Class.forName("java.lang.String"));
            return (String)method.invoke((Object)ManagedConfigBean.this.m_baseConfigBean, this.m_attributeName);
        }

        public boolean isProperty() {
            if (this.m_attributeName != null) {
                return this.m_attributeName.startsWith("property.");
            }
            return false;
        }

        public boolean isSystemProperty() {
            if (this.m_attributeName != null) {
                return this.m_attributeName.startsWith("system-property.");
            }
            return false;
        }

        public boolean isElement() {
            return this.m_attributeName == null;
        }
    }
}

