/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.alert;

import com.sun.enterprise.admin.alert.AlertSubscriptionInfo;
import com.sun.enterprise.admin.server.core.AdminService;
import java.util.Iterator;
import java.util.List;
import java.util.logging.ErrorManager;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;

public class MBeanRegistrationEventListener
implements NotificationListener {
    private List alertSubscriptions;
    private MBeanServer mbeanServer;
    private static final String NAME_PROPERTY_KEY = "name";

    public MBeanRegistrationEventListener(List alertSubscriptions) {
        this.alertSubscriptions = alertSubscriptions;
        this.mbeanServer = AdminService.getAdminService().getAdminContext().getMBeanServer();
    }

    public void handleNotification(Notification notification, Object handBack) {
        if (!notification.getType().equals("JMX.mbean.registered")) {
            return;
        }
        try {
            MBeanServerNotification mbeanServerNotification = (MBeanServerNotification)notification;
            String registeredMbeanName = mbeanServerNotification.getMBeanName().getKeyProperty(NAME_PROPERTY_KEY);
            if (registeredMbeanName == null) {
                return;
            }
            Iterator iterator = this.alertSubscriptions.iterator();
            while (iterator.hasNext()) {
                AlertSubscriptionInfo subscription = (AlertSubscriptionInfo)iterator.next();
                if (!this.matches(subscription.getMonitorNames(), registeredMbeanName)) continue;
                this.mbeanServer.addNotificationListener(mbeanServerNotification.getMBeanName(), subscription.getNotificationListener(), subscription.getNotificationFilter(), null);
            }
        }
        catch (Exception e) {
            new ErrorManager().error("Error In  MBeanServerRegistrationEventListener  ", e, 0);
        }
    }

    private boolean matches(List monitorNames, String registeredMBeanName) {
        Iterator iterator = monitorNames.iterator();
        while (iterator.hasNext()) {
            if (!registeredMBeanName.equals((String)iterator.next())) continue;
            return true;
        }
        return false;
    }
}

