/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.appserv.util.cache.CacheListener;
import com.sun.ejb.ComponentContext;
import com.sun.ejb.Invocation;
import com.sun.ejb.InvocationInfo;
import com.sun.ejb.base.io.IOUtils;
import com.sun.ejb.base.stats.StatefulSessionStoreMonitor;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.ContainerFactoryImpl;
import com.sun.ejb.containers.ContainerSynchronization;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.EJBLocalObjectImpl;
import com.sun.ejb.containers.EJBLocalRemoteObject;
import com.sun.ejb.containers.EJBObjectImpl;
import com.sun.ejb.containers.PeriodicTask;
import com.sun.ejb.containers.SessionContextImpl;
import com.sun.ejb.containers.util.ContainerWorkPool;
import com.sun.ejb.containers.util.cache.LruSessionCache;
import com.sun.ejb.spi.container.ContainerService;
import com.sun.ejb.spi.container.SFSBContainerCallback;
import com.sun.ejb.spi.container.StatefulEJBContext;
import com.sun.ejb.spi.sfsb.initialization.SFSBContainerInitialization;
import com.sun.ejb.spi.sfsb.store.SFSBBeanState;
import com.sun.ejb.spi.sfsb.store.SFSBStoreManager;
import com.sun.ejb.spi.sfsb.store.SFSBStoreManagerException;
import com.sun.ejb.spi.sfsb.util.CheckpointPolicy;
import com.sun.ejb.spi.sfsb.util.SFSBUUIDUtil;
import com.sun.ejb.spi.stats.StatefulSessionBeanStatsProvider;
import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.appverification.factory.AppVerification;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.runtime.CheckpointAtEndOfMethodDescriptor;
import com.sun.enterprise.deployment.runtime.IASEjbExtraDescriptors;
import com.sun.enterprise.util.threadpool.Servicable;
import com.sun.logging.LogDomains;
import java.io.NotSerializableException;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBObject;
import javax.ejb.EnterpriseBean;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.ejb.SessionSynchronization;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;

public final class StatefulSessionContainer
extends BaseContainer
implements CacheListener,
SFSBContainerCallback,
StatefulSessionBeanStatsProvider,
SFSBContainerInitialization {
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    static final int PASSIVE = 1;
    static final int READY = 2;
    static final int INVOKING = 3;
    static final int INCOMPLETE_TX = 4;
    static final int DESTROYED = 5;
    public static final int MIN_PASSIVATION_BATCH_COUNT = 8;
    private long instanceCount = 1L;
    protected ArrayList passivationCandidates = new ArrayList();
    private Object asyncTaskSemaphore = new Object();
    private int asyncTaskCount = 0;
    private int asyncCummTaskCount = 0;
    private int passivationBatchCount = 8;
    private int containerTrimCount = 0;
    private LruSessionCache sessionBeanCache;
    private SFSBStoreManager sfsbStoreManager;
    private SFSBUUIDUtil uuidGenerator;
    private ArrayList scheduledTimerTasks = new ArrayList();
    protected int statMethodReadyCount = 0;
    private Level TRACE_LEVEL = Level.FINE;
    private String ejbName;
    private CheckpointPolicy checkpointPolicy;
    private int removalGracePeriodInSeconds;
    private StatefulSessionStoreMonitor sfsbStoreMonitor;
    private final String traceInfoPrefix;

    public StatefulSessionContainer(EjbDescriptor desc, ClassLoader loader) throws Exception {
        super(desc, loader);
        this.ejbName = desc.getName();
        this.traceInfoPrefix = "sfsb-" + this.ejbName + ": ";
    }

    protected void initializeHome() throws Exception {
        super.initializeHome();
        this.loadCheckpointInfo();
        this.registerMonitorableComponents();
    }

    protected void loadCheckpointInfo() {
        try {
            if (this.checkpointPolicy.isHAEnabled()) {
                Iterator iter = this.invocationInfoMap.values().iterator();
                while (iter.hasNext()) {
                    CheckpointAtEndOfMethodDescriptor cpDesc;
                    InvocationInfo info = (InvocationInfo)iter.next();
                    info.checkpointEnabled = false;
                    MethodDescriptor md = new MethodDescriptor(info.method, info.methodIntf);
                    IASEjbExtraDescriptors extraDesc = this.ejbDescriptor.getIASEjbExtraDescriptors();
                    if (extraDesc != null && (cpDesc = extraDesc.getCheckpointAtEndOfMethodDescriptor()) != null) {
                        info.checkpointEnabled = cpDesc.isCheckpointEnabledFor(md);
                    }
                    if (!info.checkpointEnabled || !_logger.isLoggable(Level.FINE)) continue;
                    _logger.log(Level.FINE, "[SFSBContainer] " + info.method + " MARKED for " + "end-of-method-checkpoint");
                }
            }
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "[SFSBContainer] Exception while  loading checkpoint info", ex);
        }
    }

    protected void registerMonitorableComponents() {
        this.registryMediator.registerProvider(this);
        this.registryMediator.registerProvider(this.sessionBeanCache);
        super.registerMonitorableComponents();
        super.populateMethodMonitorMap();
        this.sfsbStoreMonitor = this.registryMediator.registerProvider(this.sfsbStoreManager.getMonitorableSFSBStoreManager(), this.checkpointPolicy.isHAEnabled());
        this.sessionBeanCache.setStatefulSessionStoreMonitor(this.sfsbStoreMonitor);
        _logger.log(Level.FINE, "[SFSBContainer] registered monitorable");
    }

    public String getMonitorAttributeValues() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(" { asyncTaskCount=").append(this.asyncTaskCount).append("; asyncCummTaskCount=").append(this.asyncCummTaskCount).append("; passivationBatchCount=").append(this.passivationBatchCount).append("; passivationQSz=").append(this.passivationCandidates.size()).append("; trimEventCount=").append(this.containerTrimCount).append(" }");
        return sbuf.toString();
    }

    public void appendStats(StringBuffer sbuf) {
        sbuf.append("\nStatefulContainer: ").append("CreateCount=").append(this.statCreateCount).append("; ").append("RemoveCount=").append(this.statRemoveCount).append("; ").append("Size=").append(this.sessionBeanCache.getNumBeansInCache()).append("; ").append("ReadyCount=").append(this.statMethodReadyCount).append("; ");
        sbuf.append("]");
    }

    private static final String convertCtxStateToString(SessionContextImpl sc) {
        switch (sc.getState()) {
            case 1: {
                return "PASSIVE";
            }
            case 2: {
                return "READY";
            }
            case 3: {
                return "INVOKING";
            }
            case 4: {
                return "INCOMPLETE_TX";
            }
            case 5: {
                return "DESTROYED";
            }
        }
        return "UNKNOWN-STATE";
    }

    boolean isIdentical(EJBObjectImpl ejbo, EJBObject other) throws RemoteException {
        if (other == ejbo.getStub()) {
            return true;
        }
        try {
            return this.protocolMgr.isIdentical((Remote)ejbo.getStub(), (Remote)other);
        }
        catch (Exception ex) {
            _logger.log(Level.FINE, "Exception while getting stub for ejb", ex);
            throw new RemoteException("Error during isIdentical.", ex);
        }
    }

    EJBObjectImpl createEJBObjectImpl() throws CreateException, RemoteException {
        try {
            SessionContextImpl context = this.createBeanInstance();
            EJBObjectImpl ejbObjImpl = this.createEJBObjectImpl(context);
            context.setState(2);
            ++this.statCreateCount;
            this.incrementMethodReadyStat();
            return ejbObjImpl;
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "ejb.create_ejbobject_exception", this.ejbDescriptor.getName());
            _logger.log(Level.WARNING, "create object exception", ex);
            if (ex instanceof EJBException) {
                throw (EJBException)((Object)ex);
            }
            CreateException ce = new CreateException("ERROR creating stateful SessionBean");
            ce.initCause((Throwable)ex);
            throw ce;
        }
    }

    EJBLocalObjectImpl createEJBLocalObjectImpl() throws CreateException {
        try {
            SessionContextImpl context = this.createBeanInstance();
            EJBLocalObjectImpl localObjImpl = this.createEJBLocalObjectImpl(context);
            context.setState(2);
            ++this.statCreateCount;
            this.incrementMethodReadyStat();
            return localObjImpl;
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "ejb.create_ejblocalobject_exception", this.ejbDescriptor.getName());
            _logger.log(Level.WARNING, "create ejblocal object exception", ex);
            if (ex instanceof EJBException) {
                throw (EJBException)((Object)ex);
            }
            CreateException ce = new CreateException("ERROR creating stateful SessionBean");
            ce.initCause((Throwable)ex);
            throw ce;
        }
    }

    private SessionContextImpl createBeanInstance() throws Exception {
        SessionContextImpl sessionContextImpl;
        block5: {
            Invocation i = null;
            try {
                SessionBean ejb = (SessionBean)this.ejbClass.newInstance();
                SessionContextImpl context = new SessionContextImpl((EnterpriseBean)ejb, this);
                i = new Invocation((EnterpriseBean)ejb, (Object)this);
                i.context = context;
                this.invocationManager.preInvoke(i);
                ejb.setSessionContext((SessionContext)context);
                context.touch();
                Object sessionKey = this.uuidGenerator.createSessionKey();
                this.sessionBeanCache.put(sessionKey, context);
                context.setInstanceKey(sessionKey);
                if (_logger.isLoggable(this.TRACE_LEVEL)) {
                    _logger.log(this.TRACE_LEVEL, "[SFSBContainer] Created session: " + sessionKey);
                }
                sessionContextImpl = context;
                Object var7_7 = null;
                if (i == null) break block5;
            }
            catch (Exception ex) {
                try {
                    throw ex;
                }
                catch (Throwable throwable) {
                    block6: {
                        Object var7_8 = null;
                        if (i == null) break block6;
                        this.invocationManager.postInvoke(i);
                    }
                    throw throwable;
                }
            }
            this.invocationManager.postInvoke(i);
        }
        return sessionContextImpl;
    }

    private EJBLocalObjectImpl createEJBLocalObjectImpl(SessionContextImpl context) throws Exception {
        if (context.getEJBLocalObjectImpl() != null) {
            return context.getEJBLocalObjectImpl();
        }
        EJBLocalObjectImpl localObjImpl = this.instantiateEJBLocalObjectImpl();
        context.setEJBLocalObjectImpl(localObjImpl);
        localObjImpl.setContext(context);
        localObjImpl.setKey(context.getInstanceKey());
        if (this.isRemote) {
            this.createEJBObjectImpl(context);
        }
        return localObjImpl;
    }

    private EJBObjectImpl createEJBObjectImpl(SessionContextImpl context) throws Exception {
        if (context.getEJBObjectImpl() != null) {
            return context.getEJBObjectImpl();
        }
        EJBObjectImpl ejbObjImpl = this.instantiateEJBObjectImpl();
        context.setEJBObjectImpl(ejbObjImpl);
        ejbObjImpl.setContext(context);
        Object sessionKey = context.getInstanceKey();
        ejbObjImpl.setKey(sessionKey);
        byte[] sessionOID = this.uuidGenerator.keyToByteArray(sessionKey);
        EJBObject ejbStub = this.remoteRefFactory.createRemoteReference(sessionOID);
        context.setEJBStub(ejbStub);
        ejbObjImpl.setStub(ejbStub);
        if (this.isLocal) {
            this.createEJBLocalObjectImpl(context);
        }
        return ejbObjImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void removeBean(EJBLocalRemoteObject ejbo, Method removeMethod, boolean local) throws RemoveException, EJBException {
        Invocation i;
        block11: {
            i = new Invocation();
            i.ejbObject = ejbo;
            i.isLocal = local;
            i.method = removeMethod;
            Class<?> declaringClass = removeMethod.getDeclaringClass();
            i.isHome = declaringClass == EJBHome.class || declaringClass == EJBLocalHome.class;
            try {
                try {
                    this.preInvoke(i);
                    this.removeBean(i);
                }
                catch (Exception e) {
                    _logger.log(Level.FINE, "ejb.preinvoke_exception", e);
                    i.exception = e;
                    Object var8_7 = null;
                    if (AppVerification.doInstrument()) {
                        AppVerification.getInstrumentLogger().doInstrumentForEjb(this.ejbDescriptor, this.ejbRemoveMethod, i.exception);
                    }
                    this.postInvoke(i);
                    break block11;
                }
                Object var8_6 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (AppVerification.doInstrument()) {
                    AppVerification.getInstrumentLogger().doInstrumentForEjb(this.ejbDescriptor, this.ejbRemoveMethod, i.exception);
                }
                this.postInvoke(i);
                throw throwable;
            }
            if (AppVerification.doInstrument()) {
                AppVerification.getInstrumentLogger().doInstrumentForEjb(this.ejbDescriptor, this.ejbRemoveMethod, i.exception);
            }
            this.postInvoke(i);
        }
        if (i.exception == null) {
            return;
        }
        if (i.exception instanceof RemoveException) {
            throw (RemoveException)i.exception;
        }
        if (i.exception instanceof RuntimeException) {
            throw (RuntimeException)i.exception;
        }
        if (i.exception instanceof Exception) {
            throw new EJBException((Exception)i.exception);
        }
        EJBException ejbEx = new EJBException();
        ejbEx.initCause(i.exception);
        throw ejbEx;
    }

    private void removeBean(Invocation inv) throws RemoveException {
        try {
            ++this.statRemoveCount;
            SessionContextImpl sc = (SessionContextImpl)inv.context;
            Transaction tc = sc.getTransaction();
            if (tc != null && tc.getStatus() != 6) {
                throw new RemoveException("Cannot remove EJB: transaction in progress");
            }
            if (_logger.isLoggable(this.TRACE_LEVEL)) {
                _logger.log(this.TRACE_LEVEL, "[SFSBContainer] Removing session: " + sc.getInstanceKey());
            }
            SessionBean sb = (SessionBean)sc.getEJB();
            sc.setInEjbRemove(true);
            try {
                sb.ejbRemove();
            }
            catch (Throwable t) {
                _logger.log(Level.FINE, "exception thrown from SFSB ejbRemove", t);
            }
            sc.setInEjbRemove(false);
            this.forceDestroyBean(sc);
        }
        catch (EJBException ex) {
            _logger.log(Level.FINE, "EJBException in removing bean", ex);
            throw ex;
        }
        catch (RemoveException ex) {
            _logger.log(Level.FINE, "Remove exception while removing bean", ex);
            throw ex;
        }
        catch (Exception ex) {
            _logger.log(Level.FINE, "Some exception while removing bean", ex);
            throw new EJBException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forceDestroyBean(EJBContextImpl ctx) {
        SessionContextImpl sc;
        SessionContextImpl sessionContextImpl = sc = (SessionContextImpl)ctx;
        synchronized (sessionContextImpl) {
            if (sc.getState() == 5) {
                return;
            }
            sc.setState(5);
            if (_logger.isLoggable(this.TRACE_LEVEL)) {
                _logger.log(this.TRACE_LEVEL, "[SFSBContainer] (Force)Destroying session: " + sc.getInstanceKey());
            }
            Transaction prevTx = sc.getTransaction();
            try {
                if (prevTx != null && prevTx.getStatus() != 6) {
                    prevTx.setRollbackOnly();
                }
            }
            catch (SystemException ex) {
                throw new EJBException((Exception)((Object)ex));
            }
            catch (IllegalStateException ex) {
                throw new EJBException((Exception)ex);
            }
            Object sessionKey = sc.getInstanceKey();
            this.sessionBeanCache.remove(sessionKey, sc.existsInStore());
            if (this.isRemote) {
                EJBObjectImpl ejbObjImpl = sc.getEJBObjectImpl();
                ejbObjImpl.clearContext();
                ejbObjImpl.setRemoved(true);
                sc.setEJBObjectImpl(null);
                this.remoteRefFactory.destroyReference((Remote)ejbObjImpl.getStub(), (Remote)ejbObjImpl.getEJBObject());
            }
            if (this.isLocal) {
                EJBLocalObjectImpl localObjImpl = sc.getEJBLocalObjectImpl();
                localObjImpl.clearContext();
                localObjImpl.setRemoved(true);
                sc.setEJBLocalObjectImpl(null);
            }
            this.transactionManager.ejbDestroyed(sc);
        }
    }

    public boolean userTransactionMethodsAllowed(ComponentInvocation inv) {
        boolean utMethodsAllowed = false;
        if (this.isBeanManagedTran) {
            if (inv instanceof Invocation) {
                Invocation i = (Invocation)inv;
                SessionContextImpl sc = (SessionContextImpl)i.context;
                utMethodsAllowed = sc.getInstanceKey() != null;
            } else {
                utMethodsAllowed = true;
            }
        }
        return utMethodsAllowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTimedoutBean(EJBContextImpl ctx) {
        EJBContextImpl eJBContextImpl = ctx;
        synchronized (eJBContextImpl) {
            if (ctx.getState() != 3) {
                try {
                    SessionBean sb = (SessionBean)ctx.getEJB();
                    ctx.setInEjbRemove(true);
                    sb.ejbRemove();
                }
                catch (Exception ex) {
                    _logger.log(Level.FINE, "ejbRemove exception", ex);
                }
                if (_logger.isLoggable(this.TRACE_LEVEL)) {
                    SessionContextImpl sc = (SessionContextImpl)ctx;
                    _logger.log(this.TRACE_LEVEL, "[SFSBContainer] Removing TIMEDOUT session: " + sc.getInstanceKey());
                }
                ctx.setInEjbRemove(false);
                this.forceDestroyBean(ctx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EJBObjectImpl getEJBObjectImpl(byte[] instanceKey) {
        Object sessionKey = this.uuidGenerator.byteArrayToKey(instanceKey, 0, -1);
        if (_logger.isLoggable(this.TRACE_LEVEL)) {
            _logger.log(this.TRACE_LEVEL, "[SFSBContainer] Got request for: " + sessionKey);
        }
        while (true) {
            SessionContextImpl sc;
            if ((sc = (SessionContextImpl)this.sessionBeanCache.lookupEJB(sessionKey, this, null)) == null) {
                throw new NoSuchObjectLocalException("Invalid Session Key ( " + sessionKey + ")");
            }
            SessionContextImpl sessionContextImpl = sc;
            synchronized (sessionContextImpl) {
                switch (sc.getState()) {
                    case 1: 
                    case 5: {
                        break;
                    }
                    default: {
                        return sc.getEJBObjectImpl();
                    }
                }
            }
        }
    }

    EJBLocalObjectImpl getEJBLocalObjectImpl(Object sessionKey) {
        EJBLocalObjectImpl localObjImpl;
        try {
            localObjImpl = this.instantiateEJBLocalObjectImpl();
            localObjImpl.setKey(sessionKey);
        }
        catch (Exception ex) {
            EJBException ejbEx = new EJBException();
            ejbEx.initCause((Throwable)ex);
            throw ejbEx;
        }
        return localObjImpl;
    }

    void checkExists(EJBLocalRemoteObject ejbObj) {
        if (ejbObj.isRemoved()) {
            throw new NoSuchObjectLocalException("Bean has been removed");
        }
    }

    private final void logTraceInfo(Invocation inv, Object key, String message) {
        _logger.log(this.TRACE_LEVEL, this.traceInfoPrefix + message + " for " + inv.method.getName() + "; key: " + key);
    }

    private final void logTraceInfo(SessionContextImpl sc, String message) {
        _logger.log(this.TRACE_LEVEL, this.traceInfoPrefix + message + " for key: " + sc.getInstanceKey() + "; " + System.identityHashCode(sc));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentContext _getContext(Invocation inv) {
        EJBLocalRemoteObject ejbo = inv.ejbObject;
        SessionContextImpl sc = ejbo.getContext();
        Object sessionKey = ejbo.getKey();
        if (_logger.isLoggable(this.TRACE_LEVEL)) {
            this.logTraceInfo(inv, sessionKey, "Trying to get context");
        }
        if (sc == null) {
            sc = (SessionContextImpl)this.sessionBeanCache.lookupEJB(sessionKey, this, ejbo);
        }
        if (sc == null || sc.getState() == 5) {
            if (_logger.isLoggable(this.TRACE_LEVEL)) {
                this.logTraceInfo(inv, sessionKey, "Context already destroyed");
            }
            throw new NoSuchObjectLocalException("The EJB does not exist. session-key: " + sessionKey);
        }
        SessionContextImpl context = null;
        SessionContextImpl sessionContextImpl = sc;
        synchronized (sessionContextImpl) {
            SessionContextImpl newSC = sc;
            if (sc.getState() == 1 && (newSC = (SessionContextImpl)this.sessionBeanCache.lookupEJB(sessionKey, this, ejbo)) == null) {
                if (_logger.isLoggable(this.TRACE_LEVEL)) {
                    this.logTraceInfo(inv, sessionKey, "Context does not exist");
                }
                throw new NoSuchObjectLocalException("The EJB does not exist. key: " + sessionKey);
            }
            SessionContextImpl sessionContextImpl2 = newSC;
            synchronized (sessionContextImpl2) {
                if (newSC.getState() == 5) {
                    if (_logger.isLoggable(this.TRACE_LEVEL)) {
                        this.logTraceInfo(inv, sessionKey, "Got destroyed context");
                    }
                    throw new NoSuchObjectLocalException("The EJB does not exist. session-key: " + sessionKey);
                }
                if (newSC.getState() == 3) {
                    if (_logger.isLoggable(this.TRACE_LEVEL)) {
                        this.logTraceInfo(inv, sessionKey, "Another invocation in progress");
                    }
                    throw new EJBException("SessionBean is executing another request. session-key: " + sessionKey);
                }
                if (newSC.getState() == 2) {
                    this.decrementMethodReadyStat();
                }
                newSC.setState(3);
                context = newSC;
            }
        }
        context.touch();
        if (context.existsInStore() && this.removalGracePeriodInSeconds > 0) {
            long now = System.currentTimeMillis();
            long threshold = now - (long)(this.removalGracePeriodInSeconds * 1000);
            if (context.getLastPersistedAt() <= threshold) {
                try {
                    this.sfsbStoreManager.updateLastAccessTime(sessionKey, now);
                    context.setLastPersistedAt(System.currentTimeMillis());
                }
                catch (SFSBStoreManagerException sfsbEx) {
                    _logger.log(Level.WARNING, "Couldn't update timestamp for: " + sessionKey + "; Exception: " + sfsbEx);
                    _logger.log(Level.FINE, "Couldn't update timestamp for: " + sessionKey, sfsbEx);
                }
            }
        }
        if (_logger.isLoggable(this.TRACE_LEVEL)) {
            this.logTraceInfo(inv, context, "Got Context!!");
        }
        return context;
    }

    public void releaseContext(Invocation inv) {
        SessionContextImpl sc = (SessionContextImpl)inv.context;
        if (sc.getState() == 5) {
            return;
        }
        Transaction tx = sc.getTransaction();
        try {
            if (tx == null || tx.getStatus() == 6) {
                if (sc.getState() != 2) {
                    if (sc.isAfterCompletionDelayed()) {
                        if (_logger.isLoggable(this.TRACE_LEVEL)) {
                            this.logTraceInfo(inv, sc, "Calling delayed afterCompletion");
                        }
                        this.callEjbAfterCompletion(sc, sc.getCompletedTxStatus());
                    }
                    if (sc.getState() != 5) {
                        sc.setState(2);
                        this.handleEndOfMethodCheckpoint(sc, inv);
                    }
                }
            } else {
                sc.setState(4);
                if (_logger.isLoggable(this.TRACE_LEVEL)) {
                    this.logTraceInfo(inv, sc, "Marking state == INCOMPLETE_TX");
                }
            }
        }
        catch (SystemException ex) {
            throw new EJBException((Exception)((Object)ex));
        }
    }

    void afterBegin(EJBContextImpl context) {
        if (this.isBeanManagedTran) {
            return;
        }
        EnterpriseBean ejb = context.getEJB();
        if (ejb instanceof SessionSynchronization) {
            SessionSynchronization sync = (SessionSynchronization)ejb;
            try {
                sync.afterBegin();
            }
            catch (Exception ex) {
                this.forceDestroyBean(context);
                throw new EJBException("Error during SessionSynchronization..afterBegin(), EJB instance discarded", ex);
            }
        }
        if (this.checkpointPolicy.isHAEnabled()) {
            ContainerSynchronization cSync = null;
            try {
                cSync = this.containerFactory.getContainerSync(context.getTransaction());
                cSync.registerForTxCheckpoint((SessionContextImpl)context);
            }
            catch (RollbackException rollEx) {
                _logger.log(Level.WARNING, "Cannot register bean for checkpointing", rollEx);
            }
            catch (SystemException sysEx) {
                _logger.log(Level.WARNING, "Cannot register bean for checkpointing", sysEx);
            }
        }
    }

    void beforeCompletion(EJBContextImpl context) {
        if (this.isBeanManagedTran) {
            return;
        }
        EnterpriseBean ejb = context.getEJB();
        if (!(ejb instanceof SessionSynchronization)) {
            return;
        }
        Invocation inv = new Invocation(ejb, (Object)this);
        inv.context = context;
        this.invocationManager.preInvoke(inv);
        try {
            this.transactionManager.enlistComponentResources();
            ((SessionSynchronization)ejb).beforeCompletion();
        }
        catch (Exception ex) {
            try {
                this.forceDestroyBean(context);
            }
            catch (Exception e) {
                _logger.log(Level.FINE, "error destroying bean", e);
            }
            throw new EJBException("Error during SessionSynchronization.beforeCompletion, EJB instance discarded", ex);
        }
        finally {
            this.invocationManager.postInvoke(inv);
        }
    }

    void afterCompletion(EJBContextImpl context, int status) {
        if (context.getState() == 5) {
            return;
        }
        SessionContextImpl sc = (SessionContextImpl)context;
        EnterpriseBean ejb = sc.getEJB();
        boolean committed = status == 3 || status == 6;
        sc.setTransaction(null);
        if (!this.isBeanManagedTran && ejb instanceof SessionSynchronization) {
            if (sc.getState() == 3 && !sc.isTxCompleting()) {
                sc.setAfterCompletionDelayed(true);
                sc.setCompletedTxStatus(committed);
                if (_logger.isLoggable(this.TRACE_LEVEL)) {
                    this.logTraceInfo(sc, "AfterCompletion delayed");
                }
                return;
            }
            this.callEjbAfterCompletion(sc, committed);
        }
        if (sc.getState() != 5) {
            if (this.checkpointPolicy.isHAEnabled()) {
                if (this.isBeanManagedTran) {
                    sc.setTxCheckpointDelayed(true);
                    if (_logger.isLoggable(this.TRACE_LEVEL)) {
                        this.logTraceInfo(sc, "(BMT)Checkpoint delayed");
                    }
                }
            } else if (!this.isBeanManagedTran) {
                if (_logger.isLoggable(this.TRACE_LEVEL)) {
                    this.logTraceInfo(sc, "Released context");
                }
                sc.setState(2);
                this.incrementMethodReadyStat();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SFSBBeanState getSFSBBeanState(SessionContextImpl sc) {
        SFSBBeanState sfsbBeanState = null;
        try {
            if (this.containerState != 0 && this.containerState != 1) {
                _logger.log(Level.FINE, "getSFSBBeanState() returning because containerState: " + this.containerState);
                return null;
            }
            if (sc.getState() == 5) {
                return null;
            }
            SessionBean ejb = (SessionBean)sc.getEJB();
            ComponentInvocation ci = new ComponentInvocation(ejb, this, sc);
            this.invocationManager.preInvoke(ci);
            SessionContextImpl sessionContextImpl = sc;
            synchronized (sessionContextImpl) {
                try {
                    ejb.ejbPassivate();
                    sc.setLastPersistedAt(System.currentTimeMillis());
                    byte[] serializedState = IOUtils.serializeObject(sc, true);
                    sfsbBeanState = this.sfsbStoreManager.createSFSBBeanState(sc.getInstanceKey(), System.currentTimeMillis(), !sc.existsInStore(), serializedState);
                    ejb.ejbActivate();
                }
                catch (NotSerializableException serEx) {
                    _logger.log(Level.WARNING, "Error  during checkpoint (" + this.ejbDescriptor.getName() + ") " + serEx);
                    _logger.log(Level.FINE, "sfsb checkpoint error", serEx);
                    try {
                        this.forceDestroyBean(sc);
                    }
                    catch (Exception e) {
                        _logger.log(Level.FINE, "error destroying bean", e);
                    }
                }
                catch (Throwable ex) {
                    _logger.log(Level.WARNING, "ejb.sfsb_checkpoint_error", new Object[]{this.ejbDescriptor.getName()});
                    _logger.log(Level.WARNING, "sfsb checkpoint error", ex);
                    try {
                        this.forceDestroyBean(sc);
                    }
                    catch (Exception e) {
                        _logger.log(Level.FINE, "error destroying bean", e);
                    }
                }
                finally {
                    this.invocationManager.postInvoke(ci);
                }
            }
        }
        catch (Throwable th) {
            _logger.log(Level.WARNING, "ejb.sfsb_checkpoint_error", new Object[]{this.ejbDescriptor.getName()});
            _logger.log(Level.WARNING, "sfsb checkpoint error", th);
        }
        return sfsbBeanState;
    }

    void txCheckpointCompleted(SessionContextImpl sc) {
        if (sc.getState() != 5) {
            sc.setExistsInStore(true);
            sc.setState(2);
            this.incrementMethodReadyStat();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callEjbAfterCompletion(SessionContextImpl context, boolean status) {
        EnterpriseBean ejb = context.getEJB();
        ComponentInvocation ci = new ComponentInvocation(ejb, this, context);
        this.invocationManager.preInvoke(ci);
        try {
            context.setInAfterCompletion(true);
            ((SessionSynchronization)ejb).afterCompletion(status);
            context.setAfterCompletionDelayed(false);
            context.setTxCompleting(false);
        }
        catch (Exception ex) {
            try {
                this.forceDestroyBean(context);
            }
            catch (Exception e) {
                _logger.log(Level.FINE, "error removing bean", e);
            }
            _logger.log(Level.INFO, "ejb.aftercompletion_exception", ex);
        }
        finally {
            context.setInAfterCompletion(false);
            this.invocationManager.postInvoke(ci);
        }
    }

    public final boolean canPassivateEJB(ComponentContext context) {
        SessionContextImpl sc = (SessionContextImpl)context;
        return sc.getState() == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean passivateEJB(ComponentContext context) {
        SessionContextImpl sc = (SessionContextImpl)context;
        boolean success = false;
        try {
            if (this.containerState != 0 && this.containerState != 1) {
                _logger.log(Level.FINE, "passivateEJB() returning because containerState: " + this.containerState);
                return false;
            }
            if (sc.getState() == 5) {
                return false;
            }
            if (_logger.isLoggable(this.TRACE_LEVEL)) {
                _logger.log(this.TRACE_LEVEL, this.traceInfoPrefix + "Passivating context " + sc.getInstanceKey() + "; current-state = " + StatefulSessionContainer.convertCtxStateToString(sc));
            }
            SessionBean ejb = (SessionBean)sc.getEJB();
            long passStartTime = -1L;
            if (this.sfsbStoreMonitor.isMonitoringOn()) {
                passStartTime = System.currentTimeMillis();
            }
            ComponentInvocation ci = new ComponentInvocation(ejb, this, sc);
            this.invocationManager.preInvoke(ci);
            boolean failed = false;
            success = false;
            SessionContextImpl sessionContextImpl = sc;
            synchronized (sessionContextImpl) {
                block24: {
                    block23: {
                        if (sc.getState() != 2) {
                            boolean bl = false;
                            Object var13_14 = null;
                            this.invocationManager.postInvoke(ci);
                            if (passStartTime == -1L) return bl;
                            long timeSpent = System.currentTimeMillis() - passStartTime;
                            this.sfsbStoreMonitor.setPassivationTime(timeSpent);
                            return bl;
                        }
                        sc.setState(1);
                        this.decrementMethodReadyStat();
                        ejb.ejbPassivate();
                        sc.setLastPersistedAt(System.currentTimeMillis());
                        boolean saved = this.sessionBeanCache.passivateEJB(sc, sc.getInstanceKey());
                        if (!saved) {
                            ejb.ejbActivate();
                            sc.setState(2);
                            this.incrementMethodReadyStat();
                            boolean bl = false;
                            Object var13_15 = null;
                            this.invocationManager.postInvoke(ci);
                            if (passStartTime == -1L) return bl;
                            long timeSpent = System.currentTimeMillis() - passStartTime;
                            this.sfsbStoreMonitor.setPassivationTime(timeSpent);
                            return bl;
                        }
                        this.sfsbStoreMonitor.incrementPassivationCount(true);
                        this.transactionManager.ejbDestroyed(sc);
                        if (this.isRemote) {
                            EJBObjectImpl ejbObjImpl = sc.getEJBObjectImpl();
                            ejbObjImpl.clearContext();
                            sc.setEJBObjectImpl(null);
                            this.remoteRefFactory.destroyReference((Remote)ejbObjImpl.getStub(), (Remote)ejbObjImpl.getEJBObject());
                        }
                        if (this.isLocal) {
                            EJBLocalObjectImpl localObjImpl = sc.getEJBLocalObjectImpl();
                            localObjImpl.clearContext();
                            sc.setEJBLocalObjectImpl(null);
                        }
                        if (!_logger.isLoggable(this.TRACE_LEVEL)) break block23;
                        this.logTraceInfo(sc, "Successfully pssivated");
                    }
                    try {
                        Object var13_16 = null;
                        this.invocationManager.postInvoke(ci);
                        if (passStartTime == -1L) return success;
                        long timeSpent = System.currentTimeMillis() - passStartTime;
                        this.sfsbStoreMonitor.setPassivationTime(timeSpent);
                        break block24;
                        catch (NotSerializableException nsEx) {
                            this.sfsbStoreMonitor.incrementPassivationCount(false);
                            _logger.log(Level.WARNING, "Error during passivation: " + sc + "; " + nsEx);
                            _logger.log(Level.FINE, "sfsb passivation error", nsEx);
                            try {
                                this.forceDestroyBean(sc);
                            }
                            catch (Exception e) {
                                _logger.log(Level.FINE, "error destroying bean", e);
                            }
                            Object var13_17 = null;
                            this.invocationManager.postInvoke(ci);
                            if (passStartTime == -1L) return success;
                            timeSpent = System.currentTimeMillis() - passStartTime;
                            this.sfsbStoreMonitor.setPassivationTime(timeSpent);
                        }
                        catch (Exception ex) {
                            this.sfsbStoreMonitor.incrementPassivationCount(false);
                            _logger.log(Level.WARNING, "ejb.sfsb_passivation_error", new Object[]{this.ejbDescriptor.getName() + " <==> " + sc});
                            _logger.log(Level.WARNING, "sfsb passivation error", ex);
                            try {
                                this.forceDestroyBean(sc);
                            }
                            catch (Exception e) {
                                _logger.log(Level.FINE, "error destroying bean", e);
                            }
                            Object var13_18 = null;
                            this.invocationManager.postInvoke(ci);
                            if (passStartTime == -1L) return success;
                            timeSpent = System.currentTimeMillis() - passStartTime;
                            this.sfsbStoreMonitor.setPassivationTime(timeSpent);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var13_19 = null;
                        this.invocationManager.postInvoke(ci);
                        if (passStartTime == -1L) throw throwable;
                        long timeSpent = System.currentTimeMillis() - passStartTime;
                        this.sfsbStoreMonitor.setPassivationTime(timeSpent);
                        throw throwable;
                    }
                }
                return success;
            }
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "ejb.sfsb_passivation_error", new Object[]{this.ejbDescriptor.getName()});
            _logger.log(Level.WARNING, "sfsb passivation error", ex);
        }
        return success;
    }

    public final int getPassivationBatchCount() {
        return this.passivationBatchCount;
    }

    public final void setPassivationBatchCount(int count) {
        this.passivationBatchCount = count;
    }

    public final boolean passivateEJB(StatefulEJBContext sfsbCtx) {
        return this.passivateEJB((ComponentContext)sfsbCtx.getSessionContext());
    }

    public long getMethodReadyCount() {
        return this.statMethodReadyCount;
    }

    public long getPassiveCount() {
        return this.sfsbStoreMonitor == null ? 0L : (long)this.sfsbStoreMonitor.getNumPassivations();
    }

    public void activateEJB(Object sessionKey, StatefulEJBContext sfsbCtx, Object cookie) {
        SessionContextImpl context = (SessionContextImpl)sfsbCtx.getSessionContext();
        if (_logger.isLoggable(this.TRACE_LEVEL)) {
            this.logTraceInfo(context, "Attempting to activate");
        }
        EJBLocalRemoteObject ejbObject = (EJBLocalRemoteObject)cookie;
        SessionBean ejb = (SessionBean)context.getEJB();
        ComponentInvocation ci = new ComponentInvocation(ejb, this, context);
        this.invocationManager.preInvoke(ci);
        try {
            context.touch();
            context.setContainer(this);
            context.setState(2);
            this.incrementMethodReadyStat();
            context.setInstanceKey(sessionKey);
            context.setExistsInStore(true);
            if (ejbObject == null) {
                this.createEJBObjectImpl(context);
            } else if (ejbObject instanceof EJBObjectImpl) {
                context.setEJBObjectImpl((EJBObjectImpl)ejbObject);
                ejbObject.setContext(context);
                ejbObject.setKey(sessionKey);
                byte[] sessionOID = this.uuidGenerator.keyToByteArray(sessionKey);
                EJBObject ejbStub = this.remoteRefFactory.createRemoteReference(sessionOID);
                context.setEJBStub(ejbStub);
                if (this.isLocal) {
                    this.createEJBLocalObjectImpl(context);
                }
            } else if (ejbObject instanceof EJBLocalObjectImpl) {
                context.setEJBLocalObjectImpl((EJBLocalObjectImpl)ejbObject);
                ejbObject.setContext(context);
                ejbObject.setKey(sessionKey);
                if (this.isRemote) {
                    this.createEJBObjectImpl(context);
                }
            }
            ejb.ejbActivate();
            long now = System.currentTimeMillis();
            try {
                this.sfsbStoreManager.updateLastAccessTime(sessionKey, now);
                context.setLastPersistedAt(now);
            }
            catch (SFSBStoreManagerException sfsbEx) {
                _logger.log(Level.WARNING, "Couldn't update timestamp for: " + sessionKey + ";Exception: " + sfsbEx);
                _logger.log(Level.FINE, "Couldn't update timestamp for: " + sessionKey, sfsbEx);
            }
            if (_logger.isLoggable(this.TRACE_LEVEL)) {
                this.logTraceInfo(context, "Successfully activated");
            }
        }
        catch (Exception ex) {
            if (_logger.isLoggable(this.TRACE_LEVEL)) {
                this.logTraceInfo(context, "Failed to activate");
            }
            _logger.log(Level.SEVERE, "ejb.sfsb_activation_error", new Object[]{sessionKey});
            _logger.log(Level.SEVERE, "sfsb activation error", ex);
            throw new EJBException("Unable to activate EJB for key: " + sessionKey, ex);
        }
        finally {
            this.invocationManager.postInvoke(ci);
        }
    }

    public void invokePeriodically(long delay, long periodicity, Runnable target) {
        Timer timer = ContainerFactoryImpl.getContainerService().getTimer();
        PeriodicTask timerTask = new PeriodicTask(this.loader, target);
        timer.scheduleAtFixedRate((TimerTask)timerTask, delay, periodicity);
        this.scheduledTimerTasks.add(timerTask);
    }

    public ContainerService getContainerService() {
        return ContainerFactoryImpl.getContainerService();
    }

    public void onUndeploy(StatefulEJBContext sfsbCtx) {
        this.undeploy((SessionContextImpl)sfsbCtx.getSessionContext());
    }

    public void onShutdown() {
        _logger.log(Level.FINE, "StatefulSessionContainer.onshutdown() called");
        super.onShutdown();
        this.cancelAllTimerTasks();
        this.sessionBeanCache.setShutdownState();
        Iterator iter = this.sessionBeanCache.values();
        while (iter.hasNext()) {
            SessionContextImpl ctx = (SessionContextImpl)iter.next();
            try {
                this.sessionBeanCache.passivateEJB(ctx, ctx.getInstanceKey());
            }
            catch (Exception ex) {
                _logger.log(Level.WARNING, "[" + this.ejbName + "]: Error while " + " saving state during shutdown. Key: " + ctx.getInstanceKey());
                _logger.log(Level.FINE, "[" + this.ejbName + "]: Error while " + " saving state during shutdown. Key: " + ctx.getInstanceKey(), ex);
            }
        }
        this.sessionBeanCache.destroy();
        try {
            this.sfsbStoreManager.shutdown();
        }
        catch (SFSBStoreManagerException sfsbEx) {
            _logger.log(Level.WARNING, "[" + this.ejbName + "]: Error during " + "storeManager.shutdown()", sfsbEx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy() {
        _logger.log(Level.FINE, "StatefulSessionContainer.undeploy() called");
        super.setUndeployedState();
        try {
            this.cancelAllTimerTasks();
            this.sessionBeanCache.setUndeployedState();
            Iterator iter = this.sessionBeanCache.values();
            while (iter.hasNext()) {
                SessionContextImpl ctx = (SessionContextImpl)iter.next();
                try {
                    this.undeploy(ctx);
                }
                catch (Exception ex) {
                    _logger.log(Level.WARNING, "[" + this.ejbName + "]: Error while " + " undeploying ctx. Key: " + ctx.getInstanceKey());
                    _logger.log(Level.FINE, "[" + this.ejbName + "]: Error while " + " undeploying ctx. Key: " + ctx.getInstanceKey(), ex);
                }
            }
            this.sessionBeanCache.destroy();
            try {
                this.sfsbStoreManager.removeAll();
            }
            catch (SFSBStoreManagerException sfsbEx) {
                _logger.log(Level.WARNING, "[" + this.ejbName + "]: Error during " + "storeManager.shutdown()", sfsbEx);
            }
            Object var5_5 = null;
            super.undeploy();
            this.passivationCandidates = null;
            this.asyncTaskSemaphore = null;
            this.sessionBeanCache = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            super.undeploy();
            this.passivationCandidates = null;
            this.asyncTaskSemaphore = null;
            this.sessionBeanCache = null;
            throw throwable;
        }
    }

    private void cancelAllTimerTasks() {
        try {
            int size = this.scheduledTimerTasks.size();
            for (int i = 0; i < size; ++i) {
                TimerTask task = (TimerTask)this.scheduledTimerTasks.get(i);
                task.cancel();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void undeploy(SessionContextImpl ctx) {
        if (ctx.getContainer() == this) {
            EJBObjectImpl ejbObjectImpl;
            if (this.isRemote && (ejbObjectImpl = ctx.getEJBObjectImpl()) != null) {
                this.remoteRefFactory.destroyReference((Remote)ejbObjectImpl.getStub(), (Remote)ejbObjectImpl.getEJBObject());
            }
            this.sessionBeanCache.remove(ctx.getInstanceKey(), ctx.existsInStore());
            this.transactionManager.ejbDestroyed(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimEvent(Object primaryKey, Object context) {
        boolean addTask = false;
        Object object = this.asyncTaskSemaphore;
        synchronized (object) {
            ++this.containerTrimCount;
            this.passivationCandidates.add(context);
            int requiredTaskCount = this.passivationCandidates.size() / this.passivationBatchCount;
            boolean bl = addTask = this.asyncTaskCount < requiredTaskCount;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "qSize: " + this.passivationCandidates.size() + "; batchCount: " + this.passivationBatchCount + "; asyncTaskCount: " + this.asyncTaskCount + "; requiredTaskCount: " + requiredTaskCount + "; ADDED TASK ==> " + addTask);
            }
            if (!addTask) {
                return;
            }
            ++this.asyncTaskCount;
            ++this.asyncCummTaskCount;
        }
        try {
            ASyncPassivator work = new ASyncPassivator();
            ContainerWorkPool.addLast(work);
        }
        catch (Exception ex) {
            Object object2 = this.asyncTaskSemaphore;
            synchronized (object2) {
                --this.asyncTaskCount;
            }
            _logger.log(Level.WARNING, "ejb.add_cleanup_task_error", ex);
        }
    }

    public void setSFSBUUIDUtil(SFSBUUIDUtil util) {
        this.uuidGenerator = util;
    }

    public void setCheckpointPolicy(CheckpointPolicy policy) {
        this.checkpointPolicy = policy;
    }

    public void setSFSBStoreManager(SFSBStoreManager storeManager) {
        this.sfsbStoreManager = storeManager;
    }

    public void setSessionCache(LruSessionCache cache) {
        this.sessionBeanCache = cache;
    }

    public SFSBStoreManager getSFSBStoreManager() {
        return this.sfsbStoreManager;
    }

    public void setRemovalGracePeriodInSeconds(int val) {
        this.removalGracePeriodInSeconds = val;
    }

    public void removeExpiredSessions() {
        try {
            _logger.log(Level.FINE, "StatefulContainer Removing expired sessions....");
            long val = this.sfsbStoreManager.removeExpiredSessions();
            this.sfsbStoreMonitor.incrementExpiredSessionsRemoved(val);
            _logger.log(Level.FINE, "StatefulContainer Removed " + val + " sessions....");
        }
        catch (SFSBStoreManagerException sfsbEx) {
            _logger.log(Level.WARNING, "Got exception from store manager", sfsbEx);
        }
    }

    private void handleEndOfMethodCheckpoint(SessionContextImpl sc, Invocation inv) {
        int txAttr = inv.invocationInfo.txAttr;
        switch (txAttr) {
            case 1: 
            case 4: 
            case 7: {
                if (!inv.invocationInfo.checkpointEnabled) break;
                this.checkpointEJB(sc);
                break;
            }
            case 2: {
                if (!sc.isTxCheckpointDelayed() && !inv.invocationInfo.checkpointEnabled) break;
                this.checkpointEJB(sc);
                sc.setTxCheckpointDelayed(false);
                break;
            }
            default: {
                if (!inv.invocationInfo.isCreateHomeFinder || !inv.invocationInfo.checkpointEnabled) break;
                this.checkpointEJB(sc);
            }
        }
        if (sc.getState() != 5) {
            sc.setState(2);
            this.incrementMethodReadyStat();
            if (_logger.isLoggable(this.TRACE_LEVEL)) {
                this.logTraceInfo(inv, sc.getInstanceKey(), "Released context");
            }
        }
    }

    public int getMaxCacheSize() {
        return this.sessionBeanCache.getMaxCacheSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkpointEJB(SessionContextImpl sc) {
        boolean checkpointed = false;
        try {
            if (this.containerState != 0 && this.containerState != 1) {
                _logger.log(Level.FINE, "passivateEJB() returning because containerState: " + this.containerState);
                return false;
            }
            if (sc.getState() == 5) {
                return false;
            }
            SessionBean ejb = (SessionBean)sc.getEJB();
            long checkpointStartTime = -1L;
            if (this.sfsbStoreMonitor.isMonitoringOn()) {
                checkpointStartTime = System.currentTimeMillis();
            }
            ComponentInvocation ci = new ComponentInvocation(ejb, this, sc);
            this.invocationManager.preInvoke(ci);
            SessionContextImpl sessionContextImpl = sc;
            synchronized (sessionContextImpl) {
                block17: {
                    try {
                        if (sc.getState() != 2) {
                            boolean bl = false;
                            Object var12_11 = null;
                            this.invocationManager.postInvoke(ci);
                            if (checkpointStartTime == -1L) return bl;
                            long timeSpent = System.currentTimeMillis() - checkpointStartTime;
                            this.sfsbStoreMonitor.setCheckpointTime(timeSpent);
                            return bl;
                        }
                        sc.setState(1);
                        this.decrementMethodReadyStat();
                        ejb.ejbPassivate();
                        sc.setLastPersistedAt(System.currentTimeMillis());
                        byte[] serializedState = IOUtils.serializeObject(sc, true);
                        SFSBBeanState beanState = this.sfsbStoreManager.createSFSBBeanState(sc.getInstanceKey(), sc.getLastAccessTime(), !sc.existsInStore(), serializedState);
                        try {
                            this.sfsbStoreManager.checkpointSave(beanState);
                            sc.setLastPersistedAt(System.currentTimeMillis());
                            sc.setExistsInStore(true);
                        }
                        catch (Exception ignorableEx) {
                            _logger.log(Level.WARNING, "Error during checkpoint", ignorableEx);
                        }
                        ejb.ejbActivate();
                        sc.setState(2);
                        this.incrementMethodReadyStat();
                        this.sfsbStoreMonitor.setCheckpointSize(serializedState.length);
                        this.sfsbStoreMonitor.incrementCheckpointCount(true);
                        Object var12_12 = null;
                        this.invocationManager.postInvoke(ci);
                        if (checkpointStartTime == -1L) return checkpointed;
                        long timeSpent = System.currentTimeMillis() - checkpointStartTime;
                        this.sfsbStoreMonitor.setCheckpointTime(timeSpent);
                        break block17;
                        catch (Throwable ex) {
                            this.sfsbStoreMonitor.incrementCheckpointCount(false);
                            _logger.log(Level.WARNING, "ejb.sfsb_checkpoint_error", new Object[]{this.ejbDescriptor.getName()});
                            _logger.log(Level.WARNING, "sfsb checkpoint error", ex);
                            try {
                                this.forceDestroyBean(sc);
                            }
                            catch (Exception e) {
                                _logger.log(Level.FINE, "error destroying bean", e);
                            }
                            Object var12_13 = null;
                            this.invocationManager.postInvoke(ci);
                            if (checkpointStartTime == -1L) return checkpointed;
                            timeSpent = System.currentTimeMillis() - checkpointStartTime;
                            this.sfsbStoreMonitor.setCheckpointTime(timeSpent);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var12_14 = null;
                        this.invocationManager.postInvoke(ci);
                        if (checkpointStartTime == -1L) throw throwable;
                        long timeSpent = System.currentTimeMillis() - checkpointStartTime;
                        this.sfsbStoreMonitor.setCheckpointTime(timeSpent);
                        throw throwable;
                    }
                }
                return checkpointed;
            }
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "ejb.sfsb_passivation_error", new Object[]{this.ejbDescriptor.getName()});
            _logger.log(Level.WARNING, "sfsb passivation error", ex);
        }
        return checkpointed;
    }

    public void incrementMethodReadyStat() {
        ++this.statMethodReadyCount;
    }

    public void decrementMethodReadyStat() {
        --this.statMethodReadyCount;
    }

    private class ASyncPassivator
    implements Servicable {
        private ASyncPassivator() {
        }

        public void prolog() {
        }

        public void epilog() {
        }

        public void service() {
            this.run();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            ClassLoader previousClassLoader;
            Thread currentThread;
            block14: {
                currentThread = Thread.currentThread();
                previousClassLoader = currentThread.getContextClassLoader();
                ClassLoader myClassLoader = StatefulSessionContainer.this.loader;
                boolean decrementedTaskCount = false;
                try {
                    try {
                        AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                currentThread.setContextClassLoader(((ASyncPassivator)this).StatefulSessionContainer.this.loader);
                                return null;
                            }
                        });
                        ComponentContext ctx = null;
                        while (true) {
                            Object object = StatefulSessionContainer.this.asyncTaskSemaphore;
                            synchronized (object) {
                                int sz = StatefulSessionContainer.this.passivationCandidates.size();
                                if (sz <= 0) break;
                                ctx = (ComponentContext)StatefulSessionContainer.this.passivationCandidates.remove(sz - 1);
                            }
                            StatefulSessionContainer.this.passivateEJB(ctx);
                        }
                        {
                        }
                        Object var10_9 = null;
                        if (decrementedTaskCount) break block14;
                    }
                    catch (Throwable th) {
                        th.printStackTrace();
                        Object var10_10 = null;
                        if (!decrementedTaskCount) {
                            Object object = StatefulSessionContainer.this.asyncTaskSemaphore;
                            synchronized (object) {
                                StatefulSessionContainer.this.asyncTaskCount--;
                            }
                        }
                        AccessController.doPrivileged(new PrivilegedAction(this, currentThread, previousClassLoader){
                            private final /* synthetic */ Thread val$currentThread;
                            private final /* synthetic */ ClassLoader val$previousClassLoader;
                            private final /* synthetic */ ASyncPassivator this$1;
                            {
                                this.this$1 = this$1;
                                this.val$currentThread = val$currentThread;
                                this.val$previousClassLoader = val$previousClassLoader;
                            }

                            public Object run() {
                                this.val$currentThread.setContextClassLoader(this.val$previousClassLoader);
                                return null;
                            }
                        });
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    if (!decrementedTaskCount) {
                        Object object = StatefulSessionContainer.this.asyncTaskSemaphore;
                        synchronized (object) {
                            StatefulSessionContainer.this.asyncTaskCount--;
                        }
                    }
                    AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                    throw throwable;
                }
                Object object = StatefulSessionContainer.this.asyncTaskSemaphore;
                synchronized (object) {
                    StatefulSessionContainer.this.asyncTaskCount--;
                }
            }
            AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
        }
    }
}

