/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.ComponentContext;
import com.sun.ejb.Container;
import com.sun.ejb.Invocation;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EJBLocalObjectImpl;
import com.sun.ejb.containers.EJBObjectImpl;
import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.J2EETransactionManager;
import com.sun.enterprise.SecurityManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.RoleReference;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.security.Identity;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBContext;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.EnterpriseBean;
import javax.transaction.Transaction;
import javax.transaction.UserTransaction;

public abstract class EJBContextImpl
implements EJBContext,
ComponentContext,
Serializable {
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EJBContextImpl.class);
    protected static int NOT_INITIALIZED = -999;
    private EnterpriseBean ejb;
    protected transient BaseContainer container;
    protected transient Transaction transaction = null;
    private transient ArrayList resources;
    private transient int concInvokeCount = 0;
    protected transient EJBObject ejbStub = null;
    protected transient EJBObjectImpl ejbObjectImpl;
    protected transient EJBLocalObjectImpl ejbLocalObjectImpl;
    private transient long lastTimeUsed;
    protected transient int state;
    protected final boolean isRemoteInterfaceSupported;
    protected final boolean isLocalInterfaceSupported;
    protected transient boolean inEjbRemove;

    EJBContextImpl(EnterpriseBean ejb, BaseContainer container) {
        this.ejb = ejb;
        this.container = container;
        this.state = NOT_INITIALIZED;
        this.inEjbRemove = false;
        this.isRemoteInterfaceSupported = container.isRemoteInterfaceSupported();
        this.isLocalInterfaceSupported = container.isLocalInterfaceSupported();
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public void setTransaction(Transaction tr) {
        this.transaction = tr;
    }

    void setEJBStub(EJBObject ejbStub) {
        this.ejbStub = ejbStub;
    }

    void setEJBLocalObjectImpl(EJBLocalObjectImpl localObjectImpl) {
        this.ejbLocalObjectImpl = localObjectImpl;
    }

    void setEJBObjectImpl(EJBObjectImpl ejbo) {
        this.ejbObjectImpl = ejbo;
    }

    EJBObjectImpl getEJBObjectImpl() {
        return this.ejbObjectImpl;
    }

    EJBLocalObjectImpl getEJBLocalObjectImpl() {
        return this.ejbLocalObjectImpl;
    }

    void setContainer(BaseContainer container) {
        this.container = container;
    }

    void setState(int s) {
        this.state = s;
    }

    boolean isTimedObject() {
        return this.container.isTimedObject();
    }

    int getState() {
        return this.state;
    }

    void setInEjbRemove(boolean beingRemoved) {
        this.inEjbRemove = beingRemoved;
    }

    boolean isInEjbRemove() {
        return this.inEjbRemove;
    }

    boolean isUnitialized() {
        return this.state == NOT_INITIALIZED;
    }

    public long getLastTimeUsed() {
        return this.lastTimeUsed;
    }

    void setSoftRef(SoftReference softRef) {
    }

    void setHardRef(Object referent) {
    }

    void touch() {
        this.lastTimeUsed = System.currentTimeMillis();
    }

    public EnterpriseBean getEJB() {
        return this.ejb;
    }

    public Container getContainer() {
        return this.container;
    }

    public void registerResource(ResourceHandle h) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        this.resources.add(h);
    }

    public void unregisterResource(ResourceHandle h) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        this.resources.remove(h);
    }

    public List getResourceList() {
        if (this.resources == null) {
            this.resources = new ArrayList(0);
        }
        return this.resources;
    }

    public int getConcurrentInvokeCount() {
        return this.concInvokeCount;
    }

    public synchronized void incrementConcurrentInvokeCount() {
        ++this.concInvokeCount;
    }

    public synchronized void decrementConcurrentInvokeCount() {
        --this.concInvokeCount;
    }

    public EJBObject getEJBObject() throws IllegalStateException {
        if (this.ejbStub == null) {
            throw new IllegalStateException("EJBObject not available");
        }
        return this.ejbStub;
    }

    public EJBLocalObject getEJBLocalObject() throws IllegalStateException {
        if (this.ejbLocalObjectImpl == null) {
            throw new IllegalStateException("EJBLocalObject not available");
        }
        return this.ejbLocalObjectImpl.getEJBLocalObject();
    }

    public EJBHome getEJBHome() {
        if (!this.isRemoteInterfaceSupported) {
            throw new IllegalStateException("EJBHome not available");
        }
        return this.container.getEJBHomeStub();
    }

    public EJBLocalHome getEJBLocalHome() {
        if (!this.isLocalInterfaceSupported) {
            throw new IllegalStateException("EJBLocalHome not available");
        }
        return this.container.getEJBLocalHome();
    }

    public Properties getEnvironment() {
        return this.container.getEnvironmentProperties();
    }

    public Identity getCallerIdentity() {
        throw new RuntimeException("getCallerIdentity() is deprecated, please use getCallerPrincipal().");
    }

    public Principal getCallerPrincipal() {
        this.checkAccessToCallerSecurity();
        SecurityManager sm = this.container.getSecurityManager();
        return sm.getCallerPrincipal();
    }

    public boolean isCallerInRole(Identity identity) {
        return this.isCallerInRole(identity.getName());
    }

    public boolean isCallerInRole(String roleRef) {
        if (roleRef == null) {
            throw new IllegalArgumentException("Argument is null");
        }
        this.checkAccessToCallerSecurity();
        EjbDescriptor ejbd = this.container.getEjbDescriptor();
        RoleReference rr = ejbd.getRoleReferenceByName(roleRef);
        if (rr == null) {
            throw new IllegalArgumentException("No mapping available for role reference " + roleRef);
        }
        SecurityManager sm = this.container.getSecurityManager();
        return sm.isCallerInRole(roleRef);
    }

    protected void checkAccessToCallerSecurity() throws IllegalStateException {
        throw new IllegalStateException("Operation not allowed");
    }

    public UserTransaction getUserTransaction() throws IllegalStateException {
        throw new IllegalStateException("Operation not allowed");
    }

    public void setRollbackOnly() throws IllegalStateException {
        if (this.state == NOT_INITIALIZED) {
            throw new IllegalStateException("EJB not in READY state");
        }
        if (this.container.isBeanManagedTx()) {
            throw new IllegalStateException("Illegal operation for bean-managed transactions");
        }
        J2EETransactionManager tm = Switch.getSwitch().getTransactionManager();
        try {
            if (tm.getStatus() == 6) {
                throw new IllegalStateException("No transaction context.");
            }
            this.checkActivatePassivate();
            tm.setRollbackOnly();
        }
        catch (Exception ex) {
            IllegalStateException illEx = new IllegalStateException(ex.toString());
            illEx.initCause(ex);
            throw illEx;
        }
    }

    public boolean getRollbackOnly() throws IllegalStateException {
        if (this.state == NOT_INITIALIZED) {
            throw new IllegalStateException("EJB not in READY state");
        }
        if (this.container.isBeanManagedTx()) {
            throw new IllegalStateException("Illegal operation for bean-managed transactions");
        }
        J2EETransactionManager tm = Switch.getSwitch().getTransactionManager();
        try {
            int status = tm.getStatus();
            if (status == 6) {
                throw new IllegalStateException("No transaction context.");
            }
            this.checkActivatePassivate();
            return status == 1 || status == 4 || status == 9;
        }
        catch (Exception ex) {
            _logger.log(Level.FINE, "Exception in method getRollbackOnly()", ex);
            IllegalStateException illEx = new IllegalStateException(ex.toString());
            illEx.initCause(ex);
            throw illEx;
        }
    }

    public void checkTimerServiceMethodAccess() throws IllegalStateException {
        throw new IllegalStateException("EJB Timer Service method calls cannot be called in this context");
    }

    protected void checkActivatePassivate() throws IllegalStateException {
        if (this.inActivatePassivate()) {
            throw new IllegalStateException("Operation not allowed.");
        }
    }

    protected boolean inActivatePassivate() {
        return this.inActivatePassivate(this.container.invocationManager.getCurrentInvocation());
    }

    protected boolean inActivatePassivate(ComponentInvocation inv) {
        boolean inActivatePassivate = false;
        if (inv instanceof Invocation) {
            Method currentMethod = ((Invocation)inv).method;
            inActivatePassivate = currentMethod != null ? currentMethod.getName().equals("ejbActivate") || currentMethod.getName().equals("ejbPassivate") : false;
        }
        return inActivatePassivate;
    }

    protected void checkEjbTimeout() throws IllegalStateException {
        this.checkEjbTimeout(this.container.invocationManager.getCurrentInvocation());
    }

    protected void checkEjbTimeout(ComponentInvocation inv) throws IllegalStateException {
        Method currentMethod;
        if (inv instanceof Invocation && (currentMethod = ((Invocation)inv).method) != null && currentMethod.getName().equals("ejbTimeout")) {
            throw new IllegalStateException("Operation not allowed.");
        }
    }

    void deleteAllReferences() {
        this.ejb = null;
        this.container = null;
        this.transaction = null;
        this.resources = null;
        this.ejbStub = null;
        this.ejbObjectImpl = null;
        this.ejbLocalObjectImpl = null;
    }
}

