/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.codegen;

import com.sun.ejb.EJBUtils;
import com.sun.ejb.codegen.CmpCompiler;
import com.sun.ejb.codegen.CmpCompilerException;
import com.sun.ejb.codegen.EjbcContext;
import com.sun.ejb.codegen.GeneratedNames;
import com.sun.ejb.codegen.Generator;
import com.sun.ejb.codegen.GeneratorException;
import com.sun.ejb.codegen.HomeGenerator;
import com.sun.ejb.codegen.JavaCompiler;
import com.sun.ejb.codegen.JavaCompilerException;
import com.sun.ejb.codegen.RMICompiler;
import com.sun.ejb.codegen.WrapperGenerator;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.DeploymentContext;
import com.sun.enterprise.deployment.DirectoryArchive;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.backend.WebServiceDeployer;
import com.sun.enterprise.util.TypeUtil;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.zip.ZipFileException;
import com.sun.enterprise.util.zip.ZipItem;
import com.sun.enterprise.webservice.codegen.JaxRpcCodegenAdapter;
import com.sun.enterprise.webservice.codegen.JaxRpcCodegenFactory;
import com.sun.logging.LogDomains;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class IASEJBC {
    private static final StringManager localStrings = StringManager.getManager(IASEJBC.class);
    private static final Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");
    static /* synthetic */ Class class$java$rmi$Remote;

    private IASEJBC() {
    }

    private String getFileName(String className, String repository) {
        return repository + File.separator + className.replace('.', File.separatorChar) + ".java";
    }

    private String getClassName(String fileName, String repository) {
        String className = fileName;
        if (className.startsWith(repository)) {
            className = className.substring(repository.length());
        }
        if (className.indexOf(".java") != -1) {
            className = className.substring(0, className.indexOf(".java"));
        } else if (className.indexOf(".class") != -1) {
            className = className.substring(0, className.indexOf(".class"));
        }
        className = className.replace(File.separatorChar, '.');
        if (className.charAt(0) == '.') {
            className = className.substring(1);
        }
        return className;
    }

    private OutputStream createOutputStream(String fileName) throws IOException {
        File file = new File(fileName);
        File parent = null;
        parent = file.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        FileOutputStream out = new FileOutputStream(fileName);
        BufferedOutputStream bout = new BufferedOutputStream(out);
        return bout;
    }

    private String generateCode(Generator gen, Vector files, File rep) throws Exception {
        String genFile = null;
        String genClass = gen.getGeneratedClass();
        String repository = rep.getCanonicalPath();
        genFile = this.getFileName(genClass, repository);
        OutputStream out = this.createOutputStream(genFile);
        gen.generate(out);
        out.close();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "[EJBC] Adding to generated files: " + genFile);
        }
        files.addElement(genFile);
        return genFile;
    }

    private void compileAndRmic(String classPath, List rmicOptions, Set stubClasses, File destDir, String repository) throws GeneratorException, IOException {
        if (stubClasses.size() == 0) {
            _logger.log(Level.FINE, "[EJBC] No code generation required");
            return;
        }
        this.progress(localStrings.getStringWithDefault("generator.compiling_rmi_iiop", "Compiling RMI-IIOP code."));
        ArrayList<String> options = new ArrayList<String>();
        ArrayList<String> fileList = new ArrayList<String>();
        options.addAll(rmicOptions);
        options.add("-classpath");
        String bigClasspath = System.getProperty("java.class.path") + File.pathSeparator + classPath + File.pathSeparator + repository;
        options.add(bigClasspath);
        options.add("-d");
        options.add(destDir.toString());
        Iterator extraIter = stubClasses.iterator();
        while (extraIter.hasNext()) {
            String next = (String)extraIter.next();
            _logger.log(Level.FINE, "[EJBC] rmic " + next + "...");
            fileList.add(next);
        }
        try {
            RMICompiler rmic = new RMICompiler(options, fileList);
            rmic.setClasspath(bigClasspath);
            rmic.compile();
        }
        catch (JavaCompilerException e) {
            _logger.log(Level.FINE, "ejbc.codegen_rmi_fail", e);
            String msg = localStrings.getString("generator.rmic_compilation_failed");
            GeneratorException ge = new GeneratorException(msg);
            ge.initCause(e);
            throw ge;
        }
        if (_logger.isLoggable(Level.FINE)) {
            StringBuffer sbuf = new StringBuffer();
            Iterator it = options.iterator();
            while (it.hasNext()) {
                sbuf.append("\n\t").append(it.next());
            }
            it = fileList.iterator();
            while (it.hasNext()) {
                sbuf.append("\n\t").append(it.next());
            }
            _logger.log(Level.FINE, "[EJBC] RMIC COMMAND: " + sbuf.toString());
        }
    }

    public static void compileClasses(String classPath, Vector files, File destDir, String repository, List javacOptions) throws GeneratorException {
        long start;
        ArrayList<String> options = new ArrayList<String>();
        ArrayList fileList = new ArrayList();
        if (files.size() <= 0) {
            return;
        }
        options.addAll(javacOptions);
        options.add("-d");
        options.add(destDir.toString());
        options.add("-classpath");
        options.add(System.getProperty("java.class.path") + File.pathSeparator + classPath + File.pathSeparator + repository);
        fileList.addAll(files);
        Iterator it = fileList.iterator();
        while (it.hasNext()) {
            String file = (String)it.next();
            _logger.log(Level.FINE, localStrings.getStringWithDefault("generator.compile", "Compiling {0} ...", new Object[]{file}));
        }
        if (_logger.isLoggable(Level.FINE)) {
            StringBuffer sbuf = new StringBuffer();
            Iterator it2 = options.iterator();
            while (it2.hasNext()) {
                sbuf.append("\n\t").append((String)it2.next());
            }
            _logger.log(Level.FINE, "[EJBC] JAVAC COMMAND: " + sbuf.toString());
        }
        long end = start = System.currentTimeMillis();
        try {
            JavaCompiler jc = new JavaCompiler(options, fileList);
            jc.compile();
        }
        catch (JavaCompilerException jce) {
            _logger.log(Level.FINE, "ejbc.codegen_compile_failed", jce);
            String msg = localStrings.getStringWithDefault("generator.java_complilation_failed", "Compilation failed: {0}", new Object[]{jce.getMessage()});
            GeneratorException ge = new GeneratorException(msg);
            ge.initCause(jce);
            throw ge;
        }
        end = System.currentTimeMillis();
        _logger.log(Level.FINE, "JAVA compile time (" + fileList.size() + " files) = " + (end - start));
    }

    private void addGeneratedFiles(Set stubClasses, Vector allClientFiles, File stubsDir) {
        Iterator iter = stubClasses.iterator();
        while (iter.hasNext()) {
            String next = (String)iter.next();
            String stubFile = stubsDir.toString() + File.separator + GeneratedNames.getStubName(next).replace('.', File.separatorChar) + ".class";
            allClientFiles.add(stubFile);
        }
        _logger.log(Level.FINE, "[EJBC] Generated client files: " + allClientFiles);
    }

    private ZipItem[] getClientZipEntries(Vector allClientFiles, File stubsDir) throws IOException, ZipFileException {
        int CLIENT_SZ = allClientFiles.size();
        ZipItem[] zipEntries = new ZipItem[CLIENT_SZ];
        String stubsDirPath = stubsDir.toString();
        for (int i = 0; i < CLIENT_SZ; ++i) {
            String longName = (String)allClientFiles.elementAt(i);
            File file = new File(longName);
            _logger.log(Level.FINE, "[EJBC] stubs - >>" + longName);
            String entryName = "";
            if (longName.startsWith(stubsDirPath)) {
                entryName = longName.substring(stubsDirPath.length());
                if (entryName.charAt(0) == File.separatorChar) {
                    entryName = entryName.substring(1);
                }
            } else {
                String msg = localStrings.getString("generator.unknown_class_prefix");
                throw new RuntimeException(msg);
            }
            entryName = entryName.replace(File.separatorChar, '/');
            zipEntries[i] = new ZipItem(file, entryName);
        }
        return zipEntries;
    }

    private Set getRemoteSuperInterfaces(ClassLoader jcl, String homeRemoteIntf) throws ClassNotFoundException {
        Set allSuperInterfaces = TypeUtil.getSuperInterfaces(jcl, homeRemoteIntf, "java.rmi.Remote");
        HashSet<String> remoteSuperInterfaces = new HashSet<String>();
        Iterator iter = allSuperInterfaces.iterator();
        while (iter.hasNext()) {
            String intfName;
            Class<?> intfClass;
            if (!(class$java$rmi$Remote == null ? IASEJBC.class$("java.rmi.Remote") : class$java$rmi$Remote).isAssignableFrom(intfClass = jcl.loadClass(intfName = (String)iter.next())) || intfName.equals("javax.ejb.EJBHome") || intfName.equals("javax.ejb.EJBObject")) continue;
            remoteSuperInterfaces.add(intfName);
        }
        return remoteSuperInterfaces;
    }

    private Set getEjbClientStubClasses(ClassLoader jcl, Application application, Set stubClasses) throws IOException, ClassNotFoundException {
        HashSet<String> ejbClientStubClasses = new HashSet<String>();
        String BASE_HOME = "javax.ejb.EJBHome";
        String BASE_REMOTE = "javax.ejb.EJBObject";
        Vector ejbRefs = application.getEjbReferenceDescriptors();
        for (int i = 0; i < ejbRefs.size(); ++i) {
            EjbReferenceDescriptor next = (EjbReferenceDescriptor)ejbRefs.get(i);
            if (next.isLocal()) continue;
            String home = next.getEjbHomeInterface();
            String remote = next.getEjbInterface();
            ejbClientStubClasses.add(home);
            Set homeSuperIntfs = this.getRemoteSuperInterfaces(jcl, home);
            ejbClientStubClasses.addAll(homeSuperIntfs);
            ejbClientStubClasses.add(remote);
            Set remoteSuperIntfs = this.getRemoteSuperInterfaces(jcl, remote);
            ejbClientStubClasses.addAll(remoteSuperIntfs);
        }
        return ejbClientStubClasses;
    }

    private Set getStubClasses(ClassLoader jcl, Set ejbHomeInterfaces, Set ejbRemoteInterfaces, List remoteEjbDescriptors) throws IOException, ClassNotFoundException {
        HashSet<String> stubClasses = new HashSet<String>();
        Iterator iter = remoteEjbDescriptors.iterator();
        while (iter.hasNext()) {
            EjbDescriptor desc = (EjbDescriptor)iter.next();
            String home = desc.getHomeClassName();
            String remote = desc.getRemoteClassName();
            stubClasses.add(home);
            Set homeSuperIntfs = this.getRemoteSuperInterfaces(jcl, home);
            stubClasses.addAll(homeSuperIntfs);
            stubClasses.add(remote);
            Set remoteSuperIntfs = this.getRemoteSuperInterfaces(jcl, remote);
            stubClasses.addAll(remoteSuperIntfs);
        }
        return stubClasses;
    }

    private String getClassPath(String[] paths, File other) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < paths.length; ++i) {
            sb.append(paths[i] + File.pathSeparator);
        }
        if (other != null) {
            sb.append(other.toString());
        }
        return sb.toString();
    }

    public static ZipItem[] ejbc(EjbcContext ejbcCtx) throws GeneratorException, ClassNotFoundException, IOException, CmpCompilerException, Exception {
        IASEJBC ejbc = new IASEJBC();
        return ejbc.doCompile(ejbcCtx);
    }

    private ZipItem[] doCompile(EjbcContext ejbcCtx) throws GeneratorException, ClassNotFoundException, IOException, CmpCompilerException, Exception {
        Iterator itr;
        long time;
        File stubsDir = ejbcCtx.getStubsDir();
        Application application = ejbcCtx.getDescriptor();
        long startTime = this.now();
        _logger.log(Level.INFO, "ejbc.begin", application.getRegistrationName());
        String classPath = this.getClassPath(ejbcCtx.getClasspathUrls(), stubsDir);
        final ClassLoader jcl = application.getClassLoader();
        if (!stubsDir.exists()) {
            stubsDir.mkdirs();
        }
        String gnrtrTMP = stubsDir.getCanonicalPath();
        final ClassLoader oContextCL = Thread.currentThread().getContextClassLoader();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(jcl);
                return null;
            }
        });
        if (application.containsCMPEntity()) {
            CmpCompiler cmpc = new CmpCompiler(ejbcCtx);
            cmpc.compile();
        }
        Vector<EjbDescriptor> ejbRemoteDeploymentDescriptors = new Vector<EjbDescriptor>();
        Vector<EjbDescriptor> ejbLocalDeploymentDescriptors = new Vector<EjbDescriptor>();
        HashSet<String> ejbHomeInterfaces = new HashSet<String>();
        HashSet<String> ejbRemoteInterfaces = new HashSet<String>();
        int ejbCount = 0;
        Iterator iter = application.getEjbDescriptors().iterator();
        boolean ejbUseDynamicProxies = EJBUtils.getEjbUseDynamicProxies();
        boolean generateRmicStubs = ejbcCtx.getDeploymentRequest().getGenerateRMIStubs();
        while (iter.hasNext()) {
            ++ejbCount;
            EjbDescriptor next = (EjbDescriptor)iter.next();
            if (!next.isRemoteInterfacesSupported() && !next.isLocalInterfacesSupported()) continue;
            if (next.isLocalInterfacesSupported()) {
                if (ejbUseDynamicProxies) {
                    _logger.log(Level.FINE, "Skipping local ejb code generation for " + next.getName());
                } else {
                    ejbLocalDeploymentDescriptors.addElement(next);
                }
            }
            if (!next.isRemoteInterfacesSupported()) continue;
            String jndiName = next.getJndiName();
            if (jndiName == null || "".equals(jndiName)) {
                String appid = next.getApplication().getRegistrationName();
                String archiveuri = next.getEjbBundleDescriptor().getModuleDescriptor().getArchiveUri();
                String ejbname = next.getName();
                String msg = localStrings.getString("generator.invalid_jndi_name", jndiName, appid, archiveuri, ejbname);
                throw new GeneratorException(msg);
            }
            if (generateRmicStubs) {
                ejbRemoteDeploymentDescriptors.addElement(next);
                ejbHomeInterfaces.add(next.getHomeClassName());
                ejbRemoteInterfaces.add(next.getRemoteClassName());
                continue;
            }
            _logger.log(Level.FINE, "Skipping RMI-IIOP STUB generation for " + next.getName());
        }
        this.progress(localStrings.getStringWithDefault("generator.processing_beans", "Processing beans..."));
        DirectoryArchive dArchive = new DirectoryArchive(gnrtrTMP);
        DeploymentContext context = new DeploymentContext(dArchive, application);
        Vector localFiles = new Vector();
        Vector localClassNames = new Vector();
        for (int i = 0; i < ejbLocalDeploymentDescriptors.size(); ++i) {
            EjbDescriptor desc = (EjbDescriptor)ejbLocalDeploymentDescriptors.elementAt(i);
            Generator gen = new HomeGenerator(context, desc, true, localClassNames);
            this.generateCode(gen, localFiles, stubsDir);
            desc.setLocalHomeImplClassName(gen.getGeneratedClass());
            _logger.log(Level.FINE, "[EJBC] desc Local Home Object Impl name  is " + desc.getLocalHomeImplClassName());
            gen = new WrapperGenerator(context, desc, true, localClassNames);
            this.generateCode(gen, localFiles, stubsDir);
            desc.setEJBLocalObjectImplClassName(gen.getGeneratedClass());
            _logger.log(Level.FINE, "[EJBC] desc EJB Local Object Impl name  is " + desc.getEJBLocalObjectImplClassName());
        }
        if (localFiles.size() > 0) {
            time = this.now();
            IASEJBC.compileClasses(classPath, localFiles, stubsDir, gnrtrTMP, ejbcCtx.getJavacOptions());
            ejbcCtx.getTiming().javaCompileTime += this.now() - time;
            _logger.log(Level.INFO, "ejbc.done_gen_local_impls", application.getRegistrationName());
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "ejbc.start_jaxrpc_generation", application.getRegistrationName());
        }
        time = this.now();
        JaxRpcCodegenFactory jaxrpcFactory = JaxRpcCodegenFactory.newInstance();
        JaxRpcCodegenAdapter jaxrpcAdapter = jaxrpcFactory.getAdapter();
        jaxrpcAdapter.run(ejbcCtx);
        ejbcCtx.getTiming().jaxrpcGenerationTime += this.now() - time;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "ejbc.end_jaxrpc_generation", application.getRegistrationName());
        }
        WebServiceDeployer deployer = new WebServiceDeployer(ejbcCtx.getDeploymentRequest());
        deployer.doWebServiceDeployment(ejbcCtx.getDescriptor(), ejbcCtx.getSrcDir());
        HashSet allStubClasses = new HashSet();
        if (generateRmicStubs) {
            Set ejbStubClasses = this.getStubClasses(jcl, ejbHomeInterfaces, ejbRemoteInterfaces, ejbRemoteDeploymentDescriptors);
            Set ejbClientStubClasses = this.getEjbClientStubClasses(jcl, application, ejbStubClasses);
            allStubClasses.addAll(ejbStubClasses);
            allStubClasses.addAll(ejbClientStubClasses);
            time = this.now();
            this.compileAndRmic(classPath, ejbcCtx.getRmicOptions(), allStubClasses, stubsDir, gnrtrTMP);
            ejbcCtx.getTiming().RMICompileTime += this.now() - time;
        }
        Vector allClientFiles = new Vector();
        this.addGeneratedFiles(allStubClasses, allClientFiles, stubsDir);
        if (jaxrpcAdapter != null && (itr = jaxrpcAdapter.getListOfBinaryFiles()) != null) {
            while (itr.hasNext()) {
                allClientFiles.add(itr.next());
            }
        }
        ZipItem[] clientStubs = this.getClientZipEntries(allClientFiles, stubsDir);
        _logger.log(Level.INFO, "ejbc.end", application.getRegistrationName());
        ejbcCtx.getTiming().totalTime = this.now() - startTime;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(oContextCL);
                return null;
            }
        });
        jaxrpcAdapter.done();
        return clientStubs;
    }

    private long now() {
        return System.currentTimeMillis();
    }

    private void progress(String message) {
        try {
            _logger.log(Level.INFO, message);
        }
        catch (Throwable t) {
            _logger.log(Level.FINE, "Cannot set status message", t);
        }
    }
}

