/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.codegen;

import com.sun.ejb.codegen.CMPGenerator;
import com.sun.ejb.codegen.CmpCompilerException;
import com.sun.ejb.codegen.EjbcContext;
import com.sun.ejb.codegen.GeneratorException;
import com.sun.ejb.codegen.IASEJBC;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.IASEjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.runtime.IASPersistenceManagerDescriptor;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

class CmpCompiler {
    private EjbcContext _ejbcCtx = null;
    private static final Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");
    private static final StringManager localStrings = StringManager.getManager(CmpCompiler.class);

    CmpCompiler(EjbcContext ctx) {
        this._ejbcCtx = ctx;
    }

    void compile() throws CmpCompilerException, GeneratorException {
        Application application = null;
        BundleDescriptor bundle = null;
        String beanName = null;
        StringBuffer generatorExceptionMsg = null;
        try {
            long time;
            File stubsDir = this._ejbcCtx.getStubsDir();
            application = this._ejbcCtx.getDescriptor();
            _logger.log(Level.FINE, "ejbc.processing_cmp", application.getRegistrationName());
            Vector<String> cmpFiles = new Vector<String>();
            ClassLoader jcl = application.getClassLoader();
            Iterator bundleItr = application.getEjbBundleDescriptors().iterator();
            while (bundleItr.hasNext()) {
                String msg;
                bundle = (EjbBundleDescriptor)bundleItr.next();
                if (!((EjbBundleDescriptor)bundle).containsCMPEntity()) continue;
                String archiveUri = !application.isVirtual() ? this._ejbcCtx.getSrcDir().getCanonicalPath() + File.separator + CmpCompiler.getModuleDirName((EjbBundleDescriptor)bundle) : this._ejbcCtx.getSrcDir().getCanonicalPath();
                _logger.log(Level.FINE, "[CMPC] Module Dir name is " + archiveUri);
                IASPersistenceManagerDescriptor pmDesc = ((EjbBundleDescriptor)bundle).getPreferredPersistenceManager();
                String generatorName = null;
                if (null == pmDesc) {
                    generatorName = "com.sun.jdo.spi.persistence.support.ejb.ejbc.JDOCodeGenerator";
                } else {
                    generatorName = pmDesc.getPersistenceManagerClassGenerator();
                    if (generatorName.equals("com.iplanet.ias.persistence.internal.ejb.ejbc.JDOCodeGenerator")) {
                        generatorName = "com.sun.jdo.spi.persistence.support.ejb.ejbc.JDOCodeGenerator";
                    }
                }
                CMPGenerator gen = null;
                try {
                    Class<?> generator = this.getClass().getClassLoader().loadClass(generatorName);
                    gen = (CMPGenerator)generator.newInstance();
                }
                catch (Throwable e) {
                    msg = localStrings.getString("cmpc.cmp_generator_class_error", application.getRegistrationName(), bundle.getModuleDescriptor().getArchiveUri());
                    _logger.log(Level.SEVERE, msg, e);
                    generatorExceptionMsg = this.addGeneratorExceptionMessage(msg, generatorExceptionMsg);
                    continue;
                }
                try {
                    time = this.now();
                    gen.init((EjbBundleDescriptor)bundle, this._ejbcCtx, archiveUri);
                    this._ejbcCtx.getTiming().cmpGeneratorTime += this.now() - time;
                    Iterator ejbs = ((EjbBundleDescriptor)bundle).getEjbs().iterator();
                    while (ejbs.hasNext()) {
                        EjbDescriptor desc = (EjbDescriptor)ejbs.next();
                        beanName = desc.getName();
                        _logger.log(Level.FINE, "[CMPC] Ejb Class Name: " + desc.getEjbClassName());
                        if (desc instanceof IASEjbCMPEntityDescriptor) {
                            IASEjbCMPEntityDescriptor entd = (IASEjbCMPEntityDescriptor)desc;
                            _logger.log(Level.FINE, "[CMPC] Home Object Impl name  is " + entd.getLocalHomeImplClassName());
                            entd.setClassLoader(jcl);
                            try {
                                time = this.now();
                                gen.generate(entd, stubsDir, stubsDir);
                                this._ejbcCtx.getTiming().cmpGeneratorTime += this.now() - time;
                            }
                            catch (GeneratorException e) {
                                String msg2 = e.getMessage();
                                _logger.log(Level.WARNING, msg2);
                                generatorExceptionMsg = this.addGeneratorExceptionMessage(msg2, generatorExceptionMsg);
                            }
                            continue;
                        }
                        if (!(desc instanceof EjbCMPEntityDescriptor)) continue;
                    }
                    beanName = null;
                    time = this.now();
                    Collection col = gen.cleanup();
                    this._ejbcCtx.getTiming().cmpGeneratorTime += this.now() - time;
                    Iterator fileIter = col.iterator();
                    while (fileIter.hasNext()) {
                        File file = (File)fileIter.next();
                        String fileName = file.getPath();
                        _logger.log(Level.FINE, "[CMPC] File name is " + fileName);
                        cmpFiles.addElement(fileName);
                    }
                }
                catch (GeneratorException e) {
                    msg = e.getMessage();
                    _logger.log(Level.WARNING, msg);
                    generatorExceptionMsg = this.addGeneratorExceptionMessage(msg, generatorExceptionMsg);
                }
            }
            bundle = null;
            if (generatorExceptionMsg == null) {
                String classPath = CmpCompiler.getClassPath(this._ejbcCtx.getClasspathUrls(), stubsDir);
                time = this.now();
                IASEJBC.compileClasses(classPath, cmpFiles, stubsDir, stubsDir.getCanonicalPath(), this._ejbcCtx.getJavacOptions());
                this._ejbcCtx.getTiming().javaCompileTime += this.now() - time;
                _logger.log(Level.FINE, "ejbc.done_processing_cmp", application.getRegistrationName());
            }
        }
        catch (GeneratorException e) {
            _logger.log(Level.WARNING, e.getMessage());
            throw e;
        }
        catch (Throwable e) {
            String eType = e.getClass().getName();
            String appName = application.getRegistrationName();
            String exMsg = e.getMessage();
            String msg = null;
            if (bundle == null) {
                msg = localStrings.getString("cmpc.cmp_app_error", eType, appName, exMsg);
            } else {
                String bundleName = bundle.getModuleDescriptor().getArchiveUri();
                msg = beanName == null ? localStrings.getString("cmpc.cmp_module_error", eType, appName, bundleName, exMsg) : localStrings.getString("cmpc.cmp_bean_error", new Object[]{eType, beanName, appName, bundleName, exMsg});
            }
            _logger.log(Level.SEVERE, msg, e);
            throw new CmpCompilerException(msg);
        }
        if (generatorExceptionMsg != null) {
            throw new GeneratorException(generatorExceptionMsg.toString());
        }
    }

    private long now() {
        return System.currentTimeMillis();
    }

    private static String getModuleDirName(EjbBundleDescriptor bundle) {
        String archieveuri = bundle.getModuleDescriptor().getArchiveUri();
        return FileUtils.makeFriendlyFilename(archieveuri);
    }

    private static String getClassPath(String[] paths, File other) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < paths.length; ++i) {
            sb.append(paths[i] + File.pathSeparator);
        }
        if (other != null) {
            sb.append(other.toString());
        }
        return sb.toString();
    }

    private StringBuffer addGeneratorExceptionMessage(String msg, StringBuffer buf) {
        StringBuffer rc = buf;
        if (rc == null) {
            rc = new StringBuffer(msg);
        } else {
            rc.append('\n').append(msg);
        }
        return rc;
    }
}

