/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.base.io;

import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.IORFactories;
import com.sun.corba.ee.spi.ior.ObjectKey;
import com.sun.corba.ee.spi.ior.TaggedProfile;
import com.sun.corba.ee.spi.presentation.rmi.StubAdapter;
import com.sun.ejb.base.io.SerializableJNDIContext;
import com.sun.ejb.base.io.SerializableS1ASEJBHomeReference;
import com.sun.ejb.base.io.SerializableS1ASEJBObjectReference;
import com.sun.ejb.spi.io.IndirectlySerializable;
import com.sun.ejb.spi.io.NonSerializableObjectHandler;
import com.sun.enterprise.util.Utility;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import org.omg.CORBA.Object;

class EJBObjectOutputStream
extends ObjectOutputStream {
    protected static Logger _ejbLogger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    protected NonSerializableObjectHandler handler;
    static final int EJBID_OFFSET = 0;
    static final int INSTANCEKEYLEN_OFFSET = 8;
    static final int INSTANCEKEY_OFFSET = 12;
    private static final byte HOME_KEY = -1;

    EJBObjectOutputStream(OutputStream out, boolean replaceObject, NonSerializableObjectHandler handler) throws IOException {
        super(out);
        if (replaceObject) {
            this.enableReplaceObject(replaceObject);
        }
        this.handler = handler;
    }

    protected java.lang.Object replaceObject(java.lang.Object obj) throws IOException {
        java.lang.Object result = obj;
        if (obj instanceof IndirectlySerializable) {
            result = ((IndirectlySerializable)obj).getSerializableObjectFactory();
        } else if (StubAdapter.isStub(obj) && StubAdapter.isLocal(obj)) {
            Object target = (Object)obj;
            result = this.getSerializableEJBReference(target);
        } else if (obj instanceof Serializable) {
            result = obj;
        } else if (obj instanceof Context) {
            result = new SerializableJNDIContext((Context)obj);
        } else {
            if (_ejbLogger.isLoggable(Level.INFO)) {
                _ejbLogger.log(Level.INFO, "EJBObjectInputStream_handling_non_serializable_object", obj.getClass().getName());
            }
            result = this.handler == null ? obj : this.handler.handleNonSerializableObject(obj);
        }
        return result;
    }

    private Serializable getSerializableEJBReference(Object obj) throws IOException {
        Serializable result = (Serializable)obj;
        try {
            IOR ior = IORFactories.getIOR(obj);
            Iterator iter = ior.iterator();
            byte[] oid = null;
            if (iter.hasNext()) {
                TaggedProfile profile = (TaggedProfile)iter.next();
                ObjectKey objKey = profile.getObjectKey();
                oid = objKey.getId().getId();
            }
            long containerId = -1L;
            int keyLength = -1;
            if (oid != null && oid.length > 12) {
                containerId = Utility.bytesToLong(oid, 0);
                keyLength = Utility.bytesToInt(oid, 8);
                if (oid.length == keyLength + 12) {
                    boolean isHomeReference;
                    boolean bl = isHomeReference = keyLength == 1 && oid[12] == -1;
                    result = isHomeReference ? new SerializableS1ASEJBHomeReference(containerId) : new SerializableS1ASEJBObjectReference(containerId, oid, keyLength);
                }
            }
        }
        catch (Exception ex) {
            _ejbLogger.log(Level.WARNING, "Exception while getting serializable object", ex);
            IOException ioEx = new IOException("Exception during extraction of instance key");
            ioEx.initCause(ex);
            throw ioEx;
        }
        return result;
    }
}

