/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.spi.monitoring;

public class StatisticsAccumulator {
    protected double max = Double.MIN_VALUE;
    protected double min = Double.MAX_VALUE;
    private double sampleSum;
    private double sampleSquareSum;
    private long sampleCount;
    protected String unit;

    public void sample(double d) {
        ++this.sampleCount;
        if (d < this.min) {
            this.min = d;
        }
        if (d > this.max) {
            this.max = d;
        }
        this.sampleSum += d;
        this.sampleSquareSum += d * d;
    }

    public String getValue() {
        return this.toString();
    }

    public String toString() {
        return "Minimum Value = " + this.min + " " + this.unit + " " + "Maximum Value = " + this.max + " " + this.unit + " " + "Average Value = " + this.computeAverage() + " " + this.unit + " " + "Standard Deviation = " + this.computeStandardDeviation() + " " + this.unit + " " + "Samples Collected = " + this.sampleCount;
    }

    protected double computeAverage() {
        return this.sampleSum / (double)this.sampleCount;
    }

    protected double computeStandardDeviation() {
        double d = this.sampleSum * this.sampleSum;
        return Math.sqrt((this.sampleSquareSum - d / (double)this.sampleCount) / (double)(this.sampleCount - 1L));
    }

    public StatisticsAccumulator(String string) {
        this.unit = string;
        this.sampleCount = 0L;
        this.sampleSum = 0.0;
        this.sampleSquareSum = 0.0;
    }

    void clearState() {
        this.min = Double.MAX_VALUE;
        this.max = Double.MIN_VALUE;
        this.sampleCount = 0L;
        this.sampleSum = 0.0;
        this.sampleSquareSum = 0.0;
    }

    public void unitTestValidate(String string, double d, double d2, long l, double d3, double d4) {
        if (!string.equals(this.unit)) {
            throw new RuntimeException("Unit is not same as expected Unit\nUnit = " + this.unit + "ExpectedUnit = " + string);
        }
        if (this.min != d) {
            throw new RuntimeException("Minimum value is not same as expected minimum value\nMin Value = " + this.min + "Expected Min Value = " + d);
        }
        if (this.max != d2) {
            throw new RuntimeException("Maximum value is not same as expected maximum value\nMax Value = " + this.max + "Expected Max Value = " + d2);
        }
        if (this.sampleCount != l) {
            throw new RuntimeException("Sample count is not same as expected Sample Count\nSampleCount = " + this.sampleCount + "Expected Sample Count = " + l);
        }
        if (this.computeAverage() != d3) {
            throw new RuntimeException("Average is not same as expected Average\nAverage = " + this.computeAverage() + "Expected Average = " + d3);
        }
        double d5 = Math.abs(this.computeStandardDeviation() - d4);
        if (d5 > 1.0) {
            throw new RuntimeException("Standard Deviation is not same as expected Std Deviation\nStandard Dev = " + this.computeStandardDeviation() + "Expected Standard Dev = " + d4);
        }
    }
}

