/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.org.apache.bcel.util;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassPath
implements Serializable {
    public static final ClassPath SYSTEM_CLASS_PATH = new ClassPath();
    private PathEntry[] paths;
    private String class_path;

    public ClassPath(String string) {
        this.class_path = string;
        ArrayList<PathEntry> arrayList = new ArrayList<PathEntry>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, System.getProperty("path.separator"));
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("")) continue;
            File file = new File(string2);
            try {
                if (!file.exists()) continue;
                if (file.isDirectory()) {
                    arrayList.add(new Dir(string2));
                    continue;
                }
                arrayList.add(new Zip(new ZipFile(file)));
            }
            catch (IOException iOException) {
                System.err.println("CLASSPATH component " + file + ": " + iOException);
            }
        }
        this.paths = new PathEntry[arrayList.size()];
        arrayList.toArray(this.paths);
    }

    public ClassPath() {
        this(ClassPath.getClassPath());
    }

    public String toString() {
        return this.class_path;
    }

    public int hashCode() {
        return this.class_path.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof ClassPath) {
            return this.class_path.equals(((ClassPath)object).class_path);
        }
        return false;
    }

    private static final void getPathComponents(String string, ArrayList arrayList) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                File file = new File(string2);
                if (!file.exists()) continue;
                arrayList.add(string2);
            }
        }
    }

    public static final String getClassPath() {
        Object object;
        String string = System.getProperty("java.class.path");
        String string2 = System.getProperty("sun.boot.class.path");
        String string3 = System.getProperty("java.ext.dirs");
        ArrayList<String> arrayList = new ArrayList<String>();
        ClassPath.getPathComponents(string, arrayList);
        ClassPath.getPathComponents(string2, arrayList);
        ArrayList arrayList2 = new ArrayList();
        ClassPath.getPathComponents(string3, arrayList2);
        Object object2 = arrayList2.iterator();
        while (object2.hasNext()) {
            object = new File((String)object2.next());
            String[] stringArray = ((File)object).list(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return (string = string.toLowerCase()).endsWith(".zip") || string.endsWith(".jar");
                }
            });
            if (stringArray == null) continue;
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(string3 + File.separatorChar + stringArray[i]);
            }
        }
        object2 = new StringBuffer();
        object = arrayList.iterator();
        while (object.hasNext()) {
            ((StringBuffer)object2).append((String)object.next());
            if (!object.hasNext()) continue;
            ((StringBuffer)object2).append(File.pathSeparatorChar);
        }
        return ((StringBuffer)object2).toString().intern();
    }

    public InputStream getInputStream(String string) throws IOException {
        return this.getInputStream(string, ".class");
    }

    public InputStream getInputStream(String string, String string2) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = this.getClass().getClassLoader().getResourceAsStream(string + string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (inputStream != null) {
            return inputStream;
        }
        return this.getClassFile(string, string2).getInputStream();
    }

    public ClassFile getClassFile(String string, String string2) throws IOException {
        for (int i = 0; i < this.paths.length; ++i) {
            ClassFile classFile = this.paths[i].getClassFile(string, string2);
            if (classFile == null) continue;
            return classFile;
        }
        throw new IOException("Couldn't find: " + string + string2);
    }

    public ClassFile getClassFile(String string) throws IOException {
        return this.getClassFile(string, ".class");
    }

    public byte[] getBytes(String string, String string2) throws IOException {
        InputStream inputStream = this.getInputStream(string, string2);
        if (inputStream == null) {
            throw new IOException("Couldn't find: " + string + string2);
        }
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte[] byArray = new byte[inputStream.available()];
        dataInputStream.readFully(byArray);
        dataInputStream.close();
        inputStream.close();
        return byArray;
    }

    public byte[] getBytes(String string) throws IOException {
        return this.getBytes(string, ".class");
    }

    public String getPath(String string) throws IOException {
        int n = string.lastIndexOf(46);
        String string2 = "";
        if (n > 0) {
            string2 = string.substring(n);
            string = string.substring(0, n);
        }
        return this.getPath(string, string2);
    }

    public String getPath(String string, String string2) throws IOException {
        return this.getClassFile(string, string2).getPath();
    }

    private static class Zip
    extends PathEntry {
        private ZipFile zip;

        Zip(ZipFile zipFile) {
            this.zip = zipFile;
        }

        ClassFile getClassFile(String string, String string2) throws IOException {
            ZipEntry zipEntry = this.zip.getEntry(string.replace('.', '/') + string2);
            return zipEntry != null ? new ClassFile(this, zipEntry){
                private final /* synthetic */ ZipEntry val$entry;
                private final /* synthetic */ Zip this$0;
                {
                    this.this$0 = zip;
                    this.val$entry = zipEntry;
                }

                public InputStream getInputStream() throws IOException {
                    return Zip.access$200(this.this$0).getInputStream(this.val$entry);
                }

                public String getPath() {
                    return this.val$entry.toString();
                }

                public long getTime() {
                    return this.val$entry.getTime();
                }

                public long getSize() {
                    return this.val$entry.getSize();
                }

                public String getBase() {
                    return Zip.access$200(this.this$0).getName();
                }
            } : null;
        }

        static /* synthetic */ ZipFile access$200(Zip zip) {
            return zip.zip;
        }
    }

    private static class Dir
    extends PathEntry {
        private String dir;

        Dir(String string) {
            this.dir = string;
        }

        ClassFile getClassFile(String string, String string2) throws IOException {
            File file = new File(this.dir + File.separatorChar + string.replace('.', File.separatorChar) + string2);
            return file.exists() ? new ClassFile(this, file){
                private final /* synthetic */ File val$file;
                private final /* synthetic */ Dir this$0;
                {
                    this.this$0 = dir;
                    this.val$file = file;
                }

                public InputStream getInputStream() throws IOException {
                    return new FileInputStream(this.val$file);
                }

                public String getPath() {
                    try {
                        return this.val$file.getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                }

                public long getTime() {
                    return this.val$file.lastModified();
                }

                public long getSize() {
                    return this.val$file.length();
                }

                public String getBase() {
                    return Dir.access$100(this.this$0);
                }
            } : null;
        }

        public String toString() {
            return this.dir;
        }

        static /* synthetic */ String access$100(Dir dir) {
            return dir.dir;
        }
    }

    public static interface ClassFile {
        public InputStream getInputStream() throws IOException;

        public String getPath();

        public String getBase();

        public long getTime();

        public long getSize();
    }

    private static abstract class PathEntry
    implements Serializable {
        private PathEntry() {
        }

        abstract ClassFile getClassFile(String var1, String var2) throws IOException;
    }
}

