/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.org.apache.bcel.generic;

import com.sun.corba.ee.org.apache.bcel.generic.BIPUSH;
import com.sun.corba.ee.org.apache.bcel.generic.ClassGenException;
import com.sun.corba.ee.org.apache.bcel.generic.CompoundInstruction;
import com.sun.corba.ee.org.apache.bcel.generic.ConstantPoolGen;
import com.sun.corba.ee.org.apache.bcel.generic.Instruction;
import com.sun.corba.ee.org.apache.bcel.generic.InstructionConstants;
import com.sun.corba.ee.org.apache.bcel.generic.InstructionList;
import com.sun.corba.ee.org.apache.bcel.generic.LDC;
import com.sun.corba.ee.org.apache.bcel.generic.LDC2_W;
import com.sun.corba.ee.org.apache.bcel.generic.SIPUSH;
import com.sun.corba.ee.org.apache.bcel.generic.VariableLengthInstruction;

public final class PUSH
implements CompoundInstruction,
VariableLengthInstruction,
InstructionConstants {
    private Instruction instruction;

    public PUSH(ConstantPoolGen constantPoolGen, int n) {
        this.instruction = n >= -1 && n <= 5 ? InstructionConstants.INSTRUCTIONS[3 + n] : (n >= -128 && n <= 127 ? new BIPUSH((byte)n) : (n >= Short.MIN_VALUE && n <= Short.MAX_VALUE ? new SIPUSH((short)n) : new LDC(constantPoolGen.addInteger(n))));
    }

    public PUSH(ConstantPoolGen constantPoolGen, boolean bl) {
        this.instruction = InstructionConstants.INSTRUCTIONS[3 + (bl ? 1 : 0)];
    }

    public PUSH(ConstantPoolGen constantPoolGen, float f) {
        this.instruction = (double)f == 0.0 ? InstructionConstants.FCONST_0 : ((double)f == 1.0 ? InstructionConstants.FCONST_1 : ((double)f == 2.0 ? InstructionConstants.FCONST_2 : new LDC(constantPoolGen.addFloat(f))));
    }

    public PUSH(ConstantPoolGen constantPoolGen, long l) {
        this.instruction = l == 0L ? InstructionConstants.LCONST_0 : (l == 1L ? InstructionConstants.LCONST_1 : new LDC2_W(constantPoolGen.addLong(l)));
    }

    public PUSH(ConstantPoolGen constantPoolGen, double d) {
        this.instruction = d == 0.0 ? InstructionConstants.DCONST_0 : (d == 1.0 ? InstructionConstants.DCONST_1 : new LDC2_W(constantPoolGen.addDouble(d)));
    }

    public PUSH(ConstantPoolGen constantPoolGen, String string) {
        this.instruction = string == null ? InstructionConstants.ACONST_NULL : new LDC(constantPoolGen.addString(string));
    }

    public PUSH(ConstantPoolGen constantPoolGen, Number number) {
        if (number instanceof Integer || number instanceof Short || number instanceof Byte) {
            this.instruction = new PUSH((ConstantPoolGen)constantPoolGen, (int)number.intValue()).instruction;
        } else if (number instanceof Double) {
            this.instruction = new PUSH((ConstantPoolGen)constantPoolGen, (double)number.doubleValue()).instruction;
        } else if (number instanceof Float) {
            this.instruction = new PUSH((ConstantPoolGen)constantPoolGen, (float)number.floatValue()).instruction;
        } else if (number instanceof Long) {
            this.instruction = new PUSH((ConstantPoolGen)constantPoolGen, (long)number.longValue()).instruction;
        } else {
            throw new ClassGenException("What's this: " + number);
        }
    }

    public PUSH(ConstantPoolGen constantPoolGen, Character c) {
        this(constantPoolGen, (int)c.charValue());
    }

    public PUSH(ConstantPoolGen constantPoolGen, Boolean bl) {
        this(constantPoolGen, (boolean)bl);
    }

    public final InstructionList getInstructionList() {
        return new InstructionList(this.instruction);
    }

    public final Instruction getInstruction() {
        return this.instruction;
    }

    public String toString() {
        return this.instruction.toString() + " (PUSH)";
    }
}

