/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.org.apache.bcel.generic;

import com.sun.corba.ee.org.apache.bcel.classfile.Attribute;
import com.sun.corba.ee.org.apache.bcel.classfile.Code;
import com.sun.corba.ee.org.apache.bcel.classfile.CodeException;
import com.sun.corba.ee.org.apache.bcel.classfile.ExceptionTable;
import com.sun.corba.ee.org.apache.bcel.classfile.LineNumber;
import com.sun.corba.ee.org.apache.bcel.classfile.LineNumberTable;
import com.sun.corba.ee.org.apache.bcel.classfile.LocalVariable;
import com.sun.corba.ee.org.apache.bcel.classfile.LocalVariableTable;
import com.sun.corba.ee.org.apache.bcel.classfile.Method;
import com.sun.corba.ee.org.apache.bcel.classfile.Utility;
import com.sun.corba.ee.org.apache.bcel.generic.BranchInstruction;
import com.sun.corba.ee.org.apache.bcel.generic.ClassGenException;
import com.sun.corba.ee.org.apache.bcel.generic.CodeExceptionGen;
import com.sun.corba.ee.org.apache.bcel.generic.ConstantPoolGen;
import com.sun.corba.ee.org.apache.bcel.generic.FieldGenOrMethodGen;
import com.sun.corba.ee.org.apache.bcel.generic.IINC;
import com.sun.corba.ee.org.apache.bcel.generic.IfInstruction;
import com.sun.corba.ee.org.apache.bcel.generic.IndexedInstruction;
import com.sun.corba.ee.org.apache.bcel.generic.Instruction;
import com.sun.corba.ee.org.apache.bcel.generic.InstructionHandle;
import com.sun.corba.ee.org.apache.bcel.generic.InstructionList;
import com.sun.corba.ee.org.apache.bcel.generic.InstructionTargeter;
import com.sun.corba.ee.org.apache.bcel.generic.LineNumberGen;
import com.sun.corba.ee.org.apache.bcel.generic.LocalVariableGen;
import com.sun.corba.ee.org.apache.bcel.generic.LocalVariableInstruction;
import com.sun.corba.ee.org.apache.bcel.generic.MethodObserver;
import com.sun.corba.ee.org.apache.bcel.generic.NOP;
import com.sun.corba.ee.org.apache.bcel.generic.ObjectType;
import com.sun.corba.ee.org.apache.bcel.generic.RET;
import com.sun.corba.ee.org.apache.bcel.generic.Select;
import com.sun.corba.ee.org.apache.bcel.generic.TargetLostException;
import com.sun.corba.ee.org.apache.bcel.generic.Type;
import com.sun.corba.ee.org.apache.bcel.generic.TypedInstruction;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;

public class MethodGen
extends FieldGenOrMethodGen {
    private String class_name;
    private Type[] arg_types;
    private String[] arg_names;
    private int max_locals;
    private int max_stack;
    private InstructionList il;
    private boolean strip_attributes;
    private ArrayList variable_vec = new ArrayList();
    private ArrayList line_number_vec = new ArrayList();
    private ArrayList exception_vec = new ArrayList();
    private ArrayList throws_vec = new ArrayList();
    private ArrayList code_attrs_vec = new ArrayList();
    private ArrayList observers;

    public MethodGen(int n, Type type, Type[] typeArray, String[] stringArray, String string, String string2, InstructionList instructionList, ConstantPoolGen constantPoolGen) {
        this.setAccessFlags(n);
        this.setType(type);
        this.setArgumentTypes(typeArray);
        this.setArgumentNames(stringArray);
        this.setName(string);
        this.setClassName(string2);
        this.setInstructionList(instructionList);
        this.setConstantPool(constantPoolGen);
        boolean bl = this.isAbstract() || this.isNative();
        InstructionHandle instructionHandle = null;
        InstructionHandle instructionHandle2 = null;
        if (!bl) {
            instructionHandle = instructionList.getStart();
            instructionHandle2 = instructionList.getEnd();
            if (!this.isStatic() && string2 != null) {
                this.addLocalVariable("this", new ObjectType(string2), instructionHandle, instructionHandle2);
            }
        }
        if (typeArray != null) {
            int n2;
            int n3 = typeArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                if (Type.VOID != typeArray[n2]) continue;
                throw new ClassGenException("'void' is an illegal argument type for a method");
            }
            if (stringArray != null) {
                if (n3 != stringArray.length) {
                    throw new ClassGenException("Mismatch in argument array lengths: " + n3 + " vs. " + stringArray.length);
                }
            } else {
                stringArray = new String[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    stringArray[n2] = "arg" + n2;
                }
                this.setArgumentNames(stringArray);
            }
            if (!bl) {
                for (n2 = 0; n2 < n3; ++n2) {
                    this.addLocalVariable(stringArray[n2], typeArray[n2], instructionHandle, instructionHandle2);
                }
            }
        }
    }

    public MethodGen(Method method, String string, ConstantPoolGen constantPoolGen) {
        this(method.getAccessFlags(), Type.getReturnType(method.getSignature()), Type.getArgumentTypes(method.getSignature()), null, method.getName(), string, (method.getAccessFlags() & 0x500) == 0 ? new InstructionList(method.getCode().getCode()) : null, constantPoolGen);
        Attribute[] attributeArray = method.getAttributes();
        for (int i = 0; i < attributeArray.length; ++i) {
            String[] stringArray;
            Attribute attribute = attributeArray[i];
            if (attribute instanceof Code) {
                InstructionHandle instructionHandle;
                stringArray = (String[])attribute;
                this.setMaxStack(stringArray.getMaxStack());
                this.setMaxLocals(stringArray.getMaxLocals());
                CodeException[] codeExceptionArray = stringArray.getExceptionTable();
                if (codeExceptionArray != null) {
                    for (int j = 0; j < codeExceptionArray.length; ++j) {
                        CodeException codeException = codeExceptionArray[j];
                        int n = codeException.getCatchType();
                        ObjectType objectType = null;
                        if (n > 0) {
                            String string2 = method.getConstantPool().getConstantString(n, (byte)7);
                            objectType = new ObjectType(string2);
                        }
                        int n2 = codeException.getEndPC();
                        int n3 = method.getCode().getCode().length;
                        if (n3 == n2) {
                            instructionHandle = this.il.getEnd();
                        } else {
                            instructionHandle = this.il.findHandle(n2);
                            instructionHandle = instructionHandle.getPrev();
                        }
                        this.addExceptionHandler(this.il.findHandle(codeException.getStartPC()), instructionHandle, this.il.findHandle(codeException.getHandlerPC()), objectType);
                    }
                }
                Attribute[] attributeArray2 = stringArray.getAttributes();
                for (int j = 0; j < attributeArray2.length; ++j) {
                    Cloneable cloneable;
                    int n;
                    Cloneable[] cloneableArray;
                    attribute = attributeArray2[j];
                    if (attribute instanceof LineNumberTable) {
                        cloneableArray = ((LineNumberTable)attribute).getLineNumberTable();
                        for (n = 0; n < cloneableArray.length; ++n) {
                            cloneable = cloneableArray[n];
                            this.addLineNumber(this.il.findHandle(((LineNumber)cloneable).getStartPC()), ((LineNumber)cloneable).getLineNumber());
                        }
                        continue;
                    }
                    if (attribute instanceof LocalVariableTable) {
                        cloneableArray = ((LocalVariableTable)attribute).getLocalVariableTable();
                        this.removeLocalVariables();
                        for (n = 0; n < cloneableArray.length; ++n) {
                            cloneable = cloneableArray[n];
                            InstructionHandle instructionHandle2 = this.il.findHandle(((LocalVariable)cloneable).getStartPC());
                            instructionHandle = this.il.findHandle(((LocalVariable)cloneable).getStartPC() + ((LocalVariable)cloneable).getLength());
                            if (null == instructionHandle2) {
                                instructionHandle2 = this.il.getStart();
                            }
                            if (null == instructionHandle) {
                                instructionHandle = this.il.getEnd();
                            }
                            this.addLocalVariable(((LocalVariable)cloneable).getName(), Type.getType(((LocalVariable)cloneable).getSignature()), ((LocalVariable)cloneable).getIndex(), instructionHandle2, instructionHandle);
                        }
                        continue;
                    }
                    this.addCodeAttribute(attribute);
                }
                continue;
            }
            if (attribute instanceof ExceptionTable) {
                stringArray = ((ExceptionTable)attribute).getExceptionNames();
                for (int j = 0; j < stringArray.length; ++j) {
                    this.addException(stringArray[j]);
                }
                continue;
            }
            this.addAttribute(attribute);
        }
    }

    public LocalVariableGen addLocalVariable(String string, Type type, int n, InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        byte by = type.getType();
        if (by != 16) {
            LocalVariableGen localVariableGen;
            int n2;
            int n3 = type.getSize();
            if (n + n3 > this.max_locals) {
                this.max_locals = n + n3;
            }
            if ((n2 = this.variable_vec.indexOf(localVariableGen = new LocalVariableGen(n, string, type, instructionHandle, instructionHandle2))) >= 0) {
                this.variable_vec.set(n2, localVariableGen);
            } else {
                this.variable_vec.add(localVariableGen);
            }
            return localVariableGen;
        }
        throw new IllegalArgumentException("Can not use " + type + " as type for local variable");
    }

    public LocalVariableGen addLocalVariable(String string, Type type, InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        return this.addLocalVariable(string, type, this.max_locals, instructionHandle, instructionHandle2);
    }

    public void removeLocalVariable(LocalVariableGen localVariableGen) {
        this.variable_vec.remove(localVariableGen);
    }

    public void removeLocalVariables() {
        this.variable_vec.clear();
    }

    private static final void sort(LocalVariableGen[] localVariableGenArray, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        int n5 = localVariableGenArray[(n + n2) / 2].getIndex();
        while (true) {
            if (localVariableGenArray[n3].getIndex() < n5) {
                ++n3;
                continue;
            }
            while (n5 < localVariableGenArray[n4].getIndex()) {
                --n4;
            }
            if (n3 <= n4) {
                LocalVariableGen localVariableGen = localVariableGenArray[n3];
                localVariableGenArray[n3] = localVariableGenArray[n4];
                localVariableGenArray[n4] = localVariableGen;
                ++n3;
                --n4;
            }
            if (n3 > n4) break;
        }
        if (n < n4) {
            MethodGen.sort(localVariableGenArray, n, n4);
        }
        if (n3 < n2) {
            MethodGen.sort(localVariableGenArray, n3, n2);
        }
    }

    public LocalVariableGen[] getLocalVariables() {
        int n = this.variable_vec.size();
        LocalVariableGen[] localVariableGenArray = new LocalVariableGen[n];
        this.variable_vec.toArray(localVariableGenArray);
        for (int i = 0; i < n; ++i) {
            if (localVariableGenArray[i].getStart() == null) {
                localVariableGenArray[i].setStart(this.il.getStart());
            }
            if (localVariableGenArray[i].getEnd() != null) continue;
            localVariableGenArray[i].setEnd(this.il.getEnd());
        }
        if (n > 1) {
            MethodGen.sort(localVariableGenArray, 0, n - 1);
        }
        return localVariableGenArray;
    }

    public LocalVariableTable getLocalVariableTable(ConstantPoolGen constantPoolGen) {
        LocalVariableGen[] localVariableGenArray = this.getLocalVariables();
        int n = localVariableGenArray.length;
        LocalVariable[] localVariableArray = new LocalVariable[n];
        for (int i = 0; i < n; ++i) {
            localVariableArray[i] = localVariableGenArray[i].getLocalVariable(constantPoolGen);
        }
        return new LocalVariableTable(constantPoolGen.addUtf8("LocalVariableTable"), 2 + localVariableArray.length * 10, localVariableArray, constantPoolGen.getConstantPool());
    }

    public LineNumberGen addLineNumber(InstructionHandle instructionHandle, int n) {
        LineNumberGen lineNumberGen = new LineNumberGen(instructionHandle, n);
        this.line_number_vec.add(lineNumberGen);
        return lineNumberGen;
    }

    public void removeLineNumber(LineNumberGen lineNumberGen) {
        this.line_number_vec.remove(lineNumberGen);
    }

    public void removeLineNumbers() {
        this.line_number_vec.clear();
    }

    public LineNumberGen[] getLineNumbers() {
        LineNumberGen[] lineNumberGenArray = new LineNumberGen[this.line_number_vec.size()];
        this.line_number_vec.toArray(lineNumberGenArray);
        return lineNumberGenArray;
    }

    public LineNumberTable getLineNumberTable(ConstantPoolGen constantPoolGen) {
        int n = this.line_number_vec.size();
        LineNumber[] lineNumberArray = new LineNumber[n];
        try {
            for (int i = 0; i < n; ++i) {
                lineNumberArray[i] = ((LineNumberGen)this.line_number_vec.get(i)).getLineNumber();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return new LineNumberTable(constantPoolGen.addUtf8("LineNumberTable"), 2 + lineNumberArray.length * 4, lineNumberArray, constantPoolGen.getConstantPool());
    }

    public CodeExceptionGen addExceptionHandler(InstructionHandle instructionHandle, InstructionHandle instructionHandle2, InstructionHandle instructionHandle3, ObjectType objectType) {
        if (instructionHandle == null || instructionHandle2 == null || instructionHandle3 == null) {
            throw new ClassGenException("Exception handler target is null instruction");
        }
        CodeExceptionGen codeExceptionGen = new CodeExceptionGen(instructionHandle, instructionHandle2, instructionHandle3, objectType);
        this.exception_vec.add(codeExceptionGen);
        return codeExceptionGen;
    }

    public void removeExceptionHandler(CodeExceptionGen codeExceptionGen) {
        this.exception_vec.remove(codeExceptionGen);
    }

    public void removeExceptionHandlers() {
        this.exception_vec.clear();
    }

    public CodeExceptionGen[] getExceptionHandlers() {
        CodeExceptionGen[] codeExceptionGenArray = new CodeExceptionGen[this.exception_vec.size()];
        this.exception_vec.toArray(codeExceptionGenArray);
        return codeExceptionGenArray;
    }

    private CodeException[] getCodeExceptions() {
        int n = this.exception_vec.size();
        CodeException[] codeExceptionArray = new CodeException[n];
        try {
            for (int i = 0; i < n; ++i) {
                CodeExceptionGen codeExceptionGen = (CodeExceptionGen)this.exception_vec.get(i);
                codeExceptionArray[i] = codeExceptionGen.getCodeException(this.cp);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return codeExceptionArray;
    }

    public void addException(String string) {
        this.throws_vec.add(string);
    }

    public void removeException(String string) {
        this.throws_vec.remove(string);
    }

    public void removeExceptions() {
        this.throws_vec.clear();
    }

    public String[] getExceptions() {
        String[] stringArray = new String[this.throws_vec.size()];
        this.throws_vec.toArray(stringArray);
        return stringArray;
    }

    private ExceptionTable getExceptionTable(ConstantPoolGen constantPoolGen) {
        int n = this.throws_vec.size();
        int[] nArray = new int[n];
        try {
            for (int i = 0; i < n; ++i) {
                nArray[i] = constantPoolGen.addClass((String)this.throws_vec.get(i));
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return new ExceptionTable(constantPoolGen.addUtf8("Exceptions"), 2 + 2 * n, nArray, constantPoolGen.getConstantPool());
    }

    public void addCodeAttribute(Attribute attribute) {
        this.code_attrs_vec.add(attribute);
    }

    public void removeCodeAttribute(Attribute attribute) {
        this.code_attrs_vec.remove(attribute);
    }

    public void removeCodeAttributes() {
        this.code_attrs_vec.clear();
    }

    public Attribute[] getCodeAttributes() {
        Attribute[] attributeArray = new Attribute[this.code_attrs_vec.size()];
        this.code_attrs_vec.toArray(attributeArray);
        return attributeArray;
    }

    public Method getMethod() {
        Object object;
        String string = this.getSignature();
        int n = this.cp.addUtf8(this.name);
        int n2 = this.cp.addUtf8(string);
        byte[] byArray = null;
        if (this.il != null) {
            byArray = this.il.getByteCode();
        }
        LineNumberTable lineNumberTable = null;
        LocalVariableTable localVariableTable = null;
        if (this.variable_vec.size() > 0 && !this.strip_attributes) {
            localVariableTable = this.getLocalVariableTable(this.cp);
            this.addCodeAttribute(localVariableTable);
        }
        if (this.line_number_vec.size() > 0 && !this.strip_attributes) {
            lineNumberTable = this.getLineNumberTable(this.cp);
            this.addCodeAttribute(lineNumberTable);
        }
        Attribute[] attributeArray = this.getCodeAttributes();
        int n3 = 0;
        for (int i = 0; i < attributeArray.length; ++i) {
            n3 += attributeArray[i].getLength() + 6;
        }
        CodeException[] codeExceptionArray = this.getCodeExceptions();
        int n4 = codeExceptionArray.length * 8;
        Code code = null;
        if (this.il != null && !this.isAbstract()) {
            object = this.getAttributes();
            for (int i = 0; i < ((Attribute[])object).length; ++i) {
                Attribute attribute = object[i];
                if (!(attribute instanceof Code)) continue;
                this.removeAttribute(attribute);
            }
            code = new Code(this.cp.addUtf8("Code"), 8 + byArray.length + 2 + n4 + 2 + n3, this.max_stack, this.max_locals, byArray, codeExceptionArray, attributeArray, this.cp.getConstantPool());
            this.addAttribute(code);
        }
        object = null;
        if (this.throws_vec.size() > 0) {
            object = this.getExceptionTable(this.cp);
            this.addAttribute((Attribute)object);
        }
        Method method = new Method(this.access_flags, n, n2, this.getAttributes(), this.cp.getConstantPool());
        if (localVariableTable != null) {
            this.removeCodeAttribute(localVariableTable);
        }
        if (lineNumberTable != null) {
            this.removeCodeAttribute(lineNumberTable);
        }
        if (code != null) {
            this.removeAttribute(code);
        }
        if (object != null) {
            this.removeAttribute((Attribute)object);
        }
        return method;
    }

    public void removeNOPs() {
        if (this.il != null) {
            InstructionHandle instructionHandle = this.il.getStart();
            while (instructionHandle != null) {
                InstructionHandle instructionHandle2 = instructionHandle.next;
                if (instructionHandle2 != null && instructionHandle.getInstruction() instanceof NOP) {
                    try {
                        this.il.delete(instructionHandle);
                    }
                    catch (TargetLostException targetLostException) {
                        InstructionHandle[] instructionHandleArray = targetLostException.getTargets();
                        for (int i = 0; i < instructionHandleArray.length; ++i) {
                            InstructionTargeter[] instructionTargeterArray = instructionHandleArray[i].getTargeters();
                            for (int j = 0; j < instructionTargeterArray.length; ++j) {
                                instructionTargeterArray[j].updateTarget(instructionHandleArray[i], instructionHandle2);
                            }
                        }
                    }
                }
                instructionHandle = instructionHandle2;
            }
        }
    }

    public void setMaxLocals(int n) {
        this.max_locals = n;
    }

    public int getMaxLocals() {
        return this.max_locals;
    }

    public void setMaxStack(int n) {
        this.max_stack = n;
    }

    public int getMaxStack() {
        return this.max_stack;
    }

    public String getClassName() {
        return this.class_name;
    }

    public void setClassName(String string) {
        this.class_name = string;
    }

    public void setReturnType(Type type) {
        this.setType(type);
    }

    public Type getReturnType() {
        return this.getType();
    }

    public void setArgumentTypes(Type[] typeArray) {
        this.arg_types = typeArray;
    }

    public Type[] getArgumentTypes() {
        return (Type[])this.arg_types.clone();
    }

    public void setArgumentType(int n, Type type) {
        this.arg_types[n] = type;
    }

    public Type getArgumentType(int n) {
        return this.arg_types[n];
    }

    public void setArgumentNames(String[] stringArray) {
        this.arg_names = stringArray;
    }

    public String[] getArgumentNames() {
        return (String[])this.arg_names.clone();
    }

    public void setArgumentName(int n, String string) {
        this.arg_names[n] = string;
    }

    public String getArgumentName(int n) {
        return this.arg_names[n];
    }

    public InstructionList getInstructionList() {
        return this.il;
    }

    public void setInstructionList(InstructionList instructionList) {
        this.il = instructionList;
    }

    public String getSignature() {
        return Type.getMethodSignature(this.type, this.arg_types);
    }

    public void setMaxStack() {
        this.max_stack = this.il != null ? MethodGen.getMaxStack(this.cp, this.il, this.getExceptionHandlers()) : 0;
    }

    public void setMaxLocals() {
        if (this.il != null) {
            int n;
            int n2 = n = this.isStatic() ? 0 : 1;
            if (this.arg_types != null) {
                for (int i = 0; i < this.arg_types.length; ++i) {
                    n += this.arg_types[i].getSize();
                }
            }
            for (InstructionHandle instructionHandle = this.il.getStart(); instructionHandle != null; instructionHandle = instructionHandle.getNext()) {
                int n3;
                Instruction instruction = instructionHandle.getInstruction();
                if (!(instruction instanceof LocalVariableInstruction) && !(instruction instanceof RET) && !(instruction instanceof IINC) || (n3 = ((IndexedInstruction)((Object)instruction)).getIndex() + ((TypedInstruction)((Object)instruction)).getType(this.cp).getSize()) <= n) continue;
                n = n3;
            }
            this.max_locals = n;
        } else {
            this.max_locals = 0;
        }
    }

    public void stripAttributes(boolean bl) {
        this.strip_attributes = bl;
    }

    public static int getMaxStack(ConstantPoolGen constantPoolGen, InstructionList instructionList, CodeExceptionGen[] codeExceptionGenArray) {
        int n;
        BranchStack branchStack = new BranchStack();
        for (n = 0; n < codeExceptionGenArray.length; ++n) {
            InstructionHandle instructionHandle = codeExceptionGenArray[n].getHandlerPC();
            if (instructionHandle == null) continue;
            branchStack.push(instructionHandle, 1);
        }
        n = 0;
        int n2 = 0;
        InstructionHandle instructionHandle = instructionList.getStart();
        while (instructionHandle != null) {
            Object object;
            Instruction instruction = instructionHandle.getInstruction();
            short s = instruction.getOpcode();
            int n3 = instruction.produceStack(constantPoolGen) - instruction.consumeStack(constantPoolGen);
            if ((n += n3) > n2) {
                n2 = n;
            }
            if (instruction instanceof BranchInstruction) {
                object = (BranchInstruction)instruction;
                if (instruction instanceof Select) {
                    Select select = (Select)object;
                    InstructionHandle[] instructionHandleArray = select.getTargets();
                    for (int i = 0; i < instructionHandleArray.length; ++i) {
                        branchStack.push(instructionHandleArray[i], n);
                    }
                    instructionHandle = null;
                } else if (!(object instanceof IfInstruction)) {
                    if (s == 168 || s == 201) {
                        branchStack.push(instructionHandle.getNext(), n - 1);
                    }
                    instructionHandle = null;
                }
                branchStack.push(((BranchInstruction)object).getTarget(), n);
            } else if (s == 191 || s == 169 || s >= 172 && s <= 177) {
                instructionHandle = null;
            }
            if (instructionHandle != null) {
                instructionHandle = instructionHandle.getNext();
            }
            if (instructionHandle != null || (object = branchStack.pop()) == null) continue;
            instructionHandle = ((BranchTarget)object).target;
            n = ((BranchTarget)object).stackDepth;
        }
        return n2;
    }

    public void addObserver(MethodObserver methodObserver) {
        if (this.observers == null) {
            this.observers = new ArrayList();
        }
        this.observers.add(methodObserver);
    }

    public void removeObserver(MethodObserver methodObserver) {
        if (this.observers != null) {
            this.observers.remove(methodObserver);
        }
    }

    public void update() {
        if (this.observers != null) {
            Iterator iterator = this.observers.iterator();
            while (iterator.hasNext()) {
                ((MethodObserver)iterator.next()).notify(this);
            }
        }
    }

    public final String toString() {
        String string = Utility.accessToString(this.access_flags);
        String string2 = Type.getMethodSignature(this.type, this.arg_types);
        string2 = Utility.methodSignatureToString(string2, this.name, string, true, this.getLocalVariableTable(this.cp));
        StringBuffer stringBuffer = new StringBuffer(string2);
        if (this.throws_vec.size() > 0) {
            Iterator iterator = this.throws_vec.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("\n\t\tthrows " + iterator.next());
            }
        }
        return stringBuffer.toString();
    }

    public MethodGen copy(String string, ConstantPoolGen constantPoolGen) {
        Method method = ((MethodGen)this.clone()).getMethod();
        MethodGen methodGen = new MethodGen(method, string, this.cp);
        if (this.cp != constantPoolGen) {
            methodGen.setConstantPool(constantPoolGen);
            methodGen.getInstructionList().replaceConstantPool(this.cp, constantPoolGen);
        }
        return methodGen;
    }

    static final class BranchStack {
        Stack branchTargets = new Stack();
        Hashtable visitedTargets = new Hashtable();

        BranchStack() {
        }

        public void push(InstructionHandle instructionHandle, int n) {
            if (this.visited(instructionHandle)) {
                return;
            }
            this.branchTargets.push(this.visit(instructionHandle, n));
        }

        public BranchTarget pop() {
            if (!this.branchTargets.empty()) {
                BranchTarget branchTarget = (BranchTarget)this.branchTargets.pop();
                return branchTarget;
            }
            return null;
        }

        private final BranchTarget visit(InstructionHandle instructionHandle, int n) {
            BranchTarget branchTarget = new BranchTarget(instructionHandle, n);
            this.visitedTargets.put(instructionHandle, branchTarget);
            return branchTarget;
        }

        private final boolean visited(InstructionHandle instructionHandle) {
            return this.visitedTargets.get(instructionHandle) != null;
        }
    }

    static final class BranchTarget {
        InstructionHandle target;
        int stackDepth;

        BranchTarget(InstructionHandle instructionHandle, int n) {
            this.target = instructionHandle;
            this.stackDepth = n;
        }
    }
}

