/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.org.apache.bcel.generic;

import com.sun.corba.ee.org.apache.bcel.ExceptionConstants;
import com.sun.corba.ee.org.apache.bcel.classfile.Constant;
import com.sun.corba.ee.org.apache.bcel.classfile.ConstantFloat;
import com.sun.corba.ee.org.apache.bcel.classfile.ConstantInteger;
import com.sun.corba.ee.org.apache.bcel.classfile.ConstantString;
import com.sun.corba.ee.org.apache.bcel.classfile.ConstantUtf8;
import com.sun.corba.ee.org.apache.bcel.generic.CPInstruction;
import com.sun.corba.ee.org.apache.bcel.generic.ConstantPoolGen;
import com.sun.corba.ee.org.apache.bcel.generic.ExceptionThrower;
import com.sun.corba.ee.org.apache.bcel.generic.PushInstruction;
import com.sun.corba.ee.org.apache.bcel.generic.Type;
import com.sun.corba.ee.org.apache.bcel.generic.TypedInstruction;
import com.sun.corba.ee.org.apache.bcel.generic.Visitor;
import com.sun.corba.ee.org.apache.bcel.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public class LDC
extends CPInstruction
implements PushInstruction,
ExceptionThrower,
TypedInstruction {
    LDC() {
    }

    public LDC(int n) {
        super((short)19, n);
        this.setSize();
    }

    protected final void setSize() {
        if (this.index <= 255) {
            this.opcode = (short)18;
            this.length = (short)2;
        } else {
            this.opcode = (short)19;
            this.length = (short)3;
        }
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.opcode);
        if (this.length == 2) {
            dataOutputStream.writeByte(this.index);
        } else {
            dataOutputStream.writeShort(this.index);
        }
    }

    public final void setIndex(int n) {
        super.setIndex(n);
        this.setSize();
    }

    protected void initFromFile(ByteSequence byteSequence, boolean bl) throws IOException {
        this.length = (short)2;
        this.index = byteSequence.readUnsignedByte();
    }

    public Object getValue(ConstantPoolGen constantPoolGen) {
        Constant constant = constantPoolGen.getConstantPool().getConstant(this.index);
        switch (constant.getTag()) {
            case 8: {
                int n = ((ConstantString)constant).getStringIndex();
                constant = constantPoolGen.getConstantPool().getConstant(n);
                return ((ConstantUtf8)constant).getBytes();
            }
            case 4: {
                return new Float(((ConstantFloat)constant).getBytes());
            }
            case 3: {
                return new Integer(((ConstantInteger)constant).getBytes());
            }
        }
        throw new RuntimeException("Unknown or invalid constant type at " + this.index);
    }

    public Type getType(ConstantPoolGen constantPoolGen) {
        switch (constantPoolGen.getConstantPool().getConstant(this.index).getTag()) {
            case 8: {
                return Type.STRING;
            }
            case 4: {
                return Type.FLOAT;
            }
            case 3: {
                return Type.INT;
            }
        }
        throw new RuntimeException("Unknown or invalid constant type at " + this.index);
    }

    public Class[] getExceptions() {
        return ExceptionConstants.EXCS_STRING_RESOLUTION;
    }

    public void accept(Visitor visitor) {
        visitor.visitStackProducer(this);
        visitor.visitPushInstruction(this);
        visitor.visitExceptionThrower(this);
        visitor.visitTypedInstruction(this);
        visitor.visitCPInstruction(this);
        visitor.visitLDC(this);
    }
}

