/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.org.apache.bcel.generic;

import com.sun.corba.ee.org.apache.bcel.Constants;
import com.sun.corba.ee.org.apache.bcel.classfile.Constant;
import com.sun.corba.ee.org.apache.bcel.classfile.ConstantPool;
import com.sun.corba.ee.org.apache.bcel.generic.ConstantPoolGen;
import com.sun.corba.ee.org.apache.bcel.generic.ExceptionThrower;
import com.sun.corba.ee.org.apache.bcel.generic.FieldOrMethod;
import com.sun.corba.ee.org.apache.bcel.generic.StackConsumer;
import com.sun.corba.ee.org.apache.bcel.generic.StackProducer;
import com.sun.corba.ee.org.apache.bcel.generic.Type;
import com.sun.corba.ee.org.apache.bcel.generic.TypedInstruction;
import java.util.StringTokenizer;

public abstract class InvokeInstruction
extends FieldOrMethod
implements ExceptionThrower,
TypedInstruction,
StackConsumer,
StackProducer {
    InvokeInstruction() {
    }

    protected InvokeInstruction(short s, int n) {
        super(s, n);
    }

    public String toString(ConstantPool constantPool) {
        Constant constant = constantPool.getConstant(this.index);
        StringTokenizer stringTokenizer = new StringTokenizer(constantPool.constantToString(constant));
        return Constants.OPCODE_NAMES[this.opcode] + " " + stringTokenizer.nextToken().replace('.', '/') + stringTokenizer.nextToken();
    }

    public int consumeStack(ConstantPoolGen constantPoolGen) {
        String string = this.getSignature(constantPoolGen);
        Type[] typeArray = Type.getArgumentTypes(string);
        int n = this.opcode == 184 ? 0 : 1;
        int n2 = typeArray.length;
        for (int i = 0; i < n2; ++i) {
            n += typeArray[i].getSize();
        }
        return n;
    }

    public int produceStack(ConstantPoolGen constantPoolGen) {
        return this.getReturnType(constantPoolGen).getSize();
    }

    public Type getType(ConstantPoolGen constantPoolGen) {
        return this.getReturnType(constantPoolGen);
    }

    public String getMethodName(ConstantPoolGen constantPoolGen) {
        return this.getName(constantPoolGen);
    }

    public Type getReturnType(ConstantPoolGen constantPoolGen) {
        return Type.getReturnType(this.getSignature(constantPoolGen));
    }

    public Type[] getArgumentTypes(ConstantPoolGen constantPoolGen) {
        return Type.getArgumentTypes(this.getSignature(constantPoolGen));
    }
}

