/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.org.apache.bcel.classfile;

import com.sun.corba.ee.org.apache.bcel.classfile.Attribute;
import com.sun.corba.ee.org.apache.bcel.classfile.ConstantPool;
import com.sun.corba.ee.org.apache.bcel.classfile.ConstantUtf8;
import com.sun.corba.ee.org.apache.bcel.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class PMGClass
extends Attribute {
    private int pmg_class_index;
    private int pmg_index;

    public PMGClass(PMGClass pMGClass) {
        this(pMGClass.getNameIndex(), pMGClass.getLength(), pMGClass.getPMGIndex(), pMGClass.getPMGClassIndex(), pMGClass.getConstantPool());
    }

    PMGClass(int n, int n2, DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this(n, n2, dataInputStream.readUnsignedShort(), dataInputStream.readUnsignedShort(), constantPool);
    }

    public PMGClass(int n, int n2, int n3, int n4, ConstantPool constantPool) {
        super((byte)9, n, n2, constantPool);
        this.pmg_index = n3;
        this.pmg_class_index = n4;
    }

    public void accept(Visitor visitor) {
        System.err.println("Visiting non-standard PMGClass object");
    }

    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.pmg_index);
        dataOutputStream.writeShort(this.pmg_class_index);
    }

    public final int getPMGClassIndex() {
        return this.pmg_class_index;
    }

    public final void setPMGClassIndex(int n) {
        this.pmg_class_index = n;
    }

    public final int getPMGIndex() {
        return this.pmg_index;
    }

    public final void setPMGIndex(int n) {
        this.pmg_index = n;
    }

    public final String getPMGName() {
        ConstantUtf8 constantUtf8 = (ConstantUtf8)this.constant_pool.getConstant(this.pmg_index, (byte)1);
        return constantUtf8.getBytes();
    }

    public final String getPMGClassName() {
        ConstantUtf8 constantUtf8 = (ConstantUtf8)this.constant_pool.getConstant(this.pmg_class_index, (byte)1);
        return constantUtf8.getBytes();
    }

    public final String toString() {
        return "PMGClass(" + this.getPMGName() + ", " + this.getPMGClassName() + ")";
    }

    public Attribute copy(ConstantPool constantPool) {
        return (PMGClass)this.clone();
    }
}

