/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.org.apache.bcel.classfile;

import com.sun.corba.ee.org.apache.bcel.classfile.Attribute;
import com.sun.corba.ee.org.apache.bcel.classfile.ClassFormatException;
import com.sun.corba.ee.org.apache.bcel.classfile.Code;
import com.sun.corba.ee.org.apache.bcel.classfile.ConstantPool;
import com.sun.corba.ee.org.apache.bcel.classfile.ConstantUtf8;
import com.sun.corba.ee.org.apache.bcel.classfile.ExceptionTable;
import com.sun.corba.ee.org.apache.bcel.classfile.FieldOrMethod;
import com.sun.corba.ee.org.apache.bcel.classfile.LineNumberTable;
import com.sun.corba.ee.org.apache.bcel.classfile.LocalVariableTable;
import com.sun.corba.ee.org.apache.bcel.classfile.Utility;
import com.sun.corba.ee.org.apache.bcel.classfile.Visitor;
import com.sun.corba.ee.org.apache.bcel.generic.Type;
import java.io.DataInputStream;
import java.io.IOException;

public final class Method
extends FieldOrMethod {
    public Method() {
    }

    public Method(Method method) {
        super(method);
    }

    Method(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException, ClassFormatException {
        super(dataInputStream, constantPool);
    }

    public Method(int n, int n2, int n3, Attribute[] attributeArray, ConstantPool constantPool) {
        super(n, n2, n3, attributeArray, constantPool);
    }

    public void accept(Visitor visitor) {
        visitor.visitMethod(this);
    }

    public final Code getCode() {
        for (int i = 0; i < this.attributes_count; ++i) {
            if (!(this.attributes[i] instanceof Code)) continue;
            return (Code)this.attributes[i];
        }
        return null;
    }

    public final ExceptionTable getExceptionTable() {
        for (int i = 0; i < this.attributes_count; ++i) {
            if (!(this.attributes[i] instanceof ExceptionTable)) continue;
            return (ExceptionTable)this.attributes[i];
        }
        return null;
    }

    public final LocalVariableTable getLocalVariableTable() {
        Code code = this.getCode();
        if (code != null) {
            return code.getLocalVariableTable();
        }
        return null;
    }

    public final LineNumberTable getLineNumberTable() {
        Code code = this.getCode();
        if (code != null) {
            return code.getLineNumberTable();
        }
        return null;
    }

    public final String toString() {
        Object object;
        String string = Utility.accessToString(this.access_flags);
        ConstantUtf8 constantUtf8 = (ConstantUtf8)this.constant_pool.getConstant(this.signature_index, (byte)1);
        String string2 = constantUtf8.getBytes();
        constantUtf8 = (ConstantUtf8)this.constant_pool.getConstant(this.name_index, (byte)1);
        String string3 = constantUtf8.getBytes();
        string2 = Utility.methodSignatureToString(string2, string3, string, true, this.getLocalVariableTable());
        StringBuffer stringBuffer = new StringBuffer(string2);
        for (int i = 0; i < this.attributes_count; ++i) {
            object = this.attributes[i];
            if (object instanceof Code || object instanceof ExceptionTable) continue;
            stringBuffer.append(" [" + ((Attribute)object).toString() + "]");
        }
        ExceptionTable exceptionTable = this.getExceptionTable();
        if (exceptionTable != null && !((String)(object = exceptionTable.toString())).equals("")) {
            stringBuffer.append("\n\t\tthrows " + (String)object);
        }
        return stringBuffer.toString();
    }

    public final Method copy(ConstantPool constantPool) {
        return (Method)this.copy_(constantPool);
    }

    public Type getReturnType() {
        return Type.getReturnType(this.getSignature());
    }

    public Type[] getArgumentTypes() {
        return Type.getArgumentTypes(this.getSignature());
    }
}

