/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.org.apache.bcel.classfile;

import com.sun.corba.ee.org.apache.bcel.classfile.Constant;
import com.sun.corba.ee.org.apache.bcel.classfile.ConstantObject;
import com.sun.corba.ee.org.apache.bcel.classfile.ConstantPool;
import com.sun.corba.ee.org.apache.bcel.classfile.ConstantUtf8;
import com.sun.corba.ee.org.apache.bcel.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ConstantString
extends Constant
implements ConstantObject {
    private int string_index;

    public ConstantString(ConstantString constantString) {
        this(constantString.getStringIndex());
    }

    ConstantString(DataInputStream dataInputStream) throws IOException {
        this(dataInputStream.readUnsignedShort());
    }

    public ConstantString(int n) {
        super((byte)8);
        this.string_index = n;
    }

    public void accept(Visitor visitor) {
        visitor.visitConstantString(this);
    }

    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.tag);
        dataOutputStream.writeShort(this.string_index);
    }

    public final int getStringIndex() {
        return this.string_index;
    }

    public final void setStringIndex(int n) {
        this.string_index = n;
    }

    public final String toString() {
        return super.toString() + "(string_index = " + this.string_index + ")";
    }

    public Object getConstantValue(ConstantPool constantPool) {
        Constant constant = constantPool.getConstant(this.string_index, (byte)1);
        return ((ConstantUtf8)constant).getBytes();
    }

    public String getBytes(ConstantPool constantPool) {
        return (String)this.getConstantValue(constantPool);
    }
}

