/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.org.apache.bcel;

import com.sun.corba.ee.org.apache.bcel.classfile.JavaClass;
import com.sun.corba.ee.org.apache.bcel.util.ClassPath;
import com.sun.corba.ee.org.apache.bcel.util.SyntheticRepository;
import java.io.IOException;

public abstract class Repository {
    private static com.sun.corba.ee.org.apache.bcel.util.Repository _repository = SyntheticRepository.getInstance();

    public static com.sun.corba.ee.org.apache.bcel.util.Repository getRepository() {
        return _repository;
    }

    public static void setRepository(com.sun.corba.ee.org.apache.bcel.util.Repository repository) {
        _repository = repository;
    }

    public static JavaClass lookupClass(String string) {
        try {
            JavaClass javaClass = _repository.findClass(string);
            if (javaClass == null) {
                return _repository.loadClass(string);
            }
            return javaClass;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static JavaClass lookupClass(Class clazz) {
        try {
            return _repository.loadClass(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static ClassPath.ClassFile lookupClassFile(String string) {
        try {
            return ClassPath.SYSTEM_CLASS_PATH.getClassFile(string);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static void clearCache() {
        _repository.clear();
    }

    public static JavaClass addClass(JavaClass javaClass) {
        JavaClass javaClass2 = _repository.findClass(javaClass.getClassName());
        _repository.storeClass(javaClass);
        return javaClass2;
    }

    public static void removeClass(String string) {
        _repository.removeClass(_repository.findClass(string));
    }

    public static void removeClass(JavaClass javaClass) {
        _repository.removeClass(javaClass);
    }

    public static JavaClass[] getSuperClasses(JavaClass javaClass) {
        return javaClass.getSuperClasses();
    }

    public static JavaClass[] getSuperClasses(String string) {
        JavaClass javaClass = Repository.lookupClass(string);
        return javaClass == null ? null : Repository.getSuperClasses(javaClass);
    }

    public static JavaClass[] getInterfaces(JavaClass javaClass) {
        return javaClass.getAllInterfaces();
    }

    public static JavaClass[] getInterfaces(String string) {
        return Repository.getInterfaces(Repository.lookupClass(string));
    }

    public static boolean instanceOf(JavaClass javaClass, JavaClass javaClass2) {
        return javaClass.instanceOf(javaClass2);
    }

    public static boolean instanceOf(String string, String string2) {
        return Repository.instanceOf(Repository.lookupClass(string), Repository.lookupClass(string2));
    }

    public static boolean instanceOf(JavaClass javaClass, String string) {
        return Repository.instanceOf(javaClass, Repository.lookupClass(string));
    }

    public static boolean instanceOf(String string, JavaClass javaClass) {
        return Repository.instanceOf(Repository.lookupClass(string), javaClass);
    }

    public static boolean implementationOf(JavaClass javaClass, JavaClass javaClass2) {
        return javaClass.implementationOf(javaClass2);
    }

    public static boolean implementationOf(String string, String string2) {
        return Repository.implementationOf(Repository.lookupClass(string), Repository.lookupClass(string2));
    }

    public static boolean implementationOf(JavaClass javaClass, String string) {
        return Repository.implementationOf(javaClass, Repository.lookupClass(string));
    }

    public static boolean implementationOf(String string, JavaClass javaClass) {
        return Repository.implementationOf(Repository.lookupClass(string), javaClass);
    }
}

