/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import sun.corba.Bridge;

class JDKClassLoader {
    private static final JDKClassLoaderCache classCache = new JDKClassLoaderCache();
    private static final Bridge bridge = (Bridge)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return Bridge.get();
        }
    });

    JDKClassLoader() {
    }

    static Class loadClass(Class clazz, String string) throws ClassNotFoundException {
        if (string == null) {
            throw new NullPointerException();
        }
        if (string.length() == 0) {
            throw new ClassNotFoundException();
        }
        ClassLoader classLoader = clazz != null ? clazz.getClassLoader() : bridge.getLatestUserDefinedLoader();
        Object object = classCache.createKey(string, classLoader);
        if (classCache.knownToFail(object)) {
            throw new ClassNotFoundException(string);
        }
        try {
            return Class.forName(string, false, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classCache.recordFailure(object);
            throw classNotFoundException;
        }
    }

    private static class JDKClassLoaderCache {
        private final Map cache = Collections.synchronizedMap(new WeakHashMap());
        private static final Object KNOWN_TO_FAIL = new Object();

        private JDKClassLoaderCache() {
        }

        public final void recordFailure(Object object) {
            this.cache.put(object, KNOWN_TO_FAIL);
        }

        public final Object createKey(String string, ClassLoader classLoader) {
            return new CacheKey(string, classLoader);
        }

        public final boolean knownToFail(Object object) {
            return this.cache.get(object) == KNOWN_TO_FAIL;
        }

        private static class CacheKey {
            String className;
            ClassLoader loader;

            public CacheKey(String string, ClassLoader classLoader) {
                this.className = string;
                this.loader = classLoader;
            }

            public int hashCode() {
                if (this.loader == null) {
                    return this.className.hashCode();
                }
                return this.className.hashCode() ^ this.loader.hashCode();
            }

            public boolean equals(Object object) {
                try {
                    if (object == null) {
                        return false;
                    }
                    CacheKey cacheKey = (CacheKey)object;
                    return this.className.equals(cacheKey.className) && this.loader == cacheKey.loader;
                }
                catch (ClassCastException classCastException) {
                    return false;
                }
            }
        }
    }
}

