/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.spi.transport.MessageTraceManager;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class MessageTraceManagerImpl
implements MessageTraceManager {
    private List dataSent;
    private List dataReceived;
    private boolean enabled;
    private boolean RHRCalled;
    private byte[] header;

    public MessageTraceManagerImpl() {
        this.init();
        this.enabled = false;
    }

    public void clear() {
        this.init();
    }

    private void init() {
        this.dataSent = new ArrayList();
        this.dataReceived = new ArrayList();
        this.initHeaderRecorder();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void enable(boolean bl) {
        this.enabled = bl;
    }

    public byte[][] getDataSent() {
        return (byte[][])this.dataSent.toArray((T[])new byte[this.dataSent.size()][]);
    }

    public byte[][] getDataReceived() {
        return (byte[][])this.dataReceived.toArray((T[])new byte[this.dataReceived.size()][]);
    }

    private void initHeaderRecorder() {
        this.RHRCalled = false;
        this.header = null;
    }

    public byte[] getBytes(ByteBuffer byteBuffer, int n) {
        ByteBuffer byteBuffer2 = byteBuffer.asReadOnlyBuffer();
        byteBuffer2.flip();
        int n2 = byteBuffer2.remaining();
        byte[] byArray = new byte[n2 + n];
        byteBuffer2.get(byArray, n, n2);
        return byArray;
    }

    public void recordDataSent(ByteBuffer byteBuffer) {
        byte[] byArray = this.getBytes(byteBuffer, 0);
        this.dataSent.add(byArray);
    }

    public void recordHeaderReceived(ByteBuffer byteBuffer) {
        if (this.RHRCalled) {
            this.dataReceived.add(this.header);
            this.initHeaderRecorder();
        }
        this.RHRCalled = true;
        this.header = this.getBytes(byteBuffer, 0);
    }

    public void recordBodyReceived(ByteBuffer byteBuffer) {
        if (!this.RHRCalled) {
            this.header = "NO HEADER!!!".getBytes();
        }
        byte[] byArray = this.getBytes(byteBuffer, this.header.length);
        System.arraycopy(this.header, 0, byArray, this.header.length, byteBuffer.remaining());
        this.dataReceived.add(byArray);
        this.initHeaderRecorder();
    }
}

