/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.pept.transport.Acceptor;
import com.sun.corba.ee.pept.transport.ListenerThread;
import com.sun.corba.ee.pept.transport.Selector;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orbutil.threadpool.Work;

public class ListenerThreadImpl
implements ListenerThread,
Work {
    private ORB orb;
    private Acceptor acceptor;
    private Selector selector;
    private boolean keepRunning;
    private long enqueueTime;

    public ListenerThreadImpl(ORB oRB, Acceptor acceptor, Selector selector) {
        this.orb = oRB;
        this.acceptor = acceptor;
        this.selector = selector;
        this.keepRunning = true;
    }

    public Acceptor getAcceptor() {
        return this.acceptor;
    }

    public void close() {
        if (this.orb.transportDebugFlag) {
            this.dprint(".close: " + this.acceptor);
        }
        this.keepRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWork() {
        try {
            if (this.orb.transportDebugFlag) {
                this.dprint(".doWork: Start ListenerThread: " + this.acceptor);
            }
            while (this.keepRunning) {
                try {
                    if (this.orb.transportDebugFlag) {
                        this.dprint(".doWork: BEFORE ACCEPT CYCLE: " + this.acceptor);
                    }
                    this.acceptor.accept();
                    if (!this.orb.transportDebugFlag) continue;
                    this.dprint(".doWork: AFTER ACCEPT CYCLE: " + this.acceptor);
                }
                catch (Throwable throwable) {
                    if (this.orb.transportDebugFlag) {
                        this.dprint(".doWork: Exception in accept: " + this.acceptor, throwable);
                    }
                    this.orb.getTransportManager().getSelector(0).unregisterForEvent(this.getAcceptor().getEventHandler());
                    this.getAcceptor().close();
                }
            }
            Object var3_2 = null;
            if (this.orb.transportDebugFlag) {
                this.dprint(".doWork: Terminated ListenerThread: " + this.acceptor);
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (this.orb.transportDebugFlag) {
                this.dprint(".doWork: Terminated ListenerThread: " + this.acceptor);
            }
            throw throwable;
        }
    }

    public void setEnqueueTime(long l) {
        this.enqueueTime = l;
    }

    public long getEnqueueTime() {
        return this.enqueueTime;
    }

    public String getName() {
        return "ListenerThread";
    }

    private void dprint(String string) {
        ORBUtility.dprint("ListenerThreadImpl", string);
    }

    private void dprint(String string, Throwable throwable) {
        this.dprint(string);
        throwable.printStackTrace(System.out);
    }
}

