/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.encoding.CDRInputObject;
import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.LocateReplyOrReplyMessage;
import com.sun.corba.ee.pept.encoding.InputObject;
import com.sun.corba.ee.pept.protocol.MessageMediator;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.protocol.CorbaMessageMediator;
import com.sun.corba.ee.spi.transport.CorbaConnection;
import com.sun.corba.ee.spi.transport.CorbaResponseWaitingRoom;
import java.util.Enumeration;
import java.util.Hashtable;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;

public class CorbaResponseWaitingRoomImpl
implements CorbaResponseWaitingRoom {
    private ORB orb;
    private ORBUtilSystemException wrapper;
    private CorbaConnection connection;
    private Hashtable out_calls = null;

    public CorbaResponseWaitingRoomImpl(ORB oRB, CorbaConnection corbaConnection) {
        this.orb = oRB;
        this.wrapper = ORBUtilSystemException.get(oRB, "rpc.transport");
        this.connection = corbaConnection;
        this.out_calls = new Hashtable();
    }

    public void registerWaiter(MessageMediator messageMediator) {
        CorbaMessageMediator corbaMessageMediator = (CorbaMessageMediator)messageMediator;
        if (this.orb.transportDebugFlag) {
            this.dprint(".registerWaiter: " + this.opAndId(corbaMessageMediator));
        }
        Integer n = corbaMessageMediator.getRequestIdInteger();
        OutCallDesc outCallDesc = new OutCallDesc();
        outCallDesc.thread = Thread.currentThread();
        outCallDesc.messageMediator = corbaMessageMediator;
        this.out_calls.put(n, outCallDesc);
    }

    public void unregisterWaiter(MessageMediator messageMediator) {
        CorbaMessageMediator corbaMessageMediator = (CorbaMessageMediator)messageMediator;
        if (this.orb.transportDebugFlag) {
            this.dprint(".unregisterWaiter: " + this.opAndId(corbaMessageMediator));
        }
        Integer n = corbaMessageMediator.getRequestIdInteger();
        this.out_calls.remove(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public InputObject waitForResponse(MessageMediator messageMediator) {
        CorbaMessageMediator corbaMessageMediator = (CorbaMessageMediator)messageMediator;
        try {
            InputObject inputObject = null;
            if (this.orb.transportDebugFlag) {
                this.dprint(".waitForResponse->: " + this.opAndId(corbaMessageMediator));
            }
            Integer n = corbaMessageMediator.getRequestIdInteger();
            if (corbaMessageMediator.isOneWay()) {
                if (this.orb.transportDebugFlag) {
                    this.dprint(".waitForResponse: one way - not waiting: " + this.opAndId(corbaMessageMediator));
                }
                InputObject inputObject2 = null;
                Object var11_7 = null;
                if (!this.orb.transportDebugFlag) return inputObject2;
                this.dprint(".waitForResponse<-: " + this.opAndId(corbaMessageMediator));
                return inputObject2;
            }
            OutCallDesc outCallDesc = (OutCallDesc)this.out_calls.get(n);
            if (outCallDesc == null) {
                throw this.wrapper.nullOutCall(CompletionStatus.COMPLETED_MAYBE);
            }
            Object object = outCallDesc.done;
            // MONITORENTER : object
            while (outCallDesc.inputObject == null && outCallDesc.exception == null) {
                try {
                    if (this.orb.transportDebugFlag) {
                        this.dprint(".waitForResponse: waiting: " + this.opAndId(corbaMessageMediator));
                    }
                    long l = this.orb.getORBData().getWaitForResponseTimeout();
                    outCallDesc.done.wait(l);
                    if (outCallDesc.inputObject != null || outCallDesc.exception != null) continue;
                    outCallDesc.exception = this.wrapper.communicationsTimeoutWaitingForResponse(CompletionStatus.COMPLETED_MAYBE, (Object)new Long(l));
                    ORBUtility.pushEncVersionToThreadLocalState(new Integer(1));
                }
                catch (InterruptedException interruptedException) {}
            }
            if (outCallDesc.exception != null) {
                if (!this.orb.transportDebugFlag) throw outCallDesc.exception;
                this.dprint(".waitForResponse: exception: " + this.opAndId(corbaMessageMediator) + " " + (Object)((Object)outCallDesc.exception));
                throw outCallDesc.exception;
            }
            inputObject = outCallDesc.inputObject;
            // MONITOREXIT : object
            if (inputObject != null) {
                ((CDRInputObject)inputObject).unmarshalHeader();
            }
            object = inputObject;
            Object var11_8 = null;
            if (!this.orb.transportDebugFlag) return object;
            this.dprint(".waitForResponse<-: " + this.opAndId(corbaMessageMediator));
            return object;
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            if (!this.orb.transportDebugFlag) throw throwable;
            this.dprint(".waitForResponse<-: " + this.opAndId(corbaMessageMediator));
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void responseReceived(InputObject inputObject) {
        CDRInputObject cDRInputObject = (CDRInputObject)inputObject;
        LocateReplyOrReplyMessage locateReplyOrReplyMessage = (LocateReplyOrReplyMessage)cDRInputObject.getMessageHeader();
        Integer n = new Integer(locateReplyOrReplyMessage.getRequestId());
        OutCallDesc outCallDesc = (OutCallDesc)this.out_calls.get(n);
        if (this.orb.transportDebugFlag) {
            this.dprint(".responseReceived: id/" + n + ": " + locateReplyOrReplyMessage);
        }
        if (outCallDesc == null) {
            if (this.orb.transportDebugFlag) {
                this.dprint(".responseReceived: id/" + n + ": no waiter: " + locateReplyOrReplyMessage);
            }
            return;
        }
        Object object = outCallDesc.done;
        synchronized (object) {
            CorbaMessageMediator corbaMessageMediator = (CorbaMessageMediator)outCallDesc.messageMediator;
            if (this.orb.transportDebugFlag) {
                this.dprint(".responseReceived: " + this.opAndId(corbaMessageMediator) + ": notifying waiters");
            }
            corbaMessageMediator.setReplyHeader(locateReplyOrReplyMessage);
            corbaMessageMediator.setInputObject(inputObject);
            cDRInputObject.setMessageMediator(corbaMessageMediator);
            outCallDesc.inputObject = inputObject;
            outCallDesc.done.notify();
        }
    }

    public int numberRegistered() {
        return this.out_calls.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalExceptionToAllWaiters(SystemException systemException) {
        if (this.orb.transportDebugFlag) {
            this.dprint(".signalExceptionToAllWaiters: " + (Object)((Object)systemException));
        }
        Enumeration enumeration = this.out_calls.elements();
        while (enumeration.hasMoreElements()) {
            OutCallDesc outCallDesc = (OutCallDesc)enumeration.nextElement();
            Object object = outCallDesc.done;
            synchronized (object) {
                ((CorbaMessageMediator)outCallDesc.messageMediator).cancelRequest();
                outCallDesc.inputObject = null;
                outCallDesc.exception = systemException;
                outCallDesc.done.notify();
            }
        }
    }

    public MessageMediator getMessageMediator(int n) {
        Integer n2 = new Integer(n);
        OutCallDesc outCallDesc = (OutCallDesc)this.out_calls.get(n2);
        if (outCallDesc == null) {
            return null;
        }
        return outCallDesc.messageMediator;
    }

    protected void dprint(String string) {
        ORBUtility.dprint("CorbaResponseWaitingRoomImpl", string);
    }

    protected String opAndId(CorbaMessageMediator corbaMessageMediator) {
        return ORBUtility.operationNameAndRequestId(corbaMessageMediator);
    }

    static final class OutCallDesc {
        Object done = new Object();
        Thread thread;
        MessageMediator messageMediator;
        SystemException exception;
        InputObject inputObject;

        OutCallDesc() {
        }
    }
}

