/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.impl.protocol.CorbaInvocationInfo;
import com.sun.corba.ee.pept.transport.ContactInfo;
import com.sun.corba.ee.pept.transport.ContactInfoList;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.transport.CorbaContactInfo;
import com.sun.corba.ee.spi.transport.CorbaContactInfoList;
import com.sun.corba.ee.spi.transport.CorbaContactInfoListIterator;
import com.sun.corba.ee.spi.transport.IIOPPrimaryToContactInfo;
import java.util.Iterator;
import java.util.List;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;

public class CorbaContactInfoListIteratorImpl
implements CorbaContactInfoListIterator {
    protected ORB orb;
    protected CorbaContactInfoList contactInfoList;
    protected CorbaContactInfo successContactInfo;
    protected CorbaContactInfo failureContactInfo;
    protected RuntimeException failureException;
    protected ORBUtilSystemException wrapper;
    protected boolean debug;
    protected Iterator effectiveTargetIORIterator;
    protected CorbaContactInfo previousContactInfo;
    protected boolean isAddrDispositionRetry;
    protected boolean retryWithPreviousContactInfo;
    protected IIOPPrimaryToContactInfo primaryToContactInfo;
    protected ContactInfo primaryContactInfo;
    protected List listOfContactInfos;
    protected long startTime;
    protected long backoff;
    private static final long INITIAL_BACKOFF = 250L;

    public CorbaContactInfoListIteratorImpl(ORB oRB, CorbaContactInfoList corbaContactInfoList, ContactInfo contactInfo, List list) {
        this.orb = oRB;
        this.wrapper = ORBUtilSystemException.get(oRB, "rpc.transport");
        this.debug = oRB.transportDebugFlag;
        this.contactInfoList = corbaContactInfoList;
        this.primaryContactInfo = contactInfo;
        if (list != null) {
            this.effectiveTargetIORIterator = list.iterator();
        }
        this.listOfContactInfos = list;
        this.previousContactInfo = null;
        this.isAddrDispositionRetry = false;
        this.retryWithPreviousContactInfo = false;
        this.successContactInfo = null;
        this.failureContactInfo = null;
        this.failureException = null;
        this.startTime = -1L;
        this.primaryToContactInfo = oRB.getORBData().getIIOPPrimaryToContactInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNext() {
        boolean bl = false;
        try {
            if (this.debug) {
                this.dprint(".hasNext->:");
            }
            if (this.startTime == -1L) {
                this.startTime = System.currentTimeMillis();
                this.backoff = 250L;
            } else {
                this.backoff *= 2L;
            }
            if (this.retryWithPreviousContactInfo) {
                if (this.debug) {
                    this.dprint(".hasNext: backoff before retry previous");
                }
                if (this.thresholdExceeded()) {
                    if (this.debug) {
                        this.dprint(".hasNext: com.sun.CORBA.transport.ORBCommunicationsRetryTimeout exceeded: " + this.orb.getORBData().getCommunicationsRetryTimeout());
                    }
                    this.failureException = this.wrapper.communicationsRetryTimeout(this.failureException, (Object)Long.toString(this.orb.getORBData().getCommunicationsRetryTimeout()));
                    boolean bl2 = bl = false;
                    return bl2;
                }
                try {
                    Thread.sleep(this.backoff);
                }
                catch (InterruptedException interruptedException) {
                    this.wrapper.ignoringExceptionWhileWaitingForRetry(interruptedException);
                }
                boolean bl3 = bl = true;
                return bl3;
            }
            if (this.isAddrDispositionRetry) {
                boolean bl4 = bl = true;
                return bl4;
            }
            bl = this.primaryToContactInfo != null ? this.primaryToContactInfo.hasNext(this.primaryContactInfo, this.previousContactInfo, this.listOfContactInfos) : this.effectiveTargetIORIterator.hasNext();
            if (!bl && !this.thresholdExceeded()) {
                if (this.debug) {
                    this.dprint("Reached end of ContactInfoList list. Starting at beginning");
                }
                this.previousContactInfo = null;
                if (this.primaryToContactInfo != null) {
                    this.primaryToContactInfo.reset(this.primaryContactInfo);
                } else {
                    this.effectiveTargetIORIterator = this.listOfContactInfos.iterator();
                }
                boolean bl5 = bl = this.hasNext();
                return bl5;
            }
            boolean bl6 = bl;
            return bl6;
        }
        finally {
            if (this.debug) {
                this.dprint(".hasNext<-: " + bl);
            }
        }
    }

    private boolean thresholdExceeded() {
        return System.currentTimeMillis() - this.startTime >= this.orb.getORBData().getCommunicationsRetryTimeout();
    }

    public Object next() {
        if (this.retryWithPreviousContactInfo) {
            this.retryWithPreviousContactInfo = false;
            return this.previousContactInfo;
        }
        if (this.isAddrDispositionRetry) {
            this.isAddrDispositionRetry = false;
            return this.previousContactInfo;
        }
        this.previousContactInfo = this.primaryToContactInfo != null ? (CorbaContactInfo)this.primaryToContactInfo.next(this.primaryContactInfo, this.previousContactInfo, this.listOfContactInfos) : (CorbaContactInfo)this.effectiveTargetIORIterator.next();
        return this.previousContactInfo;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public ContactInfoList getContactInfoList() {
        return this.contactInfoList;
    }

    public void reportSuccess(ContactInfo contactInfo) {
        if (this.debug) {
            this.dprint(".reportSuccess: " + contactInfo);
        }
        this.successContactInfo = (CorbaContactInfo)contactInfo;
        this.backoff = 250L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reportException(ContactInfo contactInfo, RuntimeException runtimeException) {
        boolean bl;
        block19: {
            block17: {
                block20: {
                    SystemException systemException;
                    block18: {
                        bl = false;
                        try {
                            if (this.debug) {
                                this.dprint(".reportException->: " + contactInfo + " " + runtimeException);
                            }
                            this.failureContactInfo = (CorbaContactInfo)contactInfo;
                            this.failureException = runtimeException;
                            if (!(runtimeException instanceof COMM_FAILURE)) break block17;
                            systemException = (SystemException)((Object)runtimeException);
                            if (systemException.minor != 1398079697) break block18;
                            if (this.debug) {
                                this.dprint(".reportException: " + contactInfo + " " + runtimeException + ": COMM_FAILURE/CONNECTION_REBIND - retryWithPreviousContactInfo");
                            }
                            this.retryWithPreviousContactInfo = true;
                            boolean bl2 = bl = true;
                            Object var7_10 = null;
                            if (this.debug) {
                                this.dprint(".reportException<-: " + contactInfo + " " + runtimeException + ": " + bl);
                            }
                            return bl2;
                        }
                        catch (Throwable throwable) {
                            block21: {
                                Object var7_15 = null;
                                if (!this.debug) break block21;
                                this.dprint(".reportException<-: " + contactInfo + " " + runtimeException + ": " + bl);
                            }
                            throw throwable;
                        }
                    }
                    if (systemException.completed != CompletionStatus.COMPLETED_NO) break block19;
                    if (!this.hasNext()) break block20;
                    if (this.debug) {
                        this.dprint(".reportException: " + contactInfo + " " + runtimeException + ": COMM_FAILURE/COMPLETED_NO and hasNext/true - try next ContactInfo");
                    }
                    boolean bl3 = bl = true;
                    Object var7_11 = null;
                    if (this.debug) {
                        this.dprint(".reportException<-: " + contactInfo + " " + runtimeException + ": " + bl);
                    }
                    return bl3;
                }
                if (this.contactInfoList.getEffectiveTargetIOR() != this.contactInfoList.getTargetIOR()) {
                    if (this.debug) {
                        this.dprint(".reportException: " + contactInfo + " " + runtimeException + ": COMM_FAILURE/COMPLETED_NO and hasNext/false and effect != target - retry target");
                    }
                    this.updateEffectiveTargetIOR(this.contactInfoList.getTargetIOR());
                    boolean bl4 = bl = true;
                    Object var7_12 = null;
                    if (this.debug) {
                        this.dprint(".reportException<-: " + contactInfo + " " + runtimeException + ": " + bl);
                    }
                    return bl4;
                }
                break block19;
            }
            if (!(runtimeException instanceof TRANSIENT)) break block19;
            if (this.debug) {
                this.dprint(".reportException: " + contactInfo + " " + runtimeException + ": TRANSIENT - retryWithPreviousContactInfo");
            }
            this.retryWithPreviousContactInfo = true;
            boolean bl5 = bl = true;
            Object var7_13 = null;
            if (this.debug) {
                this.dprint(".reportException<-: " + contactInfo + " " + runtimeException + ": " + bl);
            }
            return bl5;
        }
        bl = false;
        this.backoff = 250L;
        boolean bl6 = bl;
        Object var7_14 = null;
        if (this.debug) {
            this.dprint(".reportException<-: " + contactInfo + " " + runtimeException + ": " + bl);
        }
        return bl6;
    }

    public RuntimeException getFailureException() {
        if (this.failureException == null) {
            return ORBUtilSystemException.get(this.orb, "rpc.transport").invalidContactInfoListIteratorFailureException();
        }
        return this.failureException;
    }

    public void reportAddrDispositionRetry(CorbaContactInfo corbaContactInfo, short s) {
        if (this.debug) {
            this.dprint(".reportAddrDispositionRetry: " + corbaContactInfo + " " + s);
        }
        this.previousContactInfo.setAddressingDisposition(s);
        this.isAddrDispositionRetry = true;
        this.backoff = 250L;
    }

    public void reportRedirect(CorbaContactInfo corbaContactInfo, IOR iOR) {
        if (this.debug) {
            this.dprint(".reportRedirect: " + corbaContactInfo + " " + iOR);
        }
        this.updateEffectiveTargetIOR(iOR);
        this.backoff = 250L;
    }

    public void updateEffectiveTargetIOR(IOR iOR) {
        this.contactInfoList.setEffectiveTargetIOR(iOR);
        ((CorbaInvocationInfo)this.orb.getInvocationInfo()).setContactInfoListIterator(this.contactInfoList.iterator());
    }

    protected void dprint(String string) {
        ORBUtility.dprint("CorbaContactInfoListIteratorImpl", string);
    }
}

