/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.resolver;

import com.sun.corba.ee.impl.encoding.EncapsInputStream;
import com.sun.corba.ee.impl.logging.OMGSystemException;
import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.naming.namingutil.CorbalocURL;
import com.sun.corba.ee.impl.naming.namingutil.CorbanameURL;
import com.sun.corba.ee.impl.naming.namingutil.IIOPEndpointInfo;
import com.sun.corba.ee.impl.naming.namingutil.INSURL;
import com.sun.corba.ee.impl.naming.namingutil.INSURLHandler;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.IORFactories;
import com.sun.corba.ee.spi.ior.IORTemplate;
import com.sun.corba.ee.spi.ior.MakeImmutable;
import com.sun.corba.ee.spi.ior.ObjectKey;
import com.sun.corba.ee.spi.ior.Writeable;
import com.sun.corba.ee.spi.ior.iiop.GIOPVersion;
import com.sun.corba.ee.spi.ior.iiop.IIOPAddress;
import com.sun.corba.ee.spi.ior.iiop.IIOPFactories;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfileTemplate;
import com.sun.corba.ee.spi.orb.Operation;
import com.sun.corba.ee.spi.resolver.Resolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;

public class INSURLOperationImpl
implements Operation {
    com.sun.corba.ee.spi.orb.ORB orb;
    ORBUtilSystemException wrapper;
    OMGSystemException omgWrapper;
    Resolver bootstrapResolver;
    private NamingContextExt rootNamingContextExt;
    private java.lang.Object rootContextCacheLock = new java.lang.Object();
    private INSURLHandler insURLHandler = INSURLHandler.getINSURLHandler();
    private static final int NIBBLES_PER_BYTE = 2;
    private static final int UN_SHIFT = 4;

    public INSURLOperationImpl(com.sun.corba.ee.spi.orb.ORB oRB, Resolver resolver) {
        this.orb = oRB;
        this.wrapper = ORBUtilSystemException.get(oRB, "orb.resolver");
        this.omgWrapper = OMGSystemException.get(oRB, "orb.resolver");
        this.bootstrapResolver = resolver;
    }

    private Object getIORFromString(String string) {
        if ((string.length() & 1) == 1) {
            throw this.wrapper.badStringifiedIorLen();
        }
        byte[] byArray = new byte[(string.length() - "IOR:".length()) / 2];
        int n = 0;
        for (int i = "IOR:".length(); i < string.length(); i += 2) {
            byArray[n] = (byte)(ORBUtility.hexOf(string.charAt(i)) << 4 & 0xF0);
            int n2 = n++;
            byArray[n2] = (byte)(byArray[n2] | (byte)(ORBUtility.hexOf(string.charAt(i + 1)) & 0xF));
        }
        EncapsInputStream encapsInputStream = new EncapsInputStream((ORB)((java.lang.Object)this.orb), byArray, byArray.length, this.orb.getORBData().getGIOPVersion());
        encapsInputStream.consumeEndian();
        return encapsInputStream.read_Object();
    }

    public java.lang.Object operate(java.lang.Object object) {
        if (object instanceof String) {
            String string = (String)object;
            if (string.startsWith("IOR:")) {
                return this.getIORFromString(string);
            }
            INSURL iNSURL = this.insURLHandler.parseURL(string);
            if (iNSURL == null) {
                throw this.omgWrapper.soBadSchemeName();
            }
            return this.resolveINSURL(iNSURL);
        }
        throw this.wrapper.stringExpected();
    }

    private Object resolveINSURL(INSURL iNSURL) {
        if (iNSURL.isCorbanameURL()) {
            return this.resolveCorbaname((CorbanameURL)iNSURL);
        }
        return this.resolveCorbaloc((CorbalocURL)iNSURL);
    }

    private Object resolveCorbaloc(CorbalocURL corbalocURL) {
        Object object = null;
        object = corbalocURL.getRIRFlag() ? this.bootstrapResolver.resolve(corbalocURL.getKeyString()) : this.getIORUsingCorbaloc(corbalocURL);
        return object;
    }

    private Object resolveCorbaname(CorbanameURL corbanameURL) {
        java.lang.Object var2_2 = null;
        try {
            java.lang.Object object;
            NamingContextExt namingContextExt = null;
            if (corbanameURL.getRIRFlag()) {
                namingContextExt = this.getDefaultRootNamingContext();
            } else {
                object = this.getIORUsingCorbaloc(corbanameURL);
                if (object == null) {
                    return null;
                }
                namingContextExt = NamingContextExtHelper.narrow((Object)object);
            }
            object = corbanameURL.getStringifiedName();
            if (object == null) {
                return namingContextExt;
            }
            return namingContextExt.resolve_str((String)object);
        }
        catch (Exception exception) {
            this.clearRootNamingContextCache();
            throw this.omgWrapper.soBadSchemaSpecific(exception);
        }
    }

    private Object getIORUsingCorbaloc(INSURL iNSURL) {
        MakeImmutable makeImmutable;
        java.lang.Object object;
        List<java.lang.Object> list;
        java.lang.Object object2;
        Writeable writeable;
        java.lang.Object object3;
        HashMap<java.lang.Object, List<java.lang.Object>> hashMap = new HashMap<java.lang.Object, List<java.lang.Object>>();
        ArrayList arrayList = new ArrayList();
        List list2 = iNSURL.getEndpointInfo();
        String string = iNSURL.getKeyString();
        if (string == null) {
            return null;
        }
        ObjectKey objectKey = this.orb.getObjectKeyFactory().create(string.getBytes());
        IORTemplate iORTemplate = IORFactories.makeIORTemplate(objectKey.getTemplate());
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            object3 = (IIOPEndpointInfo)iterator.next();
            writeable = IIOPFactories.makeIIOPAddress(this.orb, ((IIOPEndpointInfo)object3).getHost(), ((IIOPEndpointInfo)object3).getPort());
            object2 = GIOPVersion.getInstance((byte)((IIOPEndpointInfo)object3).getMajor(), (byte)((IIOPEndpointInfo)object3).getMinor());
            list = null;
            if (((GIOPVersion)object2).equals(GIOPVersion.V1_0)) {
                list = IIOPFactories.makeIIOPProfileTemplate(this.orb, (GIOPVersion)object2, (IIOPAddress)writeable);
                arrayList.add(list);
                continue;
            }
            if (hashMap.get(object2) == null) {
                list = IIOPFactories.makeIIOPProfileTemplate(this.orb, (GIOPVersion)object2, (IIOPAddress)writeable);
                hashMap.put(object2, list);
                continue;
            }
            list = (IIOPProfileTemplate)hashMap.get(object2);
            object = IIOPFactories.makeAlternateIIOPAddressComponent((IIOPAddress)writeable);
            list.add(object);
        }
        object3 = this.orb.getORBData().getGIOPVersion();
        writeable = (IIOPProfileTemplate)hashMap.get(object3);
        if (writeable != null) {
            iORTemplate.add(writeable);
            hashMap.remove(object3);
        }
        object2 = new Comparator(){

            public int compare(java.lang.Object object, java.lang.Object object2) {
                GIOPVersion gIOPVersion = (GIOPVersion)object;
                GIOPVersion gIOPVersion2 = (GIOPVersion)object2;
                return gIOPVersion.lessThan(gIOPVersion2) ? 1 : (gIOPVersion.equals(gIOPVersion2) ? 0 : -1);
            }
        };
        list = new ArrayList(hashMap.keySet());
        Collections.sort(list, object2);
        object = list.iterator();
        while (object.hasNext()) {
            makeImmutable = (IIOPProfileTemplate)hashMap.get(object.next());
            iORTemplate.add(makeImmutable);
        }
        iORTemplate.addAll(arrayList);
        makeImmutable = iORTemplate.makeIOR(this.orb, "", objectKey.getId());
        return ORBUtility.makeObjectReference((IOR)makeImmutable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NamingContextExt getDefaultRootNamingContext() {
        java.lang.Object object = this.rootContextCacheLock;
        synchronized (object) {
            if (this.rootNamingContextExt == null) {
                try {
                    this.rootNamingContextExt = NamingContextExtHelper.narrow((Object)this.orb.getLocalResolver().resolve("NameService"));
                }
                catch (Exception exception) {
                    this.rootNamingContextExt = null;
                }
            }
        }
        return this.rootNamingContextExt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearRootNamingContextCache() {
        java.lang.Object object = this.rootContextCacheLock;
        synchronized (object) {
            this.rootNamingContextExt = null;
        }
    }
}

