/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.presentation.rmi.bcel;

import com.sun.corba.ee.org.apache.bcel.Constants;
import com.sun.corba.ee.org.apache.bcel.generic.ArrayType;
import com.sun.corba.ee.org.apache.bcel.generic.BasicType;
import com.sun.corba.ee.org.apache.bcel.generic.ClassGen;
import com.sun.corba.ee.org.apache.bcel.generic.ConstantPoolGen;
import com.sun.corba.ee.org.apache.bcel.generic.InstructionConstants;
import com.sun.corba.ee.org.apache.bcel.generic.InstructionFactory;
import com.sun.corba.ee.org.apache.bcel.generic.InstructionList;
import com.sun.corba.ee.org.apache.bcel.generic.MethodGen;
import com.sun.corba.ee.org.apache.bcel.generic.PUSH;
import com.sun.corba.ee.org.apache.bcel.generic.ReferenceType;
import com.sun.corba.ee.org.apache.bcel.generic.Type;
import com.sun.corba.ee.spi.orbutil.codegen.CodeGeneratorBase;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;

public class ProxyCreator
extends CodeGeneratorBase
implements Constants {
    private static final String INVOKE_METHOD_NAME = "invoke";
    private String superClassName;
    private Class[] interfaces;
    private Method[] methods;
    private InstructionFactory instructionFactory;
    private ConstantPoolGen constantPoolGen;
    private ClassGen classGen;
    private byte[] classData;

    protected byte[] getClassData() {
        return this.classData;
    }

    public ProxyCreator(String string, String string2, Class[] classArray, Method[] methodArray) {
        super(string);
        int n;
        this.superClassName = string2;
        this.interfaces = classArray;
        this.methods = methodArray;
        String string3 = this.getFileName(string);
        String[] stringArray = new String[classArray.length];
        for (n = 0; n < classArray.length; ++n) {
            stringArray[n] = classArray[n].getName();
        }
        this.classGen = new ClassGen(string, string2, string3, 33, stringArray);
        this.constantPoolGen = this.classGen.getConstantPool();
        this.instructionFactory = new InstructionFactory(this.classGen, this.constantPoolGen);
        this.createConstructor();
        this.createWriteReplace();
        for (n = 0; n < methodArray.length; ++n) {
            this.createMethod(n, methodArray[n]);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.classGen.getJavaClass().dump(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            RuntimeException runtimeException = new RuntimeException("Error in dumping class");
            runtimeException.initCause(iOException);
            throw runtimeException;
        }
        this.classData = byteArrayOutputStream.toByteArray();
    }

    private void createConstructor() {
        InstructionList instructionList = new InstructionList();
        MethodGen methodGen = new MethodGen(1, Type.VOID, Type.NO_ARGS, new String[0], "<init>", this.className, instructionList, this.constantPoolGen);
        instructionList.append(InstructionFactory.createLoad(Type.OBJECT, 0));
        instructionList.append(this.instructionFactory.createInvoke(this.superClassName, "<init>", Type.VOID, Type.NO_ARGS, (short)183));
        instructionList.append(InstructionFactory.createReturn(Type.VOID));
        this.finalizeMethod(this.classGen, instructionList, methodGen);
    }

    private void createWriteReplace() {
        InstructionList instructionList = new InstructionList();
        MethodGen methodGen = new MethodGen(2, Type.OBJECT, Type.NO_ARGS, new String[0], "writeReplace", this.className, instructionList, this.constantPoolGen);
        instructionList.append(InstructionFactory.createLoad(Type.OBJECT, 0));
        instructionList.append(this.instructionFactory.createInvoke(this.className, "selfAsBaseClass", Type.OBJECT, Type.NO_ARGS, (short)182));
        instructionList.append(InstructionFactory.createReturn(Type.OBJECT));
        this.finalizeMethod(this.classGen, instructionList, methodGen);
    }

    private int typeLength(Type type) {
        if (type.equals(Type.LONG)) {
            return 2;
        }
        if (type.equals(Type.DOUBLE)) {
            return 2;
        }
        return 1;
    }

    private ReferenceType typeForWrapper(BasicType basicType) {
        String string = "L" + this.wrapperName(basicType) + ";";
        return (ReferenceType)Type.getType(string);
    }

    private String wrapperName(BasicType basicType) {
        if (basicType.equals(Type.BOOLEAN)) {
            return "java.lang.Boolean";
        }
        if (basicType.equals(Type.BYTE)) {
            return "java.lang.Byte";
        }
        if (basicType.equals(Type.CHAR)) {
            return "java.lang.Character";
        }
        if (basicType.equals(Type.SHORT)) {
            return "java.lang.Short";
        }
        if (basicType.equals(Type.INT)) {
            return "java.lang.Integer";
        }
        if (basicType.equals(Type.LONG)) {
            return "java.lang.Long";
        }
        if (basicType.equals(Type.FLOAT)) {
            return "java.lang.Float";
        }
        if (basicType.equals(Type.DOUBLE)) {
            return "java.lang.Double";
        }
        throw new IllegalStateException();
    }

    private String wrapperValueMethod(BasicType basicType) {
        if (basicType.equals(Type.BOOLEAN)) {
            return "booleanValue";
        }
        if (basicType.equals(Type.BYTE)) {
            return "byteValue";
        }
        if (basicType.equals(Type.CHAR)) {
            return "charValue";
        }
        if (basicType.equals(Type.SHORT)) {
            return "shortValue";
        }
        if (basicType.equals(Type.INT)) {
            return "intValue";
        }
        if (basicType.equals(Type.LONG)) {
            return "longValue";
        }
        if (basicType.equals(Type.FLOAT)) {
            return "floatValue";
        }
        if (basicType.equals(Type.DOUBLE)) {
            return "doubleValue";
        }
        throw new IllegalStateException();
    }

    String[] makeArgNames(int n) {
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = "arg" + i;
        }
        return stringArray;
    }

    private void createMethod(int n, Method method) {
        String string = method.getName();
        String string2 = Type.getSignature(method);
        Type[] typeArray = Type.getArgumentTypes(string2);
        int n2 = typeArray.length;
        Type type = Type.getReturnType(string2);
        InstructionList instructionList = new InstructionList();
        MethodGen methodGen = new MethodGen(1, type, typeArray, this.makeArgNames(n2), string, this.className, instructionList, this.constantPoolGen);
        if (n2 > 0) {
            instructionList.append(new PUSH(this.constantPoolGen, n2));
            instructionList.append(this.instructionFactory.createNewArray(Type.OBJECT, (short)1));
            int n3 = 1;
            for (int i = 0; i < n2; ++i) {
                Type type2 = typeArray[i];
                instructionList.append(InstructionConstants.DUP);
                instructionList.append(new PUSH(this.constantPoolGen, i));
                if (type2 instanceof BasicType) {
                    instructionList.append(this.instructionFactory.createNew(this.wrapperName((BasicType)type2)));
                    instructionList.append(InstructionConstants.DUP);
                    instructionList.append(InstructionFactory.createLoad(type2, n3));
                    instructionList.append(this.instructionFactory.createInvoke(this.wrapperName((BasicType)type2), "<init>", Type.VOID, new Type[]{type2}, (short)183));
                } else {
                    instructionList.append(InstructionFactory.createLoad(type2, n3));
                }
                instructionList.append(InstructionConstants.AASTORE);
                n3 += this.typeLength(type2);
            }
            instructionList.append(InstructionFactory.createStore(Type.OBJECT, n3));
            instructionList.append(InstructionFactory.createLoad(Type.OBJECT, 0));
            instructionList.append(new PUSH(this.constantPoolGen, n));
            instructionList.append(InstructionFactory.createLoad(Type.OBJECT, n3));
        } else {
            instructionList.append(InstructionFactory.createLoad(Type.OBJECT, 0));
            instructionList.append(new PUSH(this.constantPoolGen, n));
            instructionList.append(InstructionConstants.ACONST_NULL);
        }
        instructionList.append(this.instructionFactory.createInvoke(this.className, INVOKE_METHOD_NAME, Type.OBJECT, new Type[]{Type.INT, new ArrayType(Type.OBJECT, 1)}, (short)182));
        if (!type.equals(Type.VOID)) {
            if (type instanceof ReferenceType) {
                instructionList.append(this.instructionFactory.createCheckCast((ReferenceType)type));
            } else if (type instanceof BasicType) {
                BasicType basicType = (BasicType)type;
                ReferenceType referenceType = this.typeForWrapper(basicType);
                instructionList.append(this.instructionFactory.createCheckCast(referenceType));
                instructionList.append(this.instructionFactory.createInvoke(this.wrapperName(basicType), this.wrapperValueMethod(basicType), type, Type.NO_ARGS, (short)182));
            } else {
                throw new IllegalStateException();
            }
        }
        instructionList.append(InstructionFactory.createReturn(type));
        this.finalizeMethod(this.classGen, instructionList, methodGen);
    }
}

