/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.presentation.rmi;

import com.sun.corba.ee.impl.orbutil.ObjectUtility;
import com.sun.corba.ee.impl.presentation.rmi.IDLType;
import com.sun.corba.ee.impl.presentation.rmi.IDLTypeException;
import com.sun.corba.ee.impl.presentation.rmi.IDLTypesUtil;
import com.sun.corba.ee.spi.presentation.rmi.IDLNameTranslator;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class IDLNameTranslatorImpl
implements IDLNameTranslator {
    private static String[] IDL_KEYWORDS = new String[]{"abstract", "any", "attribute", "boolean", "case", "char", "const", "context", "custom", "default", "double", "enum", "exception", "factory", "FALSE", "fixed", "float", "in", "inout", "interface", "long", "module", "native", "Object", "octet", "oneway", "out", "private", "public", "raises", "readonly", "sequence", "short", "string", "struct", "supports", "switch", "TRUE", "truncatable", "typedef", "unsigned", "union", "ValueBase", "valuetype", "void", "wchar", "wstring"};
    private static char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String UNDERSCORE = "_";
    private static final String INNER_CLASS_SEPARATOR = "__";
    private static final String[] BASE_IDL_ARRAY_MODULE_TYPE = new String[]{"org", "omg", "boxedRMI"};
    private static final String BASE_IDL_ARRAY_ELEMENT_TYPE = "seq";
    private static final String LEADING_UNDERSCORE_CHAR = "J";
    private static final String ID_CONTAINER_CLASH_CHAR = "_";
    private static final String OVERLOADED_TYPE_SEPARATOR = "__";
    private static final String ATTRIBUTE_METHOD_CLASH_MANGLE_CHARS = "__";
    private static final String GET_ATTRIBUTE_PREFIX = "_get_";
    private static final String SET_ATTRIBUTE_PREFIX = "_set_";
    private static final String IS_ATTRIBUTE_PREFIX = "_get_";
    private static Set idlKeywords_ = new HashSet();
    private Class[] interf_;
    private Map methodToIDLNameMap_;
    private Map IDLNameToMethodMap_;
    private Method[] methods_;
    static /* synthetic */ Class class$java$rmi$Remote;

    public static IDLNameTranslator get(Class clazz) {
        return new IDLNameTranslatorImpl(new Class[]{clazz});
    }

    public static IDLNameTranslator get(Class[] classArray) {
        return new IDLNameTranslatorImpl(classArray);
    }

    public static String getExceptionId(Class clazz) {
        IDLType iDLType = IDLNameTranslatorImpl.classToIDLType(clazz);
        return iDLType.getExceptionName();
    }

    public Class[] getInterfaces() {
        return this.interf_;
    }

    public Method[] getMethods() {
        return this.methods_;
    }

    public Method getMethod(String string) {
        return (Method)this.IDLNameToMethodMap_.get(string);
    }

    public String getIDLName(Method method) {
        return (String)this.methodToIDLNameMap_.get(method);
    }

    private IDLNameTranslatorImpl(Class[] classArray) {
        try {
            IDLTypesUtil iDLTypesUtil = new IDLTypesUtil();
            for (int i = 0; i < classArray.length; ++i) {
                iDLTypesUtil.validateRemoteInterface(classArray[i]);
            }
            this.interf_ = classArray;
            this.buildNameTranslation();
        }
        catch (IDLTypeException iDLTypeException) {
            String string = iDLTypeException.getMessage();
            IllegalStateException illegalStateException = new IllegalStateException(string);
            illegalStateException.initCause(iDLTypeException);
            throw illegalStateException;
        }
    }

    private void buildNameTranslation() {
        Object object;
        Object object2;
        Object object3;
        HashMap<Method, IDLMethodInfo> hashMap = new HashMap<Method, IDLMethodInfo>();
        for (int i = 0; i < this.interf_.length; ++i) {
            object3 = this.interf_[i];
            object2 = new IDLTypesUtil();
            object = ((Class)object3).getMethods();
            AccessController.doPrivileged(new PrivilegedAction((Method[])object){
                private final /* synthetic */ Method[] val$methods;
                {
                    this.val$methods = methodArray;
                }

                public Object run() {
                    Method.setAccessible(this.val$methods, true);
                    return null;
                }
            });
            for (int j = 0; j < ((Method[])object).length; ++j) {
                Method method = object[j];
                IDLMethodInfo iDLMethodInfo = new IDLMethodInfo();
                iDLMethodInfo.method = method;
                if (((IDLTypesUtil)object2).isPropertyAccessorMethod(method, (Class)object3)) {
                    String string;
                    iDLMethodInfo.isProperty = true;
                    iDLMethodInfo.originalName = string = ((IDLTypesUtil)object2).getAttributeNameForProperty(method.getName());
                    iDLMethodInfo.mangledName = string;
                } else {
                    iDLMethodInfo.isProperty = false;
                    iDLMethodInfo.originalName = method.getName();
                    iDLMethodInfo.mangledName = method.getName();
                }
                hashMap.put(method, iDLMethodInfo);
            }
        }
        Iterator iterator = hashMap.values().iterator();
        block2: while (iterator.hasNext()) {
            object3 = (IDLMethodInfo)iterator.next();
            object2 = hashMap.values().iterator();
            while (object2.hasNext()) {
                object = (IDLMethodInfo)object2.next();
                if (object3 == object || ((IDLMethodInfo)object3).originalName.equals(((IDLMethodInfo)object).originalName) || !((IDLMethodInfo)object3).originalName.equalsIgnoreCase(((IDLMethodInfo)object).originalName)) continue;
                ((IDLMethodInfo)object3).mangledName = this.mangleCaseSensitiveCollision(((IDLMethodInfo)object3).originalName);
                continue block2;
            }
        }
        iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            object3 = (IDLMethodInfo)iterator.next();
            ((IDLMethodInfo)object3).mangledName = IDLNameTranslatorImpl.mangleIdentifier(((IDLMethodInfo)object3).mangledName, ((IDLMethodInfo)object3).isProperty);
        }
        iterator = hashMap.values().iterator();
        block5: while (iterator.hasNext()) {
            object3 = (IDLMethodInfo)iterator.next();
            if (((IDLMethodInfo)object3).isProperty) continue;
            object2 = hashMap.values().iterator();
            while (object2.hasNext()) {
                object = (IDLMethodInfo)object2.next();
                if (object3 == object || ((IDLMethodInfo)object).isProperty || !((IDLMethodInfo)object3).originalName.equals(((IDLMethodInfo)object).originalName)) continue;
                ((IDLMethodInfo)object3).mangledName = IDLNameTranslatorImpl.mangleOverloadedMethod(((IDLMethodInfo)object3).mangledName, ((IDLMethodInfo)object3).method);
                continue block5;
            }
        }
        iterator = hashMap.values().iterator();
        block7: while (iterator.hasNext()) {
            object3 = (IDLMethodInfo)iterator.next();
            if (!((IDLMethodInfo)object3).isProperty) continue;
            object2 = hashMap.values().iterator();
            while (object2.hasNext()) {
                object = (IDLMethodInfo)object2.next();
                if (object3 == object || ((IDLMethodInfo)object).isProperty || !((IDLMethodInfo)object3).mangledName.equals(((IDLMethodInfo)object).mangledName)) continue;
                ((IDLMethodInfo)object3).mangledName = ((IDLMethodInfo)object3).mangledName + "__";
                continue block7;
            }
        }
        for (int i = 0; i < this.interf_.length; ++i) {
            object3 = this.interf_[i];
            object2 = IDLNameTranslatorImpl.getMappedContainerName((Class)object3);
            object = hashMap.values().iterator();
            while (object.hasNext()) {
                IDLMethodInfo iDLMethodInfo = (IDLMethodInfo)object.next();
                if (iDLMethodInfo.isProperty || !IDLNameTranslatorImpl.identifierClashesWithContainer((String)object2, iDLMethodInfo.mangledName)) continue;
                iDLMethodInfo.mangledName = IDLNameTranslatorImpl.mangleContainerClash(iDLMethodInfo.mangledName);
            }
        }
        this.methodToIDLNameMap_ = new HashMap();
        this.IDLNameToMethodMap_ = new HashMap();
        this.methods_ = hashMap.keySet().toArray(new Method[0]);
        Iterator iterator2 = hashMap.values().iterator();
        while (iterator2.hasNext()) {
            object3 = (IDLMethodInfo)iterator2.next();
            object2 = ((IDLMethodInfo)object3).mangledName;
            if (((IDLMethodInfo)object3).isProperty) {
                object = ((IDLMethodInfo)object3).method.getName();
                String string = "";
                string = ((String)object).startsWith("get") ? "_get_" : (((String)object).startsWith("set") ? SET_ATTRIBUTE_PREFIX : "_get_");
                object2 = string + ((IDLMethodInfo)object3).mangledName;
            }
            this.methodToIDLNameMap_.put(((IDLMethodInfo)object3).method, object2);
            if (this.IDLNameToMethodMap_.containsKey(object2)) {
                object = (Method)this.IDLNameToMethodMap_.get(object2);
                throw new IllegalStateException("Error : methods " + object + " and " + ((IDLMethodInfo)object3).method + " both result in IDL name '" + (String)object2 + "'");
            }
            this.IDLNameToMethodMap_.put(object2, ((IDLMethodInfo)object3).method);
        }
    }

    private static String mangleIdentifier(String string) {
        return IDLNameTranslatorImpl.mangleIdentifier(string, false);
    }

    private static String mangleIdentifier(String string, boolean bl) {
        String string2 = string;
        if (IDLNameTranslatorImpl.hasLeadingUnderscore(string2)) {
            string2 = IDLNameTranslatorImpl.mangleLeadingUnderscore(string2);
        }
        if (!bl && IDLNameTranslatorImpl.isIDLKeyword(string2)) {
            string2 = IDLNameTranslatorImpl.mangleIDLKeywordClash(string2);
        }
        if (!IDLNameTranslatorImpl.isIDLIdentifier(string2)) {
            string2 = IDLNameTranslatorImpl.mangleUnicodeChars(string2);
        }
        return string2;
    }

    static boolean isIDLKeyword(String string) {
        String string2 = string.toUpperCase();
        return idlKeywords_.contains(string2);
    }

    static String mangleIDLKeywordClash(String string) {
        return "_" + string;
    }

    private static String mangleLeadingUnderscore(String string) {
        return LEADING_UNDERSCORE_CHAR + string;
    }

    private static boolean hasLeadingUnderscore(String string) {
        return string.startsWith("_");
    }

    static String mangleUnicodeChars(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (IDLNameTranslatorImpl.isIDLIdentifierChar(c)) {
                stringBuffer.append(c);
                continue;
            }
            String string2 = IDLNameTranslatorImpl.charToUnicodeRepresentation(c);
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    String mangleCaseSensitiveCollision(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append("_");
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!Character.isUpperCase(c)) continue;
            if (bl) {
                stringBuffer.append("_");
            }
            stringBuffer.append(i);
            bl = true;
        }
        return stringBuffer.toString();
    }

    private static String mangleContainerClash(String string) {
        return string + "_";
    }

    private static boolean identifierClashesWithContainer(String string, String string2) {
        return string2.equalsIgnoreCase(string);
    }

    public static String charToUnicodeRepresentation(char n) {
        int n2;
        int n3;
        int n4 = n;
        StringBuffer stringBuffer = new StringBuffer();
        int n5 = n4;
        while (n5 > 0) {
            n3 = n5 / 16;
            n2 = n5 % 16;
            stringBuffer.insert(0, HEX_DIGITS[n2]);
            n5 = n3;
        }
        n3 = 4 - stringBuffer.length();
        for (n2 = 0; n2 < n3; ++n2) {
            stringBuffer.insert(0, "0");
        }
        stringBuffer.insert(0, "U");
        return stringBuffer.toString();
    }

    private static boolean isIDLIdentifier(String string) {
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            boolean bl2 = bl = i == 0 ? IDLNameTranslatorImpl.isIDLAlphabeticChar(c) : IDLNameTranslatorImpl.isIDLIdentifierChar(c);
            if (!bl) break;
        }
        return bl;
    }

    private static boolean isIDLIdentifierChar(char c) {
        return IDLNameTranslatorImpl.isIDLAlphabeticChar(c) || IDLNameTranslatorImpl.isIDLDecimalDigit(c) || IDLNameTranslatorImpl.isUnderscore(c);
    }

    private static boolean isIDLAlphabeticChar(char c) {
        boolean bl = c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '\u00c0' && c <= '\u00ff' && c != '\u00d7' && c != '\u00f7';
        return bl;
    }

    private static boolean isIDLDecimalDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isUnderscore(char c) {
        return c == '_';
    }

    private static String mangleOverloadedMethod(String string, Method method) {
        IDLTypesUtil iDLTypesUtil = new IDLTypesUtil();
        String string2 = string + "__";
        Class<?>[] classArray = method.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            String string3;
            Class<?> clazz = classArray[i];
            if (i > 0) {
                string2 = string2 + "__";
            }
            IDLType iDLType = IDLNameTranslatorImpl.classToIDLType(clazz);
            String string4 = iDLType.getModuleName();
            String string5 = iDLType.getMemberName();
            String string6 = string3 = string4.length() > 0 ? string4 + "_" + string5 : string5;
            if (!iDLTypesUtil.isPrimitive(clazz) && iDLTypesUtil.getSpecialCaseIDLTypeMapping(clazz) == null && IDLNameTranslatorImpl.isIDLKeyword(string3)) {
                string3 = IDLNameTranslatorImpl.mangleIDLKeywordClash(string3);
            }
            string3 = IDLNameTranslatorImpl.mangleUnicodeChars(string3);
            string2 = string2 + string3;
        }
        return string2;
    }

    private static IDLType classToIDLType(Class clazz) {
        IDLType iDLType = null;
        IDLTypesUtil iDLTypesUtil = new IDLTypesUtil();
        if (iDLTypesUtil.isPrimitive(clazz)) {
            iDLType = iDLTypesUtil.getPrimitiveIDLTypeMapping(clazz);
        } else if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            int n = 1;
            while (clazz2.isArray()) {
                clazz2 = clazz2.getComponentType();
                ++n;
            }
            IDLType iDLType2 = IDLNameTranslatorImpl.classToIDLType(clazz2);
            String[] stringArray = BASE_IDL_ARRAY_MODULE_TYPE;
            if (iDLType2.hasModule()) {
                stringArray = (String[])ObjectUtility.concatenateArrays(stringArray, iDLType2.getModules());
            }
            String string = BASE_IDL_ARRAY_ELEMENT_TYPE + n + "_" + iDLType2.getMemberName();
            iDLType = new IDLType(clazz, stringArray, string);
        } else {
            iDLType = iDLTypesUtil.getSpecialCaseIDLTypeMapping(clazz);
            if (iDLType == null) {
                String string;
                String string2 = IDLNameTranslatorImpl.getUnmappedContainerName(clazz);
                if (IDLNameTranslatorImpl.hasLeadingUnderscore(string2 = string2.replaceAll("\\$", "__"))) {
                    string2 = IDLNameTranslatorImpl.mangleLeadingUnderscore(string2);
                }
                if ((string = IDLNameTranslatorImpl.getPackageName(clazz)) == null) {
                    iDLType = new IDLType(clazz, string2);
                } else {
                    if (iDLTypesUtil.isEntity(clazz)) {
                        string = "org.omg.boxedIDL." + string;
                    }
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
                    String[] stringArray = new String[stringTokenizer.countTokens()];
                    int n = 0;
                    while (stringTokenizer.hasMoreElements()) {
                        String string3 = stringTokenizer.nextToken();
                        String string4 = IDLNameTranslatorImpl.hasLeadingUnderscore(string3) ? IDLNameTranslatorImpl.mangleLeadingUnderscore(string3) : string3;
                        stringArray[n++] = string4;
                    }
                    iDLType = new IDLType(clazz, stringArray, string2);
                }
            }
        }
        return iDLType;
    }

    private static String getPackageName(Class clazz) {
        String string;
        int n;
        Package package_ = clazz.getPackage();
        String string2 = null;
        string2 = package_ != null ? package_.getName() : ((n = (string = clazz.getName()).indexOf(46)) == -1 ? null : string.substring(0, n));
        return string2;
    }

    private static String getMappedContainerName(Class clazz) {
        String string = IDLNameTranslatorImpl.getUnmappedContainerName(clazz);
        return IDLNameTranslatorImpl.mangleIdentifier(string);
    }

    private static String getUnmappedContainerName(Class clazz) {
        String string = null;
        String string2 = IDLNameTranslatorImpl.getPackageName(clazz);
        String string3 = clazz.getName();
        if (string2 != null) {
            int n = string2.length();
            string = string3.substring(n + 1);
        } else {
            string = string3;
        }
        return string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IDLNameTranslator[");
        for (int i = 0; i < this.interf_.length; ++i) {
            if (i != 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(this.interf_[i].getName());
        }
        stringBuffer.append("]\n");
        Iterator iterator = this.methodToIDLNameMap_.keySet().iterator();
        while (iterator.hasNext()) {
            Method method = (Method)iterator.next();
            String string = (String)this.methodToIDLNameMap_.get(method);
            stringBuffer.append(string + ":" + method + "\n");
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        Object object;
        Class clazz;
        Class clazz2 = clazz = class$java$rmi$Remote == null ? (class$java$rmi$Remote = IDLNameTranslatorImpl.class$("java.rmi.Remote")) : class$java$rmi$Remote;
        if (stringArray.length > 0) {
            object = stringArray[0];
            try {
                clazz = Class.forName((String)object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(-1);
            }
        }
        System.out.println("Building name translation for " + clazz);
        try {
            object = IDLNameTranslatorImpl.get(clazz);
            System.out.println(object);
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        for (int i = 0; i < IDL_KEYWORDS.length; ++i) {
            String string = IDL_KEYWORDS[i];
            String string2 = string.toUpperCase();
            idlKeywords_.add(string2);
        }
    }

    private static class IDLMethodInfo {
        public Method method;
        public boolean isProperty;
        public String originalName;
        public String mangledName;

        private IDLMethodInfo() {
        }
    }
}

