/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.plugin.hwlb;

import com.sun.corba.ee.impl.orbutil.ORBUtility;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.SystemException;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitializer;

public class RetryClientRequestInterceptor
extends LocalObject
implements ORBInitializer,
ClientRequestInterceptor {
    private static final String baseMsg = (class$com$sun$corba$ee$impl$plugin$hwlb$RetryClientRequestInterceptor == null ? (class$com$sun$corba$ee$impl$plugin$hwlb$RetryClientRequestInterceptor = RetryClientRequestInterceptor.class$("com.sun.corba.ee.impl.plugin.hwlb.RetryClientRequestInterceptor")) : class$com$sun$corba$ee$impl$plugin$hwlb$RetryClientRequestInterceptor).getName();
    private static final String TRANSIENT_REPOSITORY_ID = "IDL:omg.org/CORBA/TRANSIENT:1.0";
    private static final String OBJECT_NOT_EXIST_REPOSITORY_ID = "IDL:omg.org/CORBA/OBJECT_NOT_EXIST:1.0";
    private static final long INITIAL_BACKOFF_DEFAULT = 500L;
    private static long initialBackoff = 500L;
    private static final long TRANSIENT_RETRY_TIMEOUT_DEFAULT = 300000L;
    private static long transientRetryTimeout = 300000L;
    private static boolean debug = true;
    private ThreadLocal backoffAndStartTime = new ThreadLocal(){

        protected Object initialValue() {
            return new BackoffAndStartTime();
        }
    };
    static /* synthetic */ Class class$com$sun$corba$ee$impl$plugin$hwlb$RetryClientRequestInterceptor;

    private long getStartTime() {
        return ((BackoffAndStartTime)this.backoffAndStartTime.get()).startTime;
    }

    private void setStartTime(long l) {
        ((BackoffAndStartTime)this.backoffAndStartTime.get()).startTime = l;
    }

    private long getBackoff() {
        return ((BackoffAndStartTime)this.backoffAndStartTime.get()).backoff;
    }

    private void setBackoff(long l) {
        ((BackoffAndStartTime)this.backoffAndStartTime.get()).backoff = l;
    }

    private void doubleBackoff() {
        this.setBackoff(this.getBackoff() * 2L);
    }

    public static void setInitialBackoff(long l) {
        initialBackoff = l;
    }

    public static long getInitialBackoff() {
        return initialBackoff;
    }

    public static void setTransientRetryTimeout(long l) {
        transientRetryTimeout = l;
    }

    public static long getTransientRetryTimeout() {
        return transientRetryTimeout;
    }

    public static void setDebug(boolean bl) {
        debug = bl;
    }

    public String name() {
        return baseMsg;
    }

    public void destroy() {
    }

    public void send_request(ClientRequestInfo clientRequestInfo) {
    }

    public void send_poll(ClientRequestInfo clientRequestInfo) {
    }

    public void receive_reply(ClientRequestInfo clientRequestInfo) {
        this.setBackoff(initialBackoff);
    }

    public void receive_exception(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
        if (!this.isTransientException(clientRequestInfo) && !this.isBadServerIdException(clientRequestInfo)) {
            this.setBackoff(initialBackoff);
            return;
        }
        String string = ".receive_exception: " + clientRequestInfo.received_exception_id() + " " + clientRequestInfo.operation() + ": ";
        if (this.getBackoff() == initialBackoff) {
            if (debug) {
                System.out.println(string + "initializing timer");
            }
            this.setStartTime(System.currentTimeMillis());
        } else if (System.currentTimeMillis() - this.getStartTime() >= transientRetryTimeout) {
            if (debug) {
                System.out.println(string + "exceeded transientRetryTimeout: " + transientRetryTimeout + " - not retrying");
            }
            return;
        }
        this.doubleBackoff();
        if (debug) {
            System.out.println(string + "sleep: " + this.getBackoff());
        }
        try {
            Thread.sleep(this.getBackoff());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (debug) {
            System.out.println(string + "done sleeping");
        }
        if (this.isTransientException(clientRequestInfo)) {
            throw new ForwardRequest(clientRequestInfo.effective_target());
        }
        if (this.isBadServerIdException(clientRequestInfo)) {
            throw new ForwardRequest(clientRequestInfo.target());
        }
        if (debug) {
            System.out.println(string + "unexpected: " + clientRequestInfo.received_exception_id());
        }
    }

    public void receive_other(ClientRequestInfo clientRequestInfo) {
        this.setBackoff(initialBackoff);
    }

    public void pre_init(ORBInitInfo oRBInitInfo) {
    }

    public void post_init(ORBInitInfo oRBInitInfo) {
        block3: {
            try {
                if (debug) {
                    System.out.println(".post_init: registering: " + (Object)((Object)this));
                }
                oRBInitInfo.add_client_request_interceptor((ClientRequestInterceptor)this);
            }
            catch (DuplicateName duplicateName) {
                if (!debug) break block3;
                System.out.println(".post_init: exception: " + (Object)((Object)duplicateName));
            }
        }
    }

    private boolean isTransientException(ClientRequestInfo clientRequestInfo) {
        return clientRequestInfo.received_exception_id().equals(TRANSIENT_REPOSITORY_ID);
    }

    private boolean isBadServerIdException(ClientRequestInfo clientRequestInfo) {
        if (!clientRequestInfo.received_exception_id().equals(OBJECT_NOT_EXIST_REPOSITORY_ID)) {
            return false;
        }
        SystemException systemException = ORBUtility.extractSystemException(clientRequestInfo.received_exception());
        return systemException instanceof OBJECT_NOT_EXIST && systemException.minor == 1398079690;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ long access$000() {
        return initialBackoff;
    }

    class BackoffAndStartTime {
        public long startTime;
        public long backoff = RetryClientRequestInterceptor.access$000();

        BackoffAndStartTime() {
        }
    }
}

