/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.orbutil.threadpool;

import com.sun.corba.ee.impl.orbutil.threadpool.ThreadPoolImpl;
import com.sun.corba.ee.impl.orbutil.threadpool.TimeoutException;
import com.sun.corba.ee.spi.monitoring.LongMonitoredAttributeBase;
import com.sun.corba.ee.spi.monitoring.MonitoredObject;
import com.sun.corba.ee.spi.monitoring.MonitoringFactories;
import com.sun.corba.ee.spi.orbutil.threadpool.ThreadPool;
import com.sun.corba.ee.spi.orbutil.threadpool.Work;
import com.sun.corba.ee.spi.orbutil.threadpool.WorkQueue;
import java.util.LinkedList;

public class WorkQueueImpl
implements WorkQueue {
    private ThreadPool workerThreadPool;
    private LinkedList theWorkQueue = new LinkedList();
    private long workItemsAdded = 0L;
    private long workItemsDequeued = 1L;
    private long totalTimeInQueue = 0L;
    private String name;
    private MonitoredObject workqueueMonitoredObject;

    public WorkQueueImpl() {
        this.name = "default-workqueue";
        this.initializeMonitoring();
    }

    public WorkQueueImpl(ThreadPool threadPool) {
        this(threadPool, "default-workqueue");
    }

    public WorkQueueImpl(ThreadPool threadPool, String string) {
        this.workerThreadPool = threadPool;
        this.name = string;
        this.initializeMonitoring();
    }

    private void initializeMonitoring() {
        this.workqueueMonitoredObject = MonitoringFactories.getMonitoredObjectFactory().createMonitoredObject(this.name, "Monitoring for a Work Queue");
        LongMonitoredAttributeBase longMonitoredAttributeBase = new LongMonitoredAttributeBase("totalWorkItemsAdded", "Total number of Work items added to the Queue"){

            public Object getValue() {
                return new Long(WorkQueueImpl.this.totalWorkItemsAdded());
            }
        };
        this.workqueueMonitoredObject.addAttribute(longMonitoredAttributeBase);
        LongMonitoredAttributeBase longMonitoredAttributeBase2 = new LongMonitoredAttributeBase("workItemsInQueue", "Number of Work items in the Queue to be processed"){

            public Object getValue() {
                return new Long(WorkQueueImpl.this.workItemsInQueue());
            }
        };
        this.workqueueMonitoredObject.addAttribute(longMonitoredAttributeBase2);
        LongMonitoredAttributeBase longMonitoredAttributeBase3 = new LongMonitoredAttributeBase("averageTimeInQueue", "Average time a work item waits in the work queue"){

            public Object getValue() {
                return new Long(WorkQueueImpl.this.averageTimeInQueue());
            }
        };
        this.workqueueMonitoredObject.addAttribute(longMonitoredAttributeBase3);
    }

    MonitoredObject getMonitoredObject() {
        return this.workqueueMonitoredObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWork(Work work) {
        WorkQueueImpl workQueueImpl = this;
        synchronized (workQueueImpl) {
            ++this.workItemsAdded;
            work.setEnqueueTime(System.currentTimeMillis());
            this.theWorkQueue.addLast(work);
            ((ThreadPoolImpl)this.workerThreadPool).notifyForAvailableWork(this);
        }
    }

    Work requestWork(long l) throws TimeoutException, InterruptedException {
        WorkQueueImpl workQueueImpl = this;
        synchronized (workQueueImpl) {
            if (this.theWorkQueue.size() != 0) {
                Work work = (Work)this.theWorkQueue.removeFirst();
                this.totalTimeInQueue += System.currentTimeMillis() - work.getEnqueueTime();
                ++this.workItemsDequeued;
                return work;
            }
            long l2 = l;
            long l3 = System.currentTimeMillis() + l;
            do {
                this.wait(l2);
                if (this.theWorkQueue.size() == 0) continue;
                Work work = (Work)this.theWorkQueue.removeFirst();
                this.totalTimeInQueue += System.currentTimeMillis() - work.getEnqueueTime();
                ++this.workItemsDequeued;
                return work;
            } while ((l2 = l3 - System.currentTimeMillis()) > 0L);
            throw new TimeoutException();
        }
    }

    public void setThreadPool(ThreadPool threadPool) {
        this.workerThreadPool = threadPool;
    }

    public ThreadPool getThreadPool() {
        return this.workerThreadPool;
    }

    public long totalWorkItemsAdded() {
        return this.workItemsAdded;
    }

    public int workItemsInQueue() {
        return this.theWorkQueue.size();
    }

    public synchronized long averageTimeInQueue() {
        return this.totalTimeInQueue / this.workItemsDequeued;
    }

    public String getName() {
        return this.name;
    }
}

