/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.orbutil;

import com.sun.corba.ee.impl.orbutil.ObjectWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class ObjectUtility {
    private boolean useToString;
    private boolean isIndenting;
    private int initialLevel;
    private int increment;
    private ClassMap classToPrinter = new ClassMap();
    private static ObjectUtility standard = new ObjectUtility(false, true, 0, 4);
    private static ObjectUtility compact = new ObjectUtility(true, false, 0, 4);
    private ObjectPrinter propertiesPrinter = new ObjectPrinter(){

        public void print(IdentityHashMap identityHashMap, ObjectWriter objectWriter, Object object) {
            if (!(object instanceof Properties)) {
                throw new Error();
            }
            Properties properties = (Properties)object;
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                objectWriter.startElement();
                objectWriter.append(string);
                objectWriter.append("=");
                objectWriter.append(string2);
                objectWriter.endElement();
            }
        }
    };
    private ObjectPrinter collectionPrinter = new ObjectPrinter(){

        public void print(IdentityHashMap identityHashMap, ObjectWriter objectWriter, Object object) {
            if (!(object instanceof Collection)) {
                throw new Error();
            }
            Collection collection = (Collection)object;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                objectWriter.startElement();
                ObjectUtility.this.objectToStringHelper(identityHashMap, objectWriter, e);
                objectWriter.endElement();
            }
        }
    };
    private ObjectPrinter mapPrinter = new ObjectPrinter(){

        public void print(IdentityHashMap identityHashMap, ObjectWriter objectWriter, Object object) {
            if (!(object instanceof Map)) {
                throw new Error();
            }
            Map map = (Map)object;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                objectWriter.startElement();
                ObjectUtility.this.objectToStringHelper(identityHashMap, objectWriter, entry.getKey());
                objectWriter.append("=>");
                ObjectUtility.this.objectToStringHelper(identityHashMap, objectWriter, entry.getValue());
                objectWriter.endElement();
            }
        }
    };
    static /* synthetic */ Class class$java$util$Properties;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$StringBuffer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Object;

    private ObjectUtility(boolean bl, boolean bl2, int n, int n2) {
        this.useToString = bl;
        this.isIndenting = bl2;
        this.initialLevel = n;
        this.increment = n2;
        this.classToPrinter.put(class$java$util$Properties == null ? (class$java$util$Properties = ObjectUtility.class$("java.util.Properties")) : class$java$util$Properties, this.propertiesPrinter);
        this.classToPrinter.put(class$java$util$Collection == null ? (class$java$util$Collection = ObjectUtility.class$("java.util.Collection")) : class$java$util$Collection, this.collectionPrinter);
        this.classToPrinter.put(class$java$util$Map == null ? (class$java$util$Map = ObjectUtility.class$("java.util.Map")) : class$java$util$Map, this.mapPrinter);
    }

    public static ObjectUtility make(boolean bl, boolean bl2, int n, int n2) {
        return new ObjectUtility(bl, bl2, n, n2);
    }

    public static ObjectUtility make(boolean bl, boolean bl2) {
        return new ObjectUtility(bl, bl2, 0, 4);
    }

    public static ObjectUtility make() {
        return standard;
    }

    public static String defaultObjectToString(Object object) {
        return standard.objectToString(object);
    }

    public static String compactObjectToString(Object object) {
        return compact.objectToString(object);
    }

    public String objectToString(Object object) {
        IdentityHashMap identityHashMap = new IdentityHashMap();
        ObjectWriter objectWriter = ObjectWriter.make(this.isIndenting, this.initialLevel, this.increment);
        this.objectToStringHelper(identityHashMap, objectWriter, object);
        return objectWriter.toString();
    }

    public static boolean equals(Object object, Object object2) {
        HashSet hashSet = new HashSet();
        IdentityHashMap identityHashMap = new IdentityHashMap();
        return ObjectUtility.equalsHelper(identityHashMap, hashSet, object, object2);
    }

    public static Object concatenateArrays(Object object, Object object2) {
        int n;
        Class<?> clazz = object.getClass().getComponentType();
        Class<?> clazz2 = object2.getClass().getComponentType();
        int n2 = Array.getLength(object);
        int n3 = Array.getLength(object2);
        if (clazz == null || clazz2 == null) {
            throw new IllegalStateException("Arguments must be arrays");
        }
        if (!clazz.equals(clazz2)) {
            throw new IllegalStateException("Arguments must be arrays with the same component type");
        }
        Object object3 = Array.newInstance(clazz, n2 + n3);
        int n4 = 0;
        for (n = 0; n < n2; ++n) {
            Array.set(object3, n4++, Array.get(object, n));
        }
        for (n = 0; n < n3; ++n) {
            Array.set(object3, n4++, Array.get(object2, n));
        }
        return object3;
    }

    private void objectToStringHelper(IdentityHashMap identityHashMap, ObjectWriter objectWriter, Object object) {
        if (object == null) {
            objectWriter.append("null");
            objectWriter.endElement();
        } else {
            Class<?> clazz = object.getClass();
            objectWriter.startObject(object);
            if (identityHashMap.keySet().contains(object)) {
                objectWriter.endObject("*VISITED*");
            } else {
                identityHashMap.put(object, null);
                if (this.mustUseToString(clazz)) {
                    objectWriter.endObject(object.toString());
                } else {
                    ObjectPrinter objectPrinter = (ObjectPrinter)this.classToPrinter.get(clazz);
                    if (objectPrinter != null) {
                        objectPrinter.print(identityHashMap, objectWriter, object);
                        objectWriter.endObject();
                    } else {
                        Class<?> clazz2 = clazz.getComponentType();
                        if (clazz2 == null) {
                            this.handleObject(identityHashMap, objectWriter, object);
                        } else {
                            this.handleArray(identityHashMap, objectWriter, object);
                            objectWriter.endObject();
                        }
                    }
                }
            }
        }
    }

    private boolean mustUseToString(Class clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = ObjectUtility.class$("java.lang.Integer")) : class$java$lang$Integer) || clazz == (class$java$math$BigInteger == null ? (class$java$math$BigInteger = ObjectUtility.class$("java.math.BigInteger")) : class$java$math$BigInteger) || clazz == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = ObjectUtility.class$("java.math.BigDecimal")) : class$java$math$BigDecimal) || clazz == (class$java$lang$String == null ? (class$java$lang$String = ObjectUtility.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$java$lang$StringBuffer == null ? (class$java$lang$StringBuffer = ObjectUtility.class$("java.lang.StringBuffer")) : class$java$lang$StringBuffer) || clazz == (class$java$lang$Long == null ? (class$java$lang$Long = ObjectUtility.class$("java.lang.Long")) : class$java$lang$Long) || clazz == (class$java$lang$Short == null ? (class$java$lang$Short = ObjectUtility.class$("java.lang.Short")) : class$java$lang$Short) || clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = ObjectUtility.class$("java.lang.Byte")) : class$java$lang$Byte) || clazz == (class$java$lang$Character == null ? (class$java$lang$Character = ObjectUtility.class$("java.lang.Character")) : class$java$lang$Character) || clazz == (class$java$lang$Float == null ? (class$java$lang$Float = ObjectUtility.class$("java.lang.Float")) : class$java$lang$Float) || clazz == (class$java$lang$Double == null ? (class$java$lang$Double = ObjectUtility.class$("java.lang.Double")) : class$java$lang$Double) || clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = ObjectUtility.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return true;
        }
        if (this.useToString) {
            try {
                clazz.getDeclaredMethod("toString", null);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    private void handleObject(IdentityHashMap identityHashMap, ObjectWriter objectWriter, Object object) {
        Class<?> clazz = object.getClass();
        try {
            Field[] fieldArray = clazz.getDeclaredFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                final Field field = fieldArray[i];
                int n = field.getModifiers();
                if (Modifier.isStatic(n)) continue;
                objectWriter.startElement();
                objectWriter.append(field.getName());
                objectWriter.append(":");
                try {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            field.setAccessible(true);
                            return null;
                        }
                    });
                    Object object2 = field.get(object);
                    this.objectToStringHelper(identityHashMap, objectWriter, object2);
                }
                catch (Exception exception) {
                    objectWriter.append("???");
                }
                objectWriter.endElement();
            }
            objectWriter.endObject();
        }
        catch (Exception exception) {
            objectWriter.endObject(object.toString());
        }
    }

    private void handleArray(IdentityHashMap identityHashMap, ObjectWriter objectWriter, Object object) {
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz == Boolean.TYPE) {
            boolean[] blArray = (boolean[])object;
            for (int i = 0; i < blArray.length; ++i) {
                objectWriter.startElement();
                objectWriter.append(blArray[i]);
                objectWriter.endElement();
            }
        } else if (clazz == Byte.TYPE) {
            byte[] byArray = (byte[])object;
            for (int i = 0; i < byArray.length; ++i) {
                objectWriter.startElement();
                objectWriter.append(byArray[i]);
                objectWriter.endElement();
            }
        } else if (clazz == Short.TYPE) {
            short[] sArray = (short[])object;
            for (int i = 0; i < sArray.length; ++i) {
                objectWriter.startElement();
                objectWriter.append(sArray[i]);
                objectWriter.endElement();
            }
        } else if (clazz == Integer.TYPE) {
            int[] nArray = (int[])object;
            for (int i = 0; i < nArray.length; ++i) {
                objectWriter.startElement();
                objectWriter.append(nArray[i]);
                objectWriter.endElement();
            }
        } else if (clazz == Long.TYPE) {
            long[] lArray = (long[])object;
            for (int i = 0; i < lArray.length; ++i) {
                objectWriter.startElement();
                objectWriter.append(lArray[i]);
                objectWriter.endElement();
            }
        } else if (clazz == Character.TYPE) {
            char[] cArray = (char[])object;
            for (int i = 0; i < cArray.length; ++i) {
                objectWriter.startElement();
                objectWriter.append(cArray[i]);
                objectWriter.endElement();
            }
        } else if (clazz == Float.TYPE) {
            float[] fArray = (float[])object;
            for (int i = 0; i < fArray.length; ++i) {
                objectWriter.startElement();
                objectWriter.append(fArray[i]);
                objectWriter.endElement();
            }
        } else if (clazz == Double.TYPE) {
            double[] dArray = (double[])object;
            for (int i = 0; i < dArray.length; ++i) {
                objectWriter.startElement();
                objectWriter.append(dArray[i]);
                objectWriter.endElement();
            }
        } else {
            Object[] objectArray = (Object[])object;
            for (int i = 0; i < objectArray.length; ++i) {
                objectWriter.startElement();
                this.objectToStringHelper(identityHashMap, objectWriter, objectArray[i]);
                objectWriter.endElement();
            }
        }
    }

    private static boolean equalsHelper(Map map, Set set, Object object, Object object2) {
        if (object == null || object2 == null) {
            return object == object2;
        }
        Object object3 = map.get(object);
        if (object3 == null) {
            object3 = object2;
            map.put(object, object3);
        }
        if (object == object3) {
            return true;
        }
        if (object2 != object3) {
            return false;
        }
        Pair pair = new Pair(object, object2);
        if (set.contains(pair)) {
            return true;
        }
        set.add(pair);
        if (object instanceof Object[] && object2 instanceof Object[]) {
            return ObjectUtility.equalArrays(map, set, (Object[])object, (Object[])object2);
        }
        if (object instanceof Map && object2 instanceof Map) {
            return ObjectUtility.equalMaps(map, set, (Map)object, (Map)object2);
        }
        if (object instanceof Set && object2 instanceof Set) {
            return ObjectUtility.equalSets(map, set, (Set)object, (Set)object2);
        }
        if (object instanceof List && object2 instanceof List) {
            return ObjectUtility.equalLists(map, set, (List)object, (List)object2);
        }
        if (object instanceof boolean[] && object2 instanceof boolean[]) {
            return Arrays.equals((boolean[])object, (boolean[])object2);
        }
        if (object instanceof byte[] && object2 instanceof byte[]) {
            return Arrays.equals((byte[])object, (byte[])object2);
        }
        if (object instanceof char[] && object2 instanceof char[]) {
            return Arrays.equals((char[])object, (char[])object2);
        }
        if (object instanceof double[] && object2 instanceof double[]) {
            return Arrays.equals((double[])object, (double[])object2);
        }
        if (object instanceof float[] && object2 instanceof float[]) {
            return Arrays.equals((float[])object, (float[])object2);
        }
        if (object instanceof int[] && object2 instanceof int[]) {
            return Arrays.equals((int[])object, (int[])object2);
        }
        if (object instanceof long[] && object2 instanceof long[]) {
            return Arrays.equals((long[])object, (long[])object2);
        }
        Class<?> clazz = object.getClass();
        if (clazz != object2.getClass()) {
            return object.equals(object2);
        }
        return ObjectUtility.equalsObject(map, set, clazz, object, object2);
    }

    private static boolean equalsObject(Map map, Set set, Class clazz, Object object, Object object2) {
        Class clazz2;
        Class clazz3 = clazz2 = class$java$lang$Object == null ? (class$java$lang$Object = ObjectUtility.class$("java.lang.Object")) : class$java$lang$Object;
        if (clazz == clazz2) {
            return true;
        }
        Class[] classArray = new Class[]{clazz2};
        try {
            Method method = clazz.getDeclaredMethod("equals", classArray);
            return object.equals(object2);
        }
        catch (Exception exception) {
            if (ObjectUtility.equalsObjectFields(map, set, clazz, object, object2)) {
                return ObjectUtility.equalsObject(map, set, clazz.getSuperclass(), object, object2);
            }
            return false;
        }
    }

    private static boolean equalsObjectFields(Map map, Set set, Class clazz, Object object, Object object2) {
        Field[] fieldArray = clazz.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            try {
                final Field field = fieldArray[i];
                if (Modifier.isStatic(field.getModifiers())) continue;
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        field.setAccessible(true);
                        return null;
                    }
                });
                Object object3 = field.get(object);
                Object object4 = field.get(object2);
                if (ObjectUtility.equalsHelper(map, set, object3, object4)) continue;
                return false;
            }
            catch (IllegalAccessException illegalAccessException) {
                return false;
            }
        }
        return true;
    }

    private static boolean equalArrays(Map map, Set set, Object[] objectArray, Object[] objectArray2) {
        int n = objectArray.length;
        if (n != objectArray2.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (ObjectUtility.equalsHelper(map, set, objectArray[i], objectArray2[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean equalMaps(Map map, Set set, Map map2, Map map3) {
        if (map3.size() != map2.size()) {
            return false;
        }
        try {
            Iterator iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k = entry.getKey();
                Object v = entry.getValue();
                if (!(v == null ? map3.get(k) != null || !map3.containsKey(k) : !ObjectUtility.equalsHelper(map, set, v, map3.get(k)))) continue;
                return false;
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        return true;
    }

    private static boolean equalSets(Map map, Set set, Set set2, Set set3) {
        if (set2.size() != set3.size()) {
            return false;
        }
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            boolean bl = false;
            Iterator iterator2 = set3.iterator();
            while (iterator2.hasNext() && !bl) {
                Object e2 = iterator2.next();
                bl = ObjectUtility.equals(e, e2);
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    private static boolean equalLists(Map map, Set set, List list, List list2) {
        ListIterator listIterator = list.listIterator();
        ListIterator listIterator2 = list2.listIterator();
        while (listIterator.hasNext() && listIterator2.hasNext()) {
            Object e = listIterator.next();
            Object e2 = listIterator2.next();
            if (e != null ? ObjectUtility.equalsHelper(map, set, e, e2) : e2 == null) continue;
            return false;
        }
        return !listIterator.hasNext() && !listIterator2.hasNext();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class Pair {
        private Object obj1;
        private Object obj2;

        Pair(Object object, Object object2) {
            this.obj1 = object;
            this.obj2 = object2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Pair)) {
                return false;
            }
            Pair pair = (Pair)object;
            return pair.obj1 == this.obj1 && pair.obj2 == this.obj2;
        }

        public int hashCode() {
            return System.identityHashCode(this.obj1) ^ System.identityHashCode(this.obj2);
        }
    }

    private static class ClassMap {
        ArrayList data = new ArrayList();

        public Object get(Class clazz) {
            Iterator iterator = this.data.iterator();
            while (iterator.hasNext()) {
                Object[] objectArray = (Object[])iterator.next();
                Class clazz2 = (Class)objectArray[0];
                if (!clazz2.isAssignableFrom(clazz)) continue;
                return objectArray[1];
            }
            return null;
        }

        public void put(Class clazz, Object object) {
            Object[] objectArray = new Object[]{clazz, object};
            this.data.add(objectArray);
        }
    }

    private static interface ObjectPrinter {
        public void print(IdentityHashMap var1, ObjectWriter var2, Object var3);
    }
}

