/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.orbutil;

import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.spi.orb.ORB;

public class CacheTable {
    private boolean noReverseMap;
    static final int INITIAL_SIZE = 16;
    static final int MAX_SIZE = 0x40000000;
    int size;
    int entryCount;
    private Entry[] map;
    private Entry[] rmap;
    private ORB orb;
    private ORBUtilSystemException wrapper;

    private CacheTable() {
    }

    public CacheTable(ORB oRB, boolean bl) {
        this.orb = oRB;
        this.wrapper = ORBUtilSystemException.get(oRB, "rpc.encoding");
        this.noReverseMap = bl;
        this.size = 16;
        this.entryCount = 0;
        this.initTables();
    }

    private void initTables() {
        this.map = new Entry[this.size];
        this.rmap = this.noReverseMap ? null : new Entry[this.size];
    }

    private void grow() {
        if (this.size == 0x40000000) {
            return;
        }
        Entry[] entryArray = this.map;
        int n = this.size;
        this.size <<= 1;
        this.initTables();
        for (int i = 0; i < n; ++i) {
            Entry entry = entryArray[i];
            while (entry != null) {
                this.put_table(entry.key, entry.val);
                entry = entry.next;
            }
        }
    }

    private int moduloTableSize(int n) {
        n += ~(n << 9);
        n ^= n >>> 14;
        n += n << 4;
        n ^= n >>> 10;
        return n & this.size - 1;
    }

    private int hash(Object object) {
        return this.moduloTableSize(System.identityHashCode(object));
    }

    private int hash(int n) {
        return this.moduloTableSize(n);
    }

    public final void put(Object object, int n) {
        if (this.put_table(object, n)) {
            ++this.entryCount;
            if (this.entryCount > this.size * 3 / 4) {
                this.grow();
            }
        }
    }

    private boolean put_table(Object object, int n) {
        int n2 = this.hash(object);
        Entry entry = this.map[n2];
        while (entry != null) {
            if (entry.key == object) {
                if (entry.val != n) {
                    throw this.wrapper.duplicateIndirectionOffset();
                }
                return false;
            }
            entry = entry.next;
        }
        entry = new Entry(object, n);
        entry.next = this.map[n2];
        this.map[n2] = entry;
        if (!this.noReverseMap) {
            int n3 = this.hash(n);
            entry.rnext = this.rmap[n3];
            this.rmap[n3] = entry;
        }
        return true;
    }

    public final boolean containsKey(Object object) {
        return this.getVal(object) != -1;
    }

    public final int getVal(Object object) {
        int n = this.hash(object);
        Entry entry = this.map[n];
        while (entry != null) {
            if (entry.key == object) {
                return entry.val;
            }
            entry = entry.next;
        }
        return -1;
    }

    public final boolean containsVal(int n) {
        return this.getKey(n) != null;
    }

    public final boolean containsOrderedVal(int n) {
        return this.containsVal(n);
    }

    public final Object getKey(int n) {
        int n2 = this.hash(n);
        Entry entry = this.rmap[n2];
        while (entry != null) {
            if (entry.val == n) {
                return entry.key;
            }
            entry = entry.rnext;
        }
        return null;
    }

    public void done() {
        this.map = null;
        this.rmap = null;
    }

    class Entry {
        Object key;
        int val;
        Entry next;
        Entry rnext;

        public Entry(Object object, int n) {
            this.key = object;
            this.val = n;
            this.next = null;
            this.rnext = null;
        }
    }
}

