/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.orb;

import com.sun.corba.ee.impl.encoding.CodeSetComponentInfo;
import com.sun.corba.ee.impl.legacy.connection.USLPort;
import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.orb.ParserTable;
import com.sun.corba.ee.pept.transport.Acceptor;
import com.sun.corba.ee.spi.ior.iiop.GIOPVersion;
import com.sun.corba.ee.spi.orb.DataCollector;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orb.ORBData;
import com.sun.corba.ee.spi.orb.ParserImplTableBase;
import com.sun.corba.ee.spi.orb.StringPair;
import com.sun.corba.ee.spi.transport.CorbaContactInfoListFactory;
import com.sun.corba.ee.spi.transport.IIOPPrimaryToContactInfo;
import com.sun.corba.ee.spi.transport.IORToSocketInfo;
import com.sun.corba.ee.spi.transport.ORBSocketFactory;
import com.sun.corba.ee.spi.transport.ReadTimeouts;
import java.net.InetAddress;
import java.net.URL;
import org.omg.CORBA.CompletionStatus;
import org.omg.PortableInterceptor.ORBInitializer;

public class ORBDataParserImpl
extends ParserImplTableBase
implements ORBData {
    private ORB orb;
    private ORBUtilSystemException wrapper;
    private String ORBInitialHost;
    private int ORBInitialPort;
    private String ORBServerHost;
    private int ORBServerPort;
    private boolean listenOnAllInterfaces;
    private com.sun.corba.ee.spi.legacy.connection.ORBSocketFactory legacySocketFactory;
    private ORBSocketFactory socketFactory;
    private USLPort[] userSpecifiedListenPorts;
    private IORToSocketInfo iorToSocketInfo;
    private IIOPPrimaryToContactInfo iiopPrimaryToContactInfo;
    private String orbId;
    private boolean orbServerIdPropertySpecified;
    private URL servicesURL;
    private String propertyInitRef;
    private boolean allowLocalOptimization;
    private GIOPVersion giopVersion;
    private int highWaterMark;
    private int lowWaterMark;
    private int numberToReclaim;
    private int giopFragmentSize;
    private int giopBufferSize;
    private int giop11BuffMgr;
    private int giop12BuffMgr;
    private short giopTargetAddressPreference;
    private short giopAddressDisposition;
    private boolean useByteOrderMarkers;
    private boolean useByteOrderMarkersInEncaps;
    private boolean alwaysSendCodeSetCtx;
    private boolean persistentPortInitialized;
    private int persistentServerPort;
    private boolean persistentServerIdInitialized;
    private int persistentServerId;
    private boolean serverIsORBActivated;
    private Class badServerIdHandlerClass;
    private CodeSetComponentInfo.CodeSetComponent charData;
    private CodeSetComponentInfo.CodeSetComponent wcharData;
    private ORBInitializer[] orbInitializers;
    private StringPair[] orbInitialReferences;
    private String defaultInitRef;
    private String[] debugFlags;
    private Acceptor[] acceptors;
    private CorbaContactInfoListFactory corbaContactInfoListFactory;
    private String acceptorSocketType;
    private boolean acceptorSocketUseSelectThreadToWait;
    private boolean acceptorSocketUseWorkerThreadForEvent;
    private String connectionSocketType;
    private boolean connectionSocketUseSelectThreadToWait;
    private boolean connectionSocketUseWorkerThreadForEvent;
    private long communicationsRetryTimeout;
    private long waitForResponseTimeout;
    private ReadTimeouts readTimeouts;
    private boolean disableDirectByteBufferUse;
    private boolean enableJavaSerialization;
    private boolean useRepId;
    private boolean showInfoMessages;
    private CodeSetComponentInfo codesets;

    public String getORBInitialHost() {
        return this.ORBInitialHost;
    }

    public int getORBInitialPort() {
        return this.ORBInitialPort;
    }

    public String getORBServerHost() {
        return this.ORBServerHost;
    }

    public boolean getListenOnAllInterfaces() {
        return this.listenOnAllInterfaces;
    }

    public int getORBServerPort() {
        return this.ORBServerPort;
    }

    public com.sun.corba.ee.spi.legacy.connection.ORBSocketFactory getLegacySocketFactory() {
        return this.legacySocketFactory;
    }

    public ORBSocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public USLPort[] getUserSpecifiedListenPorts() {
        return this.userSpecifiedListenPorts;
    }

    public IORToSocketInfo getIORToSocketInfo() {
        return this.iorToSocketInfo;
    }

    public IIOPPrimaryToContactInfo getIIOPPrimaryToContactInfo() {
        return this.iiopPrimaryToContactInfo;
    }

    public String getORBId() {
        return this.orbId;
    }

    public boolean getORBServerIdPropertySpecified() {
        return this.orbServerIdPropertySpecified;
    }

    public boolean isLocalOptimizationAllowed() {
        return this.allowLocalOptimization;
    }

    public GIOPVersion getGIOPVersion() {
        return this.giopVersion;
    }

    public int getHighWaterMark() {
        return this.highWaterMark;
    }

    public int getLowWaterMark() {
        return this.lowWaterMark;
    }

    public int getNumberToReclaim() {
        return this.numberToReclaim;
    }

    public int getGIOPFragmentSize() {
        return this.giopFragmentSize;
    }

    public int getGIOPBufferSize() {
        return this.giopBufferSize;
    }

    public int getGIOPBuffMgrStrategy(GIOPVersion gIOPVersion) {
        if (gIOPVersion != null) {
            if (gIOPVersion.equals(GIOPVersion.V1_0)) {
                return 0;
            }
            if (gIOPVersion.equals(GIOPVersion.V1_1)) {
                return this.giop11BuffMgr;
            }
            if (gIOPVersion.equals(GIOPVersion.V1_2)) {
                return this.giop12BuffMgr;
            }
        }
        return 0;
    }

    public short getGIOPTargetAddressPreference() {
        return this.giopTargetAddressPreference;
    }

    public short getGIOPAddressDisposition() {
        return this.giopAddressDisposition;
    }

    public boolean useByteOrderMarkers() {
        return this.useByteOrderMarkers;
    }

    public boolean useByteOrderMarkersInEncapsulations() {
        return this.useByteOrderMarkersInEncaps;
    }

    public boolean alwaysSendCodeSetServiceContext() {
        return this.alwaysSendCodeSetCtx;
    }

    public boolean getPersistentPortInitialized() {
        return this.persistentPortInitialized;
    }

    public int getPersistentServerPort() {
        if (this.persistentPortInitialized) {
            return this.persistentServerPort;
        }
        throw this.wrapper.persistentServerportNotSet(CompletionStatus.COMPLETED_MAYBE);
    }

    public boolean getPersistentServerIdInitialized() {
        return this.persistentServerIdInitialized;
    }

    public int getPersistentServerId() {
        if (this.persistentServerIdInitialized) {
            return this.persistentServerId;
        }
        throw this.wrapper.persistentServeridNotSet(CompletionStatus.COMPLETED_MAYBE);
    }

    public boolean getServerIsORBActivated() {
        return this.serverIsORBActivated;
    }

    public Class getBadServerIdHandler() {
        return this.badServerIdHandlerClass;
    }

    public CodeSetComponentInfo getCodeSetComponentInfo() {
        return this.codesets;
    }

    public ORBInitializer[] getORBInitializers() {
        return this.orbInitializers;
    }

    public StringPair[] getORBInitialReferences() {
        return this.orbInitialReferences;
    }

    public String getORBDefaultInitialReference() {
        return this.defaultInitRef;
    }

    public String[] getORBDebugFlags() {
        return this.debugFlags;
    }

    public Acceptor[] getAcceptors() {
        return this.acceptors;
    }

    public CorbaContactInfoListFactory getCorbaContactInfoListFactory() {
        return this.corbaContactInfoListFactory;
    }

    public String acceptorSocketType() {
        return this.acceptorSocketType;
    }

    public boolean acceptorSocketUseSelectThreadToWait() {
        return this.acceptorSocketUseSelectThreadToWait;
    }

    public boolean acceptorSocketUseWorkerThreadForEvent() {
        return this.acceptorSocketUseWorkerThreadForEvent;
    }

    public String connectionSocketType() {
        return this.connectionSocketType;
    }

    public boolean connectionSocketUseSelectThreadToWait() {
        return this.connectionSocketUseSelectThreadToWait;
    }

    public boolean connectionSocketUseWorkerThreadForEvent() {
        return this.connectionSocketUseWorkerThreadForEvent;
    }

    public boolean isJavaSerializationEnabled() {
        return this.enableJavaSerialization;
    }

    public long getCommunicationsRetryTimeout() {
        return this.communicationsRetryTimeout;
    }

    public long getWaitForResponseTimeout() {
        return this.waitForResponseTimeout;
    }

    public ReadTimeouts getTransportTCPReadTimeouts() {
        return this.readTimeouts;
    }

    public boolean disableDirectByteBufferUse() {
        return this.disableDirectByteBufferUse;
    }

    public boolean useRepId() {
        return this.useRepId;
    }

    public boolean showInfoMessages() {
        return this.showInfoMessages;
    }

    public ORBDataParserImpl(ORB oRB, DataCollector dataCollector) {
        super(ParserTable.get().getParserData());
        this.orb = oRB;
        this.wrapper = ORBUtilSystemException.get(oRB, "orb.lifecycle");
        this.init(dataCollector);
    }

    public void complete() {
        this.codesets = new CodeSetComponentInfo(this.charData, this.wcharData);
        this.initializeServerHostInfo();
    }

    private void initializeServerHostInfo() {
        if (this.ORBServerHost == null || this.ORBServerHost.equals("") || this.ORBServerHost.equals("0.0.0.0") || this.ORBServerHost.equals("::") || this.ORBServerHost.toLowerCase().equals("::ffff:0.0.0.0")) {
            try {
                this.ORBServerHost = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception exception) {
                throw this.wrapper.getLocalHostFailed(exception);
            }
            this.listenOnAllInterfaces = true;
        } else {
            this.listenOnAllInterfaces = false;
        }
    }
}

