/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.encoding;

import com.sun.corba.ee.impl.encoding.CDROutputStream_1_1;
import com.sun.corba.ee.impl.encoding.CodeSetConversion;
import com.sun.corba.ee.spi.ior.iiop.GIOPVersion;
import org.omg.CORBA.CompletionStatus;

public class CDROutputStream_1_2
extends CDROutputStream_1_1 {
    protected boolean primitiveAcrossFragmentedChunk = false;
    protected boolean specialChunk = false;
    private boolean headerPadding;

    protected void handleSpecialChunkBegin(int n) {
        if (this.inBlock && n + this.bbwi.position() > this.bbwi.buflen) {
            int n2 = this.bbwi.position();
            this.bbwi.position(this.blockSizeIndex - 4);
            this.writeLongWithoutAlign(n2 - this.blockSizeIndex + n);
            this.bbwi.position(n2);
            this.specialChunk = true;
        }
    }

    protected void handleSpecialChunkEnd() {
        if (this.inBlock && this.specialChunk) {
            this.inBlock = false;
            this.blockSizeIndex = -1;
            this.blockSizePosition = -1;
            this.start_block();
            this.specialChunk = false;
        }
    }

    private void checkPrimitiveAcrossFragmentedChunk() {
        if (this.primitiveAcrossFragmentedChunk) {
            this.primitiveAcrossFragmentedChunk = false;
            this.inBlock = false;
            this.blockSizeIndex = -1;
            this.blockSizePosition = -1;
            this.start_block();
        }
    }

    public void write_octet(byte by) {
        super.write_octet(by);
        this.checkPrimitiveAcrossFragmentedChunk();
    }

    public void write_short(short s) {
        super.write_short(s);
        this.checkPrimitiveAcrossFragmentedChunk();
    }

    public void write_long(int n) {
        super.write_long(n);
        this.checkPrimitiveAcrossFragmentedChunk();
    }

    public void write_longlong(long l) {
        super.write_longlong(l);
        this.checkPrimitiveAcrossFragmentedChunk();
    }

    void setHeaderPadding(boolean bl) {
        this.headerPadding = bl;
    }

    protected void alignAndReserve(int n, int n2) {
        if (this.headerPadding) {
            this.headerPadding = false;
            this.alignOnBoundary(8);
        }
        this.bbwi.position(this.bbwi.position() + this.computeAlignment(n));
        if (this.bbwi.position() + n2 > this.bbwi.buflen) {
            this.grow(n, n2);
        }
    }

    protected void grow(int n, int n2) {
        boolean bl;
        int n3 = this.bbwi.position();
        boolean bl2 = bl = this.inBlock && !this.specialChunk;
        if (bl) {
            int n4 = this.bbwi.position();
            this.bbwi.position(this.blockSizeIndex - 4);
            this.writeLongWithoutAlign(n4 - this.blockSizeIndex + n2);
            this.bbwi.position(n4);
        }
        this.bbwi.needed = n2;
        this.bufferManagerWrite.overflow(this.bbwi);
        if (this.bbwi.fragmented) {
            this.bbwi.fragmented = false;
            this.fragmentOffset += n3 - this.bbwi.position();
            if (bl) {
                this.primitiveAcrossFragmentedChunk = true;
            }
        }
    }

    public GIOPVersion getGIOPVersion() {
        return GIOPVersion.V1_2;
    }

    public void write_wchar(char c) {
        CodeSetConversion.CTBConverter cTBConverter = this.getWCharConverter();
        cTBConverter.convert(c);
        this.handleSpecialChunkBegin(1 + cTBConverter.getNumBytes());
        this.write_octet((byte)cTBConverter.getNumBytes());
        byte[] byArray = cTBConverter.getBytes();
        this.internalWriteOctetArray(byArray, 0, cTBConverter.getNumBytes());
        this.handleSpecialChunkEnd();
    }

    public void write_wchar_array(char[] cArray, int n, int n2) {
        if (cArray == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        CodeSetConversion.CTBConverter cTBConverter = this.getWCharConverter();
        int n3 = 0;
        int n4 = (int)Math.ceil(cTBConverter.getMaxBytesPerChar() * (float)n2);
        byte[] byArray = new byte[n4 + n2];
        for (int i = 0; i < n2; ++i) {
            cTBConverter.convert(cArray[n + i]);
            byArray[n3++] = (byte)cTBConverter.getNumBytes();
            System.arraycopy(cTBConverter.getBytes(), 0, byArray, n3, cTBConverter.getNumBytes());
            n3 += cTBConverter.getNumBytes();
        }
        this.handleSpecialChunkBegin(n3);
        this.internalWriteOctetArray(byArray, 0, n3);
        this.handleSpecialChunkEnd();
    }

    public void write_wstring(String string) {
        if (string == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        if (string.length() == 0) {
            this.write_long(0);
            return;
        }
        CodeSetConversion.CTBConverter cTBConverter = this.getWCharConverter();
        cTBConverter.convert(string);
        this.handleSpecialChunkBegin(this.computeAlignment(4) + 4 + cTBConverter.getNumBytes());
        this.write_long(cTBConverter.getNumBytes());
        this.internalWriteOctetArray(cTBConverter.getBytes(), 0, cTBConverter.getNumBytes());
        this.handleSpecialChunkEnd();
    }
}

