/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.encoding;

import com.sun.corba.ee.impl.encoding.BufferManagerFactory;
import com.sun.corba.ee.impl.encoding.BufferManagerWrite;
import com.sun.corba.ee.impl.encoding.ByteBufferWithInfo;
import com.sun.corba.ee.impl.encoding.CodeSetComponentInfo;
import com.sun.corba.ee.impl.encoding.CodeSetConversion;
import com.sun.corba.ee.impl.encoding.OSFCodeSetRegistry;
import com.sun.corba.ee.impl.logging.OMGSystemException;
import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.Message;
import com.sun.corba.ee.impl.transport.MessageTraceManagerImpl;
import com.sun.corba.ee.pept.protocol.MessageMediator;
import com.sun.corba.ee.spi.encoding.CorbaOutputObject;
import com.sun.corba.ee.spi.ior.iiop.GIOPVersion;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.protocol.CorbaMessageMediator;
import com.sun.corba.ee.spi.transport.CorbaConnection;
import com.sun.corba.ee.spi.transport.CorbaTransportManager;
import java.io.IOException;
import org.omg.CORBA.portable.InputStream;

public class CDROutputObject
extends CorbaOutputObject {
    private Message header;
    private ORB orb;
    private ORBUtilSystemException wrapper;
    private OMGSystemException omgWrapper;
    private CorbaConnection connection;

    private CDROutputObject(ORB oRB, GIOPVersion gIOPVersion, Message message, BufferManagerWrite bufferManagerWrite, byte by, CorbaMessageMediator corbaMessageMediator) {
        super(oRB, gIOPVersion, message.getEncodingVersion(), false, bufferManagerWrite, by, corbaMessageMediator != null && corbaMessageMediator.getConnection() != null ? ((CorbaConnection)corbaMessageMediator.getConnection()).shouldUseDirectByteBuffers() : false);
        this.header = message;
        this.orb = oRB;
        this.wrapper = ORBUtilSystemException.get(oRB, "rpc.encoding");
        this.omgWrapper = OMGSystemException.get(oRB, "rpc.encoding");
        this.getBufferManager().setOutputObject(this);
        this.corbaMessageMediator = corbaMessageMediator;
    }

    public CDROutputObject(ORB oRB, MessageMediator messageMediator, Message message, byte by) {
        this(oRB, ((CorbaMessageMediator)messageMediator).getGIOPVersion(), message, BufferManagerFactory.newBufferManagerWrite(((CorbaMessageMediator)messageMediator).getGIOPVersion(), message.getEncodingVersion(), oRB), by, (CorbaMessageMediator)messageMediator);
    }

    public CDROutputObject(ORB oRB, MessageMediator messageMediator, Message message, byte by, int n) {
        this(oRB, ((CorbaMessageMediator)messageMediator).getGIOPVersion(), message, BufferManagerFactory.newBufferManagerWrite(n, message.getEncodingVersion(), oRB), by, (CorbaMessageMediator)messageMediator);
    }

    public CDROutputObject(ORB oRB, CorbaMessageMediator corbaMessageMediator, GIOPVersion gIOPVersion, CorbaConnection corbaConnection, Message message, byte by) {
        this(oRB, gIOPVersion, message, BufferManagerFactory.newBufferManagerWrite(gIOPVersion, message.getEncodingVersion(), oRB), by, corbaMessageMediator);
        this.connection = corbaConnection;
    }

    public Message getMessageHeader() {
        return this.header;
    }

    public final void finishSendingMessage() {
        this.getBufferManager().sendMessage();
    }

    public void writeTo(CorbaConnection corbaConnection) throws IOException {
        ByteBufferWithInfo byteBufferWithInfo = this.getByteBufferWithInfo();
        this.getMessageHeader().setSize(byteBufferWithInfo.byteBuffer, byteBufferWithInfo.getSize());
        ORB oRB = (ORB)((Object)this.orb());
        if (oRB != null) {
            CorbaTransportManager corbaTransportManager;
            MessageTraceManagerImpl messageTraceManagerImpl;
            if (oRB.transportDebugFlag) {
                this.dprint(".writeTo: " + corbaConnection);
            }
            if (oRB.giopDebugFlag) {
                ORBUtility.printBuffer("CDROutputObject Buffer", byteBufferWithInfo.byteBuffer, System.out);
            }
            if ((messageTraceManagerImpl = (MessageTraceManagerImpl)(corbaTransportManager = (CorbaTransportManager)oRB.getTransportManager()).getMessageTraceManager()).isEnabled()) {
                messageTraceManagerImpl.recordDataSent(byteBufferWithInfo.byteBuffer);
            }
        }
        byteBufferWithInfo.flip();
        corbaConnection.write(byteBufferWithInfo.byteBuffer);
    }

    public InputStream create_input_stream() {
        return null;
    }

    public CorbaConnection getConnection() {
        if (this.connection != null) {
            return this.connection;
        }
        return (CorbaConnection)this.corbaMessageMediator.getConnection();
    }

    public final ByteBufferWithInfo getByteBufferWithInfo() {
        return super.getByteBufferWithInfo();
    }

    public final void setByteBufferWithInfo(ByteBufferWithInfo byteBufferWithInfo) {
        super.setByteBufferWithInfo(byteBufferWithInfo);
    }

    protected CodeSetConversion.CTBConverter createCharCTBConverter() {
        CodeSetComponentInfo.CodeSetContext codeSetContext = this.getCodeSets();
        if (codeSetContext == null) {
            return super.createCharCTBConverter();
        }
        OSFCodeSetRegistry.Entry entry = OSFCodeSetRegistry.lookupEntry(codeSetContext.getCharCodeSet());
        if (entry == null) {
            throw this.wrapper.unknownCodeset(entry);
        }
        return CodeSetConversion.impl().getCTBConverter(entry, this.isLittleEndian(), false);
    }

    protected CodeSetConversion.CTBConverter createWCharCTBConverter() {
        CodeSetComponentInfo.CodeSetContext codeSetContext = this.getCodeSets();
        if (codeSetContext == null) {
            if (this.getConnection().isServer()) {
                throw this.omgWrapper.noClientWcharCodesetCtx();
            }
            throw this.omgWrapper.noServerWcharCodesetCmp();
        }
        OSFCodeSetRegistry.Entry entry = OSFCodeSetRegistry.lookupEntry(codeSetContext.getWCharCodeSet());
        if (entry == null) {
            throw this.wrapper.unknownCodeset(entry);
        }
        boolean bl = ((ORB)((Object)this.orb())).getORBData().useByteOrderMarkers();
        if (entry == OSFCodeSetRegistry.UTF_16) {
            if (this.getGIOPVersion().equals(GIOPVersion.V1_2)) {
                return CodeSetConversion.impl().getCTBConverter(entry, false, bl);
            }
            if (this.getGIOPVersion().equals(GIOPVersion.V1_1)) {
                return CodeSetConversion.impl().getCTBConverter(entry, this.isLittleEndian(), false);
            }
        }
        return CodeSetConversion.impl().getCTBConverter(entry, this.isLittleEndian(), bl);
    }

    private CodeSetComponentInfo.CodeSetContext getCodeSets() {
        if (this.getConnection() == null) {
            return CodeSetComponentInfo.LOCAL_CODE_SETS;
        }
        return this.getConnection().getCodeSetContext();
    }

    protected void dprint(String string) {
        ORBUtility.dprint("CDROutputObject", string);
    }
}

