/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.encoding;

import com.sun.corba.ee.impl.encoding.BufferManagerFactory;
import com.sun.corba.ee.impl.encoding.CDRInputStream;
import com.sun.corba.ee.impl.encoding.CodeSetComponentInfo;
import com.sun.corba.ee.impl.encoding.CodeSetConversion;
import com.sun.corba.ee.impl.encoding.OSFCodeSetRegistry;
import com.sun.corba.ee.impl.logging.OMGSystemException;
import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.Message;
import com.sun.corba.ee.pept.encoding.InputObject;
import com.sun.corba.ee.spi.ior.iiop.GIOPVersion;
import com.sun.corba.ee.spi.transport.CorbaConnection;
import com.sun.org.omg.SendingContext.CodeBase;
import java.nio.ByteBuffer;
import org.omg.CORBA.ORB;
import org.omg.CORBA.portable.InputStream;

public class CDRInputObject
extends CDRInputStream
implements InputObject {
    private CorbaConnection corbaConnection;
    private Message header;
    private boolean unmarshaledHeader;
    private com.sun.corba.ee.spi.orb.ORB orb;
    private ORBUtilSystemException wrapper;
    private OMGSystemException omgWrapper;

    public CDRInputObject(com.sun.corba.ee.spi.orb.ORB oRB, CorbaConnection corbaConnection, ByteBuffer byteBuffer, Message message) {
        super((ORB)((Object)oRB), byteBuffer, message.getSize(), message.isLittleEndian(), message.getGIOPVersion(), message.getEncodingVersion(), BufferManagerFactory.newBufferManagerRead(message.getGIOPVersion(), message.getEncodingVersion(), oRB));
        this.corbaConnection = corbaConnection;
        this.orb = oRB;
        this.wrapper = ORBUtilSystemException.get(oRB, "rpc.encoding");
        this.omgWrapper = OMGSystemException.get(oRB, "rpc.encoding");
        if (oRB.transportDebugFlag) {
            this.dprint(".CDRInputObject constructor:");
        }
        this.getBufferManager().init(message);
        this.header = message;
        this.unmarshaledHeader = false;
        this.setIndex(12);
        this.setBufferLength(message.getSize());
    }

    public final CorbaConnection getConnection() {
        return this.corbaConnection;
    }

    public Message getMessageHeader() {
        return this.header;
    }

    public void unmarshalHeader() {
        if (!this.unmarshaledHeader) {
            try {
                try {
                    if (((com.sun.corba.ee.spi.orb.ORB)((Object)this.orb())).transportDebugFlag) {
                        this.dprint(".unmarshalHeader->: " + this.getMessageHeader());
                    }
                    this.getMessageHeader().read((InputStream)this);
                    this.unmarshaledHeader = true;
                }
                catch (RuntimeException runtimeException) {
                    if (((com.sun.corba.ee.spi.orb.ORB)((Object)this.orb())).transportDebugFlag) {
                        this.dprint(".unmarshalHeader: !!ERROR!!: " + this.getMessageHeader() + ": " + runtimeException);
                    }
                    throw runtimeException;
                }
                Object var3_1 = null;
                if (((com.sun.corba.ee.spi.orb.ORB)((Object)this.orb())).transportDebugFlag) {
                    this.dprint(".unmarshalHeader<-: " + this.getMessageHeader());
                }
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                if (((com.sun.corba.ee.spi.orb.ORB)((Object)this.orb())).transportDebugFlag) {
                    this.dprint(".unmarshalHeader<-: " + this.getMessageHeader());
                }
                throw throwable;
            }
        }
    }

    public final boolean unmarshaledHeader() {
        return this.unmarshaledHeader;
    }

    protected CodeSetConversion.BTCConverter createCharBTCConverter() {
        CodeSetComponentInfo.CodeSetContext codeSetContext = this.getCodeSets();
        if (codeSetContext == null) {
            return super.createCharBTCConverter();
        }
        OSFCodeSetRegistry.Entry entry = OSFCodeSetRegistry.lookupEntry(codeSetContext.getCharCodeSet());
        if (entry == null) {
            throw this.wrapper.unknownCodeset(entry);
        }
        return CodeSetConversion.impl().getBTCConverter(entry, this.isLittleEndian());
    }

    protected CodeSetConversion.BTCConverter createWCharBTCConverter() {
        CodeSetComponentInfo.CodeSetContext codeSetContext = this.getCodeSets();
        if (codeSetContext == null) {
            if (this.getConnection().isServer()) {
                throw this.omgWrapper.noClientWcharCodesetCtx();
            }
            throw this.omgWrapper.noServerWcharCodesetCmp();
        }
        OSFCodeSetRegistry.Entry entry = OSFCodeSetRegistry.lookupEntry(codeSetContext.getWCharCodeSet());
        if (entry == null) {
            throw this.wrapper.unknownCodeset(entry);
        }
        if (entry == OSFCodeSetRegistry.UTF_16 && this.getGIOPVersion().equals(GIOPVersion.V1_2)) {
            return CodeSetConversion.impl().getBTCConverter(entry, false);
        }
        return CodeSetConversion.impl().getBTCConverter(entry, this.isLittleEndian());
    }

    private CodeSetComponentInfo.CodeSetContext getCodeSets() {
        if (this.getConnection() == null) {
            return CodeSetComponentInfo.LOCAL_CODE_SETS;
        }
        return this.getConnection().getCodeSetContext();
    }

    public final CodeBase getCodeBase() {
        if (this.getConnection() == null) {
            return null;
        }
        return this.getConnection().getCodeBase();
    }

    public CDRInputStream dup() {
        return null;
    }

    protected void dprint(String string) {
        ORBUtility.dprint("CDRInputObject", string);
    }
}

