/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.encoding;

import com.sun.corba.ee.impl.encoding.BufferManagerWrite;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.pept.transport.ByteBufferPool;
import java.nio.ByteBuffer;
import org.omg.CORBA.ORB;

public class ByteBufferWithInfo {
    private com.sun.corba.ee.spi.orb.ORB orb;
    private boolean debug;
    public ByteBuffer byteBuffer;
    public int buflen;
    public int needed;
    public boolean fragmented;

    public ByteBufferWithInfo(ORB oRB, ByteBuffer byteBuffer, int n) {
        this.orb = (com.sun.corba.ee.spi.orb.ORB)((Object)oRB);
        this.debug = this.orb.transportDebugFlag;
        this.byteBuffer = byteBuffer;
        if (byteBuffer != null) {
            this.buflen = byteBuffer.limit();
        }
        this.position(n);
        this.needed = 0;
        this.fragmented = false;
    }

    public ByteBufferWithInfo(ORB oRB, ByteBuffer byteBuffer) {
        this(oRB, byteBuffer, 0);
    }

    public ByteBufferWithInfo(ORB oRB, BufferManagerWrite bufferManagerWrite) {
        this(oRB, bufferManagerWrite, true);
    }

    public ByteBufferWithInfo(ORB oRB, BufferManagerWrite bufferManagerWrite, boolean bl) {
        this.orb = (com.sun.corba.ee.spi.orb.ORB)((Object)oRB);
        this.debug = this.orb.transportDebugFlag;
        int n = bufferManagerWrite.getBufferSize();
        if (bl) {
            ByteBufferPool byteBufferPool = this.orb.getByteBufferPool();
            this.byteBuffer = byteBufferPool.getByteBuffer(n);
            if (this.debug) {
                int n2 = System.identityHashCode(this.byteBuffer);
                StringBuffer stringBuffer = new StringBuffer(80);
                stringBuffer.append("constructor (ORB, BufferManagerWrite) - got ").append("ByteBuffer id (").append(n2).append(") from ByteBufferPool.");
                String string = stringBuffer.toString();
                this.dprint(string);
            }
        } else {
            this.byteBuffer = ByteBuffer.allocate(n);
        }
        this.position(0);
        this.buflen = n;
        this.byteBuffer.limit(this.buflen);
        this.needed = 0;
        this.fragmented = false;
    }

    public ByteBufferWithInfo(ByteBufferWithInfo byteBufferWithInfo) {
        this.orb = byteBufferWithInfo.orb;
        this.debug = byteBufferWithInfo.debug;
        this.byteBuffer = byteBufferWithInfo.byteBuffer.duplicate();
        this.buflen = byteBufferWithInfo.buflen;
        this.byteBuffer.limit(this.buflen);
        this.position(byteBufferWithInfo.position());
        this.needed = byteBufferWithInfo.needed;
        this.fragmented = byteBufferWithInfo.fragmented;
    }

    public int getSize() {
        return this.position();
    }

    public int getLength() {
        return this.buflen;
    }

    public int position() {
        return this.byteBuffer.position();
    }

    public void position(int n) {
        this.byteBuffer.position(n);
    }

    public void flip() {
        this.byteBuffer.flip();
    }

    public void setLength(int n) {
        this.buflen = n;
        this.byteBuffer.limit(this.buflen);
    }

    public void growBuffer(com.sun.corba.ee.spi.orb.ORB oRB) {
        String string;
        StringBuffer stringBuffer;
        int n;
        int n2;
        for (n2 = this.byteBuffer.limit() * 2; this.position() + this.needed >= n2; n2 *= 2) {
        }
        ByteBufferPool byteBufferPool = oRB.getByteBufferPool();
        ByteBuffer byteBuffer = byteBufferPool.getByteBuffer(n2);
        if (this.debug) {
            n = System.identityHashCode(byteBuffer);
            stringBuffer = new StringBuffer(80);
            stringBuffer.append("growBuffer() - got ByteBuffer id (");
            stringBuffer.append(n).append(") from ByteBufferPool.");
            string = stringBuffer.toString();
            this.dprint(string);
        }
        this.flip();
        byteBuffer.put(this.byteBuffer);
        if (this.debug) {
            n = System.identityHashCode(this.byteBuffer);
            stringBuffer = new StringBuffer(80);
            stringBuffer.append("growBuffer() - releasing ByteBuffer id (");
            stringBuffer.append(n).append(") to ByteBufferPool.");
            string = stringBuffer.toString();
            this.dprint(string);
        }
        byteBufferPool.releaseByteBuffer(this.byteBuffer);
        this.byteBuffer = byteBuffer;
        this.buflen = n2;
        this.byteBuffer.limit(this.buflen);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("ByteBufferWithInfo:");
        stringBuffer.append(" buflen = " + this.buflen);
        stringBuffer.append(" byteBuffer.limit = " + this.byteBuffer.limit());
        stringBuffer.append(" position = " + this.position());
        stringBuffer.append(" needed = " + this.needed);
        stringBuffer.append(" byteBuffer = " + (this.byteBuffer == null ? "null" : "not null"));
        stringBuffer.append(" fragmented = " + this.fragmented);
        return stringBuffer.toString();
    }

    protected void dprint(String string) {
        ORBUtility.dprint("ByteBufferWithInfo", string);
    }
}

