/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.encoding;

import com.sun.corba.ee.impl.encoding.BufferManagerWrite;
import com.sun.corba.ee.impl.encoding.BufferQueue;
import com.sun.corba.ee.impl.encoding.ByteBufferWithInfo;
import com.sun.corba.ee.impl.encoding.CDROutputObject;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.FragmentMessage;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.MessageBase;
import com.sun.corba.ee.pept.encoding.OutputObject;
import com.sun.corba.ee.pept.transport.ByteBufferPool;
import com.sun.corba.ee.pept.transport.Connection;
import java.util.Iterator;
import org.omg.CORBA.ORB;
import org.omg.CORBA.portable.OutputStream;

public class BufferManagerWriteCollect
extends BufferManagerWrite {
    private BufferQueue queue = new BufferQueue();
    private boolean sentFragment = false;
    private boolean debug = false;

    BufferManagerWriteCollect(com.sun.corba.ee.spi.orb.ORB oRB) {
        super(oRB);
        if (oRB != null) {
            this.debug = oRB.transportDebugFlag;
        }
    }

    public boolean sentFragment() {
        return this.sentFragment;
    }

    public int getBufferSize() {
        return this.orb.getORBData().getGIOPFragmentSize();
    }

    public void overflow(ByteBufferWithInfo byteBufferWithInfo) {
        MessageBase.setFlag(byteBufferWithInfo.byteBuffer, 2);
        this.queue.enqueue(byteBufferWithInfo);
        ByteBufferWithInfo byteBufferWithInfo2 = new ByteBufferWithInfo((ORB)((Object)this.orb), this);
        byteBufferWithInfo2.fragmented = true;
        ((CDROutputObject)this.outputObject).setByteBufferWithInfo(byteBufferWithInfo2);
        FragmentMessage fragmentMessage = ((CDROutputObject)this.outputObject).getMessageHeader().createFragmentMessage();
        fragmentMessage.write((OutputStream)((CDROutputObject)this.outputObject));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage() {
        this.queue.enqueue(((CDROutputObject)this.outputObject).getByteBufferWithInfo());
        Iterator iterator = this.iterator();
        Connection connection = ((OutputObject)this.outputObject).getMessageMediator().getConnection();
        connection.writeLock();
        try {
            ByteBufferPool byteBufferPool = this.orb.getByteBufferPool();
            while (iterator.hasNext()) {
                ByteBufferWithInfo byteBufferWithInfo = (ByteBufferWithInfo)iterator.next();
                ((CDROutputObject)this.outputObject).setByteBufferWithInfo(byteBufferWithInfo);
                connection.sendWithoutLock((CDROutputObject)this.outputObject);
                this.sentFragment = true;
                if (this.debug) {
                    int n = System.identityHashCode(byteBufferWithInfo.byteBuffer);
                    StringBuffer stringBuffer = new StringBuffer(80);
                    stringBuffer.append("sendMessage() - releasing ByteBuffer id (");
                    stringBuffer.append(n).append(") to ByteBufferPool.");
                    String string = stringBuffer.toString();
                    this.dprint(string);
                }
                byteBufferPool.releaseByteBuffer(byteBufferWithInfo.byteBuffer);
                byteBufferWithInfo.byteBuffer = null;
                byteBufferWithInfo = null;
            }
            this.sentFullMessage = true;
        }
        finally {
            connection.writeUnlock();
        }
    }

    public void close() {
        Iterator iterator = this.iterator();
        ByteBufferPool byteBufferPool = this.orb.getByteBufferPool();
        while (iterator.hasNext()) {
            ByteBufferWithInfo byteBufferWithInfo = (ByteBufferWithInfo)iterator.next();
            if (byteBufferWithInfo == null || byteBufferWithInfo.byteBuffer == null) continue;
            if (this.debug) {
                int n = System.identityHashCode(byteBufferWithInfo.byteBuffer);
                StringBuffer stringBuffer = new StringBuffer(80);
                stringBuffer.append("close() - releasing ByteBuffer id (");
                stringBuffer.append(n).append(") to ByteBufferPool.");
                String string = stringBuffer.toString();
                this.dprint(string);
            }
            byteBufferPool.releaseByteBuffer(byteBufferWithInfo.byteBuffer);
            byteBufferWithInfo.byteBuffer = null;
            byteBufferWithInfo = null;
        }
    }

    private void dprint(String string) {
        ORBUtility.dprint("BufferManagerWriteCollect", string);
    }

    private Iterator iterator() {
        return new BufferManagerWriteCollectIterator();
    }

    private class BufferManagerWriteCollectIterator
    implements Iterator {
        private BufferManagerWriteCollectIterator() {
        }

        public boolean hasNext() {
            return BufferManagerWriteCollect.this.queue.size() != 0;
        }

        public Object next() {
            return BufferManagerWriteCollect.this.queue.dequeue();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

