/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.corba;

import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.protocol.CorbaMessageMediator;
import org.omg.CORBA.Any;
import org.omg.CORBA.Bounds;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Context;
import org.omg.CORBA.NVList;
import org.omg.CORBA.NamedValue;
import org.omg.CORBA.ServerRequest;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public class ServerRequestImpl
extends ServerRequest {
    private ORB _orb = null;
    private ORBUtilSystemException _wrapper = null;
    private String _opName = null;
    private NVList _arguments = null;
    private Context _ctx = null;
    private InputStream _ins = null;
    private boolean _paramsCalled = false;
    private boolean _resultSet = false;
    private boolean _exceptionSet = false;
    private Any _resultAny = null;
    private Any _exception = null;

    public ServerRequestImpl(CorbaMessageMediator corbaMessageMediator, ORB oRB) {
        this._opName = corbaMessageMediator.getOperationName();
        this._ins = (InputStream)corbaMessageMediator.getInputObject();
        this._ctx = null;
        this._orb = oRB;
        this._wrapper = ORBUtilSystemException.get(oRB, "oa.invocation");
    }

    public String operation() {
        return this._opName;
    }

    public void arguments(NVList nVList) {
        if (this._paramsCalled) {
            throw this._wrapper.argumentsCalledMultiple();
        }
        if (this._exceptionSet) {
            throw this._wrapper.argumentsCalledAfterException();
        }
        if (nVList == null) {
            throw this._wrapper.argumentsCalledNullArgs();
        }
        this._paramsCalled = true;
        NamedValue namedValue = null;
        for (int i = 0; i < nVList.count(); ++i) {
            try {
                namedValue = nVList.item(i);
            }
            catch (Bounds bounds) {
                throw this._wrapper.boundsCannotOccur(bounds);
            }
            try {
                if (namedValue.flags() != 1 && namedValue.flags() != 3) continue;
                namedValue.value().read_value(this._ins, namedValue.value().type());
                continue;
            }
            catch (Exception exception) {
                throw this._wrapper.badArgumentsNvlist(exception);
            }
        }
        this._arguments = nVList;
        this._orb.getPIHandler().setServerPIInfo(this._arguments);
        this._orb.getPIHandler().invokeServerPIIntermediatePoint();
    }

    public void set_result(Any any) {
        if (!this._paramsCalled) {
            throw this._wrapper.argumentsNotCalled();
        }
        if (this._resultSet) {
            throw this._wrapper.setResultCalledMultiple();
        }
        if (this._exceptionSet) {
            throw this._wrapper.setResultAfterException();
        }
        if (any == null) {
            throw this._wrapper.setResultCalledNullArgs();
        }
        this._resultAny = any;
        this._resultSet = true;
        this._orb.getPIHandler().setServerPIInfo(this._resultAny);
    }

    public void set_exception(Any any) {
        if (any == null) {
            throw this._wrapper.setExceptionCalledNullArgs();
        }
        TCKind tCKind = any.type().kind();
        if (tCKind != TCKind.tk_except) {
            throw this._wrapper.setExceptionCalledBadType();
        }
        this._exception = any;
        this._orb.getPIHandler().setServerPIExceptionInfo(this._exception);
        if (!this._exceptionSet && !this._paramsCalled) {
            this._orb.getPIHandler().invokeServerPIIntermediatePoint();
        }
        this._exceptionSet = true;
    }

    public Any checkResultCalled() {
        if (this._paramsCalled && this._resultSet) {
            return null;
        }
        if (this._paramsCalled && !this._resultSet && !this._exceptionSet) {
            try {
                TypeCode typeCode = this._orb.get_primitive_tc(TCKind.tk_void);
                this._resultAny = this._orb.create_any();
                this._resultAny.type(typeCode);
                this._resultSet = true;
                return null;
            }
            catch (Exception exception) {
                throw this._wrapper.dsiResultException(CompletionStatus.COMPLETED_MAYBE, exception);
            }
        }
        if (this._exceptionSet) {
            return this._exception;
        }
        throw this._wrapper.dsimethodNotcalled(CompletionStatus.COMPLETED_MAYBE);
    }

    public void marshalReplyParams(OutputStream outputStream) {
        this._resultAny.write_value(outputStream);
        NamedValue namedValue = null;
        for (int i = 0; i < this._arguments.count(); ++i) {
            try {
                namedValue = this._arguments.item(i);
            }
            catch (Bounds bounds) {
                // empty catch block
            }
            if (namedValue.flags() != 2 && namedValue.flags() != 3) continue;
            namedValue.value().write_value(outputStream);
        }
    }

    public Context ctx() {
        if (!this._paramsCalled || this._resultSet || this._exceptionSet) {
            throw this._wrapper.contextCalledOutOfOrder();
        }
        throw this._wrapper.contextNotImplemented();
    }
}

