/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.copyobject.newreflect;

import com.sun.corba.ee.impl.copyobject.newreflect.ClassCopier;
import com.sun.corba.ee.impl.copyobject.newreflect.ClassCopierBase;
import com.sun.corba.ee.impl.copyobject.newreflect.ClassCopierFactory;
import com.sun.corba.ee.spi.copyobject.ReflectiveCopyException;
import java.lang.reflect.Array;
import java.util.IdentityHashMap;

public class ClassCopierFactoryArrayImpl
implements ClassCopierFactory {
    private final ClassCopierFactory classCopierFactory;
    private ClassCopier arrayClassCopier = new ClassCopierBase("array"){

        public Object createCopy(Object object) throws ReflectiveCopyException {
            int n = Array.getLength(object);
            Object object2 = Array.newInstance(object.getClass().getComponentType(), n);
            return object2;
        }

        public Object doCopy(IdentityHashMap identityHashMap, Object object, Object object2) throws ReflectiveCopyException {
            int n = Array.getLength(object);
            for (int i = 0; i < n; ++i) {
                Object object3 = Array.get(object, i);
                if (object3 != null) {
                    ClassCopier classCopier = ClassCopierFactoryArrayImpl.this.classCopierFactory.get(object3.getClass());
                    object3 = classCopier.copy(identityHashMap, object3);
                }
                Array.set(object2, i, object3);
            }
            return object2;
        }
    };
    private static ClassCopier booleanArrayClassCopier = new ClassCopierBase("boolean"){

        public Object createCopy(Object object) throws ReflectiveCopyException {
            boolean[] blArray = (boolean[])object;
            return blArray.clone();
        }
    };
    private static ClassCopier byteArrayClassCopier = new ClassCopierBase("byte"){

        public Object createCopy(Object object) throws ReflectiveCopyException {
            byte[] byArray = (byte[])object;
            return byArray.clone();
        }
    };
    private static ClassCopier charArrayClassCopier = new ClassCopierBase("char"){

        public Object createCopy(Object object) throws ReflectiveCopyException {
            char[] cArray = (char[])object;
            return cArray.clone();
        }
    };
    private static ClassCopier shortArrayClassCopier = new ClassCopierBase("short"){

        public Object createCopy(Object object) throws ReflectiveCopyException {
            short[] sArray = (short[])object;
            return sArray.clone();
        }
    };
    private static ClassCopier intArrayClassCopier = new ClassCopierBase("int"){

        public Object createCopy(Object object) throws ReflectiveCopyException {
            int[] nArray = (int[])object;
            return nArray.clone();
        }
    };
    private static ClassCopier longArrayClassCopier = new ClassCopierBase("long"){

        public Object createCopy(Object object) throws ReflectiveCopyException {
            long[] lArray = (long[])object;
            return lArray.clone();
        }
    };
    private static ClassCopier floatArrayClassCopier = new ClassCopierBase("float"){

        public Object createCopy(Object object) throws ReflectiveCopyException {
            float[] fArray = (float[])object;
            return fArray.clone();
        }
    };
    private static ClassCopier doubleArrayClassCopier = new ClassCopierBase("double"){

        public Object createCopy(Object object) throws ReflectiveCopyException {
            double[] dArray = (double[])object;
            return dArray.clone();
        }
    };

    public ClassCopierFactoryArrayImpl(ClassCopierFactory classCopierFactory) {
        this.classCopierFactory = classCopierFactory;
    }

    public ClassCopier get(Class clazz) {
        Class<?> clazz2 = clazz.getComponentType();
        if (clazz2 == null) {
            return null;
        }
        if (clazz2.isPrimitive()) {
            if (clazz2 == Boolean.TYPE) {
                return booleanArrayClassCopier;
            }
            if (clazz2 == Byte.TYPE) {
                return byteArrayClassCopier;
            }
            if (clazz2 == Character.TYPE) {
                return charArrayClassCopier;
            }
            if (clazz2 == Short.TYPE) {
                return shortArrayClassCopier;
            }
            if (clazz2 == Integer.TYPE) {
                return intArrayClassCopier;
            }
            if (clazz2 == Long.TYPE) {
                return longArrayClassCopier;
            }
            if (clazz2 == Float.TYPE) {
                return floatArrayClassCopier;
            }
            if (clazz2 == Double.TYPE) {
                return doubleArrayClassCopier;
            }
            return null;
        }
        return this.arrayClassCopier;
    }
}

