/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.activation;

import com.sun.corba.ee.impl.activation.CommandHandler;
import com.sun.corba.ee.impl.activation.ServerTool;
import com.sun.corba.ee.impl.orbutil.CorbaResourceUtil;
import com.sun.corba.ee.spi.activation.Activator;
import com.sun.corba.ee.spi.activation.ActivatorHelper;
import com.sun.corba.ee.spi.activation.ServerNotActive;
import com.sun.corba.ee.spi.activation.ServerNotRegistered;
import java.io.PrintStream;
import org.omg.CORBA.ORB;

class ShutdownServer
implements CommandHandler {
    static final int illegalServerId = -1;

    ShutdownServer() {
    }

    public String getCommandName() {
        return "shutdown";
    }

    public void printCommandHelp(PrintStream printStream, boolean bl) {
        if (!bl) {
            printStream.println(CorbaResourceUtil.getText("servertool.shutdown"));
        } else {
            printStream.println(CorbaResourceUtil.getText("servertool.shutdown1"));
        }
    }

    public boolean processCommand(String[] stringArray, ORB oRB, PrintStream printStream) {
        int n = -1;
        try {
            if (stringArray.length == 2) {
                if (stringArray[0].equals("-serverid")) {
                    n = Integer.valueOf(stringArray[1]);
                } else if (stringArray[0].equals("-applicationName")) {
                    n = ServerTool.getServerIdForAlias(oRB, stringArray[1]);
                }
            }
            if (n == -1) {
                return true;
            }
            Activator activator = ActivatorHelper.narrow(oRB.resolve_initial_references("ServerActivator"));
            activator.shutdown(n);
            printStream.println(CorbaResourceUtil.getText("servertool.shutdown2"));
        }
        catch (ServerNotActive serverNotActive) {
            printStream.println(CorbaResourceUtil.getText("servertool.servernotrunning"));
        }
        catch (ServerNotRegistered serverNotRegistered) {
            printStream.println(CorbaResourceUtil.getText("servertool.nosuchserver"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }
}

