/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.activation;

import com.sun.corba.ee.impl.activation.ProcessMonitorThread;
import com.sun.corba.ee.impl.activation.ServerTableEntry;
import com.sun.corba.ee.impl.logging.ActivationSystemException;
import com.sun.corba.ee.impl.oa.poa.BadServerIdHandler;
import com.sun.corba.ee.spi.activation.EndPointInfo;
import com.sun.corba.ee.spi.activation.InvalidORBid;
import com.sun.corba.ee.spi.activation.LocatorPackage.ServerLocation;
import com.sun.corba.ee.spi.activation.LocatorPackage.ServerLocationPerORB;
import com.sun.corba.ee.spi.activation.NoSuchEndPoint;
import com.sun.corba.ee.spi.activation.ORBAlreadyRegistered;
import com.sun.corba.ee.spi.activation.ORBPortInfo;
import com.sun.corba.ee.spi.activation.Repository;
import com.sun.corba.ee.spi.activation.RepositoryPackage.ServerDef;
import com.sun.corba.ee.spi.activation.Server;
import com.sun.corba.ee.spi.activation.ServerAlreadyActive;
import com.sun.corba.ee.spi.activation.ServerAlreadyInstalled;
import com.sun.corba.ee.spi.activation.ServerAlreadyUninstalled;
import com.sun.corba.ee.spi.activation.ServerHeldDown;
import com.sun.corba.ee.spi.activation.ServerNotActive;
import com.sun.corba.ee.spi.activation.ServerNotRegistered;
import com.sun.corba.ee.spi.activation._ServerManagerImplBase;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.IORFactories;
import com.sun.corba.ee.spi.ior.IORTemplate;
import com.sun.corba.ee.spi.ior.ObjectKey;
import com.sun.corba.ee.spi.ior.ObjectKeyTemplate;
import com.sun.corba.ee.spi.ior.iiop.GIOPVersion;
import com.sun.corba.ee.spi.ior.iiop.IIOPAddress;
import com.sun.corba.ee.spi.ior.iiop.IIOPFactories;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfileTemplate;
import com.sun.corba.ee.spi.legacy.connection.LegacyServerSocketEndPointInfo;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.protocol.ForwardException;
import com.sun.corba.ee.spi.transport.CorbaTransportManager;
import com.sun.corba.ee.spi.transport.SocketOrChannelAcceptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ServerManagerImpl
extends _ServerManagerImplBase
implements BadServerIdHandler {
    HashMap serverTable;
    Repository repository;
    CorbaTransportManager transportManager;
    int initialPort;
    ORB orb;
    ActivationSystemException wrapper;
    String dbDirName;
    boolean debug = false;
    private int serverStartupDelay;

    ServerManagerImpl(ORB oRB, CorbaTransportManager corbaTransportManager, Repository repository, String string, boolean bl) {
        Class clazz;
        this.orb = oRB;
        this.wrapper = ActivationSystemException.get(oRB, "orbd.activator");
        this.transportManager = corbaTransportManager;
        this.repository = repository;
        this.dbDirName = string;
        this.debug = bl;
        LegacyServerSocketEndPointInfo legacyServerSocketEndPointInfo = oRB.getLegacyServerSocketManager().legacyGetEndpoint("BOOT_NAMING");
        this.initialPort = ((SocketOrChannelAcceptor)((Object)legacyServerSocketEndPointInfo)).getServerSocket().getLocalPort();
        this.serverTable = new HashMap(256);
        this.serverStartupDelay = 1000;
        String string2 = System.getProperty("com.sun.CORBA.activation.ServerStartupDelay");
        if (string2 != null) {
            try {
                this.serverStartupDelay = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((clazz = oRB.getORBData().getBadServerIdHandler()) == null) {
            oRB.setBadServerIdHandler(this);
        } else {
            oRB.initBadServerIdHandler();
        }
        oRB.connect(this);
        ProcessMonitorThread.start(this.serverTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate(int n) throws ServerAlreadyActive, ServerNotRegistered, ServerHeldDown {
        block9: {
            ServerTableEntry serverTableEntry;
            Integer n2 = new Integer(n);
            HashMap hashMap = this.serverTable;
            synchronized (hashMap) {
                serverTableEntry = (ServerTableEntry)this.serverTable.get(n2);
            }
            if (serverTableEntry != null && serverTableEntry.isActive()) {
                if (this.debug) {
                    System.out.println("ServerManagerImpl: activate for server Id " + n + " failed because server is already active. " + "entry = " + serverTableEntry);
                }
                throw new ServerAlreadyActive(n);
            }
            try {
                serverTableEntry = this.getEntry(n);
                if (this.debug) {
                    System.out.println("ServerManagerImpl: locateServer called with  serverId=" + n + " endpointType=" + "IIOP_CLEAR_TEXT" + " block=false");
                }
                ServerLocation serverLocation = this.locateServer(serverTableEntry, "IIOP_CLEAR_TEXT", false);
                if (this.debug) {
                    System.out.println("ServerManagerImpl: activate for server Id " + n + " found location " + serverLocation.hostname + " and activated it");
                }
            }
            catch (NoSuchEndPoint noSuchEndPoint) {
                if (!this.debug) break block9;
                System.out.println("ServerManagerImpl: activate for server Id  threw NoSuchEndpoint exception, which was ignored");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void active(int n, Server server) throws ServerNotRegistered {
        Integer n2 = new Integer(n);
        HashMap hashMap = this.serverTable;
        synchronized (hashMap) {
            ServerTableEntry serverTableEntry = (ServerTableEntry)this.serverTable.get(n2);
            if (serverTableEntry == null) {
                if (this.debug) {
                    System.out.println("ServerManagerImpl: active for server Id " + n + " called, but no such server is registered.");
                }
                throw this.wrapper.serverNotExpectedToRegister();
            }
            if (this.debug) {
                System.out.println("ServerManagerImpl: active for server Id " + n + " called.  This server is now active.");
            }
            serverTableEntry.register(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEndpoints(int n, String string, EndPointInfo[] endPointInfoArray) throws NoSuchEndPoint, ServerNotRegistered, ORBAlreadyRegistered {
        Integer n2 = new Integer(n);
        HashMap hashMap = this.serverTable;
        synchronized (hashMap) {
            ServerTableEntry serverTableEntry = (ServerTableEntry)this.serverTable.get(n2);
            if (serverTableEntry == null) {
                if (this.debug) {
                    System.out.println("ServerManagerImpl: registerEndpoint for server Id " + n + " called, but no such server is registered.");
                }
                throw this.wrapper.serverNotExpectedToRegister();
            }
            if (this.debug) {
                System.out.println("ServerManagerImpl: registerEndpoints for server Id " + n + " called.  This server is now active.");
            }
            serverTableEntry.registerPorts(string, endPointInfoArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getActiveServers() {
        int[] nArray = null;
        Serializable serializable = this.serverTable;
        synchronized (serializable) {
            ServerTableEntry serverTableEntry;
            ArrayList<ServerTableEntry> arrayList = new ArrayList<ServerTableEntry>(0);
            Iterator iterator = this.serverTable.keySet().iterator();
            try {
                while (iterator.hasNext()) {
                    Integer n = (Integer)iterator.next();
                    serverTableEntry = (ServerTableEntry)this.serverTable.get(n);
                    if (!serverTableEntry.isValid() || !serverTableEntry.isActive()) continue;
                    arrayList.add(serverTableEntry);
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            nArray = new int[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                serverTableEntry = (ServerTableEntry)arrayList.get(i);
                nArray[i] = serverTableEntry.getServerId();
            }
        }
        if (this.debug) {
            serializable = new StringBuffer();
            for (int i = 0; i < nArray.length; ++i) {
                ((StringBuffer)serializable).append(' ');
                ((StringBuffer)serializable).append(nArray[i]);
            }
            System.out.println("ServerManagerImpl: getActiveServers returns" + ((StringBuffer)serializable).toString());
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(int n) throws ServerNotActive {
        Integer n2 = new Integer(n);
        HashMap hashMap = this.serverTable;
        synchronized (hashMap) {
            block8: {
                ServerTableEntry serverTableEntry = (ServerTableEntry)this.serverTable.remove(n2);
                if (serverTableEntry == null) {
                    if (this.debug) {
                        System.out.println("ServerManagerImpl: shutdown for server Id " + n + " throws ServerNotActive.");
                    }
                    throw new ServerNotActive(n);
                }
                try {
                    serverTableEntry.destroy();
                    if (this.debug) {
                        System.out.println("ServerManagerImpl: shutdown for server Id " + n + " completed.");
                    }
                }
                catch (Exception exception) {
                    if (!this.debug) break block8;
                    System.out.println("ServerManagerImpl: shutdown for server Id " + n + " threw exception " + exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerTableEntry getEntry(int n) throws ServerNotRegistered {
        Integer n2 = new Integer(n);
        ServerTableEntry serverTableEntry = null;
        HashMap hashMap = this.serverTable;
        synchronized (hashMap) {
            serverTableEntry = (ServerTableEntry)this.serverTable.get(n2);
            if (this.debug) {
                if (serverTableEntry == null) {
                    System.out.println("ServerManagerImpl: getEntry: no active server found.");
                } else {
                    System.out.println("ServerManagerImpl: getEntry:  active server found " + serverTableEntry + ".");
                }
            }
            if (serverTableEntry != null && !serverTableEntry.isValid()) {
                this.serverTable.remove(n2);
                serverTableEntry = null;
            }
            if (serverTableEntry == null) {
                ServerDef serverDef = this.repository.getServer(n);
                serverTableEntry = new ServerTableEntry(this.wrapper, n, serverDef, this.initialPort, this.dbDirName, false, this.debug);
                this.serverTable.put(n2, serverTableEntry);
                serverTableEntry.activate();
            }
        }
        return serverTableEntry;
    }

    private ServerLocation locateServer(ServerTableEntry serverTableEntry, String string, boolean bl) throws NoSuchEndPoint, ServerNotRegistered, ServerHeldDown {
        ServerLocation serverLocation = new ServerLocation();
        if (bl) {
            String string2;
            ORBPortInfo[] oRBPortInfoArray;
            try {
                oRBPortInfoArray = serverTableEntry.lookup(string);
            }
            catch (Exception exception) {
                if (this.debug) {
                    System.out.println("ServerManagerImpl: locateServer: server held down");
                }
                throw new ServerHeldDown(serverTableEntry.getServerId());
            }
            serverLocation.hostname = string2 = this.orb.getLegacyServerSocketManager().legacyGetEndpoint("DEFAULT_ENDPOINT").getHostName();
            int n = oRBPortInfoArray != null ? oRBPortInfoArray.length : 0;
            serverLocation.ports = new ORBPortInfo[n];
            for (int i = 0; i < n; ++i) {
                serverLocation.ports[i] = new ORBPortInfo(oRBPortInfoArray[i].orbId, oRBPortInfoArray[i].port);
                if (!this.debug) continue;
                System.out.println("ServerManagerImpl: locateServer: server located at location " + serverLocation.hostname + " ORBid  " + oRBPortInfoArray[i].orbId + " Port " + oRBPortInfoArray[i].port);
            }
        }
        return serverLocation;
    }

    private ServerLocationPerORB locateServerForORB(ServerTableEntry serverTableEntry, String string, boolean bl) throws InvalidORBid, ServerNotRegistered, ServerHeldDown {
        ServerLocationPerORB serverLocationPerORB = new ServerLocationPerORB();
        if (bl) {
            String string2;
            EndPointInfo[] endPointInfoArray;
            try {
                endPointInfoArray = serverTableEntry.lookupForORB(string);
            }
            catch (InvalidORBid invalidORBid) {
                throw invalidORBid;
            }
            catch (Exception exception) {
                if (this.debug) {
                    System.out.println("ServerManagerImpl: locateServerForORB: server held down");
                }
                throw new ServerHeldDown(serverTableEntry.getServerId());
            }
            serverLocationPerORB.hostname = string2 = this.orb.getLegacyServerSocketManager().legacyGetEndpoint("DEFAULT_ENDPOINT").getHostName();
            int n = endPointInfoArray != null ? endPointInfoArray.length : 0;
            serverLocationPerORB.ports = new EndPointInfo[n];
            for (int i = 0; i < n; ++i) {
                serverLocationPerORB.ports[i] = new EndPointInfo(endPointInfoArray[i].endpointType, endPointInfoArray[i].port);
                if (!this.debug) continue;
                System.out.println("ServerManagerImpl: locateServer: server located at location " + serverLocationPerORB.hostname + " endpointType  " + endPointInfoArray[i].endpointType + " Port " + endPointInfoArray[i].port);
            }
        }
        return serverLocationPerORB;
    }

    public String[] getORBNames(int n) throws ServerNotRegistered {
        try {
            ServerTableEntry serverTableEntry = this.getEntry(n);
            return serverTableEntry.getORBList();
        }
        catch (Exception exception) {
            throw new ServerNotRegistered(n);
        }
    }

    private ServerTableEntry getRunningEntry(int n) throws ServerNotRegistered {
        ServerTableEntry serverTableEntry = this.getEntry(n);
        try {
            ORBPortInfo[] oRBPortInfoArray = serverTableEntry.lookup("IIOP_CLEAR_TEXT");
        }
        catch (Exception exception) {
            return null;
        }
        return serverTableEntry;
    }

    public void install(int n) throws ServerNotRegistered, ServerHeldDown, ServerAlreadyInstalled {
        ServerTableEntry serverTableEntry = this.getRunningEntry(n);
        if (serverTableEntry != null) {
            this.repository.install(n);
            serverTableEntry.install();
        }
    }

    public void uninstall(int n) throws ServerNotRegistered, ServerHeldDown, ServerAlreadyUninstalled {
        ServerTableEntry serverTableEntry = (ServerTableEntry)this.serverTable.get(new Integer(n));
        if (serverTableEntry != null) {
            serverTableEntry = (ServerTableEntry)this.serverTable.remove(new Integer(n));
            if (serverTableEntry == null) {
                if (this.debug) {
                    System.out.println("ServerManagerImpl: shutdown for server Id " + n + " throws ServerNotActive.");
                }
                throw new ServerHeldDown(n);
            }
            serverTableEntry.uninstall();
        }
    }

    public ServerLocation locateServer(int n, String string) throws NoSuchEndPoint, ServerNotRegistered, ServerHeldDown {
        ServerTableEntry serverTableEntry = this.getEntry(n);
        if (this.debug) {
            System.out.println("ServerManagerImpl: locateServer called with  serverId=" + n + " endpointType=" + string + " block=true");
        }
        return this.locateServer(serverTableEntry, string, true);
    }

    public ServerLocationPerORB locateServerForORB(int n, String string) throws InvalidORBid, ServerNotRegistered, ServerHeldDown {
        ServerTableEntry serverTableEntry = this.getEntry(n);
        if (this.debug) {
            System.out.println("ServerManagerImpl: locateServerForORB called with  serverId=" + n + " orbId=" + string + " block=true");
        }
        return this.locateServerForORB(serverTableEntry, string, true);
    }

    public void handle(ObjectKey objectKey) {
        IOR iOR = null;
        ObjectKeyTemplate objectKeyTemplate = objectKey.getTemplate();
        int n = objectKeyTemplate.getServerId();
        String string = objectKeyTemplate.getORBId();
        try {
            ServerTableEntry serverTableEntry = this.getEntry(n);
            ServerLocationPerORB serverLocationPerORB = this.locateServerForORB(serverTableEntry, string, true);
            if (this.debug) {
                System.out.println("ServerManagerImpl: handle called for server id" + n + "  orbid  " + string);
            }
            int n2 = 0;
            EndPointInfo[] endPointInfoArray = serverLocationPerORB.ports;
            for (int i = 0; i < endPointInfoArray.length; ++i) {
                if (!endPointInfoArray[i].endpointType.equals("IIOP_CLEAR_TEXT")) continue;
                n2 = endPointInfoArray[i].port;
                break;
            }
            IIOPAddress iIOPAddress = IIOPFactories.makeIIOPAddress(this.orb, serverLocationPerORB.hostname, n2);
            IIOPProfileTemplate iIOPProfileTemplate = IIOPFactories.makeIIOPProfileTemplate(this.orb, GIOPVersion.V1_2, iIOPAddress);
            if (GIOPVersion.V1_2.supportsIORIIOPProfileComponents()) {
                iIOPProfileTemplate.add(IIOPFactories.makeCodeSetsComponent(this.orb));
                iIOPProfileTemplate.add(IIOPFactories.makeMaxStreamFormatVersionComponent());
            }
            IORTemplate iORTemplate = IORFactories.makeIORTemplate(objectKeyTemplate);
            iORTemplate.add(iIOPProfileTemplate);
            iOR = iORTemplate.makeIOR(this.orb, "IDL:org/omg/CORBA/Object:1.0", objectKey.getId());
        }
        catch (Exception exception) {
            throw this.wrapper.errorInBadServerIdHandler(exception);
        }
        if (this.debug) {
            System.out.println("ServerManagerImpl: handle throws ForwardException");
        }
        try {
            Thread.sleep(this.serverStartupDelay);
        }
        catch (Exception exception) {
            System.out.println("Exception = " + exception);
            exception.printStackTrace();
        }
        throw new ForwardException(this.orb, iOR);
    }

    public int getEndpoint(String string) throws NoSuchEndPoint {
        return this.orb.getLegacyServerSocketManager().legacyGetTransientServerPort(string);
    }

    public int getServerPortForType(ServerLocationPerORB serverLocationPerORB, String string) throws NoSuchEndPoint {
        EndPointInfo[] endPointInfoArray = serverLocationPerORB.ports;
        for (int i = 0; i < endPointInfoArray.length; ++i) {
            if (!endPointInfoArray[i].endpointType.equals(string)) continue;
            return endPointInfoArray[i].port;
        }
        throw new NoSuchEndPoint();
    }
}

