/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.activation;

import com.sun.corba.ee.impl.activation.NameServiceStartThread;
import com.sun.corba.ee.impl.activation.RepositoryImpl;
import com.sun.corba.ee.impl.activation.ServerManagerImpl;
import com.sun.corba.ee.impl.legacy.connection.SocketFactoryAcceptorImpl;
import com.sun.corba.ee.impl.naming.cosnaming.TransientNameService;
import com.sun.corba.ee.impl.orbutil.CorbaResourceUtil;
import com.sun.corba.ee.impl.transport.SocketOrChannelAcceptorImpl;
import com.sun.corba.ee.spi.activation.Activator;
import com.sun.corba.ee.spi.activation.ActivatorHelper;
import com.sun.corba.ee.spi.activation.Locator;
import com.sun.corba.ee.spi.activation.LocatorHelper;
import com.sun.corba.ee.spi.activation.RepositoryPackage.ServerDef;
import com.sun.corba.ee.spi.orb.ORB;
import java.io.File;
import java.util.Properties;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.INTERNAL;

public class ORBD {
    private int initSvcPort;
    protected File dbDir;
    private String dbDirName;
    protected Locator locator;
    protected Activator activator;
    protected RepositoryImpl repository;
    private static String[][] orbServers = new String[][]{{""}};

    protected void initializeBootNaming(ORB oRB) {
        this.initSvcPort = oRB.getORBData().getORBInitialPort();
        SocketOrChannelAcceptorImpl socketOrChannelAcceptorImpl = oRB.getORBData().getLegacySocketFactory() == null ? new SocketOrChannelAcceptorImpl(oRB, this.initSvcPort, "BOOT_NAMING", "IIOP_CLEAR_TEXT") : new SocketFactoryAcceptorImpl(oRB, this.initSvcPort, "BOOT_NAMING", "IIOP_CLEAR_TEXT");
        oRB.getCorbaTransportManager().registerAcceptor(socketOrChannelAcceptorImpl);
    }

    protected ORB createORB(String[] stringArray) {
        Properties properties = System.getProperties();
        properties.put("com.sun.CORBA.POA.ORBServerId", "1000");
        properties.put("com.sun.CORBA.POA.ORBPersistentServerPort", properties.getProperty("com.sun.CORBA.activation.Port", Integer.toString(1049)));
        properties.put("org.omg.CORBA.ORBClass", "com.sun.corba.ee.impl.orb.ORBImpl");
        return (ORB)((Object)ORB.init((String[])stringArray, (Properties)properties));
    }

    private void run(String[] stringArray) {
        try {
            Object object;
            this.processArgs(stringArray);
            ORB oRB = this.createORB(stringArray);
            if (oRB.orbdDebugFlag) {
                System.out.println("ORBD begins initialization.");
            }
            boolean bl = this.createSystemDirs("orb.db");
            this.startActivationObjects(oRB);
            if (bl) {
                this.installOrbServers(this.getRepository(), this.getActivator());
            }
            if (oRB.orbdDebugFlag) {
                System.out.println("ORBD is ready.");
                System.out.println("ORBD serverid: " + System.getProperty("com.sun.CORBA.POA.ORBServerId"));
                System.out.println("activation dbdir: " + System.getProperty("com.sun.CORBA.activation.DbDir"));
                System.out.println("activation port: " + System.getProperty("com.sun.CORBA.activation.Port"));
                object = System.getProperty("com.sun.CORBA.activation.ServerPollingTime");
                if (object == null) {
                    object = Integer.toString(1000);
                }
                System.out.println("activation Server Polling Time: " + (String)object + " milli-seconds ");
                String string = System.getProperty("com.sun.CORBA.activation.ServerStartupDelay");
                if (string == null) {
                    string = Integer.toString(1000);
                }
                System.out.println("activation Server Startup Delay: " + string + " milli-seconds ");
            }
            object = new NameServiceStartThread(oRB, this.dbDir);
            ((Thread)object).start();
            oRB.run();
        }
        catch (COMM_FAILURE cOMM_FAILURE) {
            System.out.println(CorbaResourceUtil.getText("orbd.commfailure"));
            System.out.println((Object)cOMM_FAILURE);
            cOMM_FAILURE.printStackTrace();
        }
        catch (INTERNAL iNTERNAL) {
            System.out.println(CorbaResourceUtil.getText("orbd.internalexception"));
            System.out.println((Object)iNTERNAL);
            iNTERNAL.printStackTrace();
        }
        catch (Exception exception) {
            System.out.println(CorbaResourceUtil.getText("orbd.usage", "orbd"));
            System.out.println(exception);
            exception.printStackTrace();
        }
    }

    private void processArgs(String[] stringArray) {
        Properties properties = System.getProperties();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-port")) {
                if (i + 1 < stringArray.length) {
                    properties.put("com.sun.CORBA.activation.Port", stringArray[++i]);
                    continue;
                }
                System.out.println(CorbaResourceUtil.getText("orbd.usage", "orbd"));
                continue;
            }
            if (stringArray[i].equals("-defaultdb")) {
                if (i + 1 < stringArray.length) {
                    properties.put("com.sun.CORBA.activation.DbDir", stringArray[++i]);
                    continue;
                }
                System.out.println(CorbaResourceUtil.getText("orbd.usage", "orbd"));
                continue;
            }
            if (stringArray[i].equals("-serverid")) {
                if (i + 1 < stringArray.length) {
                    properties.put("com.sun.CORBA.POA.ORBServerId", stringArray[++i]);
                    continue;
                }
                System.out.println(CorbaResourceUtil.getText("orbd.usage", "orbd"));
                continue;
            }
            if (stringArray[i].equals("-serverPollingTime")) {
                if (i + 1 < stringArray.length) {
                    properties.put("com.sun.CORBA.activation.ServerPollingTime", stringArray[++i]);
                    continue;
                }
                System.out.println(CorbaResourceUtil.getText("orbd.usage", "orbd"));
                continue;
            }
            if (!stringArray[i].equals("-serverStartupDelay")) continue;
            if (i + 1 < stringArray.length) {
                properties.put("com.sun.CORBA.activation.ServerStartupDelay", stringArray[++i]);
                continue;
            }
            System.out.println(CorbaResourceUtil.getText("orbd.usage", "orbd"));
        }
    }

    protected boolean createSystemDirs(String string) {
        File file;
        boolean bl = false;
        Properties properties = System.getProperties();
        String string2 = properties.getProperty("file.separator");
        this.dbDir = new File(properties.getProperty("com.sun.CORBA.activation.DbDir", properties.getProperty("user.dir") + string2 + string));
        this.dbDirName = this.dbDir.getAbsolutePath();
        properties.put("com.sun.CORBA.activation.DbDir", this.dbDirName);
        if (!this.dbDir.exists()) {
            this.dbDir.mkdir();
            bl = true;
        }
        if (!(file = new File(this.dbDir, "logs")).exists()) {
            file.mkdir();
        }
        return bl;
    }

    protected File getDbDir() {
        return this.dbDir;
    }

    protected String getDbDirName() {
        return this.dbDirName;
    }

    protected void startActivationObjects(ORB oRB) throws Exception {
        this.initializeBootNaming(oRB);
        this.repository = new RepositoryImpl(oRB, this.dbDir, oRB.orbdDebugFlag);
        oRB.register_initial_reference("ServerRepository", this.repository);
        ServerManagerImpl serverManagerImpl = new ServerManagerImpl(oRB, oRB.getCorbaTransportManager(), this.repository, this.getDbDirName(), oRB.orbdDebugFlag);
        this.locator = LocatorHelper.narrow(serverManagerImpl);
        oRB.register_initial_reference("ServerLocator", this.locator);
        this.activator = ActivatorHelper.narrow(serverManagerImpl);
        oRB.register_initial_reference("ServerActivator", this.activator);
        TransientNameService transientNameService = new TransientNameService(oRB, "TNameService");
    }

    protected Locator getLocator() {
        return this.locator;
    }

    protected Activator getActivator() {
        return this.activator;
    }

    protected RepositoryImpl getRepository() {
        return this.repository;
    }

    protected void installOrbServers(RepositoryImpl repositoryImpl, Activator activator) {
        for (int i = 0; i < orbServers.length; ++i) {
            try {
                String[] stringArray = orbServers[i];
                ServerDef serverDef = new ServerDef(stringArray[1], stringArray[2], stringArray[3], stringArray[4], stringArray[5]);
                int n = Integer.valueOf(orbServers[i][0]);
                repositoryImpl.registerServer(serverDef, n);
                activator.activate(n);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void main(String[] stringArray) {
        ORBD oRBD = new ORBD();
        oRBD.run(stringArray);
    }
}

