/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.activation;

import com.sun.corba.ee.impl.activation.CommandHandler;
import com.sun.corba.ee.impl.activation.ListServers;
import com.sun.corba.ee.impl.orbutil.CorbaResourceUtil;
import com.sun.corba.ee.spi.activation.Activator;
import com.sun.corba.ee.spi.activation.ActivatorHelper;
import com.sun.corba.ee.spi.activation.Repository;
import com.sun.corba.ee.spi.activation.RepositoryHelper;
import com.sun.corba.ee.spi.activation.RepositoryPackage.ServerDef;
import com.sun.corba.ee.spi.activation.ServerNotRegistered;
import java.io.PrintStream;
import org.omg.CORBA.ORB;

class ListActiveServers
implements CommandHandler {
    ListActiveServers() {
    }

    public String getCommandName() {
        return "listactive";
    }

    public void printCommandHelp(PrintStream printStream, boolean bl) {
        if (!bl) {
            printStream.println(CorbaResourceUtil.getText("servertool.listactive"));
        } else {
            printStream.println(CorbaResourceUtil.getText("servertool.listactive1"));
        }
    }

    public boolean processCommand(String[] stringArray, ORB oRB, PrintStream printStream) {
        try {
            Repository repository = RepositoryHelper.narrow(oRB.resolve_initial_references("ServerRepository"));
            Activator activator = ActivatorHelper.narrow(oRB.resolve_initial_references("ServerActivator"));
            int[] nArray = activator.getActiveServers();
            printStream.println(CorbaResourceUtil.getText("servertool.list2"));
            ListServers.sortServers(nArray);
            for (int i = 0; i < nArray.length; ++i) {
                try {
                    ServerDef serverDef = repository.getServer(nArray[i]);
                    printStream.println("\t   " + nArray[i] + "\t\t" + serverDef.serverName + "\t\t" + serverDef.applicationName);
                    continue;
                }
                catch (ServerNotRegistered serverNotRegistered) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }
}

