/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.web.cache.mapping;

import com.sun.appserv.web.cache.mapping.Constants;
import com.sun.appserv.web.cache.mapping.Field;
import com.sun.appserv.web.cache.mapping.ValueConstraint;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class ConstraintField
extends Field {
    private static Logger _logger = null;
    private static boolean _isTraceEnabled = false;
    boolean cacheOnMatch = true;
    boolean cacheOnMatchFailure = false;
    ValueConstraint[] constraints = new ValueConstraint[0];

    public ConstraintField(String name, String scope) throws IllegalArgumentException {
        super(name, scope);
        if (_logger == null) {
            _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
            _isTraceEnabled = _logger.isLoggable(Level.FINE);
        }
    }

    public void setCacheOnMatch(boolean cacheOnMatch) {
        this.cacheOnMatch = cacheOnMatch;
    }

    public boolean getCacheOnMatch() {
        return this.cacheOnMatch;
    }

    public void setCacheOnMatchFailure(boolean cacheOnMatchFailure) {
        this.cacheOnMatchFailure = cacheOnMatchFailure;
    }

    public boolean getCacheOnMatchFailure() {
        return this.cacheOnMatchFailure;
    }

    public void addConstraint(ValueConstraint constraint) {
        if (constraint == null) {
            return;
        }
        ValueConstraint[] results = new ValueConstraint[this.constraints.length + 1];
        for (int i = 0; i < this.constraints.length; ++i) {
            results[i] = this.constraints[i];
        }
        results[this.constraints.length] = constraint;
        this.constraints = results;
    }

    public void setValueConstraints(ValueConstraint[] vcs) {
        if (vcs == null) {
            return;
        }
        this.constraints = vcs;
    }

    public boolean applyConstraints(ServletContext context, HttpServletRequest request) {
        Object value = this.getValue(context, request);
        if (value == null) {
            if (_isTraceEnabled) {
                _logger.fine("The constraint field " + this.name + " is not found in the scope " + Constants.SCOPE_NAMES[this.scope] + "; returning cache-on-match-failure: " + this.cacheOnMatchFailure);
            }
            return this.cacheOnMatchFailure;
        }
        if (this.constraints.length == 0) {
            if (_isTraceEnabled) {
                _logger.fine("The constraint field " + this.name + " value = " + value.toString() + " is found in the scope " + Constants.SCOPE_NAMES[this.scope] + "; returning cache-on-match: " + this.cacheOnMatch);
            }
            return this.cacheOnMatch;
        }
        for (int i = 0; i < this.constraints.length; ++i) {
            ValueConstraint c = this.constraints[i];
            if (!c.matches(value)) continue;
            if (_isTraceEnabled) {
                _logger.fine("The constraint field " + this.name + " value = " + value.toString() + " is found in the scope " + Constants.SCOPE_NAMES[this.scope] + "; and matches with a value " + c.toString() + "; returning cache-on-match: " + this.cacheOnMatch);
            }
            return this.cacheOnMatch;
        }
        if (_isTraceEnabled) {
            _logger.fine("The constraint field " + this.name + " value = " + value.toString() + " is found in the scope " + Constants.SCOPE_NAMES[this.scope] + "; but didn't match with any of the value constraints; returning cache-on-match-failure = " + this.cacheOnMatchFailure);
        }
        return this.cacheOnMatchFailure;
    }
}

