


proc build_uninstall_context_instance { xserverroot xInstance } {


    set x(cdsHost) ""
    set x(cdsPort) "" 
    set x(user) ""
    set x(password) ""
    set x(domain) ""
    
    set instanceRoot [file join ${xserverroot} ${xInstance}]

    # create a file per instance of DPS
    # uninstallContext.tcl

    set ucName [file join $instanceRoot  uninstallContext.tcl]


    # Read tailor to get infos to access CDS
    set tailorName [file join $instanceRoot  etc tailor.txt]        
    set tailorFile [open ${tailorName} r+ ]

    # prepare uninstall context file for write
    set ucName [file join ${instanceRoot} uninstallContext.tcl]
    set ucFile [open ${ucName} w+ ]
        
    puts $ucFile "proc init \{ xName \} \{"
    puts $ucFile "upvar \$xName x"
    
    while {[gets $tailorFile line] >= 0} {
	if [regexp "configuration_url" $line] {
	    set lin [split $line "/"]
	    set fullyHostName [lindex $lin 2]
	    set cdsHost  [lindex  [split $fullyHostName ":"] 0]
	    puts $ucFile "set x(cdsHost) \"$cdsHost\""
	    set cdsPort  [lindex  [split $fullyHostName ":"] 1]
	    puts $ucFile "set x(cdsPort) \"$cdsPort\""
	    set fulldn [lindex $lin 3]
	    set ou_index [string first " ou=" $fulldn]
	    set ou [string range $fulldn $ou_index [string length $fulldn]]
	    puts stdout "ou = : $ou"
	    set ou_val [lindex [split $ou "="] 1]
	    puts stdout "ou_val = : $ou_val"
	    #set ou_val [string range $ou [lindex [split $ou "="] 1] [string length $ou]]
	    set domain [lindex [split $ou_val "," ] 0]
	    puts stdout "domain = : $domain"
	    puts $ucFile "set x(domain) \"$domain\""
	} else {
	    if [regexp "configuration_bind_dn" $line] {
		set user [lindex [split $line ":"] 1]
		set user1 [string range  $user 1 [string length $user]]
		puts $ucFile "set x(user) \"$user1\""
	    } else {
		if [regexp "configuration_bind_pw" $line] {
		    set password [string trim [lindex [split $line ":"] 1] " "]
		    puts $ucFile "set x(password) \"$password\""
		}
	    }
	}
    }
    
    puts $ucFile "\}"
    
    close $tailorFile
    close $ucFile
}

##########
# main
##########

#   argv0 : command name argv[0] : -serverroot  argv[1] : serverroot



# variables that must be extracted (used in sync-dps-cds.tcl)
# x(cdsHost)
# x(cdsPort)
# x(domain)
# x(password)
# x(user)

set ok  0

#foreach i $argv {
#    if {$i == "-serverroot" } {
#	set ok 1 }
#    elseif {$ok == 1 }
#    {
#	set xerverroot $i
#    }
#}
 
foreach i $argv {
    set xserverroot $i
}

# the following lines have been added for windows
# the former catch {glob $xserverroot/dps-*  won't work on Windows

cd $xserverroot
set current [pwd ]

    # instance by instance part of the job
    if [catch {glob dps-* } iList] {
	set result "No DPS instances in $xserverroot.\n"
    } else {
	if [expr [llength $iList] > 0] {
	    foreach i $iList {
		set xinstance [file tail "$i"]
		puts stdout "calling build_install_context_instance on instance $xinstance"
		append result [build_uninstall_context_instance  $xserverroot $xinstance]
	    }
	}
    }
    return $result
}

