#!/usr/bin/perl

use File::Copy;
use File::Basename;
use File::Spec;
use File::Path;

# the following parameters are set-up at build time

$BUILD_NUMBER = "20041109.140213";
$DPS_PACKAGE = "5.2Patch3.tar.gz";
$IS_WINDOWS = 0;
$USE_NATIVE_ZIP = 1;
$BUILD_NUMBER = "20041118.140516";
#$DPS_PACKAGE = "5.2Patch3.tar.gz";
$DPS_PACKAGE = "5.2Patch3.tar.gz";

sub change_dir {
  my $dir = shift;
  print "Change dir to $dir\n";
  return chdir $dir;
}

sub cmd {
  $c = shift;
  print "$c\n";
  system("$c");
  if( $? ) {
    print "Error: $!, exiting\n";
    exit 1;
  }
}

sub cmd_silent {
  $c = shift;
  system("$c");
  if( $? ) {
    print "Error: $!, exiting\n";
    exit 1;
  }
}

sub cmd_noerr {
  $c = shift;
  print "$c\n";
  system("$c");
  if( $? ) {
    return 1;
  }
  return 0;
}

sub cp {
  my $c1 = shift; my $c2 = shift;
  print "cp $c1 $c2\n";
  my $res = copy $c1, $c2;
  if( ! $res ) {
    print "Error, $!\n";
  }
  return $res;
}

sub mv {
  my $c1 = shift; my $c2 = shift;
  print "mv $c1 $c2\n";
  my $res = move $c1, $c2;
  if( ! $res ) {
    print "Error, $!\n";
  }
  return $res;
}

sub unzip {
  my $pkg = shift;
  if( $USE_NATIVE_ZIP ) {
    cmd "unzip -q -o $pkg";
  }
  else {
    my $unzip_cmd = File::Spec->catdir("$CUR_DIR", "unzip");
    chmod 0755, "$unzip_cmd";
    cmd "$unzip_cmd -q -o $pkg";
  }
}

sub sav_tmp {
  my $SAV = shift;
  my $time_ext = shift;
    if( -f "$SAV" ) {
      print "saving $SAV\n";
      mv "$SAV", "$SAV.ref-$time_ext";
  }
}


sub rest_tmp {
  my $SAV = shift;
  my $time_ext = shift;
    if( -f "$SAV.ref-$time_ext" ) {
     print "restoring $SAV\n";
     unlink "$SAV";
     mv "$SAV.ref-$time_ext", "$SAV";
  }
}

if($IS_WINDOWS) {
  $CUR_DIR = `chdir`; chop $CUR_DIR;
}
else {
  $CUR_DIR = `pwd`; chop $CUR_DIR;
}

# syntax windows : upgrade.pl "<SERVER_ROOT>" <ADMIN ID> <ADMIN PASSWORD> <UPGRADE_ADMIN>
# syntax windows : upgrade.pl "<SERVER_ROOT>" <UPGRADE_ADMIN>

$SERVER_ROOT    = $ARGV[0];

if($IS_WINDOWS) {
    $UPGRADE_ADMIN  = $ARGV[3];
}				 
else				 
{
    $UPGRADE_ADMIN  = $ARGV[1];
}

my @upgrade_time = localtime(time);
my $time_ext = sprintf("%d%02d%02d-%02d:%02d", 
		       $upgrade_time[5]+1900, $upgrade_time[4], $upgrade_time[3],
		       $upgrade_time[2], $upgrade_time[1]);

my $CREDS_FILE = File::Spec->catfile("$CUR_DIR", "creds");
if($IS_WINDOWS) {
  open(CREDS, ">creds") || die "Could not create : creds, $!";
  print CREDS "Admin Id: $ARGV[1]\n";
  print CREDS "Admin Password: $ARGV[2]\n";
  close CREDS;
}

my $DPS_installed = 0;

if($IS_WINDOWS) {
print  "Please stop all DS instances under this server root <HIT RETURN>\n";
$key = getc() ;
}

# We need first to stop all instances of the DPS server
opendir(SERVERDIR, "$SERVER_ROOT") || die "Could not open directory : $SERVER_ROOT, $!";
@instance_dirs = grep { /^dps-/ } readdir SERVERDIR;
for (@instance_dirs) {
  my $stop_dps_dir = File::Spec->catfile("$SERVER_ROOT", $_);
  if( -d $stop_dps_dir) {
      $DPS_installed =  1 ;
    change_dir $stop_dps_dir || die "Could not change dir to $stop_dps_dir";

    my $stop_dps = File::Spec->catfile(File::Spec->curdir(), "stop-dps");
#not correct on windows    if( -x $stop_dps ) {
      print "Stopping instance : $_\n";
      cmd_noerr "$stop_dps";
#    }
  }
}

# And to stop the admin server (wether or not we want to upgrade the admin server)

my $stop_admin = File::Spec->catfile("$SERVER_ROOT", "stop-admin");
print "Stopping the admin server...\n";
cmd_noerr $stop_admin;


change_dir $CUR_DIR;

if ($DPS_installed) {

    ($dpspkg_file, $dpspkg_path, $d_suf) = fileparse("$DPS_PACKAGE", ".gz", ".zip");

    if( "$d_suf" eq ".gz" ) {
	# Might have already been gunzip'ed
	if( -f "$DPS_PACKAGE" ) {
	    cmd "gunzip $DPS_PACKAGE";
	}
	cp "$dpspkg_file", "$SERVER_ROOT";
	change_dir $SERVER_ROOT;

	open( TAR, "tar tf $dpspkg_file |") || die "tar tf $dpspkg_file : $!";
	while( <TAR> ) {
	    chomp;
	    if( -f "$_" ) {
		mv "$_", "$_.ref-$time_ext";
	    }
	}
	close TAR;
	cmd "tar xvf $dpspkg_file";
	unlink File::Spec->catfile("$SERVER_ROOT", "$dpspkg_file");
    }
    elsif ( "$d_suf" eq ".zip" ) {
	cp "$DPS_PACKAGE", "$SERVER_ROOT";
	chdir $SERVER_ROOT;
	unzip "$DPS_PACKAGE";
	unlink File::Spec->catfile("$SERVER_ROOT", "$DPS_PACKAGE");
    }
    else {
	print "Don't know how to handle this type of file : $DPS_PACKAGE\n";
	exit 1;
    }
}

change_dir $CUR_DIR;

 
cp "nsbase.zip", "$SERVER_ROOT";
cp "nsclient.zip", "$SERVER_ROOT";
cp "nsjre.zip", "$SERVER_ROOT";
if ($UPGRADE_ADMIN eq "UPGRADE_ADMIN") {
    cp "nsadmin.zip", "$SERVER_ROOT";
    cp "nsadminclient.zip", "$SERVER_ROOT";
}


if($IS_WINDOWS) {
  cp "dpsproperties.zip", "$SERVER_ROOT";

  $SYSTEM_DIR = $ENV{SystemRoot};
  $nss_d = File::Spec->catfile("$SERVER_ROOT",bin,https,bin);

  $SYSTEM_DIR = File::Spec->catfile($SYSTEM_DIR, "SYSTEM32");
  cp "nsbasesys.zip", "$SYSTEM_DIR";
  if( -d $nss_d ) {
  cp "nsbasesys.zip", "$nss_d";
  }
}

change_dir $SERVER_ROOT;

sav_tmp "shared/config/certmap.conf", "$time_ext";
sav_tmp "userdb/certmap.conf","$time_ext";

unzip "nsbase.zip";
unzip "nsclient.zip";
unzip "nsjre.zip";
if ($UPGRADE_ADMIN eq "UPGRADE_ADMIN") {
    unzip "nsadmin.zip";
    unzip "nsadminclient.zip";
}
unlink "nsbase.zip";
unlink "nsclient.zip";
unlink "nsjre.zip";
if ($UPGRADE_ADMIN eq "UPGRADE_ADMIN") {
    unlink "nsadmin.zip";
    unlink "nsadminclient.zip";
}

rest_tmp "shared/config/certmap.conf", "$time_ext";
rest_tmp "userdb/certmap.conf", "$time_ext";

if($IS_WINDOWS) {
  chdir $SERVER_ROOT ;
  unzip "dpsproperties.zip" ;  
  chdir $SYSTEM_DIR;
  unzip "nsbasesys.zip";
  unlink "nsbasesys.zip";
# 5.2rtm has delivered nss on 2 places on windows, so we have to replace it in the 2 places
  if ( -d $nss_d ) {
    change_dir $nss_d;
    unzip "nsbasesys.zip";
    unlink "nsbasesys.zip";
  }
}

sleep(5);

# Now restart the DPS servers
if ($DPS_installed) {
    for (@instance_dirs) {
	my $start_dir = File::Spec->catfile("$SERVER_ROOT","$_");
	if( -d $start_dir) {
	    print "cd $start_dir\n";
	    chdir $start_dir;
	    my $start_dps = File::Spec->catfile(File::Spec->curdir(), "start-dps");
# not correct on windows if( -x  $start_dps) {
		print "Starting instance : $_\n";
		cmd "$start_dps";
#	    }
	}
    }
}

sleep(30);
				
if($IS_WINDOWS) {
# need to restart CDS (if local) when upgrading AS
print  "Please make sure that the Configuration DS is started <HIT RETURN>\n";
$key = getc() ;
}

if ("$UPGRADE_ADMIN" eq "UPGRADE_ADMIN") {
    
    chdir File::Spec->catdir("$SERVER_ROOT", "bin", "admin");
    my $sync_admin = File::Spec->catfile(File::Spec->curdir(), "sync-admin");
    $sync_admin = $sync_admin . " upgrade -r $SERVER_ROOT";

    print "Upgrading the Administration Server...\n";
    my $res = cmd_noerr $sync_admin;
    if( $res ) {
	print "Warning, sync-admin upgrade returned with error, the upgrade might have already been done ?\n";
    }

    my $sync_admin_cds = File::Spec->catfile(File::Spec->curdir(), "sync-admin-cds");
    $sync_admin_cds = $sync_admin_cds . " -r $SERVER_ROOT";

    if($IS_WINDOWS) {		
	$sync_admin_cds .= " -f $CREDS_FILE";
    }
				 
    print "Updating the Configuration Directory Server for the Admin Server...\n";
    $res = cmd_noerr $sync_admin_cds;
    if( $res ) {
	print "Warning, sync-admin-cds returned with error\n";
    }				 
}

if ($DPS_installed) {
    my $sync_dps = File::Spec->catfile("$SERVER_ROOT", 
					 "bin",
					 "dps",
					 "install",
					 "script",
					 "sync-dps.tcl");
				 
    my $sync_dps_cds =  File::Spec->catfile("$SERVER_ROOT", 
					    "bin",					
					    "dps",		       
					    "install", 
					    "script",			 
					    "sync-dps-cds.tcl");


    my $as_bin = File::Spec->catfile("$AS_BASEDIR",
				     "usr",
				     "sadm",
				     "mps",
				     "admin",
				     "v5.2", 
				     "bin");


    my $tcl_shell = File::Spec->catfile("$SERVER_ROOT", "bin", "tcl8.2", "tclsh ");

    $sync_dps = $tcl_shell . $sync_dps . " -syncType upgrade -cid $SERVER_ROOT -serverroot $SERVER_ROOT ";

    # first create the uninstallContext.tcl file for each DPS instance

    print "creating uninstallContext.tcl\n" ;
    $create_context = $tcl_shell . " $CUR_DIR/build_uninstall_context.tcl -serverroot $SERVER_ROOT" ;
    $res = cmd $create_context ;
    
    $res = cmd $sync_dps;
    if( $res ) {
	print "Warning, sync_dps returned with error\n";
    }
    else
    {
	$sync_dps_cds = $tcl_shell . $sync_dps_cds . " -cid $SERVER_ROOT -serverroot $SERVER_ROOT -verbose";
	
	$res = cmd $sync_dps_cds;
	if( $res ) {
	    print "Warning, sync_dps_cds returned with error\n";
	}			
#    error code ?
    }				
}    

# And start the admin server

my $start_admin = File::Spec->catfile("$SERVER_ROOT", "start-admin");

print "Starting the admin server...\n";
cmd $start_admin;


unlink "$CREDS_FILE";

print "\n\nDone\n\n";



