/*
 * @(#) 1.10
 *
 * Copyright 2003 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

#ifndef MQ_DESTINATION_H
#define MQ_DESTINATION_H

/*
 * declarations of C interface for destination
 */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include "mqtypes.h"

/**
 * Frees the destination object specified by destinationHandle.
 *
 * @param destinationHandle the destination to free.
 * @return the status of the function call.  Pass this value to
 *         MQStatusIsError to determine if the call was
 *         successful.  */
EXPORTED_SYMBOL MQStatus 
MQFreeDestination(MQDestinationHandle destinationHandle);

/**
 * Get the destination type of a destination 
 *
 * @param destinationHandle the destination to type from
 * @param destinationType the output parameter for the type
 * @return the status of the function call.  Pass this value to
 *         MQStatusIsError to determine if the call was
 *         successful.  */
EXPORTED_SYMBOL MQStatus
MQGetDestinationType(const MQDestinationHandle destinationHandle,
                     MQDestinationType *       destinationType);

/**
 * Get the destination name of a destination. The returned  
 * destinationName is a copy which the caller is responsible
 * to free by calling MQFreeString
 *
 * @param destinationHandle the destination to get name from
 * @param destinationName the output parameter for the name 
 * @return the status of the function call.  Pass this value to
 *         MQStatusIsError to determine if the call was
 *         successful.  */
EXPORTED_SYMBOL MQStatus
MQGetDestinationName(const MQDestinationHandle destinationHandle,
                     MQString *                destinationName);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* MQ_DESTINATION_H */
