/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.transport.httptunnel;

import com.sun.messaging.jmq.transport.httptunnel.HttpTunnelPacket;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class Link
extends Thread {
    private boolean connected = false;
    protected boolean done = false;
    protected InputStream is = null;
    protected OutputStream os = null;
    private static boolean DEBUG = Boolean.getBoolean("httptunnel.debug");

    protected abstract void createLink();

    protected abstract void receivePacket(HttpTunnelPacket var1);

    protected abstract void handleLinkDown();

    public synchronized void sendPacket(HttpTunnelPacket httpTunnelPacket) {
        if (DEBUG) {
            System.out.println("Sending packet : " + httpTunnelPacket);
        }
        try {
            httpTunnelPacket.writePacket(this.os);
        }
        catch (Exception exception) {
            if (DEBUG) {
                System.out.println(exception);
            }
            this.linkDown();
        }
    }

    protected void linkDown() {
        try {
            this.is.close();
            this.os.close();
            this.handleLinkDown();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.connected = false;
    }

    public void shutdown() {
        this.done = true;
    }

    public void run() {
        while (!this.done) {
            try {
                if (!this.connected) {
                    this.createLink();
                    this.connected = true;
                }
                HttpTunnelPacket httpTunnelPacket = new HttpTunnelPacket();
                httpTunnelPacket.readPacket(this.is);
                this.receivePacket(httpTunnelPacket);
            }
            catch (IllegalStateException illegalStateException) {
                if (DEBUG) {
                    System.out.println(illegalStateException);
                }
                this.done = true;
            }
            catch (Exception exception) {
                if (DEBUG) {
                    System.out.println(exception);
                }
                this.linkDown();
            }
        }
    }
}

