/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConstants;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBTool;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.JDBCStore;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.persist.util.Util301To350;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;

public class UpgradeStore
implements DBConstants {
    private static BrokerResources br = Globals.getBrokerResources();
    private static Logger logger = Globals.getLogger();
    boolean supportBatch = true;

    static void upgradeStore(JDBCStore jDBCStore, DBManager dBManager, Connection connection) throws BrokerException {
        Object[] objectArray = new Object[]{new Integer(350)};
        logger.logToAll(8, "B1115", objectArray);
        if (jDBCStore.resetMessage()) {
            logger.logToAll(8, "B1101");
            logger.logToAll(8, "B1102");
        } else if (jDBCStore.resetInterest()) {
            logger.logToAll(8, "B1103");
            logger.logToAll(8, "B1102");
        }
        try {
            DBTool.createTables(dBManager, connection);
            connection.setAutoCommit(false);
        }
        catch (SQLException sQLException) {
            throw new BrokerException("Failed to create new tables during upgrade", sQLException);
        }
        try {
            UpgradeStore.upgradeDestinations(jDBCStore, connection);
            UpgradeStore.upgradeMessages(jDBCStore, connection);
            UpgradeStore.upgradeInterests(jDBCStore, connection);
            UpgradeStore.upgradeTxns(jDBCStore, connection);
            UpgradeStore.upgradeChangeRecords(jDBCStore, connection);
            UpgradeStore.upgradeProperties(jDBCStore, connection);
            logger.logToAll(8, "B1106");
            if (jDBCStore.upgradeNoBackup()) {
                UpgradeStore.dropTable(connection, "IMQSV" + jDBCStore.brokerid);
            } else {
                logger.logToAll(8, "B1121");
            }
        }
        catch (BrokerException brokerException) {
            logger.log(8, "B1116");
            try {
                DBTool.dropTables(connection, true, logger, dBManager.getTableNames(350));
            }
            catch (SQLException sQLException) {
                logger.log(32, "Failed to clean up new tables after upgrade failed", sQLException);
            }
        }
    }

    static void upgradeDestinations(JDBCStore jDBCStore, Connection connection) throws BrokerException {
        String string = "IMQDEST" + jDBCStore.brokerid;
        String string2 = "IMQDEST35" + jDBCStore.brokerid;
        int n = 1;
        String string3 = "SELECT DEST FROM " + string;
        String string4 = Util.getInsertDestinationSQL(string2);
        Statement statement = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Destination destination = null;
        try {
            statement = connection.createStatement();
            preparedStatement = connection.prepareStatement(string4);
            resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                destination = (Destination)Util.readObject(resultSet, n);
                String string5 = destination.getUniqueName();
                if (Store.DEBUG) {
                    logger.log(4, "LOADED:" + string5);
                }
                try {
                    preparedStatement.setString(Util.insertDstDIDIndex, string5);
                    ByteArrayInputStream byteArrayInputStream = Util.setObject(preparedStatement, Util.insertDstDestIndex, destination);
                    byteArrayInputStream.close();
                    if (jDBCStore.supportBatch) {
                        preparedStatement.addBatch();
                        continue;
                    }
                    preparedStatement.executeUpdate();
                }
                catch (IOException iOException) {
                    IOException iOException2 = DBManager.wrapIOException("[" + string4 + "]", iOException);
                    throw iOException2;
                }
                catch (SQLException sQLException) {
                    SQLException sQLException2 = DBManager.wrapSQLException("[" + string4 + "]", sQLException);
                    throw sQLException2;
                }
            }
            resultSet.close();
            statement.close();
            if (jDBCStore.supportBatch) {
                preparedStatement.executeBatch();
            }
            connection.commit();
            preparedStatement.close();
            if (jDBCStore.upgradeNoBackup()) {
                UpgradeStore.dropTable(connection, string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.log(32, "B4162", (Object)(destination == null ? "loading" : destination.getUniqueName()), (Throwable)classNotFoundException);
            throw new BrokerException(br.getString("B4162", destination == null ? "loading" : destination.getUniqueName()), classNotFoundException);
        }
        catch (IOException iOException) {
            logger.log(32, "B4162", (Object)(destination == null ? "loading" : destination.getUniqueName()), (Throwable)iOException);
            throw new BrokerException(br.getString("B4162", destination == null ? "loading" : destination.getUniqueName()), iOException);
        }
        catch (SQLException sQLException) {
            logger.log(32, "B4162", (Object)(destination == null ? "loading" : destination.getUniqueName()), (Throwable)sQLException);
            throw new BrokerException(br.getString("B4162", destination == null ? "loading" : destination.getUniqueName()), sQLException);
        }
    }

    private static void upgradeMessages(JDBCStore jDBCStore, Connection connection) throws BrokerException {
        String string = "IMQMSG" + jDBCStore.brokerid;
        String string2 = "IMQILIST" + jDBCStore.brokerid;
        ResultSet resultSet = null;
        String string3 = null;
        int n = 0;
        Statement statement = null;
        try {
            string3 = "SELECT COUNT(MID) FROM " + string;
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string3);
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            logger.log(32, "B4166", (Object)string3, (Throwable)sQLException);
            throw new BrokerException(br.getString("B4166", string3), sQLException);
        }
        if (Store.DEBUG) {
            logger.log(4, "number of messages in old table = " + n);
        }
        boolean bl = jDBCStore.upgradeNoBackup();
        if (n == 0) {
            if (bl) {
                UpgradeStore.dropTable(connection, string);
                UpgradeStore.dropTable(connection, string2);
            }
        } else if (jDBCStore.resetMessage()) {
            if (bl) {
                UpgradeStore.dropTable(connection, string);
                UpgradeStore.dropTable(connection, string2);
            } else {
                UpgradeStore.clearTable(connection, string);
                UpgradeStore.clearTable(connection, string2);
            }
        } else {
            Object[] objectArray = new Object[]{new Integer(n)};
            logger.logToAll(8, "B1118", objectArray);
            UpgradeStore.doUpgradeMsg(jDBCStore, connection);
            if (jDBCStore.upgradeNoBackup()) {
                UpgradeStore.dropTable(connection, string);
                UpgradeStore.dropTable(connection, string2);
            }
        }
    }

    private static void doUpgradeMsg(JDBCStore jDBCStore, Connection connection) throws BrokerException {
        Object object;
        String string = "IMQMSG" + jDBCStore.brokerid;
        String string2 = "IMQILIST" + jDBCStore.brokerid;
        String string3 = "IMQMSG35" + jDBCStore.brokerid;
        String string4 = "IMQILIST35" + jDBCStore.brokerid;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = 1;
        String string5 = "SELECT MSG FROM " + string;
        String string6 = Util.getInsertMessageSQL(string3);
        PreparedStatement preparedStatement = null;
        Statement statement = null;
        ResultSet resultSet = null;
        Packet packet = null;
        try {
            statement = connection.createStatement();
            preparedStatement = connection.prepareStatement(string6);
            resultSet = statement.executeQuery(string5);
            while (resultSet.next()) {
                Object object2;
                packet = new Packet(false);
                packet.generateTimestamp(false);
                packet.generateSequenceNumber(false);
                InputStream inputStream = resultSet.getBinaryStream(n);
                packet.readPacket(inputStream);
                inputStream.close();
                String string7 = packet.getSysMessageID().getUniqueName();
                String string8 = DestinationUID.getUniqueString(packet.getDestination(), packet.getIsQueue());
                int n2 = packet.getPacketSize();
                try {
                    preparedStatement.setString(Util.insertMsgMIDIndex, string7);
                    preparedStatement.setString(Util.insertMsgDIDIndex, string8);
                    preparedStatement.setInt(Util.insertMsgSizeIndex, n2);
                    object = new ByteArrayOutputStream(n2);
                    packet.writePacket((OutputStream)object);
                    object2 = ((ByteArrayOutputStream)object).toByteArray();
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object2);
                    preparedStatement.setBinaryStream(Util.insertMsgMsgIndex, (InputStream)byteArrayInputStream, ((Object)object2).length);
                    ((ByteArrayOutputStream)object).close();
                    byteArrayInputStream.close();
                    preparedStatement.executeUpdate();
                    hashMap.put(string7, string8);
                }
                catch (IOException iOException) {
                    object2 = DBManager.wrapIOException("[" + string6 + "]", iOException);
                    throw object2;
                }
                catch (SQLException sQLException) {
                    object2 = DBManager.wrapSQLException("[" + string6 + "]", sQLException);
                    throw object2;
                }
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (IOException iOException) {
            logger.log(32, "B4163", (Object)(packet == null ? "loading" : packet.getSysMessageID().getUniqueName()), (Throwable)iOException);
            throw new BrokerException(br.getString("B4163", packet == null ? "loading" : packet.getSysMessageID().getUniqueName()), iOException);
        }
        catch (SQLException sQLException) {
            logger.log(32, "B4163", (Object)(packet == null ? "loading" : packet.getSysMessageID().getUniqueName()), (Throwable)sQLException);
            throw new BrokerException(br.getString("B4163", packet == null ? "loading" : packet.getSysMessageID().getUniqueName()), sQLException);
        }
        int n3 = 1;
        int n4 = 2;
        int n5 = 3;
        string5 = "SELECT MID, CUID, STATE FROM " + string2 + " WHERE " + "STATE" + "<>" + 2;
        String string9 = Util.getInsertMessageStateSQL(string4);
        object = null;
        long l = 0L;
        try {
            PreparedStatement preparedStatement2 = connection.prepareStatement(string9);
            resultSet = statement.executeQuery(string5);
            while (resultSet.next()) {
                object = resultSet.getString(n3);
                l = resultSet.getLong(n4);
                int n6 = resultSet.getInt(n5);
                String string10 = (String)hashMap.get(object);
                if (string10 == null) continue;
                try {
                    preparedStatement2.setString(Util.insertMsgStateMIDIndex, (String)object);
                    preparedStatement2.setLong(Util.insertMsgStateCUIDIndex, l);
                    preparedStatement2.setString(Util.insertMsgStateDIDIndex, string10);
                    preparedStatement2.setInt(Util.insertMsgStateStateIndex, n6);
                    if (jDBCStore.supportBatch) {
                        preparedStatement2.addBatch();
                        continue;
                    }
                    preparedStatement2.executeUpdate();
                }
                catch (SQLException sQLException) {
                    SQLException sQLException2 = DBManager.wrapSQLException("[" + string9 + "]", sQLException);
                    throw sQLException2;
                }
            }
            resultSet.close();
            statement.close();
            hashMap.clear();
            if (jDBCStore.supportBatch) {
                preparedStatement2.executeBatch();
            }
            preparedStatement2.getConnection().commit();
            preparedStatement2.close();
        }
        catch (SQLException sQLException) {
            logger.log(32, "B4163", object == null ? "loading" : object, (Throwable)sQLException);
            throw new BrokerException(br.getString("B4163", object == null ? "loading" : object), sQLException);
        }
    }

    private static void upgradeInterests(JDBCStore jDBCStore, Connection connection) throws BrokerException {
        String string = "IMQINT" + jDBCStore.brokerid;
        ResultSet resultSet = null;
        String string2 = null;
        int n = 0;
        Statement statement = null;
        try {
            string2 = "SELECT COUNT(CUID) FROM " + string;
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string2);
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            logger.log(32, "B4166", (Object)string2, (Throwable)sQLException);
            throw new BrokerException(br.getString("B4166", string2), sQLException);
        }
        if (Store.DEBUG) {
            logger.log(4, "number of interests in old table = " + n);
        }
        boolean bl = jDBCStore.upgradeNoBackup();
        if (n == 0) {
            if (bl) {
                UpgradeStore.dropTable(connection, string);
            }
        } else if (jDBCStore.resetInterest()) {
            if (bl) {
                UpgradeStore.dropTable(connection, string);
            } else {
                UpgradeStore.clearTable(connection, string);
            }
        } else {
            UpgradeStore.doUpgradeInterests(jDBCStore, connection);
        }
    }

    private static void doUpgradeInterests(JDBCStore jDBCStore, Connection connection) throws BrokerException {
        String string = "IMQINT" + jDBCStore.brokerid;
        String string2 = "IMQINT35" + jDBCStore.brokerid;
        int n = 1;
        String string3 = "SELECT INTEREST FROM " + string;
        String string4 = Util.getInsertInterestSQL(string2);
        PreparedStatement preparedStatement = null;
        Statement statement = null;
        ResultSet resultSet = null;
        Consumer consumer = null;
        try {
            statement = connection.createStatement();
            preparedStatement = connection.prepareStatement(string4);
            resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                consumer = (Consumer)Util.readObject(resultSet, n);
                try {
                    preparedStatement.setLong(Util.insertInterestCUIDIndex, consumer.getConsumerUID().longValue());
                    ByteArrayInputStream byteArrayInputStream = Util.setObject(preparedStatement, Util.insertInterestIntIndex, consumer);
                    byteArrayInputStream.close();
                    if (jDBCStore.supportBatch) {
                        preparedStatement.addBatch();
                        continue;
                    }
                    preparedStatement.executeUpdate();
                }
                catch (IOException iOException) {
                    IOException iOException2 = DBManager.wrapIOException("[" + string4 + "]", iOException);
                    throw iOException2;
                }
                catch (SQLException sQLException) {
                    SQLException sQLException2 = DBManager.wrapSQLException("[" + string4 + "]", sQLException);
                    throw sQLException2;
                }
            }
            resultSet.close();
            statement.close();
            if (jDBCStore.supportBatch) {
                preparedStatement.executeBatch();
            }
            preparedStatement.close();
            connection.commit();
            if (jDBCStore.upgradeNoBackup()) {
                UpgradeStore.dropTable(connection, string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.log(32, "B4168", (Object)(consumer == null ? "loading" : consumer.toString()), (Throwable)classNotFoundException);
            throw new BrokerException(br.getString("B4168", consumer == null ? "loading" : consumer.toString()), classNotFoundException);
        }
        catch (IOException iOException) {
            logger.log(32, "B4168", (Object)(consumer == null ? "loading" : consumer.toString()), (Throwable)iOException);
            throw new BrokerException(br.getString("B4168", consumer == null ? "loading" : consumer.toString()), iOException);
        }
        catch (SQLException sQLException) {
            logger.log(32, "B4168", (Object)(consumer == null ? "loading" : consumer.toString()), (Throwable)sQLException);
            throw new BrokerException(br.getString("B4168", consumer == null ? "loading" : consumer.toString()), sQLException);
        }
    }

    private static void upgradeTxns(JDBCStore jDBCStore, Connection connection) throws BrokerException {
        ByteArrayInputStream byteArrayInputStream;
        Serializable serializable;
        String string = "IMQTXN" + jDBCStore.brokerid;
        String string2 = "IMQTACK" + jDBCStore.brokerid;
        String string3 = "IMQTXN35" + jDBCStore.brokerid;
        String string4 = "IMQTACK35" + jDBCStore.brokerid;
        int n = 1;
        int n2 = 2;
        int n3 = 3;
        String string5 = "SELECT TUID,STATE,TSTATEOBJ FROM " + string + " WHERE " + "STATE" + "<>" + -1;
        String string6 = Util.getInsertTxnSQL(string3);
        String string7 = Util.getInsertTxnAckSQL(string4);
        PreparedStatement preparedStatement = null;
        PreparedStatement preparedStatement2 = null;
        Statement statement = null;
        ResultSet resultSet = null;
        TransactionUID transactionUID = null;
        try {
            preparedStatement = connection.prepareStatement(string6);
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string5);
            while (resultSet.next()) {
                long l = resultSet.getLong(n);
                transactionUID = new TransactionUID(l);
                int n4 = resultSet.getInt(n2);
                serializable = (TransactionState)Util.readObject(resultSet, n3);
                serializable.setState(n4);
                try {
                    preparedStatement.setLong(Util.insertTxnTidIndex, l);
                    preparedStatement.setInt(Util.insertTxnStateIndex, n4);
                    byteArrayInputStream = Util.setObject(preparedStatement, Util.insertTxnStateObjIndex, serializable);
                    byteArrayInputStream.close();
                    if (jDBCStore.supportBatch) {
                        preparedStatement.addBatch();
                        continue;
                    }
                    preparedStatement.executeUpdate();
                }
                catch (IOException iOException) {
                    IOException iOException2 = DBManager.wrapIOException("[" + string6 + "]", iOException);
                    throw iOException2;
                }
                catch (SQLException sQLException) {
                    SQLException sQLException2 = DBManager.wrapSQLException("[" + string6 + "]", sQLException);
                    throw sQLException2;
                }
            }
            resultSet.close();
            if (jDBCStore.supportBatch) {
                preparedStatement.executeBatch();
            }
            connection.commit();
            preparedStatement.close();
            if (jDBCStore.upgradeNoBackup()) {
                UpgradeStore.dropTable(connection, string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.log(32, "B4172", (Object)(transactionUID == null ? "loading" : transactionUID.toString()), (Throwable)classNotFoundException);
            throw new BrokerException(br.getString("B4172", transactionUID == null ? "loading" : transactionUID.toString()), classNotFoundException);
        }
        catch (IOException iOException) {
            logger.log(32, "B4172", (Object)(transactionUID == null ? "loading" : transactionUID.toString()), (Throwable)iOException);
            throw new BrokerException(br.getString("B4172", transactionUID == null ? "loading" : transactionUID.toString()), iOException);
        }
        catch (SQLException sQLException) {
            logger.log(32, "B4172", (Object)(transactionUID == null ? "loading" : transactionUID.toString()), (Throwable)sQLException);
            throw new BrokerException(br.getString("B4172", transactionUID == null ? "loading" : transactionUID.toString()), sQLException);
        }
        n = 1;
        int n5 = 2;
        string5 = "SELECT TUID,TXNACK FROM " + string2;
        transactionUID = null;
        try {
            preparedStatement2 = connection.prepareStatement(string7);
            resultSet = statement.executeQuery(string5);
            while (resultSet.next()) {
                long l = resultSet.getLong(n);
                transactionUID = new TransactionUID(l);
                serializable = (TransactionAcknowledgement)Util.readObject(resultSet, n5);
                try {
                    preparedStatement2.setLong(Util.insertTxnAckTidIndex, l);
                    byteArrayInputStream = Util.setObject(preparedStatement2, Util.insertTxnAckAckIndex, serializable);
                    byteArrayInputStream.close();
                    if (jDBCStore.supportBatch) {
                        preparedStatement2.addBatch();
                        continue;
                    }
                    preparedStatement2.executeUpdate();
                }
                catch (IOException iOException) {
                    IOException iOException3 = DBManager.wrapIOException("[" + string7 + "]", iOException);
                    throw iOException3;
                }
                catch (SQLException sQLException) {
                    SQLException sQLException3 = DBManager.wrapSQLException("[" + string7 + "]", sQLException);
                    throw sQLException3;
                }
            }
            resultSet.close();
            statement.close();
            if (jDBCStore.supportBatch) {
                preparedStatement2.executeBatch();
            }
            connection.commit();
            preparedStatement2.close();
            if (jDBCStore.upgradeNoBackup()) {
                UpgradeStore.dropTable(connection, string2);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.log(32, "B4172", (Object)(transactionUID == null ? "loading" : transactionUID.toString()), (Throwable)classNotFoundException);
            throw new BrokerException(br.getString("B4172", transactionUID == null ? "loading" : transactionUID.toString()), classNotFoundException);
        }
        catch (IOException iOException) {
            logger.log(32, "B4172", (Object)(transactionUID == null ? "loading" : transactionUID.toString()), (Throwable)iOException);
            throw new BrokerException(br.getString("B4172", transactionUID == null ? "loading" : transactionUID.toString()), iOException);
        }
        catch (SQLException sQLException) {
            logger.log(32, "B4172", (Object)(transactionUID == null ? "loading" : transactionUID.toString()), (Throwable)sQLException);
            throw new BrokerException(br.getString("B4172", transactionUID == null ? "loading" : transactionUID.toString()), sQLException);
        }
    }

    private static void upgradeChangeRecords(JDBCStore jDBCStore, Connection connection) throws BrokerException {
        String string = "IMQCCREC" + jDBCStore.brokerid;
        String string2 = "IMQCCREC35" + jDBCStore.brokerid;
        int n = 1;
        int n2 = 2;
        String string3 = "SELECT RECORDTIME,RECORD FROM " + string;
        String string4 = Util.getInsertConfigRecordSQL(string2);
        PreparedStatement preparedStatement = null;
        Statement statement = null;
        ResultSet resultSet = null;
        Long l = null;
        try {
            statement = connection.createStatement();
            preparedStatement = connection.prepareStatement(string4);
            resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                long l2 = resultSet.getLong(n);
                byte[] byArray = Util.readBytes(resultSet, n2);
                l = new Long(l2);
                byte[] byArray2 = Util301To350.upgradeConfigChangeRecord(byArray);
                try {
                    preparedStatement.setLong(Util.insertCCRTimeIndex, l2);
                    ByteArrayInputStream byteArrayInputStream = Util.setBytes(preparedStatement, Util.insertCCRRecordIndex, byArray2);
                    byteArrayInputStream.close();
                    if (jDBCStore.supportBatch) {
                        preparedStatement.addBatch();
                        continue;
                    }
                    preparedStatement.executeUpdate();
                }
                catch (IOException iOException) {
                    IOException iOException2 = DBManager.wrapIOException("[" + string4 + "]", iOException);
                    throw iOException2;
                }
                catch (SQLException sQLException) {
                    SQLException sQLException2 = DBManager.wrapSQLException("[" + string4 + "]", sQLException);
                    throw sQLException2;
                }
            }
            resultSet.close();
            statement.close();
            if (jDBCStore.supportBatch) {
                preparedStatement.executeBatch();
            }
            connection.commit();
            preparedStatement.close();
            if (jDBCStore.upgradeNoBackup()) {
                UpgradeStore.dropTable(connection, string);
            }
        }
        catch (IOException iOException) {
            logger.log(32, "B4171", (Object)(l == null ? "loading" : l.toString()), (Throwable)iOException);
            throw new BrokerException(br.getString("B4171", l == null ? "loading" : l.toString()), iOException);
        }
        catch (SQLException sQLException) {
            logger.log(32, "B4171", (Object)(l == null ? "loading" : l.toString()), (Throwable)sQLException);
            throw new BrokerException(br.getString("B4171", l == null ? "loading" : l.toString()), sQLException);
        }
    }

    private static void upgradeProperties(JDBCStore jDBCStore, Connection connection) throws BrokerException {
        String string = "IMQPROPS" + jDBCStore.brokerid;
        String string2 = "IMQPROPS35" + jDBCStore.brokerid;
        int n = 1;
        int n2 = 2;
        String string3 = "SELECT PROPNAME,PROPVALUE FROM " + string;
        String string4 = Util.getInsertPropertySQL(string2);
        Statement statement = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string5 = null;
        try {
            statement = connection.createStatement();
            preparedStatement = connection.prepareStatement(string4);
            resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                string5 = resultSet.getString(n);
                Object object = Util.readObject(resultSet, n2);
                try {
                    preparedStatement.setString(Util.insertPropertyNameIndex, string5);
                    ByteArrayInputStream byteArrayInputStream = Util.setObject(preparedStatement, Util.insertPropertyValueIndex, object);
                    byteArrayInputStream.close();
                    if (jDBCStore.supportBatch) {
                        preparedStatement.addBatch();
                        continue;
                    }
                    preparedStatement.executeUpdate();
                }
                catch (IOException iOException) {
                    IOException iOException2 = DBManager.wrapIOException("[" + string4 + "]", iOException);
                    throw iOException2;
                }
                catch (SQLException sQLException) {
                    SQLException sQLException2 = DBManager.wrapSQLException("[" + string4 + "]", sQLException);
                    throw sQLException2;
                }
            }
            resultSet.close();
            statement.close();
            if (jDBCStore.supportBatch) {
                preparedStatement.executeBatch();
            }
            connection.commit();
            preparedStatement.close();
            if (jDBCStore.upgradeNoBackup()) {
                UpgradeStore.dropTable(connection, string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.log(32, "B4170", (Object)(string5 == null ? "loading" : string5), (Throwable)classNotFoundException);
            throw new BrokerException(br.getString("B4170", string5 == null ? "loading" : string5), classNotFoundException);
        }
        catch (IOException iOException) {
            logger.log(32, "B4170", (Object)(string5 == null ? "loading" : string5), (Throwable)iOException);
            throw new BrokerException(br.getString("B4170", string5 == null ? "loading" : string5), iOException);
        }
        catch (SQLException sQLException) {
            logger.log(32, "B4170", (Object)(string5 == null ? "loading" : string5), (Throwable)sQLException);
            throw new BrokerException(br.getString("B4170", string5 == null ? "loading" : string5), sQLException);
        }
    }

    private static void dropTable(Connection connection, String string) throws BrokerException {
        String string2 = "DROP TABLE " + string;
        try {
            Statement statement = connection.createStatement();
            statement.executeUpdate(string2);
            statement.close();
            connection.commit();
            if (Store.DEBUG) {
                logger.log(4, "Dropped table " + string);
            }
        }
        catch (SQLException sQLException) {
            logger.log(32, "B1117", (Object)string, (Throwable)DBManager.wrapSQLException("[" + string2 + "]", sQLException));
        }
    }

    private static void clearTable(Connection connection, String string) throws BrokerException {
        String string2 = "DELETE FROM " + string;
        try {
            Statement statement = connection.createStatement();
            int n = statement.executeUpdate(string2);
            statement.close();
            connection.commit();
            if (Store.DEBUG) {
                logger.log(4, "deleted " + n + " entries in " + string);
            }
        }
        catch (SQLException sQLException) {
            logger.log(32, "B4174", (Object)string, (Throwable)DBManager.wrapSQLException("[" + string2 + "]", sQLException));
            throw new BrokerException(br.getString("B4174", string), DBManager.wrapSQLException("[" + string2 + "]", sQLException));
        }
    }
}

