/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConnection;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConstants;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class TxnTable
implements DBConstants {
    private static Logger logger = Globals.getLogger();
    private static BrokerResources br = Globals.getBrokerResources();
    private HashMap tidMap = new HashMap();
    private HashMap tid2AckMap = new HashMap();

    TxnTable(boolean bl) throws BrokerException {
        if (bl) {
            this.clearAll();
        } else {
            this.loadData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeTransaction(TransactionUID transactionUID, TransactionState transactionState) throws BrokerException {
        HashMap hashMap = this.tidMap;
        synchronized (hashMap) {
            if (this.tidMap.get(transactionUID) != null) {
                logger.log(32, "B3015", transactionUID.toString());
                throw new BrokerException(br.getString("B3015", transactionUID.toString()));
            }
            boolean bl = false;
            do {
                bl = false;
                DBConnection dBConnection = DBConnection.getDBConnection();
                try {
                    dBConnection.getConnection().setAutoCommit(true);
                    dBConnection.insertTxnStmt.setLong(1, transactionUID.longValue());
                    dBConnection.insertTxnStmt.setInt(2, transactionState.getState());
                    ByteArrayInputStream byteArrayInputStream = Util.setObject(dBConnection.insertTxnStmt, 3, transactionState);
                    dBConnection.insertTxnStmt.executeUpdate();
                    byteArrayInputStream.close();
                    this.tidMap.put(transactionUID, new TransactionState(transactionState));
                }
                catch (IOException iOException) {
                    IOException iOException2 = DBManager.wrapIOException("[" + DBConnection.insertTxnSQL + "]", iOException);
                    logger.log(32, "B4019", (Object)transactionUID.toString(), (Throwable)iOException2);
                    throw new BrokerException(br.getString("B4019", transactionUID.toString()), iOException2);
                }
                catch (SQLException sQLException) {
                    bl = DBConnection.handleException(dBConnection, sQLException);
                    if (bl) continue;
                    SQLException sQLException2 = DBManager.wrapSQLException("[" + DBConnection.insertTxnSQL + "]", sQLException);
                    logger.log(32, "B4019", (Object)transactionUID.toString(), (Throwable)sQLException2);
                    throw new BrokerException(br.getString("B4019", transactionUID.toString()), sQLException2);
                }
                finally {
                    DBConnection.putDBConnection(dBConnection);
                }
            } while (bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransaction(TransactionUID transactionUID) throws BrokerException {
        HashMap hashMap = this.tidMap;
        synchronized (hashMap) {
            if (this.tidMap.remove(transactionUID) == null) {
                logger.log(32, "B3016", transactionUID.toString());
                throw new BrokerException(br.getString("B3016", transactionUID.toString()));
            }
            boolean bl = false;
            do {
                bl = false;
                DBConnection dBConnection = DBConnection.getDBConnection();
                try {
                    dBConnection.getConnection().setAutoCommit(true);
                    dBConnection.deleteTxnStmt.setLong(1, transactionUID.longValue());
                    dBConnection.deleteTxnStmt.executeUpdate();
                }
                catch (SQLException sQLException) {
                    bl = DBConnection.handleException(dBConnection, sQLException);
                    if (bl) continue;
                    SQLException sQLException2 = DBManager.wrapSQLException("[" + DBConnection.deleteTxnSQL + "]", sQLException);
                    logger.log(32, "B4138", (Object)transactionUID.toString(), (Throwable)sQLException);
                    throw new BrokerException(br.getString("B4138", transactionUID.toString()), sQLException);
                }
                finally {
                    DBConnection.putDBConnection(dBConnection);
                }
            } while (bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTransactionState(TransactionUID transactionUID, int n) throws IOException, BrokerException {
        HashMap hashMap = this.tidMap;
        synchronized (hashMap) {
            TransactionState transactionState = (TransactionState)this.tidMap.get(transactionUID);
            if (transactionState == null) {
                logger.log(32, "B3016", transactionUID);
                throw new BrokerException(br.getString("B3016", transactionUID));
            }
            if (transactionState.getState() == n) {
                return;
            }
            boolean bl = false;
            do {
                bl = false;
                DBConnection dBConnection = DBConnection.getDBConnection();
                try {
                    dBConnection.getConnection().setAutoCommit(true);
                    dBConnection.updateTxnStateStmt.setInt(1, n);
                    dBConnection.updateTxnStateStmt.setLong(2, transactionUID.longValue());
                    dBConnection.updateTxnStateStmt.executeUpdate();
                    transactionState.setState(n);
                }
                catch (SQLException sQLException) {
                    bl = DBConnection.handleException(dBConnection, sQLException);
                    if (bl) continue;
                    SQLException sQLException2 = DBManager.wrapSQLException("[" + DBConnection.updateTxnStateSQL + "]", sQLException);
                    logger.log(32, "B4137", (Object)transactionUID, (Throwable)sQLException);
                    throw new BrokerException(br.getString("B4137", transactionUID), sQLException);
                }
                finally {
                    DBConnection.putDBConnection(dBConnection);
                }
            } while (bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HashMap getAllTransactionStates() {
        HashMap hashMap = this.tidMap;
        synchronized (hashMap) {
            return (HashMap)this.tidMap.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkTransaction(TransactionUID transactionUID) throws BrokerException {
        HashMap hashMap = this.tidMap;
        synchronized (hashMap) {
            if (!this.tidMap.containsKey(transactionUID)) {
                logger.log(32, "B3016", transactionUID);
                throw new BrokerException(br.getString("B3016", transactionUID));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearAll() throws BrokerException {
        if (Store.DEBUG) {
            logger.log(1, "TxnTable.clearAll() called");
        }
        HashMap hashMap = this.tidMap;
        synchronized (hashMap) {
            boolean bl = false;
            do {
                bl = false;
                DBConnection dBConnection = DBConnection.getDBConnection();
                try {
                    dBConnection.getConnection().setAutoCommit(false);
                    dBConnection.deleteAllTxnsStmt.executeUpdate();
                    dBConnection.deleteAllTxnAcksStmt.executeUpdate();
                    dBConnection.getConnection().commit();
                    this.tidMap.clear();
                    HashSet[] hashSetArray = this.tid2AckMap.values().toArray(new HashSet[0]);
                    for (int i = 0; i < hashSetArray.length; ++i) {
                        hashSetArray[i].clear();
                    }
                    this.tid2AckMap.clear();
                }
                catch (SQLException sQLException) {
                    bl = DBConnection.handleException(dBConnection, sQLException);
                    if (bl) continue;
                    SQLException sQLException2 = DBManager.wrapSQLException("[" + DBConnection.deleteAllTxnsSQL + "/" + DBConnection.deleteAllTxnAcksSQL + "]", sQLException);
                    logger.log(32, "B4030", sQLException2);
                    throw new BrokerException(br.getString("B4030"), sQLException2);
                }
                finally {
                    DBConnection.putDBConnection(dBConnection);
                }
            } while (bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void clear(int n) throws BrokerException {
        if (Store.DEBUG) {
            logger.log(1, "TxdTable.clear() called");
        }
        boolean bl = false;
        HashMap hashMap = this.tidMap;
        synchronized (hashMap) {
            boolean bl2 = false;
            do {
                HashSet hashSet;
                TransactionState transactionState;
                TransactionUID transactionUID;
                Map.Entry entry;
                Iterator iterator;
                Object var9_7;
                bl2 = false;
                DBConnection dBConnection = DBConnection.getDBConnection();
                try {
                    try {
                        dBConnection.getConnection().setAutoCommit(false);
                        dBConnection.deleteTxnsNotInStateStmt.setInt(1, n);
                        dBConnection.deleteTxnsNotInStateStmt.executeUpdate();
                        dBConnection.deleteTxnAcksNotInStateStmt.executeUpdate();
                        dBConnection.getConnection().commit();
                    }
                    catch (SQLException sQLException) {
                        bl2 = DBConnection.handleException(dBConnection, sQLException);
                        if (!bl2) {
                            bl = true;
                            try {
                                dBConnection.getConnection().rollback();
                            }
                            catch (SQLException sQLException2) {
                                logger.log(32, "B4080", sQLException2);
                            }
                            SQLException sQLException3 = DBManager.wrapSQLException("[" + DBConnection.deleteTxnsNotInStateSQL + "/" + DBConnection.deleteTxnAcksNotInStateSQL + "]", sQLException);
                            logger.log(32, "B4139", (Object)new Integer(n), (Throwable)sQLException3);
                            throw new BrokerException(br.getString("B4139", new Integer(n)), sQLException3);
                        }
                        var9_7 = null;
                        DBConnection.putDBConnection(dBConnection);
                        if (bl2) continue;
                        if (bl) {
                            this.clearAll();
                            continue;
                        }
                        iterator = this.tidMap.entrySet().iterator();
                        while (iterator.hasNext()) {
                            entry = iterator.next();
                            transactionUID = (TransactionUID)entry.getKey();
                            transactionState = (TransactionState)entry.getValue();
                            if (transactionState.getState() == n) continue;
                            iterator.remove();
                            hashSet = (HashSet)this.tid2AckMap.remove(transactionUID);
                            if (hashSet == null) continue;
                            hashSet.clear();
                        }
                        continue;
                    }
                    var9_7 = null;
                }
                catch (Throwable throwable) {
                    var9_7 = null;
                    DBConnection.putDBConnection(dBConnection);
                    if (bl2) throw throwable;
                    if (bl) {
                        this.clearAll();
                        throw throwable;
                    }
                    iterator = this.tidMap.entrySet().iterator();
                    while (iterator.hasNext()) {
                        entry = iterator.next();
                        transactionUID = (TransactionUID)entry.getKey();
                        transactionState = (TransactionState)entry.getValue();
                        if (transactionState.getState() == n) continue;
                        iterator.remove();
                        hashSet = (HashSet)this.tid2AckMap.remove(transactionUID);
                        if (hashSet == null) continue;
                        hashSet.clear();
                    }
                    throw throwable;
                }
                DBConnection.putDBConnection(dBConnection);
                if (bl2) continue;
                if (bl) {
                    this.clearAll();
                    continue;
                }
                iterator = this.tidMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    transactionUID = (TransactionUID)entry.getKey();
                    transactionState = (TransactionState)entry.getValue();
                    if (transactionState.getState() == n) continue;
                    iterator.remove();
                    hashSet = (HashSet)this.tid2AckMap.remove(transactionUID);
                    if (hashSet == null) continue;
                    hashSet.clear();
                }
            } while (bl2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeTransactionAck(TransactionUID transactionUID, TransactionAcknowledgement transactionAcknowledgement) throws BrokerException {
        this.checkTransaction(transactionUID);
        HashMap hashMap = this.tidMap;
        synchronized (hashMap) {
            HashSet<TransactionAcknowledgement> hashSet = (HashSet<TransactionAcknowledgement>)this.tid2AckMap.get(transactionUID);
            if (hashSet == null) {
                hashSet = new HashSet<TransactionAcknowledgement>();
                this.tid2AckMap.put(transactionUID, hashSet);
            } else if (hashSet.contains(transactionAcknowledgement)) {
                logger.log(32, "B3062", (Object)transactionAcknowledgement, transactionUID);
                throw new BrokerException(br.getString("B3062", transactionAcknowledgement, transactionUID));
            }
            boolean bl = false;
            do {
                bl = false;
                DBConnection dBConnection = DBConnection.getDBConnection();
                try {
                    dBConnection.getConnection().setAutoCommit(true);
                    dBConnection.insertTxnAckStmt.setLong(1, transactionUID.longValue());
                    ByteArrayInputStream byteArrayInputStream = Util.setObject(dBConnection.insertTxnAckStmt, 2, transactionAcknowledgement);
                    dBConnection.insertTxnAckStmt.executeUpdate();
                    byteArrayInputStream.close();
                    hashSet.add(transactionAcknowledgement);
                }
                catch (IOException iOException) {
                    IOException iOException2 = DBManager.wrapIOException("[" + DBConnection.insertTxnAckSQL + "]", iOException);
                    logger.log(32, "B4056", transactionAcknowledgement.toString(), transactionUID.toString(), iOException2);
                    throw new BrokerException(br.getString("B4056", transactionAcknowledgement.toString(), transactionUID.toString()), iOException2);
                }
                catch (SQLException sQLException) {
                    bl = DBConnection.handleException(dBConnection, sQLException);
                    if (bl) continue;
                    SQLException sQLException2 = DBManager.wrapSQLException("[" + DBConnection.insertTxnAckSQL + "]", sQLException);
                    logger.log(32, "B4056", transactionAcknowledgement.toString(), transactionUID.toString(), sQLException2);
                    throw new BrokerException(br.getString("B4056", transactionAcknowledgement.toString(), transactionUID.toString()), sQLException2);
                }
                finally {
                    DBConnection.putDBConnection(dBConnection);
                }
            } while (bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTransactionAck(TransactionUID transactionUID) throws BrokerException {
        HashMap hashMap = this.tidMap;
        synchronized (hashMap) {
            boolean bl = false;
            do {
                bl = false;
                DBConnection dBConnection = DBConnection.getDBConnection();
                try {
                    dBConnection.getConnection().setAutoCommit(true);
                    dBConnection.deleteAcksForTxnStmt.setLong(1, transactionUID.longValue());
                    dBConnection.deleteAcksForTxnStmt.executeUpdate();
                    this.tid2AckMap.remove(transactionUID);
                }
                catch (SQLException sQLException) {
                    bl = DBConnection.handleException(dBConnection, sQLException);
                    if (bl) continue;
                    SQLException sQLException2 = DBManager.wrapSQLException("[" + dBConnection.deleteAcksForTxnStmt + "]", sQLException);
                    logger.log(32, "B4060", (Object)transactionUID.toString(), (Throwable)sQLException2);
                    throw new BrokerException(br.getString("B4060", transactionUID.toString()), sQLException2);
                }
                finally {
                    DBConnection.putDBConnection(dBConnection);
                }
            } while (bl);
        }
    }

    HashMap getAllTransactionAcks() {
        HashMap<TransactionUID, TransactionAcknowledgement[]> hashMap = new HashMap<TransactionUID, TransactionAcknowledgement[]>();
        if (this.tidMap.size() == 0) {
            return hashMap;
        }
        Set set = this.tid2AckMap.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            TransactionUID transactionUID = (TransactionUID)entry.getKey();
            HashSet hashSet = (HashSet)entry.getValue();
            TransactionAcknowledgement[] transactionAcknowledgementArray = hashSet.toArray(new TransactionAcknowledgement[0]);
            hashMap.put(transactionUID, transactionAcknowledgementArray);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TransactionAcknowledgement[] getTransactionAcks(TransactionUID transactionUID) throws BrokerException {
        HashMap hashMap = this.tidMap;
        synchronized (hashMap) {
            TransactionAcknowledgement[] transactionAcknowledgementArray = new TransactionAcknowledgement[]{};
            HashSet hashSet = (HashSet)this.tid2AckMap.get(transactionUID);
            if (hashSet != null) {
                return hashSet.toArray(transactionAcknowledgementArray);
            }
            return transactionAcknowledgementArray;
        }
    }

    private void loadData() throws BrokerException {
        Serializable serializable;
        Serializable serializable2;
        ResultSet resultSet;
        boolean bl = false;
        DBConnection dBConnection = DBConnection.getDBConnection();
        try {
            resultSet = dBConnection.selectAllTxnsStmt.executeQuery();
            while (resultSet.next()) {
                int n = resultSet.getInt(2);
                try {
                    long l = resultSet.getLong(1);
                    serializable2 = new TransactionUID(l);
                    serializable = (TransactionState)Util.readObject(resultSet, 3);
                    ((TransactionState)serializable).setState(n);
                    this.tidMap.put(serializable2, serializable);
                }
                catch (IOException iOException) {
                    logger.logStack(32, "B4128", iOException);
                }
            }
            resultSet.close();
            if (Store.DEBUG) {
                logger.log(4, "LOADED " + new Integer(this.tidMap.size()) + " TRANSACTIONS FROM DATABASE");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = true;
            logger.log(32, "B4032", classNotFoundException);
            throw new BrokerException(br.getString("B4032"), classNotFoundException);
        }
        catch (SQLException sQLException) {
            bl = true;
            SQLException sQLException2 = DBManager.wrapSQLException("[" + DBConnection.selectAllTxnsSQL + "]", sQLException);
            logger.log(32, "B4032", sQLException2);
            throw new BrokerException(br.getString("B4032"), sQLException2);
        }
        finally {
            if (bl) {
                DBConnection.putDBConnection(dBConnection);
            }
        }
        try {
            resultSet = dBConnection.selectAllTxnAcksStmt.executeQuery();
            while (resultSet.next()) {
                long l = resultSet.getLong(1);
                TransactionUID transactionUID = new TransactionUID(l);
                serializable2 = null;
                try {
                    serializable2 = (TransactionAcknowledgement)Util.readObject(resultSet, 2);
                }
                catch (IOException iOException) {
                    logger.logStack(32, "B4129", transactionUID.toString(), (Throwable)iOException);
                    continue;
                }
                serializable = (HashSet)this.tid2AckMap.get(transactionUID);
                if (serializable == null) {
                    serializable = new HashSet();
                    this.tid2AckMap.put(transactionUID, serializable);
                }
                ((HashSet)serializable).add(serializable2);
            }
            resultSet.close();
            if (Store.DEBUG) {
                logger.log(4, "LOADED ACKS FOR " + new Integer(this.tid2AckMap.size()) + " TRANSACTIONS FROM DATABASE");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.log(32, "B4032", classNotFoundException);
            throw new BrokerException(br.getString("B4032"), classNotFoundException);
        }
        catch (SQLException sQLException) {
            SQLException sQLException3 = DBManager.wrapSQLException("[" + DBConnection.selectAllTxnAcksSQL + "]", sQLException);
            logger.log(32, "B4032", sQLException3);
            throw new BrokerException(br.getString("B4032"), sQLException3);
        }
        finally {
            DBConnection.putDBConnection(dBConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Hashtable getDebugState() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("Transactions(IMQTXN35)", String.valueOf(this.tidMap.size()));
        int n = 0;
        HashMap hashMap = this.tid2AckMap;
        synchronized (hashMap) {
            Iterator iterator = this.tid2AckMap.values().iterator();
            while (iterator.hasNext()) {
                HashSet hashSet = (HashSet)iterator.next();
                n += hashSet.size();
            }
        }
        hashtable.put("Txn acks(IMQTACK35)", String.valueOf(n));
        return hashtable;
    }

    void close(boolean bl) {
        if (Store.DEBUG) {
            logger.log(1, "TxnTable.close() called");
        }
    }
}

