/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConstants;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.StringUtil;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class DBTool
implements DBConstants {
    private static final int RESERVED_TABLE_NAME_LENGTH = 12;
    static final String SQLFILEDIR_PROP = "imq.persist.jdbc.sqlfile.dirpath";
    static final String SQLFILENAME_PROP = "imq.persist.jdbc.sqlfile.name";
    private static int EXTRA_CMD_SPECIFIED = 0;
    private static int BAD_CMD_ARG = 1;
    private static int BAD_OPT = 2;
    private static int BAD_OPT_ARG = 3;
    private static int MISSING_OPT_ARG = 4;
    private static int MISSING_CMD_ARG = 5;
    private static String CMD_NAME = "dbmgrcmd";
    private static String CREATE_ALL_CMD = "createall";
    private static String CREATE_TBL_CMD = "createtbl";
    private static String DELETE_TBL_CMD = "deletetbl";
    private static String RECREATE_TBL_CMD = "recreatetbl";
    private static String DUMP_CMD = "dumptbl";
    private static String RESET_CMD = "reset";
    private static String ARG_NAME = "dbmgrarg";
    private static String CREATE_CMD_STR = "create";
    private static String DELETE_CMD_STR = "delete";
    private static String RECREATE_CMD_STR = "recreate";
    private static String DUMP_CMD_STR = "dump";
    private static String RESET_CMD_STR = "reset";
    private static String ARGU_ALL = "all";
    private static String ARGU_TBL = "tbl";
    private static String ARGU_OLDTBL = "oldtbl";
    private static String ARGU_LCK = "lck";
    private static String OPT_H = "-h";
    private static String OPT_LH = "-help";
    private static String OPT_V = "-v";
    private static String OPT_LV = "-version";
    private static String OPT_B = "-b";
    private static String OPT_U = "-u";
    private static String OPT_P = "-p";
    private static String OPT_PASSFILE = "-passfile";
    private static String OPT_D = "-D";
    private static String OPT_VARHOME = "-varhome";
    private static String OPT_VERBOSE = "-verbose";
    private static String EMPTY_STRING = "";
    private static BrokerConfig config;
    private static BrokerResources br;
    private static Logger logger;
    private Version version = new Version();
    private DBManager dbmgr;
    private boolean standalone = true;
    private boolean cliPasswdSpecified = false;
    private String instancename = null;

    DBTool(boolean bl) throws BrokerException {
        this.standalone = bl;
        br = Globals.getBrokerResources();
    }

    private void doCreate(boolean bl, boolean bl2) throws BrokerException {
        Connection connection = bl2 ? this.dbmgr.connectToCreate() : this.dbmgr.connectToUse(true);
        try {
            DBTool.createTables(this.dbmgr, connection);
            connection.close();
            if (bl) {
                System.out.println(br.getString("B1046"));
            }
        }
        catch (Throwable throwable) {
            String string = bl2 ? this.dbmgr.getCreateDBURL() : this.dbmgr.getOpenDBURL();
            logger.log(32, "B3073", (Object)string, throwable);
            throw new BrokerException(br.getString("B3073", string, throwable));
        }
        finally {
            this.dbmgr.close();
        }
    }

    static void createTables(DBManager dBManager, Connection connection) throws SQLException, BrokerException {
        String string;
        Hashtable hashtable = dBManager.getTableSchema();
        Statement statement = connection.createStatement();
        Iterator iterator = hashtable.values().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            try {
                statement.executeUpdate(string);
            }
            catch (SQLException sQLException) {
                throw DBManager.wrapSQLException("[" + string + "]", sQLException);
            }
        }
        string = "IMQSV35" + dBManager.getBrokerID();
        String string2 = "INSERT INTO " + string + " (" + "STOREVERSION" + "," + "BROKERID" + ") VALUES (" + 350 + ", null)";
        try {
            statement.executeUpdate(string2);
        }
        catch (SQLException sQLException) {
            throw DBManager.wrapSQLException("[" + string2 + "]", sQLException);
        }
        statement.close();
        if (!connection.getAutoCommit()) {
            connection.commit();
        }
    }

    private void doReset() throws BrokerException {
        Connection connection = this.dbmgr.connectToUse(false);
        try {
            DBManager.lockTables(connection, "IMQSV35" + this.dbmgr.getBrokerID(), false);
        }
        catch (SQLException sQLException) {
            logger.log(32, sQLException.getMessage());
        }
        catch (BrokerException brokerException) {
            logger.log(32, brokerException.getMessage());
            throw brokerException;
        }
        finally {
            this.dbmgr.close();
        }
    }

    private void doDrop(String string, boolean bl) throws BrokerException {
        Connection connection = this.dbmgr.connectToUse(true);
        boolean bl2 = false;
        try {
            if (string == null || string.length() == 0) {
                connection.setAutoCommit(false);
                DBManager.lockTables(connection, "IMQSV35" + this.dbmgr.getBrokerID(), true);
                connection.setAutoCommit(true);
                bl2 = DBTool.dropTables(connection, true, logger, this.dbmgr.getTableNames(350));
            } else if (string.equals(ARGU_OLDTBL)) {
                bl2 = DBTool.dropTables(connection, true, logger, this.dbmgr.getTableNames(200));
            }
            connection.close();
            if (bl && bl2) {
                System.out.println(br.getString("B1051"));
            }
        }
        catch (BrokerException brokerException) {
            logger.log(32, "B3075", (Object)this.dbmgr.getOpenDBURL(), (Throwable)brokerException);
            throw new BrokerException(br.getString("B3075", this.dbmgr.getOpenDBURL()), brokerException);
        }
        catch (SQLException sQLException) {
            logger.log(32, "B3075", (Object)this.dbmgr.getOpenDBURL(), (Throwable)sQLException);
            throw new BrokerException(br.getString("B3075", this.dbmgr.getOpenDBURL()), sQLException);
        }
        finally {
            this.dbmgr.close();
        }
    }

    static boolean dropTables(Connection connection, boolean bl, Logger logger, String[] stringArray) throws SQLException, BrokerException {
        Statement statement = connection.createStatement();
        boolean bl2 = false;
        SQLException sQLException = null;
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = "DROP TABLE " + stringArray[i];
            try {
                statement.executeUpdate(string);
                bl2 = true;
                continue;
            }
            catch (SQLException sQLException2) {
                sQLException = DBManager.wrapSQLException("[" + string + "]", sQLException2);
                if (Store.DEBUG) {
                    logger.log(4, "got: " + sQLException);
                }
                ++n;
            }
        }
        if (sQLException != null) {
            if (n == stringArray.length) {
                throw sQLException;
            }
            logger.log(16, "B3075", sQLException, sQLException);
        }
        if (bl && bl2 && !connection.getAutoCommit()) {
            connection.commit();
        }
        return bl2;
    }

    private void doRecreate(boolean bl) throws BrokerException {
        Connection connection = this.dbmgr.connectToUse(false);
        try {
            try {
                DBManager.lockTables(connection, "IMQSV35" + this.dbmgr.getBrokerID(), true);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                connection.setAutoCommit(true);
                DBTool.dropTables(connection, false, logger, this.dbmgr.getTableNames(350));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            DBTool.createTables(this.dbmgr, connection);
            connection.close();
            if (bl) {
                System.out.println(br.getString("B1046"));
            }
        }
        catch (BrokerException brokerException) {
            logger.log(32, "B3076", (Object)this.dbmgr.getOpenDBURL(), (Throwable)brokerException);
            throw new BrokerException(br.getString("B3076", this.dbmgr.getOpenDBURL()), brokerException);
        }
        catch (SQLException sQLException) {
            logger.log(32, "B3076", (Object)this.dbmgr.getOpenDBURL(), (Throwable)sQLException);
            throw new BrokerException(br.getString("B3076", this.dbmgr.getOpenDBURL()), sQLException);
        }
        finally {
            this.dbmgr.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDump(String string) throws SQLException, BrokerException {
        String[] stringArray;
        int n = 350;
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
        }
        if ((stringArray = this.dbmgr.getTableNames(n)) == null || stringArray.length == 0) {
            throw new BrokerException("version " + string + " not supported");
        }
        try {
            Connection connection = this.dbmgr.connectToUse(true);
            DBTool.doDump(connection, stringArray);
            connection.close();
        }
        finally {
            this.dbmgr.close();
        }
    }

    static void doDump(Connection connection, String[] stringArray) throws SQLException, BrokerException {
        Statement statement = connection.createStatement();
        for (int i = 0; i < stringArray.length; ++i) {
            ResultSet resultSet = null;
            String string = stringArray[i];
            String string2 = "SELECT COUNT(*) FROM " + string;
            try {
                resultSet = statement.executeQuery(string2);
                if (resultSet.next()) {
                    System.out.println(string + ": number of row=" + resultSet.getInt(1));
                }
                resultSet.close();
                if (!string.startsWith("IMQSV35")) continue;
                resultSet = statement.executeQuery("select * from " + string);
                while (resultSet.next()) {
                    System.out.print("STOREVERSION=" + resultSet.getInt(1) + ";");
                    System.out.print("BROKERID=" + resultSet.getString(2));
                }
                System.out.println();
                continue;
            }
            catch (SQLException sQLException) {
                SQLException sQLException2 = DBManager.wrapSQLException("[" + string2 + "]", sQLException);
                logger.log(32, "failed to dump tables", sQLException2);
            }
        }
        statement.close();
    }

    private boolean printHelp(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(OPT_H) && !stringArray[i].equals(OPT_LH)) continue;
            return true;
        }
        return false;
    }

    private boolean printVersion(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(OPT_V) && !stringArray[i].equals(OPT_LV)) continue;
            return true;
        }
        return false;
    }

    private void checkArg(String string, String string2, int n, int n2) throws ParserException {
        if (n >= n2) {
            ParserException parserException;
            if (string != null) {
                parserException = new ParserException(MISSING_CMD_ARG);
                parserException.cmd = string;
            } else {
                parserException = new ParserException(MISSING_OPT_ARG);
                parserException.opt = string2;
            }
            throw parserException;
        }
    }

    private void throwParserException(int n, String string, String string2, String string3, String string4) throws ParserException {
        ParserException parserException = new ParserException(n);
        parserException.cmd = string;
        parserException.cmdarg = string2;
        parserException.opt = string3;
        parserException.optarg = string4;
        throw parserException;
    }

    private void handleParserException(ParserException parserException) {
        if (parserException.reason == MISSING_CMD_ARG) {
            System.out.println(br.getString("B3083", parserException.cmd));
        } else if (parserException.reason == MISSING_OPT_ARG) {
            System.out.println(br.getString("B3080", parserException.opt));
        } else if (parserException.reason == BAD_CMD_ARG) {
            System.out.println(br.getString("B3078", parserException.cmd, parserException.cmdarg));
        } else if (parserException.reason == BAD_OPT) {
            System.out.println(br.getString("B3079", parserException.opt));
        } else if (parserException.reason == BAD_OPT_ARG) {
            System.out.println(br.getString("B3081", parserException.opt, parserException.optarg));
        } else if (parserException.reason == EXTRA_CMD_SPECIFIED) {
            System.out.println(br.getString("B3077", parserException.cmd));
        }
    }

    private Properties parseArgs(String[] stringArray) throws ParserException {
        Properties properties = System.getProperties();
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(CREATE_CMD_STR)) {
                if (bl) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, stringArray[i], null, null, null);
                } else {
                    bl = true;
                }
                this.checkArg(stringArray[i], null, ++i, stringArray.length);
                if (stringArray[i].equals(ARGU_ALL)) {
                    properties.put(CMD_NAME, CREATE_ALL_CMD);
                    continue;
                }
                if (stringArray[i].equals(ARGU_TBL)) {
                    properties.put(CMD_NAME, CREATE_TBL_CMD);
                    continue;
                }
                this.throwParserException(BAD_CMD_ARG, CREATE_CMD_STR, stringArray[i], null, null);
                continue;
            }
            if (stringArray[i].equals(DELETE_CMD_STR)) {
                if (bl) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, stringArray[i], null, null, null);
                } else {
                    bl = true;
                }
                this.checkArg(stringArray[i], null, ++i, stringArray.length);
                if (stringArray[i].equals(ARGU_TBL)) {
                    properties.put(CMD_NAME, DELETE_TBL_CMD);
                    continue;
                }
                if (stringArray[i].equals(ARGU_OLDTBL)) {
                    properties.put(CMD_NAME, DELETE_TBL_CMD);
                    properties.put(ARG_NAME, ARGU_OLDTBL);
                    continue;
                }
                this.throwParserException(BAD_CMD_ARG, DELETE_CMD_STR, stringArray[i], null, null);
                continue;
            }
            if (stringArray[i].equals(RECREATE_CMD_STR)) {
                if (bl) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, stringArray[i], null, null, null);
                } else {
                    bl = true;
                }
                this.checkArg(stringArray[i], null, ++i, stringArray.length);
                if (stringArray[i].equals(ARGU_TBL)) {
                    properties.put(CMD_NAME, RECREATE_TBL_CMD);
                    continue;
                }
                this.throwParserException(BAD_CMD_ARG, RECREATE_CMD_STR, stringArray[i], null, null);
                continue;
            }
            if (stringArray[i].equals(DUMP_CMD_STR)) {
                if (bl) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, stringArray[i], null, null, null);
                } else {
                    bl = true;
                }
                this.checkArg(stringArray[i], null, ++i, stringArray.length);
                properties.put(CMD_NAME, DUMP_CMD);
                properties.put(ARG_NAME, stringArray[i]);
                continue;
            }
            if (stringArray[i].equals(RESET_CMD_STR)) {
                if (bl) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, stringArray[i], null, null, null);
                } else {
                    bl = true;
                }
                this.checkArg(stringArray[i], null, ++i, stringArray.length);
                if (stringArray[i].equals(ARGU_LCK)) {
                    properties.put(CMD_NAME, RESET_CMD);
                    continue;
                }
                this.throwParserException(BAD_CMD_ARG, RESET_CMD_STR, stringArray[i], null, null);
                continue;
            }
            if (stringArray[i].equals(OPT_B)) {
                this.checkArg(null, OPT_B, ++i, stringArray.length);
                properties.put("imq.instancename", stringArray[i]);
                continue;
            }
            if (stringArray[i].equals(OPT_U)) {
                this.checkArg(null, OPT_U, ++i, stringArray.length);
                properties.put("imq.persist.jdbc.user", stringArray[i]);
                continue;
            }
            if (stringArray[i].equals(OPT_P)) {
                this.checkArg(null, OPT_P, ++i, stringArray.length);
                properties.put("imq.persist.jdbc.password", stringArray[i]);
                this.cliPasswdSpecified = true;
                continue;
            }
            if (stringArray[i].equals(OPT_PASSFILE)) {
                this.checkArg(null, OPT_PASSFILE, ++i, stringArray.length);
                File file = null;
                try {
                    file = new File(stringArray[i]).getCanonicalFile();
                }
                catch (Exception exception) {
                    this.throwParserException(BAD_OPT, null, null, stringArray[i], null);
                }
                properties.put("imq.passfile.enabled", "true");
                properties.put("imq.passfile.dirpath", file.getParent());
                properties.put("imq.passfile.name", file.getName());
                continue;
            }
            if (stringArray[i].equals(OPT_VERBOSE)) continue;
            if (stringArray[i].equals(OPT_VARHOME)) {
                ++i;
                continue;
            }
            if (stringArray[i].startsWith(OPT_D)) {
                int n = 0;
                String string = null;
                String string2 = "";
                n = stringArray[i].indexOf(61);
                if (stringArray[i].length() <= 2) continue;
                if (n < 0) {
                    string = stringArray[i].substring(2);
                } else if (n == stringArray[i].length() - 1) {
                    string = stringArray[i].substring(2, n);
                } else {
                    string = stringArray[i].substring(2, n);
                    string2 = stringArray[i].substring(n + 1);
                }
                properties.put(string, string2);
                if (!Store.DEBUG) continue;
                logger.log(4, "added sys prop: " + string + "=" + string2);
                continue;
            }
            this.throwParserException(BAD_OPT, null, null, stringArray[i], null);
        }
        return properties;
    }

    private void parsePassfile() throws FileNotFoundException {
        Properties properties;
        BrokerConfig brokerConfig = Globals.getConfig();
        String string = null;
        String string2 = null;
        String string3 = null;
        string3 = brokerConfig.getProperty("imq.passfile.enabled");
        if (string3 == null || !string3.equalsIgnoreCase(Boolean.TRUE.toString())) {
            return;
        }
        string = brokerConfig.getProperty("imq.passfile.dirpath");
        string2 = string != null ? (string = StringUtil.expandVariables(string, brokerConfig)) : brokerConfig.getProperty("imq.etchome") + File.separator + "security";
        String string4 = string2 + File.separator + brokerConfig.getProperty("imq.passfile.name");
        File file = new File(string4);
        if (file.exists()) {
            properties = new Properties();
            try {
                FileInputStream fileInputStream = new FileInputStream(string4);
                properties.load(fileInputStream);
                if (this.cliPasswdSpecified) {
                    String string5 = brokerConfig.getProperty("imq.persist.jdbc.password");
                    properties.put("imq.persist.jdbc.password", string5);
                }
            }
            catch (IOException iOException) {
                logger.log(32, br.getKString("B4023"), iOException);
            }
        } else {
            logger.log(32, br.getKString("B3020", string4));
            throw new FileNotFoundException(br.getKString("B3020", string4));
        }
        brokerConfig.putAll((Map)properties);
    }

    private void exit(int n) {
        if (this.standalone) {
            System.exit(n);
        }
    }

    void doCommand(String[] stringArray) throws SQLException, BrokerException, FileNotFoundException {
        String string;
        if (stringArray.length == 0) {
            System.out.println(this.version.getBanner(true));
            System.out.println(br.getString("B0011"));
            this.exit(0);
        }
        if (this.printHelp(stringArray)) {
            System.out.println(br.getString("B0011"));
            this.exit(0);
        }
        if (this.printVersion(stringArray)) {
            System.out.println(this.version.getBanner(true));
            System.out.println(br.getString("B1003") + System.getProperty("java.version") + " " + System.getProperty("java.vendor") + " " + System.getProperty("java.home"));
            System.out.println(br.getString("B1054") + System.getProperty("java.class.path"));
            this.exit(0);
        }
        Properties properties = null;
        try {
            properties = this.parseArgs(stringArray);
        }
        catch (ParserException parserException) {
            this.handleParserException(parserException);
            this.exit(1);
        }
        if (this.cliPasswdSpecified) {
            System.err.println(br.getString("B2088", OPT_P));
            System.err.println("");
        }
        Globals.init(properties, false);
        logger = Globals.getLogger();
        String string2 = Globals.JMQ_INSTANCES_HOME + File.separator + Globals.getConfigName();
        String string3 = properties.getProperty("imq.ri");
        if (string3 == null && !new File(string2).exists()) {
            System.err.println(br.getString("B3119", Globals.getConfigName()));
            System.exit(1);
        }
        this.parsePassfile();
        config = Globals.getConfig();
        this.dbmgr = new DBManager(this.standalone);
        String string4 = properties.getProperty(CMD_NAME);
        String string5 = this.dbmgr.getBrokerID();
        if (string5.length() > 0) {
            string = CREATE_ALL_CMD.equals(string4) ? this.dbmgr.getCreateDBURL() : this.dbmgr.getOpenDBURL();
            logger.logToAll(8, br.getString("B1067", string, string5));
        }
        if (CREATE_ALL_CMD.equals(string4)) {
            this.doCreate(true, true);
        } else if (CREATE_TBL_CMD.equals(string4)) {
            this.doCreate(true, false);
        } else if (DELETE_TBL_CMD.equals(string4)) {
            this.doDrop(properties.getProperty(ARG_NAME), true);
        } else if (RECREATE_TBL_CMD.equals(string4)) {
            this.doRecreate(true);
        } else if (DUMP_CMD.equals(string4)) {
            string = properties.getProperty(ARG_NAME);
            this.doDump(string);
        } else if (RESET_CMD.equals(string4)) {
            this.doReset();
        } else if (string4 == null) {
            System.out.println(br.getString("B3105"));
        } else {
            System.out.println(br.getString("B3104", string4));
        }
    }

    public static void main(String[] stringArray) {
        BrokerResources brokerResources = Globals.getBrokerResources();
        try {
            DBTool dBTool = new DBTool(true);
            dBTool.doCommand(stringArray);
            System.exit(0);
        }
        catch (Exception exception) {
            System.exit(1);
        }
    }

    private static class ParserException
    extends Exception {
        String cmd;
        String cmdarg;
        String opt;
        String optarg;
        int reason;

        ParserException(int n) {
            this.reason = n;
        }
    }
}

