/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConstants;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.LockFile;
import com.sun.messaging.jmq.util.Password;
import com.sun.messaging.jmq.util.StringUtil;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.io.PrintStream;
import java.net.Socket;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;

final class DBManager
implements DBConstants {
    private static BrokerConfig config = Globals.getConfig();
    private static BrokerResources br = Globals.getBrokerResources();
    private static Logger logger = Globals.getLogger();
    static final String JDBC_PROP_PREFIX = "imq.persist.jdbc.";
    static final String STORE_TYPE_PROP = "imq.persist.store";
    static final String JDBC_STORE_TYPE = "jdbc";
    static final String TABLE_PROP_PREFIX = "imq.persist.jdbc.table.";
    static final String DRIVER_PROP = "imq.persist.jdbc.driver";
    static final String OPENDB_URL_PROP = "imq.persist.jdbc.opendburl";
    static final String CREATEDB_URL_PROP = "imq.persist.jdbc.createdburl";
    static final String CLOSEDB_URL_PROP = "imq.persist.jdbc.closedburl";
    static final String USER_PROP = "imq.persist.jdbc.user";
    static final String PASSWORD_PROP = "imq.persist.jdbc.password";
    static final String NEEDPASSWORD_PROP = "imq.persist.jdbc.needpassword";
    static final String BROKERID_PROP = "imq.persist.jdbc.brokerid";
    static final boolean DEFAULT_NEEDPASSWORD = false;
    private String driver;
    private String openDBUrl;
    private String createDBUrl = null;
    private String closeDBUrl = null;
    private String user = null;
    private String password = null;
    private String brokerid = null;
    private Hashtable tables = new Hashtable();
    private static String[] v200TableNames = new String[]{"IMQSV", "IMQCCREC", "IMQDEST", "IMQINT", "IMQMSG", "IMQPROPS", "IMQILIST", "IMQTXN", "IMQTACK"};
    private static String[] tableNames = new String[]{"IMQSV35", "IMQCCREC35", "IMQDEST35", "IMQINT35", "IMQMSG35", "IMQPROPS35", "IMQILIST35", "IMQTXN35", "IMQTACK35"};
    private static int LOCK_INDEX = 2;

    DBManager(boolean bl) throws BrokerException {
        String string = config.getProperty(STORE_TYPE_PROP);
        if (string == null || !string.equals(JDBC_STORE_TYPE)) {
            logger.log(32, "B3103", string == null ? "" : string);
            throw new BrokerException(br.getString("B3103", string == null ? "" : string));
        }
        this.driver = config.getProperty(DRIVER_PROP);
        if (this.driver == null) {
            logger.log(32, "B3023", DRIVER_PROP);
            throw new BrokerException(br.getString("B3023", DRIVER_PROP));
        }
        this.openDBUrl = config.getProperty(OPENDB_URL_PROP);
        if (this.openDBUrl == null) {
            logger.log(32, "B3025", OPENDB_URL_PROP);
            throw new BrokerException(br.getString("B3025", OPENDB_URL_PROP));
        }
        this.openDBUrl = StringUtil.expandVariables(this.openDBUrl, config);
        this.createDBUrl = config.getProperty(CREATEDB_URL_PROP);
        if (this.createDBUrl != null) {
            this.createDBUrl = StringUtil.expandVariables(this.createDBUrl, config);
        }
        this.closeDBUrl = config.getProperty(CLOSEDB_URL_PROP);
        if (this.closeDBUrl != null) {
            this.closeDBUrl = StringUtil.expandVariables(this.closeDBUrl, config);
        }
        this.user = config.getProperty(USER_PROP);
        this.password = this.getPassword();
        this.brokerid = config.getProperty(BROKERID_PROP);
        if (this.brokerid != null && this.brokerid.length() > 0) {
            for (int i = 0; i < this.brokerid.length(); ++i) {
                if (Character.isLetterOrDigit(this.brokerid.charAt(i))) continue;
                logger.log(32, "B3093", this.brokerid);
                throw new BrokerException(br.getString("B3093", this.brokerid));
            }
            this.fixOldTableNames();
        } else {
            this.brokerid = "";
        }
        this.loadTableSchema();
        try {
            Class.forName(this.driver).newInstance();
        }
        catch (InstantiationException instantiationException) {
            logger.log(32, "B3024", (Object)this.driver, (Throwable)instantiationException);
            throw new BrokerException(br.getString("B3024", this.driver), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.log(32, "B3024", (Object)this.driver, (Throwable)illegalAccessException);
            throw new BrokerException(br.getString("B3024", this.driver), illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.log(32, "B3024", (Object)this.driver, (Throwable)classNotFoundException);
            throw new BrokerException(br.getString("B3024", this.driver), classNotFoundException);
        }
    }

    Connection connectToCreate() throws BrokerException {
        if (this.createDBUrl == null) {
            logger.log(32, "B3025", CREATEDB_URL_PROP);
            throw new BrokerException(br.getString("B3025", CREATEDB_URL_PROP));
        }
        try {
            Connection connection = this.user == null ? DriverManager.getConnection(this.createDBUrl) : DriverManager.getConnection(this.createDBUrl, this.user, this.password);
            connection.setAutoCommit(false);
            return connection;
        }
        catch (SQLException sQLException) {
            logger.log(32, "B3026", (Object)this.createDBUrl, (Throwable)sQLException);
            throw new BrokerException(br.getString("B3026", this.createDBUrl), sQLException);
        }
    }

    Connection connectToUse(boolean bl) throws BrokerException {
        try {
            Connection connection = this.user == null ? DriverManager.getConnection(this.openDBUrl) : DriverManager.getConnection(this.openDBUrl, this.user, this.password);
            connection.setAutoCommit(bl);
            return connection;
        }
        catch (SQLException sQLException) {
            logger.log(32, "B3026", (Object)this.openDBUrl, (Throwable)sQLException);
            throw new BrokerException(br.getString("B3026", this.openDBUrl), sQLException);
        }
    }

    String getOpenDBURL() {
        return this.openDBUrl;
    }

    String getCreateDBURL() {
        return this.createDBUrl;
    }

    String getBrokerID() {
        return this.brokerid;
    }

    String getDriver() {
        return this.driver;
    }

    void close() {
        block3: {
            if (this.closeDBUrl != null) {
                try {
                    DriverManager.getConnection(this.closeDBUrl);
                }
                catch (SQLException sQLException) {
                    if (!Store.DEBUG) break block3;
                    logger.log(4, "B1052", (Object)this.closeDBUrl, (Throwable)sQLException);
                }
            }
        }
    }

    void printInfo(PrintStream printStream) {
        printStream.println("Configuration properties:");
        printStream.println("imq.persist.jdbc.driver=" + this.driver);
        printStream.println("imq.persist.jdbc.opendburl=" + this.openDBUrl);
        printStream.println("imq.persist.jdbc.createdburl=" + this.createDBUrl);
        printStream.println("imq.persist.jdbc.closedburl=" + this.closeDBUrl);
        printStream.println("imq.persist.jdbc.user=" + this.user);
        printStream.println("imq.persist.jdbc.needpassword=" + config.getBooleanProperty(NEEDPASSWORD_PROP));
        printStream.println("imq.persist.jdbc.password=" + this.password);
        printStream.println("imq.persist.jdbc.brokerid=" + this.brokerid);
    }

    Hashtable getTableSchema() {
        return this.tables;
    }

    String[] getTableNames(int n) {
        String[] stringArray = new String[]{};
        if (n == 350) {
            stringArray = this.tables.keySet().toArray(stringArray);
        } else if (n == 200) {
            stringArray = v200TableNames;
        }
        return stringArray;
    }

    static SQLException wrapSQLException(String string, SQLException sQLException) {
        SQLException sQLException2 = new SQLException(string + ": " + sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode());
        sQLException2.setNextException(sQLException);
        return sQLException2;
    }

    static IOException wrapIOException(String string, IOException iOException) {
        IOException iOException2 = new IOException(string + ": " + iOException.getMessage());
        iOException2.initCause(iOException);
        return iOException2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void lockTables(Connection connection, String string, boolean bl) throws BrokerException, SQLException {
        Statement statement = null;
        ResultSet resultSet = null;
        String string2 = "SELECT STOREVERSION, BROKERID FROM " + string + " WHERE " + "STOREVERSION" + " = " + 350 + " FOR UPDATE";
        try {
            statement = connection.createStatement(1003, 1008);
        }
        catch (SQLException sQLException) {
            logger.log(32, "failed to create Statement", sQLException);
            throw new BrokerException("failed to create Statement", sQLException);
        }
        try {
            resultSet = statement.executeQuery(string2);
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = DBManager.wrapSQLException("[" + string2 + "]", sQLException);
            throw sQLException2;
        }
        try {
            if (resultSet.next()) {
                String string3 = null;
                if (bl) {
                    LockFile lockFile = LockFile.getCurrentLockFile();
                    string3 = lockFile != null ? lockFile.getInstance() + ":" + lockFile.getHost() + ":" + lockFile.getPort() : Globals.getConfigName() + ":" + "localhost" + ":" + "imqdbmgr";
                    string2 = "UPDATE " + string + " SET " + "BROKERID" + " = '" + string3 + "' WHERE " + "STOREVERSION" + " = " + 350;
                    TableLock tableLock = new TableLock(resultSet.getString(LOCK_INDEX));
                    if (tableLock.isNull) {
                        DBManager.updateLock(connection, string3, resultSet, statement, string2);
                        return;
                    } else {
                        if (DBManager.isOurLock(lockFile, tableLock)) return;
                        if (DBManager.validLock(tableLock)) throw new BrokerException(DBManager.generateLockError(tableLock));
                        DBManager.updateLock(connection, string3, resultSet, statement, string2);
                        return;
                    }
                } else {
                    string2 = "UPDATE " + string + " SET " + "BROKERID" + " = null WHERE " + "STOREVERSION" + " = " + 350;
                    DBManager.updateLock(connection, string3, resultSet, statement, string2);
                }
                return;
            }
            logger.log(32, "cannot find store version in " + string);
            throw new BrokerException("cannot find store version in " + string);
        }
        catch (SQLException sQLException) {
            SQLException sQLException3 = DBManager.wrapSQLException("[" + string2 + "]", sQLException);
            logger.log(32, "failed to get broker id from version table", sQLException3);
            throw new BrokerException("failed to get broker id from version table", sQLException3);
        }
    }

    private static void updateLock(Connection connection, String string, ResultSet resultSet, Statement statement, String string2) throws SQLException {
        try {
            resultSet.updateString(LOCK_INDEX, string);
            resultSet.updateRow();
            connection.commit();
        }
        catch (Throwable throwable) {
            logger.log(4, "updateLock got:" + throwable);
            statement.executeUpdate(string2);
            connection.commit();
        }
    }

    private static boolean isOurLock(LockFile lockFile, TableLock tableLock) {
        if (lockFile != null) {
            return lockFile.getPort() == tableLock.port && LockFile.equivalentHostNames(lockFile.getHost(), tableLock.host, false) && lockFile.getInstance().equals(tableLock.instance);
        }
        return false;
    }

    private static boolean validLock(TableLock tableLock) {
        if (tableLock.port == 0) {
            return true;
        }
        Socket socket = null;
        try {
            socket = new Socket(tableLock.host, tableLock.port);
            socket.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private void loadTableSchema() throws BrokerException {
        Properties properties = new Properties();
        Iterator<Map.Entry<Object, Object>> iterator = config.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String string = (String)entry.getKey();
            String string2 = null;
            if (!string.startsWith(TABLE_PROP_PREFIX)) continue;
            string2 = (String)entry.getValue();
            int n = string.lastIndexOf(46);
            String string3 = string.substring(n + 1) + this.brokerid;
            properties.setProperty("name", string3);
            string2 = StringUtil.expandVariables(string2, properties);
            this.tables.put(string3, string2);
        }
        this.checkTables();
    }

    private void fixOldTableNames() throws BrokerException {
        for (int i = 0; i < v200TableNames.length; ++i) {
            DBManager.v200TableNames[i] = v200TableNames[i] + this.brokerid;
        }
    }

    private void checkTables() throws BrokerException {
        for (int i = 0; i < tableNames.length; ++i) {
            String string = tableNames[i] + this.brokerid;
            String string2 = (String)this.tables.get(string);
            if (string2 == null || string2.length() == 0) {
                logger.log(32, "B3127", tableNames[i]);
                throw new BrokerException(br.getString("B3127", tableNames[i]));
            }
            if (!Store.DEBUG) continue;
            logger.log(4, string + ":'" + string2 + "'");
        }
    }

    private String getPassword() {
        String string = config.getProperty(PASSWORD_PROP);
        boolean bl = config.getBooleanProperty(NEEDPASSWORD_PROP, false);
        if (string == null && bl) {
            Password password = new Password();
            for (int i = 0; (string == null || string.trim().equals("")) && i < 5; ++i) {
                System.err.print(br.getString("B0039", this.openDBUrl));
                System.err.flush();
                string = password.getPassword();
            }
        }
        return string;
    }

    private static String generateLockError(TableLock tableLock) {
        if (tableLock.port != 0) {
            return br.getString("B3155", tableLock.host, String.valueOf(tableLock.port));
        }
        return br.getString("B3156");
    }

    static class TableLock {
        String lockstr;
        String instance;
        String host;
        String portstr;
        int port = 0;
        boolean isNull = false;

        TableLock(String string) {
            this.lockstr = string;
            if (this.lockstr == null || this.lockstr.length() == 0) {
                this.isNull = true;
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(this.lockstr, " :\t\n\r\f");
                try {
                    this.instance = stringTokenizer.nextToken();
                    this.host = stringTokenizer.nextToken();
                    this.portstr = stringTokenizer.nextToken();
                    try {
                        this.port = Integer.parseInt(this.portstr);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.port = 0;
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    Logger logger = logger;
                    logger;
                    br;
                    logger.log(16, "B2087", this.lockstr);
                    this.lockstr = null;
                    this.isNull = true;
                }
            }
        }
    }
}

